﻿--[[-------------------------------------------------------------------------------------------------
Cube Initialize
--]]-------------------------------------------------------------------------------------------------

do
	-- Addon Initialize
	IGAS:NewAddon("Cube")
	
	-- SavedVariables
	_Addon:AddSavedVariable("CubeSave")
	
	-- Localization
    L = IGAS:NewLocal("Cube")
	
	-- Logger
	Log = IGAS:NewLogger("Cube")
	
	Log.LogLevel = 2
	
	Log:SetPrefix(1, "[Cube:Debug]")
	Log:SetPrefix(2, "[Cube:Info]")
	
	Log:AddHandler(print)
	
	-- Global Functions
    CreateFrame = IGAS.GUI.CreateFrame
	
	GRN    ='|cff20ff20'
	YEL    ='|cffffff00'
	RED    ='|cffff0000'
	WHT    ='|cffffffff'
	BLU    ='|cff8888ff'
	DRKBLU ='|cff1b0495'
	ORN    ='|cffff9C00'
	GRY    ='|cffA0A0A0'
    
	-- Binding Text
    _G.BINDING_HEADER_CUBE = L["Cube"]
    _G.BINDING_NAME_CUBE_CODE = L["Simple Dev Tool"]
    _G.BINDING_NAME_CUBE_BUGLIST = L["Simple Bug List"]
    _G.BINDING_NAME_CUBE_DEBUG = L["Simple Debug Tool"]
	_G.BINDING_NAME_CUBE_LOGVIEW = L["Simple Log View"]
	
	-- Functions	
	function GetErrMsg(err)		
        if not err or err == "" then
            return
        end
		
        -- Get the full backtrace
        local real =
            err:find("^.-([^\\]+\\)([^\\]-)(:%d+):(.*)$") or
            err:find("^%[string \".-([^\\]+\\)([^\\]-)\"%](:%d+):(.*)$") or
            err:find("^%[string (\".-\")%](:%d+):(.*)$") or err:find("^%[C%]:(.*)$")
    
        err = err .. "\n" .. debugstack(real and 4 or 3)
		
        local errorType = "error"
    
        -- Normalize the full paths into last directory component and filename.
        local errmsg = ""
        
        for trace in err:gmatch("(.-)\n") do
            local match, found, path, file, line, msg, _
            found = false
        
            -- "Interface\AddOns\path\to\file.lua:linenum:message"
            if not found then
                match, _, path, file, line, msg = trace:find("^.-[A%.][d%.][d%.][Oo]ns\\(.*)([^\\]-)(:%d+):(.*)$")
                if match then
                    found = true
                    local addon = path:gsub("\\.*$", "")
                    local addonObject = _G[addon]
                    if not addonObject then
                        addonObject = _G[addon:match("^[^_]+_(.*)$")]
                    end
                    local version, revision = nil, nil
                    local objectName = addon:upper()
                    if not version then version = _G[objectName .. "_VERSION"] end
                    if not revision then revision = _G[objectName .. "_REVISION"] or _G[objectName .. "_REV"] end
                    if not version then version = GetAddOnMetadata(addon, "Version") end
                    if not version and revision then version = revision
                    elseif type(version) == "string" and revision and not version:find(revision) then
                        version = version .. "." .. revision
                    end
                    if version then
                        path = addon .. "-" .. version .. path:gsub("^[^\\]*", "")
                    end
                end
            end
            
            -- "path\to\file.lua:linenum:message"
            if not found then
                match, _, path, file, line, msg = trace:find("^.-([^\\]+\\)([^\\])(:%d+):(.*)$")
                if match then
                    found = true
                end
            end
    
            -- "[string \"path\\to\\file.lua:<foo>\":linenum:message"
            if not found then
                match, _, path, file, line, msg = trace:find("^%[string \".-([^\\]+\\)([^\\]-)\"%](:%d+):(.*)$")
                if match then
                    found = true
                end
            end
    
            -- "[string \"FOO\":linenum:message"
            if not found then
                match, _, file, line, msg = trace:find("^%[string (\".-\")%](:%d+):(.*)$")
                if match then
                    found = true
                    path = "<string>:"
                end
            end
    
            -- "[C]:message"
            if not found then
                match, _, msg = trace:find("^%[C%]:(.*)$")
                if match then
                    found = true
                    path = "<in C code>"
                    file = ""
                    line = ""
                end
            end
        
            -- Anything else
            if not found then
                path = trace--"<unknown>"
                file = ""
                line = ""
                msg = line
            end
    
            -- Add it to the formatted error
            errmsg = errmsg .. path .. file .. line .. ":" .. msg .. "\n"
        end
		
		return errmsg
	end
	
	local function orderKey(t1, t2)
		if t1 and t2 then
			if type(t1) == "string" and type(t2) ~= "string" then
				return true
			elseif type(t1) ~= "string" and type(t2) == "string" then
				return false
			else
				return tostring(t1) < tostring(t2)
			end
		else
			return tostring(t1) < tostring(t2)
		end
	end
	
	function pairsByKeys (t, f)
		local a = {}
		for n in pairs(t) do table.insert(a, n) end
		table.sort(a, f or orderKey)
		local i = 0      -- iterator variable
		local iter = function ()   -- iterator function
			i = i + 1
			if a[i] == nil then 
				return nil
			else 
				return a[i], t[a[i]]
			end
		end
		return iter
	end
end