﻿-- Author      : Kurapica

do
	-- Check Version
	local version = 1

	if not IGAS:NewAddon("IGAS.Special.MsgBox", version) then
		return
	end
	
	local L = IGAS:NewLocal("IGAS_Special")
	
	local tinsert = table.insert
	local tremove = table.remove
	local getn = table.getn
	local strfind = string.find
	local strlower = string.lower
	local _Queue = {}
	local _MaxQueue = 10
	local WorldFrame = IGAS:GetWrapper(_G.WorldFrame)
	
	local frmPop = IGAS:NewFrame("PopupDialog", "IGAS_GUI_MSGBOX", WorldFrame)
	frmPop.Style = "LIGHT"
	frmPop.OkayButtonText = L["Okay"]
	frmPop.NoButtonText = L["No"]
	frmPop.CancelButtonText = L["Cancel"]
	
	local function ShowDialog(_Message, _Map, _Callback, _KeyList)
		frmPop.Message = _Message
		frmPop.ShowNoButton = (strfind(_Map, "n") and true) or false
		frmPop.ShowCancelButton = (strfind(_Map, "c") and true) or false
		frmPop.ShowInputBox = (strfind(_Map, "i") and true) or false
		frmPop.Input:Clear()
		frmPop.Text = ""
		frmPop.__CallBack = _Callback
		
		if frmPop.ShowInputBox and _KeyList and type(_KeyList) == "table" and next(_KeyList) then
			frmPop.Input.HideDropDownButton = false
			frmPop.Input.Editable = false
			frmPop.Input.AutoFocus = false
			
			frmPop.Input:SetList(_KeyList)
		else
			frmPop.Input.HideDropDownButton = true
			frmPop.Input.Editable = true
			frmPop.Input.AutoFocus = true
		end
		
		frmPop.Visible = true
	end
	
	function frmPop:OnHide()
		if _Queue[1] then
			local info = _Queue[1]
			tremove(_Queue, 1)
			
			return ShowDialog(info.Message, info.Map, info.Callback, info.KeyList)
		end
	end
	
	function frmPop:OnOkay()
		if not self.__CallBack and type(self.__CallBack) ~= "function" then
			return
		end
		if self.ShowInputBox then
			return self.__CallBack(self.Text)
		else
			return self.__CallBack(true)
		end
	end
	
	function frmPop:OnNo()
		if not self.__CallBack and type(self.__CallBack) ~= "function" then
			return
		end
		if self.ShowInputBox then
			return self.__CallBack(nil)
		else
			return self.__CallBack(false)
		end
	end
	
	function frmPop:OnCancel()
		if not self.__CallBack and type(self.__CallBack) ~= "function" then
			return
		end
		if self.ShowInputBox then
			return self.__CallBack(nil)
		else
			return self.__CallBack(nil)
		end
	end
	
	------------------------------------
	--- Show a custom popup dialog
	-- @name IGAS:MsgBox
	-- @class function
	-- @param _Message The message to be displayed in the popupdialog.
	-- @param _Map Combined by "n", "c", "i", "n" means show No Button, "c" means show Cancel Button, "i" means show the input box
	-- @param _Callback The function to receive the result.If input box is showed, and okay button is clicked the text would be passed in, click other button, would be nil. If input box is hidden, okay button pass true, no button pass false, cancel button pass nil.
	-- @param _KeyList Optional,a list contains some strings to be selected for the input box.
	-- @return nil
	-- @usage IGAS:MsgBox("Hello World!!!", "nc") will show a dialog with message "Hello World!!!", and three button with text "Okay" and "NO", "Cancel"
	------------------------------------
	IGAS:RegisterFunction("MsgBox", function(self, _Message, _Map, _Callback, _KeyList)
		if not _Message or type(_Message) ~= "string" then
			return
		end
		if not _Map or type(_Map) ~= "string" then
			_Map = ""
		end
		if _Callback and type(_Callback) ~= "function" then
			error("The callback must be a function", 2)
		end
		
		_Map = strlower(_Map)
		
		if frmPop.Visible then
			if getn(_Queue) < _MaxQueue then
				return tinsert(_Queue, {["Message"] = _Message, ["Map"] = _Map, ["Callback"] = _Callback, ["KeyList"] = _KeyList})
			else
				error("Too many request for MsgBox.", 2)
			end
		end
		
		return ShowDialog(_Message, _Map, _Callback, _KeyList)
	end)
end