﻿-- Author      : Kurapica
-- Create Date : 10/22/2008

--[[
    Localization
--]]
do
	local version = 1

	if not IGAS:NewAddon("IGAS.Localization", version) then
		return
	end

    -- Scripts
	_RegisterLocal = _RegisterLocal or {}

    _gameLocale = GetLocale()
    if _gameLocale == "enGB" then
        _gameLocale = "enUS"
    end

    -- This metatable is used on all tables returned from GetLocale
    _metaT = _metaT or {}

    _metaT.__index = function(self, key)
		rawset(self, key, key)
		return key
	end

    _metaT.__newindex = function(_table,_key,_value)
		rawset(_table, _key, _value == true and _key or _value)
	end

	------------------------------------
	--- Create or get a localization file
	-- @name IGAS:NewLocal
	-- @class function
	-- @param key always be the addon's name
	-- @param locale the language' name, such as "zhCN"
	-- @param isDefault if this language is default, always set to true if the locale is "enUS"
	-- @return if "locale" is setted and equal to the game's version or "isDefault" is true, return the local table, else nil
	-- @usage L = IGAS:NewLocal("HelloWorld", "zhCN")
	------------------------------------
	IGAS:RegisterFunction("NewLocal", function(self, _key, _locale,_isDefault)
		if _locale and _locale ~= _gameLocale and not _isDefault then
			return nil
		end

		_RegisterLocal[_key] = _RegisterLocal[_key] or setmetatable({}, _metaT)

		return _RegisterLocal[_key]
	end)
end