﻿-- Author      : Kurapica
-- Create Date : 8/03/2008 17:14

---------------------------------------------------------------------------------------------------------------------------------------
--- SingleTextBox is a widget type using to contain one line text
-- <br><br>inherit <a href="..\Base\EditBox.html">EditBox</a> For all methods, properties and scriptTypes
-- @name SingleTextBox
-- @class table
-- @field Style the style of the singletextbox: COMMON, LIGHT
---------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 3

	if not IGAS:NewAddon("IGAS.GUI.SingleTextBox", version) then
		return
	end

    local CreateFrame = IGAS.GUI.CreateFrame

	local _WidgetName = "SingleTextBox"
    local _Base = "EditBox"

    -- Style
    local TEMPLATE_COMMON = "COMMON"
    local TEMPLATE_LIGHT = "LIGHT"

    -- Define Block
	local _StyleEnum = IGAS:NewEnum("TextBoxStyle", {
        TEMPLATE_COMMON,
		TEMPLATE_LIGHT,
    })

	local _StyleType = IGAS:NewPropertyType("TextBoxStyle", {
		["Type"] = "enum",
		["EnumType"] = _StyleEnum,
	})

    -- Scripts
    local _FrameBackdropLight = {
        bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
        edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
        tile = true, tileSize = 16, edgeSize = 16,
        insets = { left = 3, right = 3, top = 3, bottom = 3 }
    }

    local function OnEscapePressed(self, ...)
	    self:ClearFocus()
    end

	local function OnEditFocusLost(self, ...)
		self:HighlightText(0, 0)
    end

    local function OnEditFocusGained(self, ...)
	    self:HighlightText()
    end

	-- ScriptType
	local _ScriptType = {
    }

	--	FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Sets the singletextbox's style
		-- @name SingleTextBox:SetStyle
		-- @class function
		-- @param style the style of the singletextbox : COMMON, LIGHT
		-- @usage SingleTextBox:SetStyle("LIGHT")
		------------------------------------

        -- SetStyle
        ["SetStyle"] = function(self, style)
            local t

            -- Check Style
            if not style or type(style) ~= "string" then
                return
            end

            if (not _StyleEnum[style]) or style == self.__Style then
                return
            end

            -- Change Style
            if style == TEMPLATE_COMMON then
				self:SetBackdrop(nil)

				local left = CreateFrame("Texture", "LEFT", self, "BACKGROUND")
				left.Visible = true
				left.Width = 8
				left:SetTexture("Interface\\Common\\Common-Input-Border")
				left:SetTexCoord(0, 0.0625, 0, 0.625)
				left:SetPoint("TOPLEFT", self, "TOPLEFT", -5, 0)
				left:SetPoint("BOTTOMLEFT", self, "BOTTOMLEFT", -5, 0)

				local right = CreateFrame("Texture", "RIGHT", self, "BACKGROUND")
				right.Visible = true
				right.Width = 8
				right:SetTexture("Interface\\Common\\Common-Input-Border")
				right:SetTexCoord(0.9375, 1.0, 0, 0.625)
				right:SetPoint("TOPRIGHT", self, "TOPRIGHT", 0, 0)
				right:SetPoint("BOTTOMRIGHT", self, "BOTTOMRIGHT", 0, 0)

				local middle = CreateFrame("Texture", "MIDDLE", self, "BACKGROUND")
				middle.Visible = true
				middle.Width = 10
				middle:SetTexture("Interface\\Common\\Common-Input-Border")
				middle:SetTexCoord(0.0625, 0.9375, 0, 0.625)
				middle:SetPoint("TOPLEFT", left, "TOPRIGHT", 0, 0)
				middle:SetPoint("TOPRIGHT", right, "TOPLEFT", 0, 0)
				middle:SetPoint("BOTTOMLEFT", left, "BOTTOMRIGHT", 0, 0)
				middle:SetPoint("BOTTOMRIGHT", right, "BOTTOMLEFT", 0, 0)
            elseif style == TEMPLATE_LIGHT then
				if self:GetChild("LEFT") then
					self:GetChild("LEFT"):Hide()
				end
				if self:GetChild("RIGHT") then
					self:GetChild("RIGHT"):Hide()
				end
				if self:GetChild("MIDDLE") then
					self:GetChild("MIDDLE"):Hide()
				end

				self:SetBackdrop(_FrameBackdropLight)
				self:SetBackdropColor(0, 0, 0, 1)
            end
        end,

		------------------------------------
		--- Gets the singletextbox's style
		-- @name SingleTextBox:GetStyle
		-- @class function
		-- @return the style of the singletextbox : COMMON, LIGHT
		-- @usage SingleTextBox:GetStyle("LIGHT")
		------------------------------------

        -- GetStyle
        ["GetStyle"] = function(self)
            return self.__Style or TEMPLATE_NONE
        end,
	}

	--	Property
	local _Property = {
		-- Style
        ["Style"] = {
			["Set"] = function(self, style)
                self:SetStyle(style)
			end,

			["Get"] = function(self)
				return self:GetStyle()
			end,

			["Type"] = "TextBoxStyle",
		},
	}

    local function _New(parent)
		-- New Frame
		local txtBox = CreateFrame(_Base,nil,parent)
		txtBox.Height = 25
		txtBox.FontObject = "GameFontNormal"
		txtBox:SetTextInsets(4 , -4, 0, 0)
        txtBox.MouseEnabled = true
        txtBox.AutoFocus = false
		txtBox:SetBackdrop(_FrameBackdropLight)
        txtBox:SetBackdropColor(0, 0, 0, 1)
		txtBox.__Style = TEMPLATE_LIGHT

        txtBox:StackScript("OnEscapePressed", OnEscapePressed)
        txtBox:StackScript("OnEditFocusLost", OnEditFocusLost)
        txtBox:StackScript("OnEditFocusGained", OnEditFocusGained)

		return txtBox
	end

	-- Register
    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true)
end
