﻿-- Author		: Kurapica
-- Create Date	: 8/04/2008 00:06
-- ChangeLog	:
--					2010/05/31 Fix OnEnter and OnLeave Script

---------------------------------------------------------------------------------------------------------------------------------------
--- ScrollBar is a widget type using for <a href=".\ScrollForm">ScrollForm</a>
-- <br><br>inherit <a href="..\Base\Frame.html">Frame</a> For all methods, properties and scriptTypes
-- @name ScrollBar
-- @class table
-- @field Value the value representing the current position of the slider thumb
-- @field ValueStep the minimum increment between allowed slider values
-- @field Enabled whether user interaction with the slider is allowed
-- @field Style the popupdialog's style: COMMON, LIGHT
---------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 3
	if not IGAS:NewAddon("IGAS.GUI.ScrollBar", version) then
		return
	end

    local CreateFrame = IGAS.GUI.CreateFrame

	local _WidgetName = "ScrollBar"
    local _Base = "Frame"

    -- ScrollBar Template
    local TEMPLATE_COMMON = "COMMON"
    local TEMPLATE_LIGHT = "LIGHT"

    local _frmSingle

    -- Define Block
	local _StyleEnum = IGAS:NewEnum("ScrollBarStyle", {
        TEMPLATE_COMMON,
        TEMPLATE_LIGHT,
    })

	local _StyleType = IGAS:NewPropertyType("ScrollBarStyle", {
		["Type"] = "enum",
		["EnumType"] = _StyleEnum,
	})

	-- Scripts
	local function OnEnter(self)
		self.Parent:Fire("OnEnter")
	end
	
	local function OnLeave(self)
		self.Parent:Fire("OnLeave")
	end
	
    local function OnValueChanged(self, value)
		if self.Parent.SetVerticalScroll then
			self:GetParent():SetVerticalScroll(value)
		end
    end

    local function clickUpBtn(self)
        local slider = self:GetParent():GetChild("Slider")

		slider:SetValue(slider:GetValue() - slider:GetValueStep());
        PlaySound("UChatScrollButton")
    end

    local function clickDownBtn(self)
        local slider = self:GetParent():GetChild("Slider")

        slider:SetValue(slider:GetValue() + slider:GetValueStep());
        PlaySound("UChatScrollButton")
    end

    local function OnMouseWheel(self,value)
        local iMin, iMax = self:GetMinMaxValues()

        if value > 0 then
            if IsShiftKeyDown() then
                self.Value = iMin
            else
                 if self.Value - self.ValueStep > iMin then
                   self.Value = self.Value - self.ValueStep
                else
                   self.Value = iMin
                end
            end
        elseif value < 0 then
            if IsShiftKeyDown() then
                self.Value = iMax
            else
                if self.Value + self.ValueStep < iMax then
                   self.Value = self.Value + self.ValueStep
                else
                   self.Value = iMax
                end
            end
        end
    end

    local function scrollChg(self)
        local iMin, iMax = self:GetMinMaxValues()

        if self:GetValue() == iMin then
            btnUp = self:GetParent():GetChild("UpBtn"):Disable()
        else
            btnUp = self:GetParent():GetChild("UpBtn"):Enable()
        end

        if self:GetValue() == iMax then
            self:GetParent():GetChild("DownBtn"):Disable()
        else
            self:GetParent():GetChild("DownBtn"):Enable()
        end

        self:GetParent():Fire("OnValueChanged", self:GetValue())
    end

	-- ScriptType
	local _ScriptType = {
		------------------------------------
		--- ScriptType, Run when the ScrollBar's or status bar's value changes
		-- @name ScrollBar:OnValueChanged
		-- @class function
		-- @param value New value of the ScrollBar or the status bar
		-- @usage function ScrollBar:OnValueChanged(value)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
        ["OnValueChanged"] = true,
    }

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Sets the scrollbar's style
		-- @name ScrollBar:SetStyle
		-- @class function
		-- @param style the style of the scrollbar : COMMON, LIGHT
		-- @usage ScrollBar:SetStyle("LIGHT")
		------------------------------------

        -- SetStyle
        ["SetStyle"] = function(self, style)
            local t

            -- Check Style
            if not style or type(style) ~= "string" then
                return
            end

            if (not _StyleEnum[style]) or style == self.__Style then
                return
            end

            -- Change Style
            if style == TEMPLATE_COMMON then
				local top = CreateFrame("Texture", "TopTexture", self, "ARTWORK")
				top.TexturePath = [[Interface\PaperDollInfoFrame\UI-Character-ScrollBar]]
				top.Width = 32
				top.Height = 24
				top:SetTexCoord(0, 0.484375, 0, 0.086)
				top:SetPoint("TOP", self, "TOP")
				top.Visible = true
				
				local bottom = CreateFrame("Texture", "BottomTexture", self, "ARTWORK")
				bottom.TexturePath = [[Interface\PaperDollInfoFrame\UI-Character-ScrollBar]]
				bottom.Width = 32
				bottom.Height = 24
				bottom:SetTexCoord(0.515625, 1, 0.333, 0.4140625)
				bottom:SetPoint("BOTTOM", self, "BOTTOM")
				bottom.Visible = true
				
				local middle = CreateFrame("Texture", "MiddleTexture", self, "ARTWORK")
				middle.TexturePath = [[Interface\PaperDollInfoFrame\UI-Character-ScrollBar]]
				middle:SetTexCoord(0, 0.484375, 0.75, 1.0)
				middle:SetPoint("TOPLEFT", top, "BOTTOMLEFT")
				middle:SetPoint("BOTTOMRIGHT", bottom, "TOPRIGHT")
				middle.Visible = true
				
            elseif style == TEMPLATE_LIGHT then
				if self.MiddleTexture then
					self.MiddleTexture.Visible = false
				end
				if self.TopTexture then
					self.TopTexture.Visible = false
				end
				if self.BottomTexture then
					self.BottomTexture.Visible = false
				end
            end
			
			self.__Style = style
        end,

		------------------------------------
		--- Gets the scrollbar's style
		-- @name ScrollBar:GetStyle
		-- @class function
		-- @return the style of the scrollbar : COMMON, LIGHT
		-- @usage ScrollBar:GetStyle()
		------------------------------------

        -- GetStyle
        ["GetStyle"] = function(self)
            return self.__Style or TEMPLATE_LIGHT
        end,

		------------------------------------
		--- Get the current bounds of the slider.
		-- @name ScrollBar:GetMinMaxValues
		-- @class function
		-- @return the current bounds of the slider
		-- @usage ScrollBar:GetMinMaxValues()
		------------------------------------

        -- GetMinMaxValues
        ["GetMinMaxValues"] = function(self)
            return self:GetChild("Slider"):GetMinMaxValues()
        end,

		------------------------------------
		--- Get the current value of the slider.
		-- @name ScrollBar:GetMinMaxValues
		-- @class function
		-- @return the current value of the slider
		-- @usage ScrollBar:GetMinMaxValues()
		------------------------------------

        -- GetMinMaxValues
        ["GetValue"] = function(self)
            return self:GetChild("Slider"):GetValue()
        end,

		------------------------------------
		--- Get the current step size of the slider.
		-- @name ScrollBar:GetValueStep
		-- @class function
		-- @return the current step size of the slider
		-- @usage ScrollBar:GetValueStep()
		------------------------------------

        -- GetValueStep
        ["GetValueStep"] = function(self)
            return self:GetChild("Slider"):GetValueStep()
        end,

		------------------------------------
		--- Sets the minimum and maximum values for the slider
		-- @name ScrollBar:SetMinMaxValues
		-- @class function
		-- @param minValue - Lower boundary for values represented by the slider position (number)
		-- @param maxValue - Upper boundary for values represented by the slider position (number)
		-- @usage ScrollBar:SetMinMaxValues(1, 100)
		------------------------------------

		-- SetMinMaxValues
        ["SetMinMaxValues"] = function(self, iMin, iMax)
            self:GetChild("Slider"):SetMinMaxValues(iMin, iMax)
        end,

		------------------------------------
		--- Sets the value representing the position of the slider thumb
		-- @name ScrollBar:SetValue
		-- @class function
		-- @param value Value representing the new position of the slider thumb (between minValue and maxValue, where minValue, maxValue = slider:GetMinMaxValues())
		-- @usage ScrollBar:SetValue(10)
		------------------------------------

		-- SetValue
        ["SetValue"] = function(self, value)
            self:GetChild("Slider"):SetValue(value)
        end,

		------------------------------------
		--- Sets the minimum increment between allowed slider values.
		-- @name ScrollBar:SetValueStep
		-- @class function
		-- @param step Minimum increment between allowed slider values
		-- @usage ScrollBar:SetValueStep(10)
		------------------------------------

		-- SetValueStep
        ["SetValueStep"] = function(self, value)
            self:GetChild("Slider"):SetValueStep(value)
        end,

		------------------------------------
		--- Disable the scrollbar
		-- @name ScrollBar:Disable
		-- @class function
		-- @usage ScrollBar:Disable()
		------------------------------------

		-- Disable
        ["Disable"] = function(self)
            self:GetChild("DownBtn"):Disable()
            self:GetChild("UpBtn"):Disable()
            self:GetChild("Slider"):GetThumbTexture():Hide()
        end,

		------------------------------------
		--- Enable the scrollbar
		-- @name ScrollBar:Enable
		-- @class function
		-- @usage ScrollBar:Enable()
		------------------------------------

		-- Enable
        ["Enable"] = function(self)
            local iMin, iMax = self:GetMinMaxValues()

            self:GetChild("Slider"):GetThumbTexture():Show()

            if self:GetValue() == iMin then
                btnUp = self:GetChild("UpBtn"):Disable()
            else
                btnUp = self:GetChild("UpBtn"):Enable()
            end

            if self:GetValue() == iMax then
                self:GetChild("DownBtn"):Disable()
            else
                self:GetChild("DownBtn"):Enable()
            end
        end,

		------------------------------------
		--- Check if the scrollbar is enabled
		-- @name ScrollBar:IsEnabled
		-- @class function
		-- @return true if the scrollbar is enabled
		-- @usage ScrollBar:IsEnabled()
		------------------------------------

		-- IsEnabled
        ["IsEnabled"] = function(self)
            return self:GetChild("Slider"):GetThumbTexture():IsShown()
        end,
    }

	-- Property
	local _Property = {
        -- Value
        ["Value"] = {
			["Set"] = function(self, value)
				self:SetValue(value)
			end,

			["Get"] = function(self)
				return self:GetValue()
			end,

			["Type"] = "number",
		},

        -- ValueStep
        ["ValueStep"] = {
			["Set"] = function(self, value)
				self:SetValueStep(value)
			end,

			["Get"] = function(self)
				return self:GetValueStep()
			end,

			["Type"] = "number",
		},

        -- Enabled
        ["Enabled"] = {
			["Set"] = function(self, flag)
                if flag then
                    self:Enable()
                else
                    self:Disable()
                end
			end,

			["Get"] = function(self)
				return (self:IsEnabled() and true) or false
			end,

			["Type"] = "boolean",
        },
		-- Style
        ["Style"] = {
			["Set"] = function(self, style)
                self:SetStyle(style)
			end,

			["Get"] = function(self)
				return self:GetStyle()
			end,

			["Type"] = _StyleType,
		},
    }

    -- New
    local _New = function(parent)
        -- ScrollBar
		local scrollBar = CreateFrame("Frame",nil,parent)

        scrollBar:SetWidth(18)
        scrollBar:ClearAllPoints()
        scrollBar:SetPoint("TOPRIGHT", parent, "TOPRIGHT", -8, -8)
        scrollBar:SetPoint("BOTTOM", parent, "BOTTOM", 0, 8)

        local slider = CreateFrame("Slider", "Slider", scrollBar)
        slider:ClearAllPoints()
        slider:SetPoint("LEFT", scrollBar, "LEFT", 0, 0)
        slider:SetPoint("RIGHT", scrollBar, "RIGHT", 0, 0)
        slider:SetPoint("TOP", scrollBar, "TOP", 0, -24)
        slider:SetPoint("BOTTOM", scrollBar, "BOTTOM", 0, 24)
        slider:SetThumbTexture("Interface\\Buttons\\UI-ScrollBar-Knob.blp")
        slider.MouseWheelEnabled = true
		slider.OnEnter = OnEnter
		slider.OnLeave = OnLeave

        local texture = slider:GetThumbTexture()
        texture:SetTexCoord(7/32, 25/32, 7/32, 24/32)
        texture:SetWidth(18)
        texture:SetHeight(17)
        slider:SetMinMaxValues(1, 10)
        slider:SetValueStep(1)
        slider:SetValue(1)

        local btnScrollUp = CreateFrame("Button", "UpBtn", scrollBar)
        btnScrollUp:SetWidth(32)
        btnScrollUp:SetHeight(32)
        btnScrollUp:ClearAllPoints()
        btnScrollUp:SetPoint("TOP", scrollBar, "TOP", 0, 4)
        btnScrollUp:SetNormalTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Up.blp")
        btnScrollUp:SetPushedTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Down.blp")
        btnScrollUp:SetDisabledTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Disabled.blp")
        btnScrollUp:SetHighlightTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Highlight.blp", "ADD")
        btnScrollUp:SetHitRectInsets(6, 7, 7, 8)
		btnScrollUp.OnEnter = OnEnter
		btnScrollUp.OnLeave = OnLeave

        local btnScrollDown = CreateFrame("Button", "DownBtn", scrollBar)
        btnScrollDown:SetWidth(32)
        btnScrollDown:SetHeight(32)
        btnScrollDown:ClearAllPoints()
        btnScrollDown:SetPoint("BOTTOM", scrollBar, "BOTTOM", 0, -4)
        btnScrollDown:SetNormalTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Up.blp")
        btnScrollDown:SetPushedTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Down.blp")
        btnScrollDown:SetDisabledTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Disabled.blp")
        btnScrollDown:SetHighlightTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Highlight.blp", "ADD")
        btnScrollDown:SetHitRectInsets(6, 7, 7, 8)
		btnScrollDown.OnEnter = OnEnter
		btnScrollDown.OnLeave = OnLeave

        -- Event Handle
        btnScrollUp.OnClick = clickUpBtn
        btnScrollDown.OnClick = clickDownBtn
        slider.OnValueChanged = scrollChg
        slider.OnMouseWheel = OnMouseWheel

        -- Can be override, Special use.
        scrollBar.__StackScripts["OnValueChanged"] = {
			[0] = OnValueChanged,
		}

        btnScrollUp:Disable()
        btnScrollDown:Disable()

        return scrollBar
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true)
end