﻿-- Author      : Kurapica

---------------------------------------------------------------------------------------------------------------------------------------
--- OptionSlider is using to make settings in numbers
-- <br><br>inherit <a href="..\Base\Slider.html">Slider</a> For all methods, properties and scriptTypes
-- @name OptionSlider
-- @class table
-- @field Title the text to be diplayed at the topleft of the slide bar
-- @field TooltipText  the tooltip to be shown when mouse is over the silder bar
-- @field TooltipAnchor the tooltip's position
---------------------------------------------------------------------------------------------------------------------------------------
do
    -- Check Version
    local version = 2

    if not IGAS:NewAddon("IGAS.GUI.OptionSlider", version) then
        return
    end

    local CreateFrame = IGAS.GUI.CreateFrame

    local _WidgetName = "OptionSlider"
    local _Base = "Slider"

    local _GUI = IGAS.GUI
    local _Widget = IGAS.GUI.Widget

	local GameTooltip = IGAS:GetWrapper(_G.GameTooltip)
	local _AnchorType = IGAS:GetEnum("Anchor")

    -- Script
    local _FrameBackdrop = {
        bgFile = "Interface\\Buttons\\UI-SliderBar-Background",
        edgeFile = "Interface\\Buttons\\UI-SliderBar-Border",
        tile = true, tileSize = 8, edgeSize = 8,
        insets = { left = 3, right = 3, top = 6, bottom = 6 }
    }

	local function OnEnter(self)
		if self.Enabled then
			if self.__TooltipText and self.__TooltipText ~= "" then
				GameTooltip:SetOwner(self, self.__TooltipAnchor or "ANCHOR_RIGHT")
				GameTooltip:SetText(self:GetChild("Title").Text, nil, nil, nil, nil, 1)
				GameTooltip:AddLine(self.__TooltipText, 1.0, 1.0, 1.0, 1.0)
				GameTooltip:Show()
			end
		end
	end

	local function OnLeave(self)
		GameTooltip:Hide()
	end

	local function OnValueChanged(self)
		self.Text.Text = ""..self.Value
	end

    -- ScriptType
    local _ScriptType = {
    }

    --    FuncProxy
    local _FuncProxy = {
		------------------------------------
		--- Sets the minimum and maximum values for the slider
		-- @name OptionSlider:SetMinMaxValues
		-- @class function
		-- @param minValue - Lower boundary for values represented by the slider position (number)
		-- @param maxValue - Upper boundary for values represented by the slider position (number)
		-- @usage OptionSlider:SetMinMaxValues(1, 100)
		------------------------------------

		-- SetMinMaxValues
		["SetMinMaxValues"] = function(self, minV, maxV)
			if type(minV) ~= "number" or type(maxV) ~= "number" or minV >= maxV then
				return
			end

			self.Low.Text = ""..minV
			self.High.Text = ""..maxV

			if self.Value > maxV then
				self.Value = maxV
			elseif self.Value < minV then
				self.Value = minV
			end

			self.Text.Text = ""..self.Value

			-- Call super's dispose
			self:CallMethod(_Base, "SetMinMaxValues", minV, maxV)
		end,
    }

    --    Property
    local _Property = {
        -- Orientation, can't be changed
        ["Orientation"] = {
			["Get"] = function(self)
				return self.__UI:GetOrientation()
			end,

			["Type"] = "Orientation",
		},
		-- Title
        ["Title"] = {
			["Set"] = function(self, title)
				self:GetChild("Title").Text = title
			end,

			["Get"] = function(self)
				return self:GetChild("Title").Text
			end,

			["Type"] = "string",
		},
		-- TooltipText
        ["TooltipText"] = {
			["Set"] = function(self, text)
				if type(text) == "string" and text ~= "" then
					self.__TooltipText = text
				else
					self.__TooltipText = nil
				end
			end,

			["Get"] = function(self)
				return self.__TooltipText or ""
			end,

			["Type"] = "string",
		},
		-- TooltipAnchor
        ["TooltipAnchor"] = {
			["Set"] = function(self, anchor)
				self.__TooltipAnchor = nil
				if anchor and _AnchorType[anchor] then
					self.__TooltipAnchor = anchor
				end
			end,

			["Get"] = function(self)
				return self.__TooltipAnchor or "ANCHOR_RIGHT"
			end,

			["Type"] = "Anchor",
		},
    }

    local function _New(parent)
        local slider = CreateFrame("Slider", "Slider", parent)
        slider.Orientation = "HORIZONTAL"
        slider.Height = 17
		slider.Width = 144
		slider.ValueStep = 1
		slider:SetMinMaxValues(1, 10)

        slider.ThumbTexturePath = "Interface\\Buttons\\UI-SliderBar-Button-Horizontal"
        slider.ThumbTexture.Height = 32
        slider.ThumbTexture.Width = 32

        slider:SetHitRectInsets(0, 0, -10, -10)
        slider:SetBackdrop(_FrameBackdrop)

        local title = CreateFrame("FontString", "Title", slider, "ARTWORK", "GameFontHighlight")
		title:SetPoint("BOTTOM", slider, "TOP", 0, 0)

		local low = CreateFrame("FontString", "Low", slider, "ARTWORK", "GameFontHighlightSmall")
		low:SetPoint("TOPLEFT", slider, "BOTTOMLEFT", -4, 3)
		low.Text = "1"

		local high = CreateFrame("FontString", "High", slider, "ARTWORK", "GameFontHighlightSmall")
		high:SetPoint("TOPRIGHT", slider, "BOTTOMRIGHT", 4, 3)
		high.Text = "10"

		local text = CreateFrame("FontString", "Text", slider, "ARTWORK", "GameFontHighlightSmall")
		text:SetPoint("TOP", slider, "BOTTOM", 0, 0)
		text.Text = "1"

		slider.Value = 1

		slider:StackScript("OnEnter", OnEnter)
		slider:StackScript("OnLeave", OnLeave)
		slider:StackScript("OnValueChanged", OnValueChanged)

        return slider
    end

    -- Register
    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true)
end
