﻿-- Author      : Kurapica

---------------------------------------------------------------------------------------------------------------------------------------
--- GroupBox is created as a box to contains other frames.
-- <br><br>inherit <a href="..\Base\Frame.html">Frame</a> For all methods, properties and scriptTypes
-- @name GroupBox
-- @class table
-- @field Caption the groupbox's caption text
---------------------------------------------------------------------------------------------------------------------------------------
do
    -- Check Version
    local version = 2

    if not IGAS:NewAddon("IGAS.GUI.GroupBox", version) then
        return
    end

    local CreateFrame = IGAS.GUI.CreateFrame

    local _WidgetName = "GroupBox"
    local _Base = "Frame"

    local _GUI = IGAS.GUI
    local _Widget = IGAS.GUI.Widget

    -- Script
    local _FrameBackdrop = {
        bgFile = "Interface\\Buttons\\UI-SliderBar-Background",
        edgeFile = "Interface\\Buttons\\UI-SliderBar-Border",
        tile = true, tileSize = 8, edgeSize = 8,
        insets = { left = 3, right = 3, top = 6, bottom = 6 }
    }

    -- ScriptType
    local _ScriptType = {
    }

    --    FuncProxy
    local _FuncProxy = {
    }

    --    Property
    local _Property = {
        -- Text
        ["Caption"] = {
            ["Set"] = function(self, text)
                self:GetChild("Text").Text = text
            end,

            ["Get"] = function(self)
                return self:GetChild("Text").Text
            end,

            ["Type"] = "string",
        },
    }

    local function _New(parent)
        local frame = CreateFrame("Frame",nil,parent)

        frame.Width = 700
        frame.Height = 500
        frame.FrameStrata = "DIALOG"
        frame.Toplevel = true

        frame:SetPoint("CENTER",parent,"CENTER",0,0)
        frame:SetBackdrop(_FrameBackdrop)
        frame:SetBackdropColor(0,0,0,1)

        local text = CreateFrame("FontString", "Text", frame, "OVERLAY","GameFontNormal")
        text.JustifyH = "LEFT"
        text:SetPoint("BOTTOMLEFT", frame, "TOPLEFT", 0, 0)
        text.Text = "GroupBox"

        return frame
    end

    -- Register
    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true)
end