﻿-- Author      : Kurapica,zys924

------------------------------------------------------------------------------------------------------------------------------------------------------------------
--- Form is using as a base frame to contain other frames. It can move, resize, has a caption, a close button, and a message bar.
-- <br><br>inherit <a href="..\Base\Frame.html">Frame</a> For all methods, properties and scriptTypes
-- @name Form
-- @class table
-- @field CaptionAlign the caption's align:LEFT, RIGHT, CENTER
-- @field TitleBarColor the title bar's color, default alpha is 0, so make it can't be see
-- @field ShowCloseButton whether the close button is shown
-- @field Caption The text to be displayed at the top of the form.
-- @field Message The text to be displayed at the bottom of the form.
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 3
	if not IGAS:NewAddon("IGAS.GUI.Form", version) then
		return
	end

	-- API Localization
	local pairs = pairs
    local ipairs = ipairs
    local type = type
    local error = error
    local CreateFrame = IGAS.GUI.CreateFrame

	-- Widget Name & Inherit
	local _WidgetName = "Form"
	local _Base = "Frame"

	-- Define Style
    -- Style
    local TEMPLATE_COMMON = "COMMON"
    local TEMPLATE_LIGHT = "LIGHT"

    -- Define Block
	local _StyleEnum = IGAS:NewEnum("FormStyle", {
        TEMPLATE_COMMON,
		TEMPLATE_LIGHT,
    })

	local _StyleType = IGAS:NewPropertyType("FormStyle", {
		["Type"] = "enum",
		["EnumType"] = _StyleEnum,
	})

	-- Backdrop Handlers
	local _FrameBackdrop = {
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
		tile = true, tileSize = 16, edgeSize = 16,
		insets = { left = 3, right = 3, top = 3, bottom = 3 }
	}
	local _FrameBackdropTitle = {
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
		edgeFile = "",
		tile = true, tileSize = 16, edgeSize = 0,
		insets = { left = 3, right = 3, top = 3, bottom = 0 }
	}
	local _FrameBackdropCommon = {
		bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
		edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
		tile = true, tileSize = 32, edgeSize = 32,
		insets = { left = 11, right = 12, top = 12, bottom = 11 }
	}

	-- Event Handlers
	local function frameOnMouseDown(self)
		if not self.Parent.InDesignMode then
			self.Parent:StartMoving()
		end
	end

	local function frameOnMouseUp(self)
		self.Parent:StopMovingOrSizing()
	end

	local function sizerseOnMouseDown(self)
		if not self.Parent.InDesignMode and self:GetParent().Resizable then
			self.Parent:StartSizing("BOTTOMRIGHT")
		end
	end

	local function sizerOnMouseUp(self)
		self.Parent:StopMovingOrSizing()
	end

	-- ScriptType
	local _ScriptType = {
	}

	--	FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Sets the ComboBox's style
		-- @name ComboBox:SetStyle
		-- @class function
		-- @param style the style of the ComboBox : COMMON, LIGHT
		-- @usage ComboBox:SetStyle("LIGHT")
		------------------------------------

        -- SetStyle
        ["SetStyle"] = function(self, style)
            local t

            -- Check Style
            if not style or type(style) ~= "string" or style == self.__Style then
                return
            end

            -- Change Style
            if style == TEMPLATE_COMMON then
				self:SetBackdrop(_FrameBackdropCommon)

				self.Form_Btn_Close:SetPoint("TOPRIGHT", self, "TOPRIGHT", -2, -4)
				
				self.Form_Caption:SetBackdrop(nil)
				self.Form_Caption:ClearAllPoints()
				self.Form_Caption:SetPoint("TOP", self, "TOP", 0, 12)
				self.Form_Caption.Width = 136
				self.Form_Caption.Height = 36
				self.Form_Caption.Text.JustifyV = "MIDDLE"
				self.Form_Caption.Text.JustifyH = "CENTER"
				
				self.Form_Caption.Text:SetPoint("LEFT", self.Form_Caption, "LEFT")
				self.Form_Caption.Text:SetPoint("RIGHT", self.Form_Caption, "RIGHT")

				self.Sizer_se:SetPoint("BOTTOMRIGHT", self, "BOTTOMRIGHT", -8, 8)
				self.Form_StatusBar_Text:SetPoint("BOTTOMLEFT", self, "BOTTOMLEFT", 11, 11)

				local backTexture = CreateFrame("Texture", "HeaderBack", self.Form_Caption, "BACKGROUND")

				backTexture.TexturePath = [[Interface\DialogFrame\UI-DialogBox-Header]]
				backTexture:SetAllPoints(self.Form_Caption)
				backTexture:SetTexCoord(0.24, 0.76, 0, 0.56)
				backTexture.Visible = true
				
				if self:GetChild("Form_Caption"):GetChild("Text").Width + 36 > 136 then
					self:GetChild("Form_Caption").Width = self:GetChild("Form_Caption"):GetChild("Text").Width + 36
				else
					self:GetChild("Form_Caption").Width = 136
				end
            elseif style == TEMPLATE_LIGHT then
				self:SetBackdrop(_FrameBackdrop)
				self:SetBackdropColor(0, 0, 0)
				self:SetBackdropBorderColor(0.4, 0.4, 0.4)

				local title = CreateFrame("Frame", "Form_Caption", self)
				title:ClearAllPoints()
				title:SetPoint("TOPLEFT", self, "TOPLEFT", 0, 0)
				title:SetPoint("RIGHT", self, "RIGHT")
				title:SetBackdrop(_FrameBackdropTitle)
				title:SetBackdropColor(1, 0, 0, 0)
				title.Height = 24
				
				self.Form_Caption.Text:SetPoint("LEFT", self.Form_Caption, "LEFT", 4, 0)
				self.Form_Caption.Text:SetPoint("RIGHT", self.Form_Caption, "RIGHT", -32, 0)
				
				if title.HeaderBack then
					title.HeaderBack.Visible = false
				end

				local CloseButton = CreateFrame("Button", "Form_Btn_Close", self)
				CloseButton:SetPoint("TOPRIGHT", self, "TOPRIGHT", 2, 0)

				local statusText = CreateFrame("FontString", "Form_StatusBar_Text", self, "OVERLAY", "GameFontNormal")
				statusText:SetPoint("BOTTOMLEFT", self, "BOTTOMLEFT", 6, 4)

				-- Sizer
				local sizer_se = CreateFrame("Button", "Sizer_se", self)
				sizer_se:SetPoint("BOTTOMRIGHT", self, "BOTTOMRIGHT", 0, 0)
            end

			self.__Style = style
        end,

		------------------------------------
		--- Gets the ComboBox's style
		-- @name ComboBox:GetStyle
		-- @class function
		-- @return the style of the ComboBox : COMMON, LIGHT
		-- @usage ComboBox:GetStyle()
		------------------------------------

        -- GetStyle
        ["GetStyle"] = function(self)
            return self.__Style or TEMPLATE_LIGHT
        end,

		-- SetResizable, Override
        ["SetResizable"] = function(self, enabled)
			enabled = (enabled and true) or false
			self.Sizer_se.Visible = enabled

			return self:CallMethod(_Base, "SetResizable", enabled)
        end,
	}

	--	Property
	local _Property = {
		-- Style
        ["Style"] = {
			["Set"] = function(self, style)
                self:SetStyle(style)
			end,

			["Get"] = function(self)
				return self:GetStyle()
			end,

			["Type"] = "FormStyle",
		},
		-- CaptionAlign
		["CaptionAlign"]={
			["Get"] = function(self)
				return self:GetChild("Form_Caption"):GetChild("Text").JustifyH
			end,
			["Set"] = function(self, value)				
				if self.Style ~= TEMPLATE_COMMON then
					self:GetChild("Form_Caption"):GetChild("Text").JustifyH = value
				end
			end,
			["Type"] = "JustifyH",
		},

		-- TitleBarColor
		["TitleBarColor"]={
			["Get"] = function(self)
				return self:GetChild("Form_Caption").BackdropColor
			end,
			["Set"] = function(self, value)
				self:GetChild("Form_Caption").BackdropColor = value
			end,
			["Type"] = "Color",
		},

		-- HasCloseButton
		["ShowCloseButton"]={
			["Get"] = function(self)
				return self:GetChild("Form_Btn_Close").Visible
			end,
			["Set"] = function(self, value)
				self:GetChild("Form_Btn_Close").Visible = value
			end,
			["Type"] = "boolean",
		},

		-- Caption
		["Caption"] = {
			["Set"] = function(self, title)
				self:GetChild("Form_Caption"):GetChild("Text").Text = title
				
				if self.Style == TEMPLATE_COMMON then
					if self:GetChild("Form_Caption"):GetChild("Text").Width + 36 > 136 then
						self:GetChild("Form_Caption").Width =  self:GetChild("Form_Caption"):GetChild("Text").Width + 36
					else
						self:GetChild("Form_Caption").Width = 136
					end
				end
			end,
			["Get"] = function(self)
				return self:GetChild("Form_Caption"):GetChild("Text").Text
			end,
			["Type"] = "string",
		},

		-- Message
		["Message"] = {
			["Set"] = function(self, mes)
				self:GetChild("Form_StatusBar_Text").Text = mes
			end,
			["Get"] = function(self)
				return self:GetChild("Form_StatusBar_Text").Text
			end,
			["Type"] = "string",
		},
	}

	local function _New(parent)
		-- New Frame
		local frame = CreateFrame("Frame",nil,parent)

		frame.Width = 400
		frame.Height = 300
		frame.Movable = true
		frame.Resizable = true
		frame.Toplevel = true

		frame:SetPoint("CENTER",parent,"CENTER",0,0)
		frame:SetMinResize(300,200)
        frame:SetBackdrop(_FrameBackdrop)
		frame:SetBackdropColor(0, 0, 0)
		frame:SetBackdropBorderColor(0.4, 0.4, 0.4)

		local title = CreateFrame("Frame", "Form_Caption", frame)
		title.MouseEnabled = true
		title.Height = 24
		title:SetPoint("TOPLEFT", frame, "TOPLEFT", 0, 0)
		title:SetPoint("RIGHT", frame, "RIGHT")
		title:SetBackdrop(_FrameBackdropTitle)
		title:SetBackdropColor(1, 0, 0, 0)
		title.OnMouseDown = frameOnMouseDown
		title.OnMouseUp = frameOnMouseUp

		local CloseButton = CreateFrame("Button", "Form_Btn_Close", frame)
		CloseButton:SetPoint("TOPRIGHT", frame, "TOPRIGHT", 2, 0)
		CloseButton.FrameLevel = title.FrameLevel + 1
        CloseButton.Style = "CLOSE"

		local titleText = CreateFrame("FontString", "Text", title, "OVERLAY", "GameFontNormal")
		titleText:SetPoint("LEFT", title, "LEFT", 4, 0)
		titleText:SetPoint("RIGHT", title, "RIGHT", -32, 0)
		titleText:SetPoint("CENTER", title, "CENTER")
		titleText.Height = 24
		titleText.Text = "Form"
		titleText.JustifyV = "MIDDLE"
		titleText.JustifyH = "CENTER"

        local statusText = CreateFrame("FontString", "Form_StatusBar_Text", frame, "OVERLAY", "GameFontNormal")
        statusText.JustifyH = "LEFT"
        statusText:SetPoint("BOTTOMLEFT", frame, "BOTTOMLEFT", 6, 4)
        statusText:SetPoint("RIGHT", frame, "RIGHT")
        statusText:SetText("")

		-- Sizer
		local sizer_se = CreateFrame("Button", "Sizer_se", frame)
		sizer_se.Width = 16
		sizer_se.Height = 16
		sizer_se.MouseEnabled = true
		sizer_se:SetPoint("BOTTOMRIGHT", frame, "BOTTOMRIGHT", 0, 0)
		sizer_se.OnMouseDown = sizerseOnMouseDown
		sizer_se.OnMouseUp = sizerOnMouseUp
		sizer_se.NormalTexturePath = [[Interface\ChatFrame\UI-ChatIM-SizeGrabber-Up]]
		sizer_se.HighlightTexturePath = [[Interface\ChatFrame\UI-ChatIM-SizeGrabber-Highlight]]
		sizer_se.PushedTexturePath = [[Interface\ChatFrame\UI-ChatIM-SizeGrabber-Down]]

		frame.MouseWheelEnabled = true
		frame.MouseEnabled = true

		return frame
	end

	-- Register
	local _WidgetInfo = {
		["WidgetName"] = _WidgetName,
		["Base"] = _Base,
		["FuncProxy"] = _FuncProxy,
		["Property"] = _Property,
		["ScriptType"] = _ScriptType,
		["New"] = _New,
	}

	IGAS:NewWidget(_WidgetInfo, true)
end
