﻿-- Author      : Kurapica

---------------------------------------------------------------------------------------------------------------------------------------
--- CheckBox is a widget type using for boolean selection with a label.
-- <br><br>inherit <a href="..\Base\Button.html">Button</a> For all methods, properties and scriptTypes
-- @name CheckBox
-- @class table
-- @field Checked whether the checkbox is checked
-- @field Text the text to be displayed for informations
-- @filed TrueText the text to be displayed when the checkbox is checked
-- @field FalseText the text to be displyed when the checkbox is un-checked
---------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 3

	if not IGAS:NewAddon("IGAS.GUI.CheckBox", version) then
		return
	end

	local CreateFrame = IGAS.GUI.CreateFrame

	local _WidgetName = "CheckBox"
	local _Base = "Button"

	-- Script
    local function OnClick(self, ...)
        self:GetChild("ChkBtn").Checked = not self:GetChild("ChkBtn").Checked
		if self:GetChild("ChkBtn").Checked and self.TrueText then
			self.Text = self.TrueText
		elseif (not self:GetChild("ChkBtn").Checked) and self.FalseText then
			self.Text = self.FalseText
		end
        return self:Fire("OnValueChanged", self:GetChild("ChkBtn").Checked)
    end

    local function OnEnter(self)
        self.Parent:GetHighlightTexture():Show()
    end

    local function OnLeave(self)
        self.Parent:GetHighlightTexture():Hide()
    end

	-- ScriptType
	local _ScriptType = {
		------------------------------------
		--- ScriptType, Run when the checkbox's checking state is changed
		-- @name CheckBox:OnValueChanged
		-- @class function
		-- @param checked true if the checkbox is checked
		-- @usage function CheckBox:OnValueChanged(checked)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
        ["OnValueChanged"] = true,
	}

	--	FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Sets the checkbox's checking state
		-- @name CheckBox:SetChecked
		-- @class function
		-- @param checked true if set the checkbox to be checked
		-- @usage CheckBox:SetChecked(true)
		------------------------------------

        -- SetChecked
        ["SetChecked"] = function(self, flag)
            self:GetChild("ChkBtn").Checked = (flag and true) or false
			if self:GetChild("ChkBtn").Checked and self.TrueText then
				self.Text = self.TrueText
			elseif (not self:GetChild("ChkBtn").Checked) and self.FalseText then
				self.Text = self.FalseText
			end
        end,

		------------------------------------
		--- Gets the checkbox's checking state
		-- @name CheckBox:GetChecked
		-- @class function
		-- @return checked - true if set the checkbox to be checked
		-- @usage CheckBox:GetChecked()
		------------------------------------

        -- GetChecked
        ["GetChecked"] = function(self)
            return self:GetChild("ChkBtn").Checked or false
        end,

		------------------------------------
		--- Sets the checkbox's label
		-- @name CheckBox:SetText
		-- @class function
		-- @param text the text to be displyed
		-- @usage CheckBox:SetText("Enable the addon")
		------------------------------------

        -- SetText
        ["SetText"] = function(self, text)
            self:GetChild("Text").Text = text
        end,

		------------------------------------
		--- Gets the checkbox's label
		-- @name CheckBox:GetText
		-- @class function
		-- @return text - the text to be displyed
		-- @usage CheckBox:GetText()
		------------------------------------

        -- GetText
        ["GetText"] = function(self)
            return self:GetChild("Text").Text
        end,

		------------------------------------
		--- Enable the checkbox, make it clickable
		-- @name CheckBox:Enable
		-- @class function
		-- @usage CheckBox:Enable()
		------------------------------------

        -- Enable
        ["Enable"] = function(self)
            self.__UI:Enable()
            self:GetChild("ChkBtn"):Enable()
        end,

		------------------------------------
		--- Disable the checkbox, make it un-clickable
		-- @name CheckBox:Disable
		-- @class function
		-- @usage CheckBox:Disable()
		------------------------------------

        -- Disable
        ["Disable"] = function(self)
            self.__UI:Disable()
            self:GetChild("ChkBtn"):Disable()
        end,
	}

	--	Property
	local _Property = {
        -- Style
        ["Style"] = {
			["Get"] = function(self)
				return nil
			end,
		},
        -- Checked
        ["Checked"] = {
			["Set"] = function(self, value)
				self:SetChecked(value)
			end,

			["Get"] = function(self)
				return (self:GetChecked() and true) or false
			end,

			["Type"] = "boolean",
		},
		-- Text
		["Text"] = {
			["Set"] = function(self, text)
				self:SetText(text)
                self.Width = self:GetChild("Text").Width + 26
			end,

			["Get"] = function(self)
				return self:GetText()
			end,

			["Type"] = "string",
		},
		-- TrueText
		["TrueText"] = {
			["Set"] = function(self, text)
				self.__TrueText = text and tostring(text)
			end,

			["Get"] = function(self)
				return self.__TrueText
			end,

			["Type"] = "string",
		},
		-- FalseText
		["FalseText"] = {
			["Set"] = function(self, text)
				self.__FalseText = text and tostring(text)
			end,

			["Get"] = function(self)
				return self.__FalseText
			end,

			["Type"] = "string",
		},
	}

	local function _New(parent)
		-- New Frame
		local frame = CreateFrame("Button",nil,parent)

        frame.Height = 24
        frame.Width = 100
        frame.MouseEnabled = true

        local chkBtn = CreateFrame("CheckButton", "ChkBtn", frame)
        chkBtn:SetPoint("TOPLEFT", frame, "TOPLEFT")
        chkBtn.MouseEnabled = false

        local text = CreateFrame("FontString","Text",frame,"OVERLAY","GameFontNormal")
        text.JustifyH = "LEFT"
        text:SetPoint("TOPLEFT", chkBtn, "TOPRIGHT")
        text:SetPoint("BOTTOMRIGHT", frame, "BOTTOMRIGHT")
        text.Text = ""

        frame:SetHighlightTexture("Interface\\PaperDollInfoFrame\\UI-Character-Tab-Highlight")
        local t = frame:GetHighlightTexture()
        t:SetBlendMode("ADD")
        t:SetAllPoints(text)

        chkBtn.OnEnter = OnEnter
        chkBtn.OnLeave = OnLeave
        frame:StackScript("OnClick", OnClick)

		return frame
	end

	-- Register
	local _WidgetInfo = {
		["WidgetName"] = _WidgetName,
		["Base"] = _Base,
		["FuncProxy"] = _FuncProxy,
		["Property"] = _Property,
		["ScriptType"] = _ScriptType,
		["New"] = _New,
	}

	IGAS:NewWidget(_WidgetInfo, true)
end
