﻿-- Author      : Kurapica
-- Create Date : 8/18/2009

----------------------------------------------------------------------------------------------------------------------------------------
--- Translation is an Animation type that applies an affine translation to its affected region automatically as it progresses.
-- <br><br>inherit <a href=".\Animation.html">Animation</a> For all methods, properties and scriptTypes
-- @name Translation
-- @class table
-- @field Offset the animation's translation offsets
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.Translation", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "Translation"
    local _Base = "Animation"

	-- ScriptType
	local _ScriptType = {
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Sets the animation's translation offsets
		-- @name Translation:SetOffset
		-- @class function
		-- @param xOffset Distance away from the left edge of the screen (in pixels) to move the region over the animation's duration (number)
		-- @param yOffset Distance away from the bottom edge of the screen (in pixels) to move the region over the animation's duration (number)
		-- @usage Translation:SetOffset(10, 20)
		------------------------------------

		-- SetOffset
		["SetOffset"] = function(self, x, y)
			self.__UI:SetOffset(x, y)
		end,

		------------------------------------
		--- Gets the animation's translation offsets
		-- @name Translation:GetOffset
		-- @class function
		-- @return xOffset - Distance away from the left edge of the screen (in pixels) to move the region over the animation's duration (number)
		-- @return yOffset - Distance away from the bottom edge of the screen (in pixels) to move the region over the animation's duration (number)
		-- @usage Translation:GetOffset()
		------------------------------------

		-- GetOffset
		["GetOffset"] = function(self)
			return self.__UI:GetOffset()
		end,
	}

	-- Property
	local _Property = {
        -- Offset
        ["Offset"] = {
			["Set"] = function(self, offset)
				self:SetOffset(offset.x, offset.y)
			end,
			["Get"] = function(self)
				local offset = {}
				offset.x, offset.y = self:GetOffset()
				return offset
			end,

			["Type"] = "Offset",
		},
	}

    -- New
    local _New = function(_parent,inheritsFrom)
		if _parent and _parent["CreateAnimation"] then
			return IGAS:GetUI(_parent):CreateAnimation(_WidgetName, nil, inheritsFrom)
		end
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

	local _ScanFrameParent = IGAS:NewFrame("AnimationGroup")

    IGAS:NewWidget(_WidgetInfo, true, true, _ScanFrameParent)

	_ScanFrameParent:Dispose()
end