﻿-- Author      : Kurapica
-- Create Date : 7/16/2008 15:10

----------------------------------------------------------------------------------------------------------------------------------------
--- TabardModel is a frame type provided specifically for designing or modifying guild tabards.
-- <br><br>inherit <a href=".\PlayerModel.html">PlayerModel</a> For all methods, properties and scriptTypes
-- @name TabardModel
-- @class table
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.TabardModel", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "TabardModel"
    local _Base = "PlayerModel"

	-- ScriptType
	local _ScriptType = {
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Returns whether the tabard model's current design can be saved as the player's guild tabard
		-- @name TabardModel:CanSaveTabardNow
		-- @class function
		-- @return enabled - 1 if the tabard model's current design can be saved as the player's guild tabard; otherwise nil
		-- @usage TabardModel:CanSaveTabardNow()
		------------------------------------

		-- CanSaveTabardNow
		["CanSaveTabardNow"] = function(self, ...)
			return self.__UI:CanSaveTabardNow(...)
		end,

		------------------------------------
		--- Cycles through available design variations for the tabard model
		-- @name TabardModel:CycleVariation
		-- @class function
		-- @param variable Number identifying one of the five tabard design variables:<br> 1 - Icon<br> 2 - Icon color<br> 3 - Border style<br> 4 - Border color<br> 5 - Background color
		-- @param delta Number of steps by which to cycle through available options for the design variable (e.g. 1 for next design, -1 for previous design, 3 to skip ahead by three)
		-- @usage TabardModel:CycleVariation(1, 1)
		------------------------------------

		-- CycleVariation
		["CycleVariation"] = function(self, ...)
			return self.__UI:CycleVariation(...)
		end,

		------------------------------------
		--- Returns the image file for the lower portion of the tabard model's current background design
		-- @name TabardModel:GetLowerBackgroundFileName
		-- @class function
		-- @param filename Path to the texture image file for the lower portion of the tabard model's current background design
		-- @usage TabardModel:GetLowerBackgroundFileName("filename")
		------------------------------------

		-- GetLowerBackgroundFileName
		["GetLowerBackgroundFileName"] = function(self, ...)
			return self.__UI:GetLowerBackgroundFileName(...)
		end,

		------------------------------------
		--- Returns the image file for the lower portion of the tabard model's current emblem design
		-- @name TabardModel:GetLowerEmblemFileName
		-- @class function
		-- @param filename Path to the texture image file for the lower portion of the tabard model's current emblem design
		-- @usage TabardModel:GetLowerEmblemFileName("filename")
		------------------------------------

		-- GetLowerEmblemFileName
		["GetLowerEmblemFileName"] = function(self, ...)
			return self.__UI:GetLowerEmblemFileName(...)
		end,

		------------------------------------
		--- Sets a Texture object to display the lower portion of the tabard model's current emblem design
		-- @name TabardModel:GetLowerEmblemTexture
		-- @class function
		-- @param texture Reference to a Texture objec
		-- @usage TabardModel:GetLowerEmblemTexture("texture")
		------------------------------------

		-- GetLowerEmblemTexture
		["GetLowerEmblemTexture"] = function(self, ...)
			return self.__UI:GetLowerEmblemTexture(...)
		end,

		------------------------------------
		--- Returns the image file for the upper portion of the tabard model's current background design
		-- @name TabardModel:GetUpperBackgroundFileName
		-- @class function
		-- @param filename Path to the texture image file for the upper portion of the tabard model's current background design
		-- @usage TabardModel:GetUpperBackgroundFileName("filename")
		------------------------------------

		-- GetUpperBackgroundFileName
		["GetUpperBackgroundFileName"] = function(self, ...)
			return self.__UI:GetUpperBackgroundFileName(...)
		end,

		------------------------------------
		--- Returns the image file for the upper portion of the tabard model's current emblem design
		-- @name TabardModel:GetUpperEmblemFileName
		-- @class function
		-- @param filename Path to the texture image file for the upper portion of the tabard model's current emblem design
		-- @usage TabardModel:GetUpperEmblemFileName("filename")
		------------------------------------

		-- GetUpperEmblemFileName
		["GetUpperEmblemFileName"] = function(self, ...)
			return self.__UI:GetUpperEmblemFileName(...)
		end,

		------------------------------------
		--- Sets a Texture object to display the upper portion of the tabard model's current emblem design
		-- @name TabardModel:GetUpperEmblemTexture
		-- @class function
		-- @param texture Reference to a Texture object
		-- @usage TabardModel:GetUpperEmblemTexture("texture")
		------------------------------------

		-- GetUpperEmblemTexture
		["GetUpperEmblemTexture"] = function(self, ...)
			return self.__UI:GetUpperEmblemTexture(...)
		end,

		------------------------------------
		--- Sets the tabard model's design to match the player's guild tabard. If the player is not in a guild or the player's guild does not yet have a tabard design, randomizes the tabard model's design.
		-- @name TabardModel:InitializeTabardColors
		-- @class function
		-- @usage TabardModel:InitializeTabardColors()
		------------------------------------

		-- InitializeTabardColors
		["InitializeTabardColors"] = function(self, ...)
			return self.__UI:InitializeTabardColors(...)
		end,

		------------------------------------
		--- Save the tabard.
		-- @name TabardModel:Save
		-- @class function
		-- @usage TabardModel:Save()
		------------------------------------

		-- Save
		["Save"] = function(self, ...)
			return self.__UI:Save(...)
		end,
    }

	-- Property
	local _Property = {
	}

    -- New
    local _New = function(_parent,inheritFrame)
        -- New Frame
		return CreateFrame(_WidgetName,nil,IGAS:GetUI(_parent),inheritFrame)
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true, true)
end