﻿-- Author      : Kurapica
-- Create Date : 7/16/2008 14:36

----------------------------------------------------------------------------------------------------------------------------------------
--- The most sophisticated control over text display is offered by SimpleHTML widgets. When its text is set to a string containing valid HTML markup, a SimpleHTML widget will parse the content into its various blocks and sections, and lay the text out. While it supports most common text commands, a SimpleHTML widget accepts an additional argument to most of these; if provided, the element argument will specify the HTML elements to which the new style information should apply, such as formattedText:SetTextColor("h2", 1, 0.3, 0.1) which will cause all level 2 headers to display in red. If no element name is specified, the settings apply to the SimpleHTML widget's default font.
-- <br><br>inherit <a href=".\Frame.html">Frame</a> For all methods, properties and scriptTypes
-- @name SimpleHTML
-- @class table
-- @field HyperlinksEnabled whether hyperlinks in the frame's text are interactive
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.SimpleHTML", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "SimpleHTML"
    local _Base = "Frame"

	-- ScriptType
	local _ScriptType = {
		------------------------------------
		--- ScriptType, Run when the mouse clicks a hyperlink in the scrolling message frame or SimpleHTML frame
		-- @name SimpleHTML:OnHyperlinkClick
		-- @class function
		-- @param linkData Essential data (linktype:linkdata portion) of the hyperlink (e.g. "quest:982:17")
		-- @param link Complete hyperlink text (e.g. "|cffffff00|Hquest:982:17|h[Deep Ocean, Vast Sea]|h|r")
		-- @param button Name of the mouse button responsible for the click action
		-- @usage function SimpleHTML:OnHyperlinkClick(linkData, link, button)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnHyperlinkClick"] = true,

		------------------------------------
		--- ScriptType, Run when the mouse moves over a hyperlink in the scrolling message frame or SimpleHTML frame
		-- @name SimpleHTML:OnHyperlinkEnter
		-- @class function
		-- @param linkData Essential data (linktype:linkdata portion) of the hyperlink (e.g. "quest:982:17")
		-- @param link Complete hyperlink text (e.g. "|cffffff00|Hquest:982:17|h[Deep Ocean, Vast Sea]|h|r")
		-- @usage function SimpleHTML:OnHyperlinkEnter(linkData, link)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnHyperlinkEnter"] = true,

		------------------------------------
		--- ScriptType, Run when the mouse moves away from a hyperlink in the scrolling message frame or SimpleHTML frame
		-- @name SimpleHTML:OnHyperlinkLeave
		-- @class function
		-- @param linkData Essential data (linktype:linkdata portion) of the hyperlink (e.g. "quest:982:17")
		-- @param link Complete hyperlink text (e.g. "|cffffff00|Hquest:982:17|h[Deep Ocean, Vast Sea]|h|r")
		-- @usage function SimpleHTML:OnHyperlinkLeave(linkData, link)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnHyperlinkLeave"] = true,
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Returns basic properties of a font used in the frame
		-- @name SimpleHTML:GetFont
		-- @class function
		-- @param element Optional,Name of an HTML element (e.g. p, h1); if omitted, returns information about the frame's default
		-- @return filename - Path to a font file (string)
		-- @return fontHeight - Height (point size) of the font to be displayed (in pixels) (number)
		-- @return flags - Additional properties for the font specified by one or more (separated by commas) of the following tokens:MONOCHROME, OUTLINE, THICKOUTLINE
		-- @usage SimpleHTML:GetFont()
		------------------------------------

		-- GetFont
		["GetFont"] = function(self, ...)
			return self.__UI:GetFont(...)
		end,

		------------------------------------
		--- Returns the Font object from which the properties of a font used in the frame are inherited
		-- @name SimpleHTML:GetFontObject
		-- @class function
		-- @param element Optional,Name of an HTML element (e.g. p, h1); if omitted, returns information about the frame's default
		-- @return font - Reference to the Font object from which font properties are inherited, or nil if no properties are inherited
		-- @usage SimpleHTML:GetFontObject()
		------------------------------------

		-- GetFontObject
		["GetFontObject"] = function(self, ...)
			return IGAS:GetWrapper(self.__UI:GetFontObject(...))
		end,

		------------------------------------
		--- Returns the format string used for displaying hyperlinks in the frame.
		-- @name SimpleHTML:GetHyperlinkFormat
		-- @class function
		-- @return format - Format string used for displaying hyperlinks in the frame
		-- @usage SimpleHTML:GetHyperlinkFormat()
		------------------------------------

		-- GetHyperlinkFormat
		["GetHyperlinkFormat"] = function(self, ...)
			return self.__UI:GetHyperlinkFormat(...)
		end,

		------------------------------------
		--- Returns whether hyperlinks in the frame's text are interactive
		-- @name SimpleHTML:GetHyperlinksEnabled
		-- @class function
		-- @return 1 if hyperlinks in the frame's text are interactive; otherwise nil
		-- @usage SimpleHTML:GetHyperlinksEnabled()
		------------------------------------

		-- GetHyperlinksEnabled
		["GetHyperlinksEnabled"] = function(self, ...)
			return self.__UI:GetHyperlinksEnabled(...)
		end,

		------------------------------------
		--- Returns the horizontal alignment style for text in the frame
		-- @name SimpleHTML:GetJustifyH
		-- @class function
		-- @param element Optional,Name of an HTML element (e.g. p, h1); if omitted, returns information about the frame's default
		-- @return justify - Horizontal text alignment style
		-- @usage SimpleHTML:GetJustifyH()
		------------------------------------

		-- GetJustifyH
		["GetJustifyH"] = function(self, ...)
			return self.__UI:GetJustifyH(...)
		end,

		------------------------------------
		--- Returns the vertical alignment style for text in the frame
		-- @name SimpleHTML:GetJustifyV
		-- @class function
		-- @param element Optional,Name of an HTML element (e.g. p, h1); if omitted, returns information about the frame's default
		-- @return justify - Vertical text alignment style
		-- @usage SimpleHTML:GetJustifyV()
		------------------------------------

		-- GetJustifyV
		["GetJustifyV"] = function(self, ...)
			return self.__UI:GetJustifyV(...)
		end,

		------------------------------------
		--- Returns the shadow color for text in the frame
		-- @name SimpleHTML:GetShadowColor
		-- @class function
		-- @param element Optional,Name of an HTML element (e.g. p, h1); if omitted, returns information about the frame's default
		-- @return shadowR - Red component of the shadow color (0.0 - 1.0) (number)
		-- @return shadowG - Green component of the shadow color (0.0 - 1.0) (number)
		-- @return shadowB - Blue component of the shadow color (0.0 - 1.0) (number)
		-- @return shadowAlpha - Alpha (opacity) of the text's shadow (0.0 = fully transparent, 1.0 = fully opaque) (number)
		-- @usage SimpleHTML:GetShadowColor()
		------------------------------------

		-- GetShadowColor
		["GetShadowColor"] = function(self, ...)
			return self.__UI:GetShadowColor(...)
		end,

		------------------------------------
		--- Returns the offset of text shadow from text in the frame
		-- @name SimpleHTML:GetShadowOffset
		-- @class function
		-- @param element Optional,Name of an HTML element (e.g. p, h1); if omitted, returns information about the frame's default
		-- @return xOffset - Horizontal distance between the text and its shadow (in pixels) (number)
		-- @return yOffset - Vertical distance between the text and its shadow (in pixels) (number)
		-- @usage SimpleHTML:GetShadowOffset()
		------------------------------------

		-- GetShadowOffset
		["GetShadowOffset"] = function(self, ...)
			return self.__UI:GetShadowOffset(...)
		end,

		------------------------------------
		--- Returns the amount of spacing between lines of text in the frame
		-- @name SimpleHTML:GetSpacing
		-- @class function
		-- @param element Optional,Name of an HTML element (e.g. p, h1); if omitted, returns information about the frame's default
		-- @return spacing - Amount of space between lines of text (in pixels)
		-- @usage SimpleHTML:GetSpacing()
		------------------------------------

		-- GetSpacing
		["GetSpacing"] = function(self, ...)
			return self.__UI:GetSpacing(...)
		end,

		------------------------------------
		--- Returns the color of text in the frame
		-- @name SimpleHTML:GetTextColor
		-- @class function
		-- @param element Optional,Name of an HTML element (e.g. p, h1); if omitted, returns information about the frame's default
		-- @return textR - Red component of the text color (0.0 - 1.0) (number)
		-- @return textG - Green component of the text color (0.0 - 1.0) (number)
		-- @return textB - Blue component of the text color (0.0 - 1.0) (number)
		-- @return textAlpha - Alpha (opacity) of the text (0.0 = fully transparent, 1.0 = fully opaque) (number)
		-- @usage SimpleHTML:GetTextColor()
		------------------------------------

		-- GetTextColor
		["GetTextColor"] = function(self, ...)
			return self.__UI:GetTextColor(...)
		end,

		------------------------------------
		--- Sets basic properties of a font used in the frame
		-- @name SimpleHTML:SetFont
		-- @class function
		-- @param element Optional,Name of an HTML element (e.g. p, h1); if omitted, returns information about the frame's default
		-- @param filename Path to a font file (string)
		-- @param fontHeight Height (point size) of the font to be displayed (in pixels) (number)
		-- @param flags Additional properties for the font specified by one or more (separated by commas) of the following tokens:MONOCHROME, OUTLINE, THICKOUTLINE
		-- @usage SimpleHTML:SetFont("h1", [[Interface\Font\ZZ_Font]], 24)
		------------------------------------

		-- SetFont
		["SetFont"] = function(self, ...)
			return self.__UI:SetFont(...)
		end,

		------------------------------------
		--- Sets the Font object from which the properties of a font used in the frame are inherited.
		-- @name SimpleHTML:SetFontObject
		-- @class function
		-- @param element Optional,Name of an HTML element (e.g. p, h1); if omitted, returns information about the frame's default
		-- @param font Reference to a Font object Or a global name of a font object
		-- @usage SimpleHTML:SetFontObject("h1", GameFontNormal)
		------------------------------------

		-- SetFontObject
		["SetFontObject"] = function(self, element, font)
			return self.__UI:SetFontObject(IGAS:GetUI(element), IGAS:GetUI(font))
		end,

		------------------------------------
		--- Sets the format string used for displaying hyperlinks in the frame. Hyperlinks are specified via HTML in the text input to a SimpleHTML  frame, but in order to be handled as hyperlinks by the game's text engine they need to be formatted like the hyperlinks  used elsewhere.
		-- @name SimpleHTML:SetHyperlinkFormat
		-- @class function
		-- @param format Format string used for displaying hyperlinks in the frame
		-- @usage SimpleHTML:SetHyperlinkFormat("|H%s|h%s|h")
		------------------------------------

		-- SetHyperlinkFormat
		["SetHyperlinkFormat"] = function(self, ...)
			return self.__UI:SetHyperlinkFormat(...)
		end,

		------------------------------------
		--- Enables or disables hyperlink interactivity in the frame. The frame's hyperlink-related script handlers will only be run if hyperlinks are enabled.
		-- @name SimpleHTML:SetHyperlinksEnabled
		-- @class function
		-- @param enable True to enable hyperlink interactivity in the frame; false to disable
		-- @usage SimpleHTML:SetHyperlinksEnabled(true)
		------------------------------------

		-- SetHyperlinksEnabled
		["SetHyperlinksEnabled"] = function(self, ...)
			return self.__UI:SetHyperlinksEnabled(...)
		end,

		------------------------------------
		--- Sets the horizontal alignment style for text in the frame
		-- @name SimpleHTML:SetJustifyH
		-- @class function
		-- @param element Optional,Name of an HTML element for which to set properties (e.g. p, h1); if omitted, sets properties of the frame's default text style
		-- @param justify Horizontal text alignment style
		-- @usage SimpleHTML:SetJustifyH("h1", "LEFT")
		------------------------------------

		-- SetJustifyH
		["SetJustifyH"] = function(self, ...)
			return self.__UI:SetJustifyH(...)
		end,

		------------------------------------
		--- Sets the vertical alignment style for text in the frame
		-- @name SimpleHTML:SetJustifyV
		-- @class function
		-- @param element Optional,Name of an HTML element for which to set properties (e.g. p, h1); if omitted, sets properties of the frame's default text style
		-- @param justify - Vertical text alignment style
		-- @usage SimpleHTML:SetJustifyV("h1", "TOP")
		------------------------------------

		-- SetJustifyV
		["SetJustifyV"] = function(self, ...)
			return self.__UI:SetJustifyV(...)
		end,

		------------------------------------
		--- Sets the shadow color for text in the frame
		-- @name SimpleHTML:SetShadowColor
		-- @class function
		-- @param element Optional,Name of an HTML element for which to set properties (e.g. p, h1); if omitted, sets properties of the frame's default text style
		-- @param shadowR Red component of the shadow color (0.0 - 1.0) (number)
		-- @param shadowG Green component of the shadow color (0.0 - 1.0) (number)
		-- @param shadowB Blue component of the shadow color (0.0 - 1.0) (number)
		-- @param shadowAlpha Optional,Alpha (opacity) of the text's shadow (0.0 = fully transparent, 1.0 = fully opaque) (number)
		-- @usage SimpleHTML:SetShadowColor("h1", 1, 1, 1, 0.9)
		------------------------------------

		-- SetShadowColor
		["SetShadowColor"] = function(self, ...)
			return self.__UI:SetShadowColor(...)
		end,

		------------------------------------
		--- Sets the offset of text shadow from text in the frame
		-- @name SimpleHTML:SetShadowOffset
		-- @class function
		-- @param element Optional,Name of an HTML element for which to set properties (e.g. p, h1); if omitted, sets properties of the frame's default text style
		-- @param xOffset Horizontal distance between the text and its shadow (in pixels)
		-- @param yOffset Vertical distance between the text and its shadow (in pixels)
		-- @usage SimpleHTML:SetShadowOffset("h1", 10, 10)
		------------------------------------

		-- SetShadowOffset
		["SetShadowOffset"] = function(self, ...)
			return self.__UI:SetShadowOffset(...)
		end,

		------------------------------------
		--- Sets the amount of spacing between lines of text in the frame
		-- @name SimpleHTML:SetSpacing
		-- @class function
		-- @param element Optional,Name of an HTML element for which to set properties (e.g. p, h1); if omitted, sets properties of the frame's default text style
		-- @param spacing Amount of space between lines of text (in pixels)
		-- @usage SimpleHTML:SetSpacing("h1", 10, 10)
		------------------------------------

		-- SetSpacing
		["SetSpacing"] = function(self, ...)
			return self.__UI:SetSpacing(...)
		end,

		------------------------------------
		--- Sets the text to be displayed in the SimpleHTML frame.
		-- @name SimpleHTML:SetText
		-- @class function
		-- @param text Text (with HTML markup) to be displayed
		-- @usage SimpleHTML:SetText([[<a href="aLink">text</a>]])
		------------------------------------

		-- SetText
	    ["SetText"] = function(self, ...)
			return self.__UI:SetText(...)
		end,

		------------------------------------
		--- Sets the color of text in the frame
		-- @name SimpleHTML:SetTextColor
		-- @class function
		-- @param element Optional,Name of an HTML element for which to set font properties (e.g. p, h1); if omitted, sets properties for the frame's default font (string)
		-- @param textR Red component of the text color (0.0 - 1.0) (number)
		-- @param textG Green component of the text color (0.0 - 1.0) (number)
		-- @param textB Blue component of the text color (0.0 - 1.0) (number)
		-- @param textAlpha Optional,Alpha (opacity) of the text (0.0 = fully transparent, 1.0 = fully opaque) (number)
		-- @usage SimpleHTML:SetTextColor("h1", 1, 1, 1)
		------------------------------------

		-- SetTextColor
		["SetTextColor"] = function(self, ...)
			return self.__UI:SetTextColor(...)
		end,
    }

	-- Property
	local _Property = {
        -- HyperlinksEnabled
        ["HyperlinksEnabled"] = {
			["Set"] = function(self, state)
				self.__UI:SetHyperlinksEnabled(state)
			end,

			["Get"] = function(self)
				return (self.__UI:GetHyperlinksEnabled() and true) or false
			end,

			["Type"] = "boolean",
		},
	}

    -- New
    local _New = function(_parent,inheritFrame)
        -- New Frame
		return CreateFrame(_WidgetName,nil,IGAS:GetUI(_parent),inheritFrame)
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true, true)
end