﻿-- Author      : Kurapica
-- Create Date : 7/16/2008 14:28

----------------------------------------------------------------------------------------------------------------------------------------
--- Button is the primary means for users to control the game and their characters.
-- <br><br>inherit <a href=".\FontFrame.html">FontFrame</a> For all methods, properties and scriptTypes
-- @name ScrollingMessageFrame
-- @class table
-- @field Fading whether messages added to the frame automatically fade out after a period of time
-- @field HyperlinksEnabled whether hyperlinks in the frame's text are interactive
-- @field TimeVisible the amount of time for which a message remains visible before beginning to fade out
-- @field FadeDuration the duration of the fade-out animation for disappearing messages
-- @field InsertMode the position at which new messages are added to the frame
-- @field MaxLines the maximum number of messages to be kept in the frame
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.ScrollingMessageFrame", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "ScrollingMessageFrame"
    local _Base = "FontFrame"

	-- ScriptType
	local _ScriptType = {
		------------------------------------
		--- ScriptType, Run when the mouse clicks a hyperlink in the scrolling message frame or SimpleHTML frame
		-- @name ScrollingMessageFrame:OnHyperlinkClick
		-- @class function
		-- @param linkData linkData - Essential data (linktype:linkdata portion) of the hyperlink (e.g. "quest:982:17")
		-- @param link Complete hyperlink text (e.g. "|cffffff00|Hquest:982:17|h[Deep Ocean, Vast Sea]|h|r")
		-- @param button Name of the mouse button responsible for the click action
		-- @usage function ScrollingMessageFrame:OnHyperlinkClick(linkData, link, button)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnHyperlinkClick"] = true,

		------------------------------------
		--- ScriptType, Run when the mouse moves over a hyperlink in the scrolling message frame or SimpleHTML frame
		-- @name ScrollingMessageFrame:OnHyperlinkEnter
		-- @class function
		-- @param linkData Essential data (linktype:linkdata portion) of the hyperlink (e.g. "quest:982:17")
		-- @param link Complete hyperlink text (e.g. "|cffffff00|Hquest:982:17|h[Deep Ocean, Vast Sea]|h|r")
		-- @usage function ScrollingMessageFrame:OnHyperlinkEnter(linkData, link)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnHyperlinkEnter"] = true,

		------------------------------------
		--- ScriptType, Run when the mouse moves away from a hyperlink in the scrolling message frame or SimpleHTML frame
		-- @name ScrollingMessageFrame:OnHyperlinkLeave
		-- @class function
		-- @param linkData Essential data (linktype:linkdata portion) of the hyperlink (e.g. "quest:982:17")
		-- @param link Complete hyperlink text (e.g. "|cffffff00|Hquest:982:17|h[Deep Ocean, Vast Sea]|h|r")
		-- @usage function ScrollingMessageFrame:OnHyperlinkLeave(linkData, link)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnHyperlinkLeave"] = true,

		------------------------------------
		--- ScriptType, Run when the scrolling message frame's scroll position changes
		-- @name ScrollingMessageFrame:OnMessageScrollChanged
		-- @class function
		-- @usage function ScrollingMessageFrame:OnMessageScrollChanged()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnMessageScrollChanged"] = true,
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Adds a message to those listed in the frame
		-- @name ScrollingMessageFrame:AddMessage
		-- @class function
		-- @param text Text of the message (string)
		-- @param red Optional,Red component of the text color for the message (0.0 - 1.0) (number)
		-- @param green Optional,Green component of the text color for the message (0.0 - 1.0) (number)
		-- @param blue Optional,Blue component of the text color for the message (0.0 - 1.0) (number)
		-- @param id Optional,Identifier for the message's type (see :UpdateColorByID()) (number)
		-- @param addToTop Optional,True to insert the message above all others listed in the frame, even if the frame's insert mode is set to BOTTOM; false to insert according to the frame's insert mode (boolean)
		-- @usage ScrollingMessageFrame:AddMessage("Time is money")
		------------------------------------

		-- AddMessage
	    ["AddMessage"] = function(self, ...)
			return self.__UI:AddMessage(...)
		end,

		------------------------------------
		--- Returns whether the message frame is currently scrolled to the bottom of its contents
		-- @name ScrollingMessageFrame:AtBottom
		-- @class function
		-- @return 1 if the message frame is currently scrolled to the bottom of its contents; otherwise nil
		-- @usage ScrollingMessageFrame:AtBottom()
		------------------------------------

		-- AtBottom
		["AtBottom"] = function(self, ...)
			return self.__UI:AtBottom(...)
		end,

		------------------------------------
		--- Returns whether the message frame is currently scrolled to the top of its contents
		-- @name ScrollingMessageFrame:AtTop
		-- @class function
		-- @return 1 if the message frame is currently scrolled to the top of its contents; otherwise nil
		-- @usage ScrollingMessageFrame:AtTop()
		------------------------------------

		-- AtTop
		["AtTop"] = function(self, ...)
			return self.__UI:AtTop(...)
		end,

		------------------------------------
		--- Clear all lines from the frame.
		-- @name ScrollingMessageFrame:Clear
		-- @class function
		-- @usage ScrollingMessageFrame:Clear()
		------------------------------------

		-- Clear
		["Clear"] = function(self, ...)
			return self.__UI:Clear(...)
		end,

		------------------------------------
		--- Returns a number identifying the last message added to the frame. This number starts at 0 when the frame is created and increments with each message AddMessage  to the frame; however, it resets to 0 when a message is added beyond the frame's GetMaxLines.
		-- @name ScrollingMessageFrame:GetCurrentLine
		-- @class function
		-- @return A number identifying the last message added to the frame
		-- @usage ScrollingMessageFrame:GetCurrentLine()
		------------------------------------

		-- GetCurrentLine
		["GetCurrentLine"] = function(self, ...)
			return self.__UI:GetCurrentLine(...)
		end,

		------------------------------------
		--- Returns the message frame's current scroll position
		-- @name ScrollingMessageFrame:GetCurrentScroll
		-- @class function
		-- @return Number of lines by which the frame is currently scrolled back from the end of its message history
		-- @usage ScrollingMessageFrame:GetCurrentScroll()
		------------------------------------

		-- GetCurrentScroll
	    ["GetCurrentScroll"] = function(self, ...)
			return self.__UI:GetCurrentScroll(...)
		end,

		------------------------------------
		--- Returns the duration of the fade-out animation for disappearing messages. For the amount of time a message remains in the frame before beginning to fade
		-- @name ScrollingMessageFrame:GetFadeDuration
		-- @class function
		-- @return Duration of the fade-out animation for disappearing messages (in seconds)
		-- @usage ScrollingMessageFrame:GetFadeDuration()
		------------------------------------

		-- GetFadeDuration
		["GetFadeDuration"] = function(self, ...)
			return self.__UI:GetFadeDuration(...)
		end,

		------------------------------------
		--- Returns whether messages added to the frame automatically fade out after a period of time
		-- @name ScrollingMessageFrame:GetFading
		-- @class function
		-- @return 1 if messages added to the frame automatically fade out after a period of time; otherwise nil
		-- @usage ScrollingMessageFrame:GetFading()
		------------------------------------

		-- GetFading
		["GetFading"] = function(self, ...)
			return self.__UI:GetFading(...)
		end,

		------------------------------------
		--- Returns whether hyperlinks in the frame's text are interactive
		-- @name ScrollingMessageFrame:GetHyperlinksEnabled
		-- @class function
		-- @return 1 if hyperlinks in the frame's text are interactive; otherwise nil
		-- @usage ScrollingMessageFrame:GetHyperlinksEnabled()
		------------------------------------

		-- GetFading
		["GetHyperlinksEnabled"] = function(self, ...)
			return self.__UI:GetHyperlinksEnabled(...)
		end,

		------------------------------------
		--- Returns the position at which new messages are added to the frame
		-- @name ScrollingMessageFrame:GetInsertMode
		-- @class function
		-- @return Token identifying the position at which new messages are added to the frame: BOTTOM, TOP
		-- @usage ScrollingMessageFrame:GetInsertMode()
		------------------------------------

		-- GetInsertMode
		["GetInsertMode"] = function(self, ...)
			return self.__UI:GetInsertMode(...)
		end,

		------------------------------------
		--- Returns the maximum number of messages kept in the frame
		-- @name ScrollingMessageFrame:GetMaxLines
		-- @class function
		-- @return Maximum number of messages kept in the frame
		-- @usage ScrollingMessageFrame:GetMaxLines()
		------------------------------------

		-- GetMaxLines
		["GetMaxLines"] = function(self, ...)
			return self.__UI:GetMaxLines(...)
		end,

		------------------------------------
		--- Returns the number of lines displayed in the message frame. This number reflects the list of messages currently displayed, not including those which are stored for display if the frame is scrolled.
		-- @name ScrollingMessageFrame:GetNumLinesDisplayed
		-- @class function
		-- @return Number of messages currently displayed in the frame
		-- @usage ScrollingMessageFrame:GetNumLinesDisplayed()
		------------------------------------

		-- GetNumLinesDisplayed
		["GetNumLinesDisplayed"] = function(self, ...)
			return self.__UI:GetNumLinesDisplayed(...)
		end,

		------------------------------------
		--- Returns the number of messages currently kept in the frame's message history. This number reflects the list of messages which can be seen by scrolling the frame, including (but not limited to) the list of messages currently displayed.
		-- @name ScrollingMessageFrame:GetNumMessages
		-- @class function
		-- @return Number of messages currently kept in the frame's message history
		-- @usage ScrollingMessageFrame:GetNumMessages()
		------------------------------------

		-- GetNumMessages
		["GetNumMessages"] = function(self, ...)
			return self.__UI:GetNumMessages(...)
		end,

		------------------------------------
		--- Returns the amount of time for which a message remains visible before beginning to fade out
		-- @name ScrollingMessageFrame:GetTimeVisible
		-- @class function
		-- @return Amount of time for which a message remains visible before beginning to fade out (in seconds)
		-- @usage ScrollingMessageFrame:GetTimeVisible()
		------------------------------------

		-- GetTimeVisible
		["GetTimeVisible"] = function(self, ...)
			return self.__UI:GetTimeVisible(...)
		end,

		------------------------------------
		--- Scrolls the message frame's contents down by one page. One "page" is slightly less than the number of lines displayed in the frame.
		-- @name ScrollingMessageFrame:PageDown
		-- @class function
		-- @usage ScrollingMessageFrame:PageDown()
		------------------------------------

		-- PageDown
		["PageDown"] = function(self, ...)
			return self.__UI:PageDown(...)
		end,

		------------------------------------
		--- Scrolls the message frame's contents up by one page. One "page" is slightly less than the number of lines displayed in the frame.
		-- @name ScrollingMessageFrame:PageUp
		-- @class function
		-- @usage ScrollingMessageFrame:PageUp()
		------------------------------------

		-- PageUp
		["PageUp"] = function(self, ...)
			return self.__UI:PageUp(...)
		end,

		------------------------------------
		--- Scrolls the message frame's contents down by two lines
		-- @name ScrollingMessageFrame:ScrollDown
		-- @class function
		-- @usage ScrollingMessageFrame:ScrollDown()
		------------------------------------

		-- ScrollDown
		["ScrollDown"] = function(self, ...)
			return self.__UI:ScrollDown(...)
		end,

		------------------------------------
		--- Scrolls to the bottom of the message frame's contents
		-- @name ScrollingMessageFrame:ScrollToBottom
		-- @class function
		-- @usage ScrollingMessageFrame:ScrollToBottom()
		------------------------------------

		-- ScrollToBottom
		["ScrollToBottom"] = function(self, ...)
			return self.__UI:ScrollToBottom(...)
		end,

		------------------------------------
		--- Scrolls to the top of the message frame's contents
		-- @name ScrollingMessageFrame:ScrollToTop
		-- @class function
		-- @usage ScrollingMessageFrame:ScrollToTop()
		------------------------------------

		-- ScrollToTop
		["ScrollToTop"] = function(self, ...)
			return self.__UI:ScrollToTop(...)
		end,

		------------------------------------
		--- Scrolls the message frame's contents up by two lines
		-- @name ScrollingMessageFrame:ScrollUp
		-- @class function
		-- @usage ScrollingMessageFrame:ScrollUp()
		------------------------------------

		-- ScrollUp
		["ScrollUp"] = function(self, ...)
			return self.__UI:ScrollUp(...)
		end,

		------------------------------------
		--- Sets the duration of the fade-out animation for disappearing messages. For the amount of time a message remains in the frame before beginning to fade
		-- @name ScrollingMessageFrame:SetFadeDuration
		-- @class function
		-- @param duration Duration of the fade-out animation for disappearing messages (in seconds)
		-- @usage ScrollingMessageFrame:SetFadeDuration(8)
		------------------------------------

		-- SetFadeDuration
		["SetFadeDuration"] = function(self, ...)
			return self.__UI:SetFadeDuration(...)
		end,

		------------------------------------
		--- Sets whether messages added to the frame automatically fade out after a period of time
		-- @name ScrollingMessageFrame:SetFading
		-- @class function
		-- @param fading True to cause messages added to the frame to automatically fade out after a period of time; false to leave message visible
		-- @usage ScrollingMessageFrame:SetFading(8)
		------------------------------------

		-- SetFading
		["SetFading"] = function(self, ...)
			return self.__UI:SetFading(...)
		end,

		------------------------------------
		--- Enables or disables hyperlink interactivity in the frame. The frame's hyperlink-related script handlers will only be run if hyperlinks are enabled.
		-- @name ScrollingMessageFrame:SetHyperlinksEnabled
		-- @class function
		-- @param enable True to enable hyperlink interactivity in the frame; false to disable
		-- @usage ScrollingMessageFrame:SetHyperlinksEnabled(false)
		------------------------------------

		-- SetHyperlinksEnabled
		["SetHyperlinksEnabled"] = function(self, ...)
			return self.__UI:SetHyperlinksEnabled(...)
		end,

		------------------------------------
		--- Sets the position at which new messages are added to the frame
		-- @name ScrollingMessageFrame:SetInsertMode
		-- @class function
		-- @param position Token identifying the position at which new messages should be added to the frame: TOP, BOTTOM
		-- @usage ScrollingMessageFrame:SetInsertMode("TOP")
		------------------------------------

		-- SetInsertMode
	    ["SetInsertMode"] = function(self, ...)
			return self.__UI:SetInsertMode(...)
		end,

		------------------------------------
		--- Sets the maximum number of messages to be kept in the frame. If additional messages are added beyond this number, the oldest lines are discarded and can no longer be seen by scrolling.
		-- @name ScrollingMessageFrame:SetMaxLines
		-- @class function
		-- @param maxLines Maximum number of messages to be kept in the frame
		-- @usage ScrollingMessageFrame:SetMaxLines(30)
		------------------------------------

		-- SetMaxLines
	    ["SetMaxLines"] = function(self, ...)
			return self.__UI:SetMaxLines(...)
		end,

		------------------------------------
		--- Sets the message frame's scroll position
		-- @name ScrollingMessageFrame:SetScrollOffset
		-- @class function
		-- @param offsetNumber of lines to scroll back from the end of the frame's message history
		-- @usage ScrollingMessageFrame:SetScrollOffset(5)
		------------------------------------

		-- SetScrollOffset
		["SetScrollOffset"] = function(self, ...)
			return self.__UI:SetScrollOffset(...)
		end,

		------------------------------------
		--- Sets the amount of time for which a message remains visible before beginning to fade out. For the duration of the fade-out animation
		-- @name ScrollingMessageFrame:SetTimeVisible
		-- @class function
		-- @param time Amount of time for which a message remains visible before beginning to fade out (in seconds)
		-- @usage ScrollingMessageFrame:SetTimeVisible(5)
		------------------------------------

		-- SetTimeVisible
		["SetTimeVisible"] = function(self, ...)
			return self.__UI:SetTimeVisible(...)
		end,

		------------------------------------
		--- Updates the color of a set of messages already added to the frame
		-- @name ScrollingMessageFrame:UpdateColorByID
		-- @class function
		-- @param id Identifier for a message's type (as set when the messages were added  to the frame) (number)
		-- @param red Red component of the new text color (0.0 - 1.0) (number)
		-- @param green Green component of the new text color (0.0 - 1.0) (number)
		-- @param blue Blue component of the new text color (0.0 - 1.0) (number)
		-- @usage ScrollingMessageFrame:UpdateColorByID(5, 1, 0, 1)
		------------------------------------

		-- UpdateColorByID
		["UpdateColorByID"] = function(self, ...)
			return self.__UI:UpdateColorByID(...)
		end,
    }

	-- Property
	local _Property = {
        -- Fading
        ["Fading"] = {
			["Set"] = function(self, state)
				self.__UI:SetFading(state)
			end,

			["Get"] = function(self)
				return (self.__UI:GetFading() and true) or false
			end,

			["Type"] = "boolean",
		},

        -- HyperlinksEnabled
        ["HyperlinksEnabled"] = {
			["Set"] = function(self, state)
				self.__UI:SetHyperlinksEnabled(state)
			end,

			["Get"] = function(self)
				return (self.__UI:GetHyperlinksEnabled() and true) or false
			end,

			["Type"] = "boolean",
		},

        -- TimeVisible
        ["TimeVisible"] = {
			["Set"] = function(self, seconds)
				self.__UI:SetTimeVisible(seconds)
			end,

			["Get"] = function(self)
				return self.__UI:GetTimeVisible()
			end,

			["Type"] = "number",
		},

        -- FadeDuration
        ["FadeDuration"] = {
			["Set"] = function(self, seconds)
				self.__UI:SetFadeDuration(seconds)
			end,

			["Get"] = function(self)
				return self.__UI:GetFadeDuration()
			end,

			["Type"] = "number",
		},

        -- InsertMode
        ["InsertMode"] = {
			["Set"] = function(self, mode)
				self.__UI:SetInsertMode(mode)
			end,

			["Get"] = function(self)
				return self.__UI:GetInsertMode()
			end,

			["Type"] = "InsertMode",
		},

        -- MaxLines
        ["MaxLines"] = {
			["Set"] = function(self, lines)
				self.__UI:SetMaxLines(lines)
			end,

			["Get"] = function(self)
				return self.__UI:GetMaxLines()
			end,

			["Type"] = "number",
		},
   }

    -- New
    local _New = function(_parent,inheritFrame)
        -- New Frame
		return CreateFrame(_WidgetName,nil,IGAS:GetUI(_parent),inheritFrame)
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true, true)
end