﻿-- Author      : Kurapica
-- Create Date : 7/16/2008 14:16

----------------------------------------------------------------------------------------------------------------------------------------
--- ScrollFrame is how a large body of content can be displayed through a small window. The ScrollFrame is the size of the "window" through which you want to see the larger content, and it has another frame set as a "ScrollChild" containing the full content.
-- <br><br>inherit <a href=".\Frame.html">Frame</a> For all methods, properties and scriptTypes
-- @name ScrollFrame
-- @class table
-- @field HorizontalScroll the scroll frame's current horizontal scroll position
-- @field VerticalScroll the scroll frame's vertical scroll position
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.ScrollFrame", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "ScrollFrame"
    local _Base = "Frame"

    -- Scripts

	-- ScriptType
	local _ScriptType = {
		------------------------------------
		--- ScriptType, Run when the scroll frame's horizontal scroll position changes
		-- @name ScrollFrame:OnHorizontalScroll
		-- @class function
		-- @param offset New horizontal scroll position (in pixels, measured from the leftmost scroll position)
		-- @usage function ScrollFrame:OnHorizontalScroll(offset)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnHorizontalScroll"] = true,

		------------------------------------
		--- ScriptType, Run when the scroll frame's scroll position is changed
		-- @name ScrollFrame:OnScrollRangeChanged
		-- @class function
		-- @param xOffset New horizontal scroll range (in pixels, measured from the leftmost scroll position)
		-- @param yOffset New vertical scroll range (in pixels, measured from the topmost scroll position)
		-- @usage function ScrollFrame:OnScrollRangeChanged(xOffset, yOffset)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnScrollRangeChanged"] = true,

		------------------------------------
		--- ScriptType, Run when the scroll frame's vertical scroll position changes
		-- @name ScrollFrame:OnVerticalScroll
		-- @class function
		-- @param offset New vertical scroll position (in pixels, measured from the topmost scroll position)
		-- @usage function ScrollFrame:OnVerticalScroll(offset)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnVerticalScroll"] = true,
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Returns the scroll frame's current horizontal scroll position
		-- @name ScrollFrame:GetHorizontalScroll
		-- @class function
		-- @return the scroll frame's current horizontal scroll position
		-- @usage ScrollFrame:GetHorizontalScroll()
		------------------------------------

		-- GetHorizontalScroll
		["GetHorizontalScroll"] = function(self, ...)
			return self.__UI:GetHorizontalScroll(...)
		end,

		------------------------------------
		--- Returns the scroll frame's maximum horizontal (rightmost) scroll position
		-- @name ScrollFrame:GetHorizontalScrollRange
		-- @class function
		-- @return the scroll frame's maximum horizontal (rightmost) scroll position
		-- @usage ScrollFrame:GetHorizontalScrollRange()
		------------------------------------

		-- GetHorizontalScrollRange
		["GetHorizontalScrollRange"] = function(self, ...)
			return self.__UI:GetHorizontalScrollRange(...)
		end,

		------------------------------------
		--- Returns the frame scrolled by the scroll frame
		-- @name ScrollFrame:GetScrollChild
		-- @class function
		-- @return the frame scrolled by the scroll frame
		-- @usage ScrollFrame:GetScrollChild()
		------------------------------------

		-- GetScrollChild
		["GetScrollChild"] = function(self, ...)
			return self.__UI:GetScrollChild(...)
		end,

		------------------------------------
		--- Returns the scroll frame's current vertical scroll position
		-- @name ScrollFrame:GetVerticalScroll
		-- @class function
		-- @return the scroll frame's current vertical scroll position
		-- @usage ScrollFrame:GetVerticalScroll()
		------------------------------------

		-- GetVerticalScroll
		["GetVerticalScroll"] = function(self, ...)
			return self.__UI:GetVerticalScroll(...)
		end,

		------------------------------------
		--- Returns the scroll frame's maximum vertical (bottom) scroll position
		-- @name ScrollFrame:GetVerticalScrollRange
		-- @class function
		-- @return the scroll frame's maximum vertical (bottom) scroll position
		-- @usage ScrollFrame:GetVerticalScrollRange()
		------------------------------------

		-- GetVerticalScrollRange
		["GetVerticalScrollRange"] = function(self, ...)
			return self.__UI:GetVerticalScrollRange(...)
		end,

		------------------------------------
		--- Returns the scroll frame's maximum vertical (bottom) scroll position
		-- @name ScrollFrame:SetHorizontalScroll
		-- @class function
		-- @param scroll Current horizontal scroll position (0 = at left edge, frame:GetHorizontalScrollRange()  = at right edge)
		-- @usage ScrollFrame:SetHorizontalScroll(14)
		------------------------------------

		-- SetHorizontalScroll
		["SetHorizontalScroll"] = function(self, ...)
			return self.__UI:SetHorizontalScroll(...)
		end,

		------------------------------------
		--- Sets the scroll child for the scroll frame.
		-- @name ScrollFrame:SetScrollChild
		-- @class function
		-- @param frame Reference to another frame to be the ScrollFrame's child
		-- @usage ScrollFrame:SetScrollChild(IGAS:NewFrame("Frame"))
		------------------------------------

		-- SetScrollChild
		["SetScrollChild"] = function(self, child)
			return self.__UI:SetScrollChild(IGAS:GetUI(child))
		end,

		------------------------------------
		--- Sets the scroll frame's vertical scroll position
		-- @name ScrollFrame:SetVerticalScroll
		-- @class function
		-- @param scroll Current vertical scroll position (0 = at top edge, frame:GetVerticalScrollRange()  = at bottom edge)
		-- @usage ScrollFrame:SetVerticalScroll(14)
		------------------------------------

		-- SetVerticalScroll
		["SetVerticalScroll"] = function(self, ...)
			return self.__UI:SetVerticalScroll(...)
		end,

		------------------------------------
		--- Updates the position of the scroll frame's child. The ScrollFrame  automatically adjusts the position of the child frame when scrolled, but manually updating its position may be necessary when changing the size or contents of the child frame.
		-- @name ScrollFrame:UpdateScrollChildRect
		-- @class function
		-- @usage ScrollFrame:UpdateScrollChildRect()
		------------------------------------

		-- UpdateScrollChildRect
		["UpdateScrollChildRect"] = function(self, ...)
			return self.__UI:UpdateScrollChildRect(...)
		end,
    }

	-- Property
	local _Property = {
        -- HorizontalScroll
        ["HorizontalScroll"] = {
			["Set"] = function(self, offset)
				self:SetHorizontalScroll(offset)
			end,

			["Get"] = function(self)
				return self:GetHorizontalScroll()
			end,

			["Type"] = "number",
		},

        -- VerticalScroll
        ["VerticalScroll"] = {
			["Set"] = function(self, offset)
				self:SetVerticalScroll(offset)
			end,

			["Get"] = function(self)
				return self:GetVerticalScroll()
			end,

			["Type"] = "number",
		},
	}

    -- New
    local _New = function(_parent,inheritFrame)
        -- New Frame
		return CreateFrame(_WidgetName,nil,IGAS:GetUI(_parent),inheritFrame)
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true, true)
end