﻿-- Author      : Kurapica
-- Create Date : 8/18/2009

----------------------------------------------------------------------------------------------------------------------------------------
--- Button is the primary means for users to control the game and their characters.
-- <br><br>inherit <a href=".\Animation.html">Animation</a> For all methods, properties and scriptTypes
-- @name Scale
-- @class table
-- @field Scale the animation's scaling factors
-- @field Origin the scale animation's origin point
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.Scale", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "Scale"
    local _Base = "Animation"

	-- ScriptType
	local _ScriptType = {
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Sets the X scalar and the Y scalar that the animation's parent Region should scale by.
		-- @name Scale:SetScale
		-- @class function
		-- @param xFactor Horizontal scaling factor
		-- @param yFactor Vertical scaling factor
		-- @usage Scale:SetScale(1.5, 2)
		------------------------------------

		-- SetScale
		["SetScale"] = function(self, x, y)
			return self.__UI:SetScale(x, y)
		end,

		------------------------------------
		--- Returns the animation's scaling factors. At the end of the scale animation, the animated region's dimensions are equal to its initial dimensions multiplied by its scaling factors.
		-- @name Scale:GetScale
		-- @class function
		-- @return xFactor - Horizontal scaling factor
		-- @return yFactor - Vertical scaling factor
		-- @usage Scale:GetScale()
		------------------------------------

		-- GetScale
		["GetScale"] = function(self)
			return self.__UI:GetScale()
		end,

		------------------------------------
		--- Sets the scale animation's origin point. During a scale animation, the origin point remains in place while the positions of all other points in the scaled region are moved according to the scale factor.
		-- @name Scale:SetOrigin
		-- @class function
		-- @param point Anchor point for the scale origin
		-- @param xOffset Horizontal distance from the anchor point to the scale origin (in pixels)
		-- @param yOffset Vertical distance from the anchor point to the scale origin (in pixels)
		-- @usage Scale:SetOrigin("CENTER", 10, 20)
		------------------------------------

		--SetOrigin
		["SetOrigin"] = function(self, point, offsetX, offsetY)
			return self.__UI:SetOrigin(point, offsetX, offsetY)
		end,

		------------------------------------
		--- Gets the scale animation's origin point. During a scale animation, the origin point remains in place while the positions of all other points in the scaled region are moved according to the scale factor.
		-- @name Scale:GetOrigin
		-- @class function
		-- @param return - Anchor point for the scale origin
		-- @param return - Horizontal distance from the anchor point to the scale origin (in pixels)
		-- @param return - Vertical distance from the anchor point to the scale origin (in pixels)
		-- @usage Scale:GetOrigin()
		------------------------------------

		--GetOrigin
		["GetOrigin"] = function(self)
			return self.__UI:GetOrigin()
		end,
	}

	-- Property
	local _Property = {
        -- Scale
        ["Scale"] = {
			["Set"] = function(self, offset)
				if offset and type(offset) == "table" then
					self:SetScale(offset.x, offset.y)
				end
			end,
			["Get"] = function(self)
				local offset = {}
				offset.x, offset.y = self:GetScale()
				return offset
			end,

			["Type"] = "Offset",
		},
        -- Origin
        ["Origin"] = {
			["Set"] = function(self, origin)
				self:SetOrigin(origin.point, origin.x, origin.y)
			end,
			["Get"] = function(self)
				local origin = {}
				origin.point, origin.x, origin.y = self:GetOrigin()
				return origin
			end,

			["Type"] = "Origin",
		},
	}

    -- New
    local _New = function(_parent,inheritsFrom)
		if _parent and _parent["CreateAnimation"] then
			return IGAS:GetUI(_parent):CreateAnimation(_WidgetName, nil, inheritsFrom)
		end
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

	local _ScanFrameParent = IGAS:NewFrame("AnimationGroup")

    IGAS:NewWidget(_WidgetInfo, true, true, _ScanFrameParent)

	_ScanFrameParent:Dispose()
end