﻿-- Author      : Kurapica
-- Create Date : 8/18/2009

----------------------------------------------------------------------------------------------------------------------------------------
--- Rotation is an Animation that automatically applies an affine rotation to the region being animated. You can set the origin around which the rotation is being done, and the angle of rotation in either degrees or radians.<br>
-- Rotation animations have no effect on FontStrings.
-- <br><br>inherit <a href=".\Animation.html">Animation</a> For all methods, properties and scriptTypes
-- @name Rotation
-- @class table
-- @field Degrees the animation's rotation amount (in degrees)
-- @field Radians the animation's rotation amount (in radians)
-- @field Origin the rotation animation's origin point
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.Rotation", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "Rotation"
    local _Base = "Animation"

	-- ScriptType
	local _ScriptType = {
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Sets the amount of degrees that the animation's parent Region would rotate.
		-- @name Rotation:SetDegrees
		-- @class function
		-- @param degrees the amount of degrees that the animation's parent Region would rotate
		-- @usage Rotation:SetDegrees(43)
		------------------------------------

		-- SetDegrees
		["SetDegrees"] = function(self, degrees)
			return self.__UI:SetDegrees(degrees)
		end,

		------------------------------------
		--- Gets the amount of degrees that the animation's parent Region would rotate.
		-- @name Rotation:GetDegrees
		-- @class function
		-- @return the amount of degrees that the animation's parent Region would rotate
		-- @usage Rotation:GetDegrees()
		------------------------------------

		-- GetDegrees
		["GetDegrees"] = function(self)
			return self.__UI:GetDegrees()
		end,

		------------------------------------
		--- Sets the animation's rotation amount
		-- @name Rotation:SetRadians
		-- @class function
		-- @param radians Amount by which the region should rotate over the animation's duration (in radians; positive values for counter-clockwise rotation, negative for clockwise)
		-- @usage Rotation:SetRadians(60)
		------------------------------------

		-- SetRadians
		["SetRadians"] = function(self, radians)
			return self.__UI:SetRadians(radians)
		end,

		------------------------------------
		--- Returns the animation's rotation amount (in radians)
		-- @name Rotation:GetRadians
		-- @class function
		-- @return radians - Amount by which the region rotates over the animation's duration (in radians; positive values for counter-clockwise rotation, negative for clockwise)
		-- @usage Rotation:GetRadians()
		------------------------------------

		-- GetRadians
		["GetRadians"] = function(self)
			return self.__UI:GetRadians()
		end,

		------------------------------------
		--- Sets the rotation animation's origin point. During a rotation animation, the origin point remains in place while the positions of all other points in the scaled region are moved according to the rotation amount.
		-- @name Rotation:SetOrigin
		-- @class function
		-- @param point Anchor point for the rotation origin (string, anchorPoint)
		-- @param xOffset Horizontal distance from the anchor point to the rotation origin (in pixels) (number)
		-- @param yOffset Vertical distance from the anchor point to the rotation origin (in pixels)
		-- @usage Rotation:SetOrigin("CENTER", 10, 20)
		------------------------------------

		-- SetOrigin
		["SetOrigin"] = function(self, point, offsetX, offsetY)
			return self.__UI:SetOrigin()
		end,

		------------------------------------
		--- Returns the rotation animation's origin point. During a rotation animation, the origin point remains in place while the positions of all other points in the scaled region are moved according to the rotation amount.
		-- @name Rotation:GetOrigin
		-- @class function
		-- @return point - Anchor point for the rotation origin (string, anchorPoint)
		-- @return xOffset - Horizontal distance from the anchor point to the rotation origin (in pixels) (number)
		-- @return yOffset - Vertical distance from the anchor point to the rotation origin (in pixels)
		-- @usage Rotation:GetOrigin()
		------------------------------------

		-- GetOrigin
		["GetOrigin"] = function(self)
			return self.__UI:GetOrigin()
		end,
	}

	-- Property
	local _Property = {
        -- Degrees
        ["Degrees"] = {
			["Set"] = function(self, degrees)
				self:SetDegrees(degrees)
			end,

			["Get"] = function(self)
				return self:GetDegrees()
			end,

			["Type"] = "number",
		},
        -- Radians
        ["Radians"] = {
			["Set"] = function(self, radians)
				self:SetRadians(radians)
			end,

			["Get"] = function(self)
				return self:GetRadians()
			end,

			["Type"] = "number",
		},
        -- Origin
        ["Origin"] = {
			["Set"] = function(self, origin)
				self:SetOrigin(origin.point, origin.x, origin.y)
			end,
			["Get"] = function(self)
				local origin = {}
				origin.point, origin.x, origin.y = self:GetOrigin()
				return origin
			end,

			["Type"] = "Origin",
		},
	}

    -- New
    local _New = function(_parent,inheritsFrom)
		if _parent and _parent["CreateAnimation"] then
			return IGAS:GetUI(_parent):CreateAnimation(_WidgetName, nil, inheritsFrom)
		end
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

	local _ScanFrameParent = IGAS:NewFrame("AnimationGroup")

    IGAS:NewWidget(_WidgetInfo, true, true, _ScanFrameParent)

	_ScanFrameParent:Dispose()
end