﻿-- Author      : Kurapica
-- Create Date : 6/12/2008 1:13:21 AM

----------------------------------------------------------------------------------------------------------------------------------------
--- Button is the primary means for users to control the game and their characters.
-- <br><br>inherit <a href=".\UIObject.html">UIObject</a> For all methods, properties and scriptTypes
-- @name Region
-- @class table
-- @field Alpha Set or get the frame's transparency value(0-1)
-- @field Height the height of the region
-- @field Width the width of the region
-- @field Visible the visible of the region
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 3
	if not IGAS:NewAddon("IGAS.GUI.Region", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "Region"
    local _Base = "UIObject"

    -- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Return this object's alpha (transparency) value.
		-- @name Region:GetAlpha
		-- @class function
		-- @return this object's alpha (transparency) value
		-- @usage Region:GetAlpha()
		------------------------------------

		-- GetAlpha
        ["GetAlpha"] = function(self)
            return self.__UI:GetAlpha() or 1
        end,

		------------------------------------
		--- Set the object's alpha (transparency) value.
		-- @name Region:SetAlpha
		-- @class function
		-- @param alpha this object's alpha (transparency) value
		-- @usage Region:SetAlpha(1)
		------------------------------------

		-- SetAlpha
        ["SetAlpha"] = function(self, alpha)
            self.__UI:SetAlpha(alpha)
        end,

		------------------------------------
		--- Clear all attachment points for this object.
		-- @name Region:ClearAllPoints
		-- @class function
		-- @usage Region:ClearAllPoints()
		------------------------------------

		-- ClearAllPoints
        ["ClearAllPoints"] = function(self)
            self.__UI:ClearAllPoints()
        end,

		------------------------------------
		--- Creates a new AnimationGroup as a child of the region
		-- @name Region:CreateAnimationGroup
		-- @class function
		-- @param name Optional,A name to use for the new animation group
		-- @param inheritsFrom Optional,Template from which the new animation group should inherit
		-- @return animationGroup - The newly created AnimationGroup
		-- @usage Region:CreateAnimationGroup()
		------------------------------------

		-- CreateAnimationGroup
        ["CreateAnimationGroup"] = function(self, name, inheritsFrom)
			return IGAS:NewFrame("AnimationGroup", name, self, inheritsFrom)
		end,

		------------------------------------
		--- Returns all AnimationGroups that are children of this Region
		-- @name Region:GetAnimationGroups
		-- @class function
		-- @return all AnimationGroups that are children of this Region
		-- @usage Region:GetAnimationGroups()
		------------------------------------

		-- GetAnimationGroups
		-- Region:GetAnimationGroups() - Returns all AnimationGroups that are children of this Region. - New in 3.1.0
		-- Not include, this method will be added when scan function works.
		--[[["GetAnimationGroups"] = function(self)
			return self.__UI:GetAnimationGroups()
		end,--]]

		------------------------------------
		--- Get the y location of the bottom edge of this frame
		-- @name Region:GetBottom
		-- @class function
		-- @return the y location of the bottom edge of this frame
		-- @usage Region:GetBottom()
		------------------------------------

		-- GetBottom
        ["GetBottom"] = function(self)
            return self.__UI:GetBottom()
        end,

		------------------------------------
		--- Get the coordinates of the center of this frame
		-- @name Region:GetCenter
		-- @class function
		-- @return x - Distance from the left edge of the screen to the center of the region (in pixels)
		-- @return y - Distance from the bottom edge of the screen to the center of the region (in pixels)
		-- @usage Region:GetCenter()
		------------------------------------

		-- GetCenter
        ["GetCenter"] = function(self)
            return self.__UI:GetCenter()
        end,

		------------------------------------
		--- Get the height of this object.
		-- @name Region:GetHeight
		-- @class function
		-- @return the height of this object
		-- @usage Region:GetHeight()
		------------------------------------

		-- GetHeight
        ["GetHeight"] = function(self)
            return self.__UI:GetHeight()
        end,

		------------------------------------
		--- Set the height of the object.
		-- @name Region:SetHeight
		-- @class function
		-- @param height the height of this object
		-- @usage Region:SetHeight()
		------------------------------------

		-- SetHeight
        ["SetHeight"] = function(self, height)
            self.__UI:SetHeight(height)
        end,

		------------------------------------
		--- Get the x location of the left edge of this frame
		-- @name Region:GetLeft
		-- @class function
		-- @return the x location of the left edge of this frame
		-- @usage Region:GetLeft()
		------------------------------------

		-- GetLeft
        ["GetLeft"] = function(self)
            return self.__UI:GetLeft()
        end,

		------------------------------------
		--- Get the number of anchor points for this frame
		-- @name Region:GetNumPoints
		-- @class function
		-- @return the number of anchor points for this frame
		-- @usage Region:GetNumPoints()
		------------------------------------

		-- GetNumPoints
        ["GetNumPoints"] = function(self)
            return self.__UI:GetNumPoints()
        end,

		------------------------------------
		--- Returns information about one of the region's anchor points
		-- @name Region:GetPoint
		-- @class function
		-- @param index Index of an anchor point defined for the region (between 1 and region:GetNumPoints())
		-- @return point - Point on this region at which it is anchored to another (string, anchorPoint)
		-- @return relativeTo - Reference to the other region to which this region is anchored (region)
		-- @return relativePoint - Point on the other region to which this region is anchored (string, anchorPoint)
		-- @return xOffset - Horizontal distance between point and relativePoint (in pixels; positive values put point  to the right of relativePoint) (number)
		-- @return yOffset - Vertical distance between point and relativePoint (in pixels; positive values put point  below relativePoint) (number)
		-- @usage Region:GetPoint(1)
		------------------------------------

		-- GetPoint
        ["GetPoint"] = function(self, pointNum)
            local point, frame, relativePoint, x, y = self.__UI:GetPoint(pointNum)
            frame = IGAS:GetWrapper(frame)
            return point, frame, relativePoint, x, y
        end,

		------------------------------------
		--- Get the x location of the right edge of this frame
		-- @name Region:GetRight
		-- @class function
		-- @return the x location of the right edge of this frame
		-- @usage Region:GetRight()
		------------------------------------

		-- GetRight
        ["GetRight"] = function(self)
            return self.__UI:GetRight()
        end,

		------------------------------------
		--- Get the y location of the top edge of this frame
		-- @name Region:GetTop
		-- @class function
		-- @return the y location of the top edge of this frame
		-- @usage Region:GetTop()
		------------------------------------

		-- GetTop
        ["GetTop"] = function(self)
            return self.__UI:GetTop()
        end,

		------------------------------------
		--- Get the width of this object
		-- @name Region:GetWidth
		-- @class function
		-- @return the width of this object
		-- @usage Region:GetWidth()
		------------------------------------

		-- GetWidth
        ["GetWidth"] = function(self)
            return self.__UI:GetWidth()
        end,

		------------------------------------
		--- Set the width of the object.
		-- @name Region:SetWidth
		-- @class function
		-- @param width the width of this object
		-- @usage Region:SetWidth()
		------------------------------------

		-- SetWidth
        ["SetWidth"] = function(self, width)
            self.__UI:SetWidth(width)
        end,

		------------------------------------
		--- Set this object to hidden (it and all of its children will disappear).
		-- @name Region:Hide
		-- @class function
		-- @usage Region:Hide()
		------------------------------------

		-- Hide
        ["Hide"] = function(self)
            return self.__UI:Hide()
        end,

		------------------------------------
		--- Set this object to shown (it will appear if its parent is visible).
		-- @name Region:Show
		-- @class function
		-- @usage Region:Show()
		------------------------------------

		-- Show
        ["Show"] = function(self)
            self.__UI:Show()
        end,

		------------------------------------
		--- Determine if this object can be manipulated in certain ways by tainted code in combat or not
		-- @name Region:IsProtected
		-- @class function
		-- @return isProtected - 1 if the region is protected; otherwise nil
		-- @return explicit - 1 if the region is explicitly protected; nil if the frame is only protected due to relationship with a protected region
		-- @usage Region:IsProtected()
		------------------------------------

		-- IsProtected
        ["IsProtected"] = function(self)
            return self.__UI:IsProtected()
        end,

		------------------------------------
		--- Determine if this object is shown (would be visible if its parent was visible).
		-- @name Region:IsShown
		-- @class function
		-- @return true if the object is shown
		-- @usage Region:IsShown()
		------------------------------------

		-- IsShown
        ["IsShown"] = function(self)
            return self.__UI:IsShown()
        end,

		------------------------------------
		--- Get whether the object is visible on screen (logically (IsShown() and GetParent():IsVisible()));
		-- @name Region:IsVisible
		-- @class function
		-- @return true if the object is visible
		-- @usage Region:IsVisible()
		------------------------------------

		-- IsVisible
        ["IsVisible"] = function(self)
            return self.__UI:IsVisible()
        end,

		------------------------------------
		--- Sets all anchor points of the region to match those of another region. If no region is specified, the region's anchor points are set to those of its parent.
		-- @name Region:SetAllPoints
		-- @class function
		-- @param region Reference to a region or a global name of a region
		-- @usage Region:SetAllPoints(UIParent)
		------------------------------------

		-- SetAllPoints
        ["SetAllPoints"] = function(self, frame)
            if frame and type(frame) == "string" then
                frame = _G[frame]
            end

            if not frame or type(frame) ~= "table" then
                frame = self.Parent
            end

            frame = IGAS:GetUI(frame)

            self.__UI:SetAllPoints(frame)
        end,

		------------------------------------
		--- Sets an anchor point for the region
		-- @name Region:SetPoint
		-- @class function
		-- @param point Point on this region at which it is to be anchored to another (string, anchorPoint)
		-- @param relativeTo Reference to the other region to which this region is to be anchored; if nil or omitted, anchors the region relative to its parent (or to the screen dimensions if the region has no parent) (region)
		-- @param relativePoint Point on the other region to which this region is to be anchored; if nil or omitted, defaults to the same value as point (string, anchorPoint)
		-- @param xOffset Horizontal distance between point and relativePoint (in pixels; positive values put point to the right of relativePoint); if nil or omitted, defaults to 0 (number)
		-- @param yOffset Vertical distance between point and relativePoint (in pixels; positive values put point below relativePoint); if nil or omitted, defaults to 0 (number)
		-- @usage Region:SetPoint("CENTER", UIParent, "CENTER", 50, 40)
		------------------------------------

		-- SetPoint
        ["SetPoint"] = function(self, point, relativeObject, relativePoint, xOfs, yOfs)
            if relativeObject then
                if type(relativeObject) == "string" then
                    relativeObject = _G[relativeObject]
                end

                relativeObject = IGAS:GetUI(relativeObject)

                self.__UI:SetPoint(point, relativeObject, relativePoint, xOfs, yOfs)
            end
        end,

        -- Dispose, release resource
        ["Dispose"] = function(self)
            self:ClearAllPoints()
            self:Hide()

            -- Call super's dispose
			self:CallMethod(_Base, "Dispose")
        end,

		------------------------------------
		--- Returns the position and dimensions of the region
		-- @name Region:GetRect
		-- @class function
		-- @return left - Distance from the left edge of the screen to the left edge of the region (in pixels) (number)
		-- @return bottom - Distance from the bottom edge of the screen to the bottom of the region (in pixels) (number)
		-- @return width - Width of the region (in pixels) (number)
		-- @return height - Height of the region (in pixels)
		-- @usage Region:GetRect()
		------------------------------------

		-- GetRect
		["GetRect"] = function(self)
			return self.__UI:GetRect()
		end,

		------------------------------------
		--- Returns whether the region is currently being dragged
		-- @name Region:IsDragging
		-- @class function
		-- @return isDragging - 1 if the region (or its parent or ancestor) is currently being dragged; otherwise nil
		-- @usage Region:IsDragging()
		------------------------------------

		-- IsDragging
		["IsDragging"] = function(self)
			return self.__UI:IsDragging()
		end,

		------------------------------------
		--- Stops any active animations involving the region or its children
		-- @name Region:StopAnimating
		-- @class function
		-- @usage Region:StopAnimating()
		------------------------------------

		-- StopAnimating
		["StopAnimating"] = function(self)
			return self.__UI:StopAnimating()
		end,
    }

    -- Property
	local _Property = {
		--- Alpha
		["Alpha"] = {
			["Set"] = function(self, alpha)
				self:SetAlpha(alpha)
			end,

			["Get"] = function(self)
				return self:GetAlpha()
			end,

			["Type"] = "Alpha",
		},
		--- Height
		["Height"] = {
			["Set"] = function(self, height)
				self:SetHeight(height)
			end,

			["Get"] = function(self)
				return self:GetHeight()
			end,

			["Type"] = "number",
		},
		--- Width
		["Width"] = {
			["Set"] = function(self, width)
				self:SetWidth(width)
			end,

			["Get"] = function(self)
				return self:GetWidth()
			end,

			["Type"] = "number",
		},
		--- Visible
		["Visible"] = {
			["Set"] = function(self, visible)
				if not self.InDesignMode then
					if visible then
						self:Show()
					else
						self:Hide()
					end
				else
					self.__Visible = (visible and true) or false
				end
			end,

			["Get"] = function(self)
				if not self.InDesignMode then
					return (self:IsShown() and true ) or false
				else
					if self.__Visible == nil then
						self.__Visible = true
					end
					return (self.__Visible and true) or false
				end
			end,

			["Type"] = "boolean",
		},
    }

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
    }

    IGAS:NewWidget(_WidgetInfo, true)
end