﻿-- Author      : Kurapica
-- Create Date : 7/16/2008 15:06

----------------------------------------------------------------------------------------------------------------------------------------
--- PlayerModels are the most commonly used subtype of Model frame. They expand on the Model type by adding functions to quickly set the model to represent a particular player or creature, by unitID or creature ID.
-- <br><br>inherit <a href=".\Model.html">Model</a> For all methods, properties and scriptTypes
-- @name PlayerModel
-- @class table
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.PlayerModel", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "PlayerModel"
    local _Base = "Model"

	-- ScriptType
	local _ScriptType = {
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Updates the model's appearance to match that of its unit
		-- @name PlayerModel:RefreshUnit
		-- @class function
		-- @usage PlayerModel:RefreshUnit()
		------------------------------------

		-- RefreshUnit
		["RefreshUnit"] = function(self, ...)
			return self.__UI:RefreshUnit(...)
		end,

		------------------------------------
		--- Sets the model to display the 3D model of a specific creature.
		-- @name PlayerModel:SetCreature
		-- @class function
		-- @param creature Numeric ID of a creature
		-- @usage PlayerModel:SetCreature(10181)
		------------------------------------

		-- SetCreature
		["SetCreature"] = function(self, ...)
			return self.__UI:SetCreature(...)
		end,

		------------------------------------
		--- Sets the model's current rotation by animating the model.
		-- @name PlayerModel:SetRotation
		-- @class function
		-- @param facing Rotation angle for the model (in radians)
		-- @usage PlayerModel:SetRotation(43)
		------------------------------------

		-- SetRotation
		["SetRotation"] = function(self, ...)
			return self.__UI:SetRotation(...)
		end,

		------------------------------------
		--- Sets the model to display the 3D model of a specific unit
		-- @name PlayerModel:SetUnit
		-- @class function
		-- @param unit Unit ID of a visible unit
		-- @usage PlayerModel:SetUnit("pet")
		------------------------------------

		-- SetUnit
		["SetUnit"] = function(self, ...)
			return self.__UI:SetUnit(...)
		end,
    }

	-- Property
	local _Property = {
	}

    -- New
    local _New = function(_parent,inheritFrame)
        -- New Frame
		return CreateFrame(_WidgetName,nil,IGAS:GetUI(_parent),inheritFrame)
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true, true)
end