﻿-- Author      : Kurapica
-- Create Date : 7/16/2008 12:21

----------------------------------------------------------------------------------------------------------------------------------------
--- Minimap is a frame type whose backdrop is filled in with a top-down representation of the area around the character being played.
-- <br><br>inherit <a href=".\Frame.html">Frame</a> For all methods, properties and scriptTypes
-- @name Minimap
-- @class table
-- @field Zoom the minimap's current zoom level
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.Minimap", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "Minimap"
    local _Base = "Frame"

	-- ScriptType
	local _ScriptType = {
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Get the last ping location.
		-- @name Minimap:GetPingPosition
		-- @class function
		-- @return x - Horizontal coordinate of the "ping" position
		-- @return y - Vertical coordinate of the "ping" position
		-- @usage Minimap:GetPingPosition()
		------------------------------------

		-- GetPingPosition
		["GetPingPosition"] = function(self, ...)
			return self.__UI:GetPingPosition(...)
		end,

		------------------------------------
		--- Get the current zoom level.
		-- @name Minimap:GetZoom
		-- @class function
		-- @return the current zoom level
		-- @usage Minimap:GetZoom()
		------------------------------------

		-- GetZoom
		["GetZoom"] = function(self, ...)
			return self.__UI:GetZoom(...)
		end,

		------------------------------------
		--- Get the current zoom level.
		-- @name Minimap:GetZoomLevels
		-- @class function
		-- @return the number of available zoom settings for the minimap
		-- @usage Minimap:GetZoomLevels()
		------------------------------------

		-- GetZoomLevels
		["GetZoomLevels"] = function(self, ...)
			return self.__UI:GetZoomLevels(...)
		end,

		------------------------------------
		--- Perform a ping at the specified location. As of 2.4.2 protected while targeting area of effect spells.
		-- @name Minimap:PingLocation
		-- @class function
		-- @param x Horizontal coordinate of the "ping" position
		-- @param y Vertical coordinate of the "ping" position
		-- @usage Minimap:PingLocation(100, 1024)
		------------------------------------

		-- PingLocation
		["PingLocation"] = function(self, ...)
			return self.__UI:PingLocation(...)
		end,

		------------------------------------
		--- Sets the texture used to display quest and tracking icons on the minimap.
		-- @name Minimap:SetBlipTexture
		-- @class function
		-- @param filename Path to a texture containing display quest and tracking icons for the minimap
		-- @usage Minimap:SetBlipTexture("Interface\\Minimap\\ObjectIcons")
		------------------------------------

		-- SetBlipTexture
		["SetBlipTexture"] = function(self, ...)
			return self.__UI:SetBlipTexture(...)
		end,

		------------------------------------
		--- Sets the texture used to display party and raid members on the minimap.
		-- @name Minimap:SetClassBlipTexture
		-- @class function
		-- @param filename Path to a texture containing icons for party and raid members
		-- @usage Minimap:SetClassBlipTexture("Interface\\Minimap\\PartyRaidBlips")
		------------------------------------

		-- SetClassBlipTexture
		["SetClassBlipTexture"] = function(self, ...)
			return self.__UI:SetClassBlipTexture(...)
		end,

		------------------------------------
		--- Sets the texture used to the player's corpse when located beyond the scope of the minimap.
		-- @name Minimap:SetCorpsePOIArrowTexture
		-- @class function
		-- @param filename Path to a texture image
		-- @usage Minimap:SetCorpsePOIArrowTexture("Interface\\Minimap\\ROTATING-MINIMAPCORPSEARROW")
		------------------------------------

		-- SetCorpsePOIArrowTexture
		["SetCorpsePOIArrowTexture"] = function(self, ...)
			return self.__UI:SetCorpsePOIArrowTexture(...)
		end,

		------------------------------------
		--- Sets the texture used to display various points of interest on the minimap.
		-- @name Minimap:SetIconTexture
		-- @class function
		-- @param filename Path to a texture containing icons for various map landmarks
		-- @usage Minimap:SetIconTexture("Interface\\Minimap\\POIIcons")
		------------------------------------

		-- SetIconTexture
		["SetIconTexture"] = function(self, texture, ...)
			return self.__UI:SetIconTexture(IGAS:GetUI(texture), ...)
		end,

		------------------------------------
		--- Sets the texture used to mask the shape of the minimap.
		-- @name Minimap:SetMaskTexture
		-- @class function
		-- @param filename Path to a texture used to mask the shape of the minimap
		-- @usage Minimap:SetMaskTexture("Textures\\MinimapMask")
		------------------------------------

		-- SetMaskTexture
		["SetMaskTexture"] = function(self, texture, ...)
			return self.__UI:SetMaskTexture(IGAS:GetUI(texture), ...)
		end,

		------------------------------------
		--- Sets the texture used to represent points of interest located beyond the scope of the minimap.
		-- @name Minimap:SetPOIArrowTexture
		-- @class function
		-- @param filename Path to a texture image
		-- @usage Minimap:SetPOIArrowTexture("Interface\\Minimap\\ROTATING-MINIMAPGUIDEARROW")
		------------------------------------

		-- SetPOIArrowTexture
		["SetPOIArrowTexture"] = function(self, ...)
			return self.__UI:SetPOIArrowTexture(...)
		end,

		------------------------------------
		--- Sets the texture used to represent the player on the minimap.
		-- @name Minimap:SetPlayerTexture
		-- @class function
		-- @param filename Path to a texture image
		-- @usage Minimap:SetPlayerTexture("Interface\\Minimap\\MinimapArrow")
		------------------------------------

		-- SetPlayerTexture
		["SetPlayerTexture"] = function(self, ...)
			return self.__UI:SetPlayerTexture(...)
		end,

		------------------------------------
		--- Sets the height of the texture used to represent the player on the minimap
		-- @name Minimap:SetPlayerTextureHeight
		-- @class function
		-- @param height Height of the texture used to represent the player on the minimap
		-- @usage Minimap:SetPlayerTextureHeight(14)
		------------------------------------

		-- SetPlayerTextureHeight
		["SetPlayerTextureHeight"] = function(self, ...)
			return self.__UI:SetPlayerTextureHeight(...)
		end,

		------------------------------------
		--- Sets the width  of the texture used to represent the player on the minimap
		-- @name Minimap:SetPlayerTextureWidth
		-- @class function
		-- @param width  Width  of the texture used to represent the player on the minimap
		-- @usage Minimap:SetPlayerTextureWidth(14)
		------------------------------------

		-- SetPlayerTextureWidth
		["SetPlayerTextureWidth"] = function(self, ...)
			return self.__UI:SetPlayerTextureWidth(...)
		end,

		------------------------------------
		--- Sets the texture used to represent static points of interest located beyond the scope of the minimap.
		-- @name Minimap:SetStaticPOIArrowTexture
		-- @class function
		-- @param filename Path to a texture image
		-- @usage Minimap:SetStaticPOIArrowTexture("Interface\\Minimap\\ROTATING-MINIMAPARROW")
		------------------------------------

		-- SetStaticPOIArrowTexture
		["SetStaticPOIArrowTexture"] = function(self, ...)
			return self.__UI:SetStaticPOIArrowTexture(...)
		end,

		------------------------------------
		--- Sets the minimap's zoom level
		-- @name Minimap:SetZoom
		-- @class function
		-- @param zoomLevel Index of a zoom level (between 0 for the widest possible zoom and (minimap:GetZoomLevels()- 1) for the narrowest possible zoom)
		-- @usage Minimap:SetZoom(2)
		------------------------------------

		-- SetZoom
		["SetZoom"] = function(self, ...)
			return self.__UI:SetZoom(...)
		end,
    }

	-- Property
	local _Property = {
		--- Zoom
		["Zoom"] = {
			["Set"] = function(self, level)
				self:SetZoom(level)
			end,

			["Get"] = function(self)
				return self:GetZoom()
			end,

			["Type"] = "number",
		},
	}

    -- New
    local _New = function(_parent,inheritFrame)
        -- New Frame
		return CreateFrame(_WidgetName,nil,IGAS:GetUI(_parent),inheritFrame)
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true, true)
end