﻿-- Author      : Kurapica
-- Create Date : 7/16/2008 12:09

----------------------------------------------------------------------------------------------------------------------------------------
--- MessageFrames are used to present series of messages or other lines of text, usually stacked on top of each other.
-- <br><br>inherit <a href=".\FontFrame.html">FontFrame</a> For all methods, properties and scriptTypes
-- @name MessageFrame
-- @class table
-- @field Fading whether messages added to the frame automatically fade out after a period of time
-- @field TimeVisible the amount of time for which a message remains visible before beginning to fade out
-- @field FadeDuration the duration of the fade-out animation for disappearing messages
-- @field InsertMode the position at which new messages are added to the frame
-- @field IndentedWordWrap whether long lines of text are indented when wrapping
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 3
	if not IGAS:NewAddon("IGAS.GUI.MessageFrame", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "MessageFrame"
    local _Base = "FontFrame"

	-- ScriptType
	local _ScriptType = {
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Adds a message to those listed in the frame.
		-- @name MessageFrame:AddMessage
		-- @class function
		-- @param text Text of the message
		-- @param red Optional,Red component of the text color for the message (0.0 - 1.0)
		-- @param green Optional,Green component of the text color for the message (0.0 - 1.0)
		-- @param blue Optional,Blue component of the text color for the message (0.0 - 1.0)
		-- @param alpha Optional,Alpha (opacity) for the message (0.0 = fully transparent, 1.0 = fully opaque)
		-- @usage MessageFrame:AddMessage("Show me the money")
		------------------------------------

		-- AddMessage
		["AddMessage"] = function(self, ...)
			return self.__UI:AddMessage(...)
		end,

		------------------------------------
		--- Clear the messages from the frame
		-- @name MessageFrame:Clear
		-- @class function
		-- @usage MessageFrame:Clear()
		------------------------------------

		-- Clear
		["Clear"] = function(self, ...)
			return self.__UI:Clear(...)
		end,

		------------------------------------
		--- Gets the fade duration in seconds
		-- @name MessageFrame:GetFadeDuration
		-- @class function
		-- @return the fade duration in seconds
		-- @usage MessageFrame:GetFadeDuration()
		------------------------------------

		-- GetFadeDuration
		["GetFadeDuration"] = function(self, ...)
			return self.__UI:GetFadeDuration(...)
		end,

		------------------------------------
		--- Get whether the frame is fading
		-- @name MessageFrame:GetFading
		-- @class function
		-- @return whether the frame is fading
		-- @usage MessageFrame:GetFading()
		------------------------------------

		-- GetFading
		["GetFading"] = function(self, ...)
			return self.__UI:GetFading(...)
		end,

		------------------------------------
		--- Returns whether long lines of text are indented when wrapping
		-- @name MessageFrame:GetIndentedWordWrap
		-- @class function
		-- @return 1 if long lines of text are indented when wrapping; otherwise nil
		-- @usage MessageFrame:GetIndentedWordWrap()
		------------------------------------

		-- GetIndentedWordWrap
		["GetIndentedWordWrap"] = function(self, ...)
			return self.__UI:GetIndentedWordWrap(...)
		end,

		------------------------------------
		--- Get the insert mode for the frame
		-- @name MessageFrame:GetInsertMode
		-- @class function
		-- @return the insert mode
		-- @usage MessageFrame:GetInsertMode()
		------------------------------------

		-- GetInsertMode
		["GetInsertMode"] = function(self, ...)
			return self.__UI:GetInsertMode(...)
		end,

		------------------------------------
		--- Get the message visibility time in seconds
		-- @name MessageFrame:GetTimeVisible
		-- @class function
		-- @return the message visibility time
		-- @usage MessageFrame:GetTimeVisible()
		------------------------------------

		-- GetTimeVisible
		["GetTimeVisible"] = function(self, ...)
			return self.__UI:GetTimeVisible(...)
		end,

		------------------------------------
		--- Sets the duration of the fade-out animation for disappearing messages.
		-- @name MessageFrame:SetFadeDuration
		-- @class function
		-- @param duration Duration of the fade-out animation for disappearing messages (in seconds)
		-- @usage MessageFrame:SetFadeDuration(12)
		------------------------------------

		-- SetFadeDuration
	    ["SetFadeDuration"] = function(self, ...)
			return self.__UI:SetFadeDuration(...)
		end,

		------------------------------------
		--- Sets whether messages added to the frame automatically fade out after a period of time
		-- @name MessageFrame:SetFading
		-- @class function
		-- @param fading True to cause messages added to the frame to automatically fade out after a period of time; false to leave message visible
		-- @usage MessageFrame:SetFading(12)
		------------------------------------

		-- SetFading
	    ["SetFading"] = function(self, ...)
			return self.__UI:SetFading(...)
		end,

		------------------------------------
		--- Sets whether long lines of text are indented when wrapping
		-- @name MessageFrame:SetIndentedWordWrap
		-- @class function
		-- @param indent True to indent wrapped lines of text; false otherwise
		-- @usage MessageFrame:SetIndentedWordWrap(12)
		------------------------------------

		-- SetIndentedWordWrap
		["SetIndentedWordWrap"] = function(self, ...)
			return self.__UI:SetIndentedWordWrap(...)
		end,

		------------------------------------
		--- Sets whether messages added to the frame automatically fade out after a period of time
		-- @name MessageFrame:SetInsertMode
		-- @class function
		-- @param position Token identifying the position at which new messages should be added to the frame: BOTTOM, TOP
		-- @usage MessageFrame:SetInsertMode("TOP")
		------------------------------------

		-- SetInsertMode
	    ["SetInsertMode"] = function(self, ...)
			return self.__UI:SetInsertMode(...)
		end,

		------------------------------------
		--- Sets the amount of time for which a message remains visible before beginning to fade out.
		-- @name MessageFrame:SetTimeVisible
		-- @class function
		-- @param time Amount of time for which a message remains visible before beginning to fade out (in seconds)
		-- @usage MessageFrame:SetTimeVisible(12)
		------------------------------------

		-- SetTimeVisible
	    ["SetTimeVisible"] = function(self, ...)
			return self.__UI:SetTimeVisible(...)
		end,
    }

	-- Property
	local _Property = {
        -- Fading
        ["Fading"] = {
			["Set"] = function(self, state)
				self.__UI:SetFading(state)
			end,

			["Get"] = function(self)
				return (self.__UI:GetFading() and true) or false
			end,

			["Type"] = "boolean",
		},

        -- IndentedWordWrap
        ["IndentedWordWrap"] = {
			["Set"] = function(self, state)
				self.__UI:SetIndentedWordWrap(state)
			end,

			["Get"] = function(self)
				return (self.__UI:GetIndentedWordWrap() and true) or false
			end,

			["Type"] = "boolean",
		},

        -- TimeVisible
        ["TimeVisible"] = {
			["Set"] = function(self, seconds)
				self.__UI:SetTimeVisible(seconds)
			end,

			["Get"] = function(self)
				return self.__UI:GetTimeVisible()
			end,

			["Type"] = "number",
		},

        -- FadeDuration
        ["FadeDuration"] = {
			["Set"] = function(self, seconds)
				self.__UI:SetFadeDuration(seconds)
			end,

			["Get"] = function(self)
				return self.__UI:GetFadeDuration()
			end,

			["Type"] = "number",
		},

        -- InsertMode
        ["InsertMode"] = {
			["Set"] = function(self, mode)
				self.__UI:SetInsertMode(mode)
			end,

			["Get"] = function(self)
				return self.__UI:GetInsertMode()
			end,

			["Type"] = "InsertMode",
		},
	 }

    -- New
    local _New = function(_parent,inheritFrame)
        -- New Frame
		return CreateFrame(_WidgetName,nil,IGAS:GetUI(_parent),inheritFrame)
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true, true)
end