﻿-- Author      : Kurapica
-- Create Date : 6/13/2008 5:22:03 PM

----------------------------------------------------------------------------------------------------------------------------------------
--- LayeredRegion is an abstract UI type that groups together the functionality of layered graphical regions, specifically Textures and FontStrings.
-- <br><br>inherit <a href=".\Region.html">Region</a> For all methods, properties and scriptTypes
-- @name LayeredRegion
-- @class table
-- @field DrawLayer the layer at which the region's graphics are drawn relative to others in its frame
-- @field VertexColor the color shading for the region's graphics
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.LayeredRegion", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "LayeredRegion"
    local _Base = "Region"

    -- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Returns the draw layer for the Region
		-- @name LayeredRegion:GetDrawLayer
		-- @class function
		-- @return the draw layer for the Region
		-- @usage LayeredRegion:GetDrawLayer()
		------------------------------------

		-- GetDrawLayer
        ["GetDrawLayer"] = function(self)
            return self.__UI:GetDrawLayer()
        end,

		------------------------------------
		--- Sets the draw layer for the Region
		-- @name LayeredRegion:SetDrawLayer
		-- @class function
		-- @param layer String identifying a graphics layer;
		-- @usage LayeredRegion:SetDrawLayer("ARTWORK")
		------------------------------------

		-- SetDrawLayer
        ["SetDrawLayer"] = function(self, layer)
            self.__UI:SetDrawLayer(layer)
        end,

		------------------------------------
		--- Sets a color shading for the region's graphics. The effect of changing this property differs by the type of region:
		-- @name LayeredRegion:SetVertexColor
		-- @class function
		-- @param red Red component of the color (0.0 - 1.0)
		-- @param green Green component of the color (0.0 - 1.0)
		-- @param blue Blue component of the color (0.0 - 1.0)
		-- @param alpha Alpha (opacity) for the graphic (0.0 = fully transparent, 1.0 = fully opaque)
		-- @usage LayeredRegion:SetVertexColor(1, 1, 1, 1)
		------------------------------------

		-- SetVertexColor
        ["SetVertexColor"] = function(self, r,g,b,a)
            self.__UI:SetVertexColor(r,g,b,a)
        end,
    }

	-- Property
	local _Property = {
		["DrawLayer"] = {
			["Set"] = function(self, layer)
				self:SetDrawLayer(layer)
			end,

			["Get"] = function(self)
				return self:GetDrawLayer()
			end,

			["Type"] = "DrawLayer",
		},

		["VertexColor"] = {
			["Set"] = function(self, color)
				self:SetVertexColor(color.red, color,green, color.blue, color.alpha)
			end,

			["Type"] = "Color",
		},
	}

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
    }

    IGAS:NewWidget(_WidgetInfo, true)
end