﻿-- Author      : Kurapica
-- Create Date : 7/16/2008 11:55

----------------------------------------------------------------------------------------------------------------------------------------
--- GameTooltips are used to display explanatory information relevant to a particular element of the game world.
-- <br><br>inherit <a href=".\Frame.html">Frame</a> For all methods, properties and scriptTypes
-- @name GameTooltip
-- @class table
----------------------------------------------------------------------------------------------------------------------------------------

do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.GameTooltip", version) then
		return
	end

	local CreateFrame = CreateFrame

	local _WidgetName = "GameTooltip"
	local _Base = "Frame"
	local _G = _G
	local strmatch = strmatch

	-- Scripts
	local _FrameBackdrop = {
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
		tile = true, tileSize = 16, edgeSize = 16,
		insets = { left = 5, right = 5, top = 5, bottom = 5}
	}

	-- Counter, must be inherited from the prev version
	_GameTooltipCnt = _GameTooltipCnt or 1

	-- ScriptType
	local _ScriptType = {
		------------------------------------
		--- ScriptType, Run when an amount of money should be added to the tooltip
		-- @name GameTooltip:OnTooltipAddMoney
		-- @class function
		-- @param amount Amount of money to be added to the tooltip (in copper)
		-- @param maxAmount A second amount of money to be added to the tooltip (in copper); if non-nil, the first amount is treated as the minimum and this amount as the maximum of a price range
		-- @usage function GameTooltip:OnTooltipAddMoney(amount, maxAmount)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnTooltipAddMoney"] = true,

		------------------------------------
		--- ScriptType, Run when the tooltip is hidden or its content is cleared
		-- @name GameTooltip:OnTooltipCleared
		-- @class function
		-- @usage function GameTooltip:OnTooltipCleared()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnTooltipCleared"] = true,

		------------------------------------
		--- ScriptType, Run when the tooltip is filled with information about an achievement
		-- @name GameTooltip:OnTooltipSetAchievement
		-- @class function
		-- @usage function GameTooltip:OnTooltipSetAchievement()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnTooltipSetAchievement"] = true,

		------------------------------------
		--- ScriptType, Run when the tooltip is repositioned to its default anchor location
		-- @name GameTooltip:OnTooltipSetDefaultAnchor
		-- @class function
		-- @usage function GameTooltip:OnTooltipSetDefaultAnchor()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnTooltipSetDefaultAnchor"] = true,

		------------------------------------
		--- ScriptType, Run when the tooltip is filled with information about an equipment set
		-- @name GameTooltip:OnTooltipSetEquipmentSet
		-- @class function
		-- @usage function GameTooltip:OnTooltipSetEquipmentSet()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnTooltipSetEquipmentSet"] = true,

		------------------------------------
		--- ScriptType, Run when the tooltip is filled with a list of frames under the mouse cursor
		-- @name GameTooltip:OnTooltipSetFrameStack
		-- @class function
		-- @usage function GameTooltip:OnTooltipSetFrameStack()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnTooltipSetFrameStack"] = true,

		------------------------------------
		--- ScriptType, Run when the tooltip is filled with information about an item
		-- @name GameTooltip:OnTooltipSetItem
		-- @class function
		-- @usage function GameTooltip:OnTooltipSetItem()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnTooltipSetItem"] = true,

		------------------------------------
		--- ScriptType, Run when the tooltip is filled with information about a quest
		-- @name GameTooltip:OnTooltipSetQuest
		-- @class function
		-- @usage function GameTooltip:OnTooltipSetQuest()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnTooltipSetQuest"] = true,

		------------------------------------
		--- ScriptType, Run when the tooltip is filled with information about a spell
		-- @name GameTooltip:OnTooltipSetSpell
		-- @class function
		-- @usage function GameTooltip:OnTooltipSetSpell()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnTooltipSetSpell"] = true,

		------------------------------------
		--- ScriptType, Run when the tooltip is filled with information about a unit
		-- @name GameTooltip:OnTooltipSetUnit
		-- @class function
		-- @usage function GameTooltip:OnTooltipSetUnit()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnTooltipSetUnit"] = true,
	}

	-- FuncProxy
	local _FuncProxy = {
		-- Dispose, release resource
        ["Dispose"] = function(self)
			local name = self.__UI:GetName()
			local index, chkName

			self:ClearLines()

			if name and _G[name] then
				-- remove lefttext
				index = 1

				while _G[name.."TextLeft"..index] do
					_G[name.."TextLeft"..index] = nil
					index = index + 1
				end

				-- remove righttext
				index = 1

				while _G[name.."TextRight"..index] do
					_G[name.."TextRight"..index] = nil
					index = index + 1
				end

				-- remove texture
				index = 1

				while _G[name.."Texture"..index] do
					_G[name.."Texture"..index] = nil
					index = index + 1
				end

				-- remove self
				_G[name] = nil
			end

            -- Call super's dispose
			self:CallMethod(_Base, "Dispose")
        end,

		------------------------------------
		--- Adds a line to the tooltip with both left-side and right-side portions.
		-- @name GameTooltip:AddDoubleLine
		-- @class function
		-- @param textLeft Text to be displayed on the left side of the new line
		-- @param textRight Text to be displayed on the right side of the new line
		-- @param rL Optional,Red component of the color for the left-side text (0.0 - 1.0)
		-- @param gL Optional,Green component of the color for the left-side text (0.0 - 1.0)
		-- @param bL Optional,Blue component of the color for the left-side text (0.0 - 1.0)
		-- @param rR Optional,Red component of the color for the right-side text (0.0 - 1.0)
		-- @param gR Optional,Green component of the color for the right-side text (0.0 - 1.0)
		-- @param bR Optional,Blue component of the color for the right-side text (0.0 - 1.0)
		-- @usage GameTooltip:AddDoubleLine("LEFT1", "RIGHT1")
		------------------------------------

		-- AddDoubleLine
		["AddDoubleLine"] = function(self, ...)
			return self.__UI:AddDoubleLine(...)
		end,

		------------------------------------
		--- Adds FontString objects to the tooltip, allowing it to display an additional line of text.
		-- @name GameTooltip:AddFontStrings
		-- @class function
		-- @param left Reference to a FontString object for the left-side text of a new line
		-- @param right Reference to a FontString object for the right-side text of a new line
		-- @usage GameTooltip:AddFontStrings(IGAS:NewFrame("FontString"), IGAS:NewFrame("FontString"))
		------------------------------------

		-- AddFontStrings
		["AddFontStrings"] = function(self, leftstring, rightstring, ...)
			return self.__UI:AddFontStrings(IGAS:GetUI(leftstring), IGAS:GetUI(rightstring),...)
		end,

		------------------------------------
		--- Adds a line of text to the tooltip.The tooltip is not automatically resized to fit the added line (and wrap it, if applicable); to do so, call the tooltip's :Show()  method after adding lines.
		-- @name GameTooltip:AddLine
		-- @class function
		-- @param text - Text to be added as a new line in the tooltip
		-- @param r Optional,- Red component of the text color (0.0 - 1.0)
		-- @param g Optional,- Green component of the text color (0.0 - 1.0)
		-- @param b Optional,- Blue component of the text color (0.0 - 1.0)
		-- @param wrap Optional,- True to cause the line to wrap if it is longer than other, non-wrapping lines in the tooltip or longer than the tooltip's forced width
		-- @usage GameTooltip:AddLine("Line 1")
		------------------------------------

		-- AddLine
		["AddLine"] = function(self, ...)
			return self.__UI:AddLine(...)
		end,

		------------------------------------
		--- Adds a texture to the last tooltip line. The texture is sized to match the height of the line's text and positioned to the left of the text (indenting the text to provide room).
		-- @name GameTooltip:AddTexture
		-- @class function
		-- @param texture Path to a texture image file
		-- @usage GameTooltip:AddTexture("Interface\\Icons\\Ability_Creature_Cursed_04")
		------------------------------------

		-- AddTexture
		["AddTexture"] = function(self, texture, ...)
			return self.__UI:AddTexture(IGAS:GetUI(texture), ...)
		end,

		------------------------------------
		--- Adds text to the first line of the tooltip
		-- @name GameTooltip:AppendText
		-- @class function
		-- @param text Text to be appended to the tooltip's first line
		-- @usage GameTooltip:AppendText("Sample Text")
		------------------------------------

		-- AppendText
		["AppendText"] = function(self, ...)
			return self.__UI:AppendText(...)
		end,

		------------------------------------
		--- Clear all lines of tooltip (both left and right ones)
		-- @name GameTooltip:ClearLines
		-- @class function
		-- @usage GameTooltip:ClearLines()
		------------------------------------

		-- ClearLines
		["ClearLines"] = function(self, ...)
			return self.__UI:ClearLines(...)
		end,

		------------------------------------
		--- Causes the tooltip to begin fading out
		-- @name GameTooltip:FadeOut
		-- @class function
		-- @usage GameTooltip:FadeOut()
		------------------------------------

		-- FadeOut
		["FadeOut"] = function(self, ...)
			return self.__UI:FadeOut(...)
		end,

		------------------------------------
		--- Returns the current anchoring type.
		-- @name GameTooltip:GetAnchorType
		-- @class function
		-- @return the current anchoring type
		-- @usage GameTooltip:GetAnchorType()
		------------------------------------

		-- GetAnchorType
		["GetAnchorType"] = function(self, ...)
			return self.__UI:GetAnchorType(...)
		end,

		------------------------------------
		--- Returns the name and hyperlink for the item displayed in the tooltip
		-- @name GameTooltip:GetItem
		-- @class function
		-- @return name Name of the item whose information is displayed in the tooltip, or nil
		-- @return link A hyperlink for the item
		-- @usage GameTooltip:GetItem()
		------------------------------------

		-- GetItem
		["GetItem"] = function(self, ...)
			return self.__UI:GetItem(...)
		end,

		------------------------------------
		--- Returns the minimum width of the tooltip
		-- @name GameTooltip:GetMinimumWidth
		-- @class function
		-- @return the minimum width of the tooltip
		-- @usage GameTooltip:GetMinimumWidth()
		------------------------------------

		-- GetMinimumWidth
		["GetMinimumWidth"] = function(self, ...)
			return self.__UI:GetMinimumWidth(...)
		end,

		------------------------------------
		--- Returns information about the spell displayed in the tooltip
		-- @name GameTooltip:GetSpell
		-- @class function
		-- @return spellName - Name of the spell, or nil if the information in the tooltip is not for a spell
		-- @return spellRank - Secondary text associated with the spell name
		-- @return spellID - Numeric identifier for the spell and rank
		-- @usage GameTooltip:GetSpell()
		------------------------------------

		-- GetSpell
		["GetSpell"] = function(self, ...)
			return self.__UI:GetSpell(...)
		end,

		------------------------------------
		--- Returns the frame to which the tooltip refers and is anchored
		-- @name GameTooltip:GetOwner
		-- @class function
		-- @return owner - Reference to the Frame object to which the tooltip is anchored
		-- @usage GameTooltip:GetOwner()
		------------------------------------

		-- GetOwner
		["GetOwner"] = function(self, ...)
			return IGAS:GetWrapper(self.__UI:GetOwner(...))
		end,

		------------------------------------
		--- Returns information about the unit displayed in the tooltip
		-- @name GameTooltip:GetUnit
		-- @class function
		-- @return name - Name of the unit displayed in the tooltip, or nil
		-- @return unit - Unit identifier of the unit, or nil if the unit cannot be referenced by a unitID
		-- @usage GameTooltip:GetUnit()
		------------------------------------

		-- GetUnit
		["GetUnit"] = function(self, ...)
			return self.__UI:GetUnit(...)
		end,

		------------------------------------
		--- Returns whether the tooltip is displaying information for a given unit
		-- @name GameTooltip:IsUnit
		-- @class function
		-- @param unit A unit to query
		-- @return 1 if the tooltip is displaying information for the unit; otherwise nil
		-- @usage GameTooltip:IsUnit()
		------------------------------------

		-- IsUnit
		["IsUnit"] = function(self, ...)
			return self.__UI:IsUnit(...)
		end,

		------------------------------------
		--- Get the number of lines in the tooltip.
		-- @name GameTooltip:NumLines
		-- @class function
		-- @return the number of lines in the tooltip
		-- @usage GameTooltip:NumLines()
		------------------------------------

		-- NumLines
		["NumLines"] = function(self, ...)
			return self.__UI:NumLines(...)
		end,

		------------------------------------
		--- Shows the tooltip for the specified action button.
		-- @name GameTooltip:SetAction
		-- @class function
		-- @param slot An action bar slot
		-- @usage GameTooltip:SetAction(7)
		------------------------------------

		-- SetAction
		["SetAction"] = function(self, ...)
			return self.__UI:SetAction(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item in the auction house
		-- @name GameTooltip:SetAuctionItem
		-- @class function
		-- @param list Type of auction listing:bidder,list,owner
		-- @param index Index of an auction in the listing
		-- @usage GameTooltip:SetAuctionItem("list", 1)
		------------------------------------

		-- SetAuctionItem
		["SetAuctionItem"] = function(self, ...)
			return self.__UI:SetAuctionItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about the item currently being set up for auction
		-- @name GameTooltip:SetAuctionSellItem
		-- @class function
		-- @usage GameTooltip:SetAuctionSellItem()
		------------------------------------

		-- SetAuctionSellItem
		["SetAuctionSellItem"] = function(self, ...)
			return self.__UI:SetAuctionSellItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about a currency marked for watching on the Backpack UI
		-- @name GameTooltip:SetBackpackToken
		-- @class function
		-- @param index Index of a 'slot' for displaying currencies on the backpack (between 1 and MAX_WATCHED_TOKENS)
		-- @usage GameTooltip:SetBackpackToken(2)
		------------------------------------

		-- SetBackpackToken
		["SetBackpackToken"] = function(self, ...)
			return self.__UI:SetBackpackToken(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item in the player's bags
		-- @name GameTooltip:SetBagItem
		-- @class function
		-- @param container Index of one of the player's bags or other containers
		-- @param slot Index of an item slot within the container
		-- @return hasCooldown - 1 if the item is currently on cooldown, otherwise nil
		-- @return repairCost - Cost of repairing the item (in copper, ignoring faction discounts)
		-- @usage GameTooltip:SetBagItem(0, 4)
		------------------------------------

		-- SetBagItem
		["SetBagItem"] = function(self, ...)
			return self.__UI:SetBagItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about item recently sold to a vendor and available to be repurchased
		-- @name GameTooltip:SetBuybackItem
		-- @class function
		-- @param index Index of an item in the buyback listing (between 1 and GetNumBuybackItems())
		-- @usage GameTooltip:SetBuybackItem(1)
		------------------------------------

		-- SetBuybackItem
		["SetBuybackItem"] = function(self, ...)
			return self.__UI:SetBuybackItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about a special currency type
		-- @name GameTooltip:SetCurrencyToken
		-- @class function
		-- @param index Index of a currency type in the currency list (between 1 and GetCurrencyListSize())
		-- @usage GameTooltip:SetCurrencyToken(1)
		------------------------------------

		-- SetCurrencyToken
		["SetCurrencyToken"] = function(self, ...)
			return self.__UI:SetCurrencyToken(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about one of the player's glyphs
		-- @name GameTooltip:SetGlyph
		-- @class function
		-- @param socket Which socket's glyph to display (between 1 and NUM_GLYPH_SLOTS)
		-- @param talentGroup Optional,Which set of glyphs to display, if the player has Dual Talent Specialization enabled: 1 - Primary Talents,2 - Secondary Talents,nil - Currently active talents
		-- @usage GameTooltip:SetGlyph(1)
		------------------------------------

		-- SetGlyph
		["SetGlyph"] = function(self, ...)
			return self.__UI:SetGlyph(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item in the guild bank. Information is only available if the guild bank tab has been opened in the current play session.
		-- @name GameTooltip:SetGuildBankItem
		-- @class function
		-- @param tab Index of a guild bank tab (between 1 and GetNumGuildBankTabs())
		-- @param slot Index of an item slot in the guild bank tab (between 1 and MAX_GUILDBANK_SLOTS_PER_TAB)
		-- @usage GameTooltip:SetGuildBankItem(1, 1)
		------------------------------------

		-- SetGuildBankItem
		["SetGuildBankItem"] = function(self, ...)
			return self.__UI:SetGuildBankItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item, quest, spell, or other entity represented by a hyperlink
		-- @name GameTooltip:SetHyperlink
		-- @class function
		-- @param hyperlink A full hyperlink, or the linktype:linkdata  portion thereof
		-- @usage GameTooltip:SetHyperlink([Horse' bagpack])
		------------------------------------

		-- SetHyperlink
		["SetHyperlink"] = function(self, ...)
			return self.__UI:SetHyperlink(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item, quest, spell, or other entity represented by a hyperlink
		-- @name GameTooltip:SetHyperlinkCompareItem
		-- @class function
		-- @param hyperlink A full hyperlink, or the linktype:linkdata  portion thereof, for an item to compare against the player's equipped similar item
		-- @param index Index of the slot to compare against (1, 2, or 3), if more than one item of the equipment type can be equipped at once
		-- @return 1 if an item's information was loaded into the tooltip; otherwise nil
		-- @usage GameTooltip:SetHyperlinkCompareItem([Horse' bagpack], 12)
		------------------------------------

		-- SetHyperlinkCompareItem
		["SetHyperlinkCompareItem"] = function(self, ...)
			return self.__UI:SetHyperlinkCompareItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item attached to a message in the player's inbox
		-- @name GameTooltip:SetInboxItem
		-- @class function
		-- @param mailID Index of a message in the player's inbox (between 1 and GetInboxNumItems())
		-- @param attachmentIndex Index of an attachment to the message (between 1 and select(8,GetInboxHeaderInfo(mailID)))
		-- @usage GameTooltip:SetInboxItem(1, 12)
		------------------------------------

		-- SetInboxItem
		["SetInboxItem"] = function(self, ...)
			return self.__UI:SetInboxItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an equipped item
		-- @name GameTooltip:SetInventoryItem
		-- @class function
		-- @param unit A unit to query; only valid for 'player' or the unit currently being inspected
		-- @param slot An inventory slot number, as can be obtained from GetInventorySlotInfo
		-- @param nameOnly Optional,True to omit much of the item's information (stat bonuses, sockets, and binding) from the tooltip; false to show all of the item's information
		-- @return hasItem - 1 if the unit has an item in the given slot; otherwise nil
		-- @return hasCooldown - 1 if the item is currently on cooldown; otherwise nil
		-- @return repairCost - Cost to repair the item (in copper, ignoring faction discounts)
		-- @usage GameTooltip:SetInventoryItem("player", 13)
		------------------------------------

		-- SetInventoryItem
		["SetInventoryItem"] = function(self, ...)
			return self.__UI:SetInventoryItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item available as loot
		-- @name GameTooltip:SetLootItem
		-- @class function
		-- @param slot Index of a loot slot (between 1 and GetNumLootItems())
		-- @usage GameTooltip:SetLootItem(1)
		------------------------------------

		-- SetLootItem
		["SetLootItem"] = function(self, ...)
			return self.__UI:SetLootItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item currently up for loot rolling
		-- @name GameTooltip:SetLootRollItem
		-- @class function
		-- @param id Index of an item currently up for loot rolling (as provided in the START_LOOT_ROLL  event)
		-- @usage GameTooltip:SetLootRollItem(1)
		------------------------------------

		-- SetLootRollItem
		["SetLootRollItem"] = function(self, ...)
			return self.__UI:SetLootRollItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item available for purchase from a vendor
		-- @name GameTooltip:SetMerchantItem
		-- @class function
		-- @param merchantIndex The index of an item in the merchant window, between 1 and GetMerchantNumItems()
		-- @usage GameTooltip:SetMerchantItem(1)
		------------------------------------

		-- SetMerchantItem
		["SetMerchantItem"] = function(self, ...)
			return self.__UI:SetMerchantItem(...)
		end,

		------------------------------------
		--- Sets the minimum width of the tooltip.
		-- @name GameTooltip:SetMinimumWidth
		-- @class function
		-- @param width Minimum width of the tooltip frame (in pixels)
		-- @usage GameTooltip:SetMinimumWidth(30)
		------------------------------------

		-- SetMinimumWidth
		["SetMinimumWidth"] = function(self, ...)
			return self.__UI:SetMinimumWidth(...)
		end,

		------------------------------------
		--- Sets the frame to which the tooltip refers and is anchored
		-- @name GameTooltip:SetOwner
		-- @class function
		-- @param frame Reference to the Frame to which the tooltip refers
		-- @param anchorType Optional,Token identifying the positioning method for the tooltip relative to its owner frame
		-- @param xOffset Optional,The horizontal offset for the tooltip anchor
		-- @param yOffset Optional,The vertical offset for the tooltip anchor
		-- @usage GameTooltip:SetOwner(UIParent)
		------------------------------------

		-- SetOwner
		["SetOwner"] = function(self, owner, ...)
			return self.__UI:SetOwner(IGAS:GetUI(owner), ...)
		end,

		------------------------------------
		--- Sets the amount of space between tooltip's text and its right-side edge. Used in the default UI's ItemRefTooltip to provide space for a close button.
		-- @name GameTooltip:SetPadding
		-- @class function
		-- @param padding Amount of space between the right-side edge of the tooltip's text and the right-side edge of the tooltip frame (in pixels)
		-- @usage GameTooltip:SetPadding(14)
		------------------------------------

		-- SetPadding
		["SetPadding"] = function(self, ...)
			return self.__UI:SetPadding(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about a pet action.
		-- @name GameTooltip:SetPetAction
		-- @class function
		-- @param index Index of a pet action button (between 1 and NUM_PET_ACTION_SLOTS)
		-- @usage GameTooltip:SetPetAction(5)
		------------------------------------

		-- SetPetAction
		["SetPetAction"] = function(self, ...)
			return self.__UI:SetPetAction(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item in a questgiver dialog
		-- @name GameTooltip:SetQuestItem
		-- @class function
		-- @param itemType Token identifying one of the possible sets of items: choice, required, reward
		-- @param index Index of an item in the set (between 1 and GetNumQuestChoices(), GetNumQuestItems(), or GetNumQuestRewards(), according to itemType)
		-- @usage GameTooltip:SetQuestItem("reward", 1)
		------------------------------------

		-- SetQuestItem
		["SetQuestItem"] = function(self, ...)
			return self.__UI:SetQuestItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item related to the selected quest in the quest log
		-- @name GameTooltip:SetQuestLogItem
		-- @class function
		-- @param itemType Token identifying one of the possible sets of items: choice, reward
		-- @param index Index of an item in the set (between 1 and GetNumQuestLogChoices()  or GetNumQuestLogRewards(), according to itemType)
		-- @usage GameTooltip:SetQuestLogItem("reward", 1)
		------------------------------------

		-- SetQuestLogItem
		["SetQuestLogItem"] = function(self, ...)
			return self.__UI:SetQuestLogItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about the reward spell for the selected quest in the quest log
		-- @name GameTooltip:SetQuestLogRewardSpell
		-- @class function
		-- @usage GameTooltip:SetQuestLogRewardSpell()
		------------------------------------

		-- SetQuestLogRewardSpell
		["SetQuestLogRewardSpell"] = function(self, ...)
			return self.__UI:SetQuestLogRewardSpell(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about the spell reward in a questgiver dialog
		-- @name GameTooltip:SetQuestRewardSpell
		-- @class function
		-- @usage GameTooltip:SetQuestRewardSpell()
		------------------------------------

		-- SetQuestRewardSpell
		["SetQuestRewardSpell"] = function(self, ...)
			return self.__UI:SetQuestRewardSpell(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item attached to the outgoing mail message
		-- @name GameTooltip:SetSendMailItem
		-- @class function
		-- @param slot Index of an outgoing attachment slot (between 1 and ATTACHMENTS_MAX_SEND)
		-- @usage GameTooltip:SetSendMailItem(2)
		------------------------------------

		-- SetSendMailItem
		["SetSendMailItem"] = function(self, ...)
			return self.__UI:SetSendMailItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an ability on the stance/shapeshift bar
		-- @name GameTooltip:SetShapeshift
		-- @class function
		-- @param index Index of an ability on the stance/shapeshift bar (between 1 and GetNumShapeshiftForms())
		-- @usage GameTooltip:SetShapeshift(2)
		------------------------------------

		-- SetShapeshift
		["SetShapeshift"] = function(self, ...)
			return self.__UI:SetShapeshift(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about a spell from the player (or pet's) spellbook
		-- @name GameTooltip:SetSpell
		-- @class function
		-- @param id Index of a spell in the spellbook
		-- @param bookType Type of spellbook:pet, spell
		-- @usage GameTooltip:SetSpell(2, "spell")
		------------------------------------

		-- SetSpell
		["SetSpell"] = function(self, ...)
			return self.__UI:SetSpell(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about a talent
		-- @name GameTooltip:SetTalent
		-- @class function
		-- @param tabIndex Index of a talent tab (between 1 and GetNumTalentTabs())
		-- @param talentIndex Index of a talent option (between 1 and GetNumTalents())
		-- @param inspect true to return information for the currently inspected unit; false to return information for the player
		-- @param pet true to return information for the player's pet; false to return information for the player
		-- @param talentGroup Which set of talents to edit, if the player has Dual Talent Specialization enabled
		-- @usage GameTooltip:SetTalent(2, 3)
		------------------------------------

		-- SetTalent
		["SetTalent"] = function(self, ...)
			return self.__UI:SetTalent(...)
		end,

		------------------------------------
		--- Sets the tooltip's text. Any other content currently displayed in the tooltip will be removed or hidden, and the tooltip's size will be adjusted to fit the new text.
		-- @name GameTooltip:SetText
		-- @class function
		-- @param text Text to be displayed in the tooltip
		-- @param r Optional,Red component of the text color (0.0 - 1.0)
		-- @param g Optional,Green component of the text color (0.0 - 1.0)
		-- @param b Optional,Blue component of the text color (0.0 - 1.0)
		-- @param a Optional,Alpha (opacity) for the text (0.0 = fully transparent, 1.0 = fully opaque)
		-- @usage GameTooltip:SetText("Hellow", 1, 0.8, 0.8)
		------------------------------------

		-- SetText
		["SetText"] = function(self, ...)
			return self.__UI:SetText(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about the currently selected tracking type. If no tracking type is selected, the tooltip reads "Click to choose tracking type" (or localized equivalent).
		-- @name GameTooltip:SetTracking
		-- @class function
		-- @usage GameTooltip:SetTracking()
		------------------------------------

		-- SetTracking
		["SetTracking"] = function(self, ...)
			return self.__UI:SetTracking(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item offered for trade by the player. See :SetTradeTargetItem()  for items to be received from the trade.
		-- @name GameTooltip:SetTradePlayerItem
		-- @class function
		-- @param index Index of an item offered for trade by the player
		-- @usage GameTooltip:SetTradePlayerItem(1)
		------------------------------------

		-- SetTradePlayerItem
		["SetTradePlayerItem"] = function(self, ...)
			return self.__UI:SetTradePlayerItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item created by a trade skill recipe or a reagent in the recipe
		-- @name GameTooltip:SetTradeSkillItem
		-- @class function
		-- @param skillIndex Index of a recipe in the trade skill list (between 1 and GetNumTradeSkills())
		-- @param reagentIndex Index of a reagent in the recipe (between 1 and GetTradeSkillNumReagents()); if omitted, displays a tooltip for the item created by the recipe
		-- @usage GameTooltip:SetTradeSkillItem(2001, 2)
		------------------------------------

		-- SetTradeSkillItem
		["SetTradeSkillItem"] = function(self, ...)
			return self.__UI:SetTradeSkillItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about an item offered for trade by the target. See :SetTradePlayerItem()  for items to be traded away by the player.
		-- @name GameTooltip:SetTradeTargetItem
		-- @class function
		-- @param index Index of an item offered for trade by the target (between 1 and MAX_TRADE_ITEMS)
		-- @usage GameTooltip:SetTradeTargetItem(1)
		------------------------------------

		-- SetTradeTargetItem
		["SetTradeTargetItem"] = function(self, ...)
			return self.__UI:SetTradeTargetItem(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about a trainer service
		-- @name GameTooltip:SetTrainerService
		-- @class function
		-- @param index Index of an entry in the trainer service listing (between 1 and GetNumTrainerServices())
		-- @usage GameTooltip:SetTrainerService(1)
		------------------------------------

		-- SetTrainerService
		["SetTrainerService"] = function(self, ...)
			return self.__UI:SetTrainerService(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about a unit
		-- @name GameTooltip:SetUnit
		-- @class function
		-- @param unit A unit to query
		-- @usage GameTooltip:SetUnit("mouseover")
		------------------------------------

		-- SetUnit
		["SetUnit"] = function(self, ...)
			return self.__UI:SetUnit(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about a buff or debuff on a unit
		-- @name GameTooltip:SetUnitAura
		-- @class function
		-- @param unit A unit to query
		-- @param index Index of a buff or debuff on the unit
		-- @param filter A list of filters to use when resolving the index, separated by the pipe '|' character: CANCELABLE, HARMFUL, HELPFUL, NOT_CANCELABLE, PLAYER, RAID
		-- @usage GameTooltip:SetUnitAura("player", 1, "RAID")
		------------------------------------

		-- SetUnitAura
		["SetUnitAura"] = function(self, ...)
			return self.__UI:SetUnitAura(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about a buff on a unit. This method is an alias for :SetUnitAura()  with a built-in HELPFUL filter (which cannot be removed or negated with the HARMFUL filter).
		-- @name GameTooltip:SetUnitBuff
		-- @class function
		-- @param unit A unit to query
		-- @param index Index of a buff or debuff on the unit
		-- @param filter A list of filters to use when resolving the index, separated by the pipe '|' character: CANCELABLE, NOT_CANCELABLE, PLAYER, RAID
		-- @usage GameTooltip:SetUnitBuff("player", 1, "RAID")
		------------------------------------

		-- SetUnitBuff
		["SetUnitBuff"] = function(self, ...)
			return self.__UI:SetUnitBuff(...)
		end,

		------------------------------------
		--- Fills the tooltip with information about a debuff on a unit. This method is an alias for :SetUnitAura()  with a built-in HARMFUL filter (which cannot be removed or negated with the HELPFUL filter).
		-- @name GameTooltip:SetUnitDebuff
		-- @class function
		-- @param unit A unit to query
		-- @param index Index of a buff or debuff on the unit
		-- @param filter A list of filters to use when resolving the index, separated by the pipe '|' character: CANCELABLE, NOT_CANCELABLE, PLAYER, RAID
		-- @usage GameTooltip:SetUnitDebuff("player", 1, "RAID")
		------------------------------------

		-- SetUnitDebuff
		["SetUnitDebuff"] = function(self, ...)
			return self.__UI:SetUnitDebuff(...)
		end,

		------------------------------------
		--- Get the left text of the given index line
		-- @name GameTooltip:GetLeftText
		-- @class function
		-- @param index between 1 and self:NumLines()
		-- @usage GameTooltip:GetLeftText(1)
		------------------------------------

		-- GetLeftText
		["GetLeftText"] = function(self, index)
			local name = self.__UI:GetName()

			if not name or not index or type(index) ~= "number" then
				return
			end

			name = name.."TextLeft"..index

			if _G[name] and type(_G[name]) == "table" and _G[name].GetText then
				return _G[name]:GetText()
			end
		end,

		------------------------------------
		--- Get the right text of the given index line
		-- @name GameTooltip:GetRightText
		-- @class function
		-- @param index between 1 and self:NumLines()
		-- @usage GameTooltip:GetRightText(1)
		------------------------------------

		-- GetRightText
		["GetRightText"] = function(self, index)
			local name = self.__UI:GetName()

			if not name or not index or type(index) ~= "number" then
				return
			end

			name = name.."TextRight"..index

			if _G[name] and type(_G[name]) == "table" and _G[name].GetText then
				return _G[name]:GetText()
			end
		end,

		------------------------------------
		--- Get the texutre of the given index line
		-- @name GameTooltip:GetTexture
		-- @class function
		-- @param index between 1 and self:NumLines()
		-- @usage GameTooltip:GetTexture(1)
		------------------------------------

		-- GetTexture
		["GetTexture"] = function(self, index)
			local name = self.__UI:GetName()

			if not name or not index or type(index) ~= "number" then
				return
			end

			name = name.."Texture"..index

			if _G[name] and type(_G[name]) == "table" and _G[name].GetTexture then
				return _G[name]:GetTexture()
			end
		end,

		------------------------------------
		--- Get the money of the given index, default 1
		-- @name GameTooltip:GetMoney
		-- @class function
		-- @param index if nil, 1 would be the default
		-- @usage GameTooltip:GetMoney()
		------------------------------------

		-- GetMoney
		["GetMoney"] = function(self, index)
			local name = self.__UI:GetName()

			index = index or 1

			if not name or not index or type(index) ~= "number" then
				return
			end

			name = name.."MoneyFrame"..index

			if _G[name] and type(_G[name]) == "table" then
				local gold = strmatch((_G[name.."GoldButton"] and _G[name.."GoldButton"]:GetText()) or "0", "%d*") or 0
				local silver = strmatch((_G[name.."SilverButton"] and _G[name.."SilverButton"]:GetText()) or "0", "%d*") or 0
				local copper = strmatch((_G[name.."CopperButton"] and _G[name.."CopperButton"]:GetText()) or "0", "%d*") or 0

				return gold * COPPER_PER_SILVER * SILVER_PER_GOLD + silver * COPPER_PER_SILVER + copper
			end
		end,
	}

	-- Property
	local _Property = {
	}

	-- New
	local _New = function(_parent, inheritsFrom)
		-- New Frame
		local frame = CreateFrame("GameTooltip","IGAS_GameTooltip".._GameTooltipCnt,IGAS:GetUI(_parent), inheritsFrom or "GameTooltipTemplate")
		--[[
		frame:SetFrameStrata("TOOLTIP")
		frame:SetClampedToScreen(true)
		frame:Hide()

		frame:SetBackdrop(_FrameBackdrop)
		frame:SetBackdropBorderColor(1, 1, 1)
		frame:SetBackdropColor(0.09, 0.09, 0.19)
		frame:SetOwner(IGAS:GetUI(_parent), "ANCHOR_NONE")

		local lftText = frame:CreateFontString("IGAS_GameTooltip".._GameTooltipCnt.."_TextLeft1", "ARTWORK", "GameTooltipHeaderText")
		local ritText = frame:CreateFontString("IGAS_GameTooltip".._GameTooltipCnt.."_TextRight1", "ARTWORK", "GameTooltipHeaderText")
		local texutre = frame:CreateTexture("IGAS_GameTooltip".._GameTooltipCnt.."_Texture1", "ARTWORK")

		lftText:SetPoint("TOPLEFT", frame, "TOPLEFT", 10, -10)
		ritText:SetPoint("RIGHT", lftText, "LEFT", 40, 0)

		texutre:SetWidth(12)
		texutre:SetHeight(12)

		frame:AddFontStrings(lftText, ritText)
		frame:AddTexture(texutre)
--]]
		_GameTooltipCnt = _GameTooltipCnt + 1

		return frame
	end

	local _WidgetInfo = {
		["WidgetName"] = _WidgetName,
		["Base"] = _Base,
		["FuncProxy"] = _FuncProxy,
		["Property"] = _Property,
		["ScriptType"] = _ScriptType,
		["New"] = _New,
	}

	IGAS:NewWidget(_WidgetInfo, true, true)
end