﻿-- Author      : Kurapica
-- Create Date : 6/12/2008 1:13:42 AM

----------------------------------------------------------------------------------------------------------------------------------------
--- The Font object is the only type of object that is not attached to a parent widget; indeed, its purpose is to be shared between other objects that share font characteristics.<br>
-- In this way, changes to the Font object will update the text appearance of all text objects that have it set as their Font using :SetFontObject().
-- <br><br>inherit <a href=".\FontInstance.html">FontInstance</a> For all methods, properties and scriptTypes
-- @name Font
-- @class table
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.Font", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "Font"
    local _Base = "FontInstance"
	local _G = _G

    -- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Set this Font's attributes to be a copy of the otherFont font object's.
		-- @name Font:CopyFontObject
		-- @class function
		-- @class font a Font object or a Font name
		-- @usage Font:CopyFontObject(GameFontNormal)
		------------------------------------

		-- CopyFontObject
        ["CopyFontObject"] = function(self, otherFont)
            otherFont = IGAS:GetUI(otherFont)
            if otherFont then
                self.__UI:CopyFontObject(otherFont)
            else
                error("No such font")
            end
        end,
    }

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
    }

    IGAS:NewWidget(_WidgetInfo, true)
	
	IGAS:NewPropertyType(_WidgetName, {
		["Check"] = function(font)
			font = (type(font) == "string" and _G[font]) or font
			
			font = IGAS:GetWrapper(font)
			
			assert(font and type(font) == "table" and font.IsObjectType and font:IsObjectType(_WidgetName), "The value must be a font.")
			
			return font
		end,
	})
end