﻿-- Author      : Kurapica
-- Create Date : 7/16/2008 11:15

----------------------------------------------------------------------------------------------------------------------------------------
--- EditBoxes are used to allow the player to type text into a UI component.
-- <br><br>inherit <a href=".\FontFrame.html">FontFrame</a> For all methods, properties and scriptTypes
-- @name EditBox
-- @class table
-- @field MultiLine true if the edit box shows more than one line of text
-- @field NumericOnly true if the edit box only accepts numeric input
-- @field Password true if the text entered in the edit box is masked
-- @field AutoFocus true if the edit box automatically acquires keyboard input focus
-- @field HistoryLines the maximum number of history lines stored by the edit box
-- @field Focused true if the edit box is currently focused
-- @field AltArrowKeyMode true if the arrow keys are ignored by the edit box unless the Alt key is held
-- @field BlinkSpeed the rate at which the text insertion blinks when the edit box is focused
-- @field CursorPosition the current cursor position inside edit box
-- @field MaxBytes the maximum number of bytes of text allowed in the edit box, default is 0(Infinite)
-- @field MaxLetters the maximum number of text characters allowed in the edit box
-- @field Number the contents of the edit box as a number
-- @field Text the edit box's text contents
-- @field TextInsets the insets from the edit box's edges which determine its interactive text area
-- @field Editable true if the edit box is editable
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.EditBox", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "EditBox"
    local _Base = "FontFrame"

	-- ScriptType
	local _ScriptType = {
		------------------------------------
		--- ScriptType, Run when the edit box's input composition mode changes
		-- @name EditBox:OnCharComposition
		-- @class function
		-- @param text The text entered
		-- @usage function EditBox:OnCharComposition(text)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnCharComposition"] = true,

		------------------------------------
		--- ScriptType, Run when the position of the text insertion cursor in the edit box changes
		-- @name EditBox:OnCursorChanged
		-- @class function
		-- @param x Horizontal position of the cursor relative to the top left corner of the edit box (in pixels)
		-- @param y Vertical position of the cursor relative to the top left corner of the edit box (in pixels)
		-- @param width Width of the cursor graphic (in pixels)
		-- @param height Height of the cursor graphic (in pixels); matches the height of a line of text in the edit box
		-- @usage function EditBox:OnCursorChanged(x, y, width, height)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnCursorChanged"] = true,

		------------------------------------
		--- ScriptType, Run when the edit box becomes focused for keyboard input
		-- @name EditBox:OnEditFocusGained
		-- @class function
		-- @usage function EditBox:OnEditFocusGained()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnEditFocusGained"] = true,

		------------------------------------
		--- ScriptType, Run when the edit box loses keyboard input focus
		-- @name EditBox:OnEditFocusLost
		-- @class function
		-- @usage function EditBox:OnEditFocusLost()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnEditFocusLost"] = true,

		------------------------------------
		--- ScriptType, Run when the Enter (or Return) key is pressed while the edit box has keyboard focus
		-- @name EditBox:OnEnterPressed
		-- @class function
		-- @usage function EditBox:OnEnterPressed()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnEnterPressed"] = true,

		------------------------------------
		--- ScriptType, Run when the Escape key is pressed while the edit box has keyboard focus
		-- @name EditBox:OnEscapePressed
		-- @class function
		-- @usage function EditBox:OnEscapePressed()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnEscapePressed"] = true,

		------------------------------------
		--- ScriptType, Run when the edit box's language input mode changes
		-- @name EditBox:OnInputLanguageChanged
		-- @class function
		-- @param language Name of the new input language
		-- @usage function EditBox:OnInputLanguageChanged("language")<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnInputLanguageChanged"] = true,

		------------------------------------
		--- ScriptType, Run when the space bar is pressed while the edit box has keyboard focus
		-- @name EditBox:OnSpacePressed
		-- @class function
		-- @usage function EditBox:OnSpacePressed()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnSpacePressed"] = true,

		------------------------------------
		--- ScriptType, Run when the Tab key is pressed while the edit box has keyboard focus
		-- @name EditBox:OnTabPressed
		-- @class function
		-- @usage function EditBox:OnTabPressed()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnTabPressed"] = true,

		------------------------------------
		--- ScriptType, Run when the edit box's text is changed
		-- @name EditBox:OnTextChanged
		-- @class function
		-- @param isUserInput
		-- @usage function EditBox:OnTextChanged(isUserInput)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnTextChanged"] = true,

		------------------------------------
		--- ScriptType, Run when the edit box's text is set programmatically
		-- @name EditBox:OnTextSet
		-- @class function
		-- @usage function EditBox:OnTextSet()<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnTextSet"] = true,
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Add text to the edit history.
		-- @name EditBox:AddHistoryLine
		-- @class function
		-- @param text Text to be added to the edit box's list of history lines
		-- @usage EditBox:AddHistoryLine("This is a line")
		------------------------------------

		-- AddHistoryLine
		["AddHistoryLine"] = function(self, ...)
			return self.__UI:AddHistoryLine(...)
		end,

		------------------------------------
		--- Releases keyboard input focus from the edit box
		-- @name EditBox:ClearFocus
		-- @class function
		-- @usage EditBox:ClearFocus()
		------------------------------------

		-- ClearFocus
		["ClearFocus"] = function(self, ...)
			return self.__UI:ClearFocus(...)
		end,

		------------------------------------
		--- Return whether only alt+arrow keys work for navigating the edit box, not arrow keys alone.
		-- @name EditBox:GetAltArrowKeyMode
		-- @class function
		-- @return true if only alt+arrow keys work for navigating the edit box, not arrow keys alone
		-- @usage EditBox:GetAltArrowKeyMode()
		------------------------------------

		-- GetAltArrowKeyMode
		["GetAltArrowKeyMode"] = function(self, ...)
			return self.__UI:GetAltArrowKeyMode(...)
		end,

		------------------------------------
		--- Gets the blink speed of the EditBox in seconds
		-- @name EditBox:GetBlinkSpeed
		-- @class function
		-- @return the blink speed of the EditBox in seconds
		-- @usage EditBox:GetBlinkSpeed()
		------------------------------------

		-- GetBlinkSpeed
		["GetBlinkSpeed"] = function(self, ...)
			return self.__UI:GetBlinkSpeed(...)
		end,

		------------------------------------
		--- Gets the position of the cursor inside the EditBox
		-- @name EditBox:GetCursorPosition
		-- @class function
		-- @return the position of the cursor inside the EditBox
		-- @usage EditBox:GetCursorPosition()
		------------------------------------

		-- GetCursorPosition
		["GetCursorPosition"] = function(self, ...)
			return self.__UI:GetCursorPosition(...)
		end,

		------------------------------------
		--- Get the number of history lines for this edit box
		-- @name EditBox:GetHistoryLines
		-- @class function
		-- @return the number of history lines for this edit box
		-- @usage EditBox:GetHistoryLines()
		------------------------------------

		-- GetHistoryLines
		["GetHistoryLines"] = function(self, ...)
			return self.__UI:GetHistoryLines(...)
		end,

		------------------------------------
		--- Get the input language (locale based not in-game)
		-- @name EditBox:GetInputLanguage
		-- @class function
		-- @return the input language (locale based not in-game)
		-- @usage EditBox:GetInputLanguage()
		------------------------------------

		-- GetInputLanguage
		["GetInputLanguage"] = function(self, ...)
			return self.__UI:GetInputLanguage(...)
		end,

		------------------------------------
		--- Gets the maximum number bytes allowed in the EditBox
		-- @name EditBox:GetMaxBytes
		-- @class function
		-- @return the maximum number bytes allowed in the EditBox
		-- @usage EditBox:GetMaxBytes()
		------------------------------------

		-- GetMaxBytes
		["GetMaxBytes"] = function(self, ...)
			return self.__UI:GetMaxBytes(...)
		end,

		------------------------------------
		--- Gets the maximum number of letters allowed in the EditBox
		-- @name EditBox:GetMaxLetters
		-- @class function
		-- @return the maximum number of letters allowed in the EditBox
		-- @usage EditBox:GetMaxLetters()
		------------------------------------

		-- GetMaxLetters
		["GetMaxLetters"] = function(self, ...)
			return self.__UI:GetMaxLetters(...)
		end,

		------------------------------------
		--- Gets the number of letters in the box.
		-- @name EditBox:GetNumLetters
		-- @class function
		-- @return he number of letters in the box
		-- @usage EditBox:GetNumLetters()
		------------------------------------

		-- GetNumLetters
		["GetNumLetters"] = function(self, ...)
			return self.__UI:GetNumLetters(...)
		end,

		------------------------------------
		--- Get the contents of the edit box as a number
		-- @name EditBox:GetNumber
		-- @class function
		-- @return the contents of the edit box as a number
		-- @usage EditBox:GetNumber()
		------------------------------------

		-- GetNumber
		["GetNumber"] = function(self, ...)
			return self.__UI:GetNumber(...)
		end,

		------------------------------------
		--- Get the current text contained in the edit box.
		-- @name EditBox:GetText
		-- @class function
		-- @return the current text contained in the edit box
		-- @usage EditBox:GetText()
		------------------------------------

		-- GetText
		["GetText"] = function(self, ...)
			return self.__UI:GetText(...)
		end,

		------------------------------------
		--- Gets the insets from the edit box's edges which determine its interactive text area
		-- @name EditBox:GetTextInsets
		-- @class function
		-- @return left - Distance from the left edge of the edit box to the left edge of its interactive text area (in pixels)
		-- @return right - Distance from the right edge of the edit box to the right edge of its interactive text area (in pixels)
		-- @return top - Distance from the top edge of the edit box to the top edge of its interactive text area (in pixels)
		-- @return bottom - Distance from the bottom edge of the edit box to the bottom edge of its interactive text area (in pixels)
		-- @usage EditBox:GetTextInsets()
		------------------------------------

		-- GetTextInsets
		["GetTextInsets"] = function(self, ...)
			return self.__UI:GetTextInsets(...)
		end,

		------------------------------------
		--- Selects all or a portion of the text in the edit box
		-- @name EditBox:HighlightText
		-- @class function
		-- @param start Optional,Character position at which to begin the selection (between 0, for the position before the first character, and editbox:GetNumLetters(), for the position after the last character); defaults to 0 if not specified
		-- @param end Optional,Character position at which to end the selection; if not specified or if less than start, selects all characters after the start  position; if equal to start, selects nothing and positions the cursor at the start position
		-- @usage EditBox:HighlightText(1, 10)
		------------------------------------

		-- HighlightText
		["HighlightText"] = function(self, ...)
			return self.__UI:HighlightText(...)
		end,

		------------------------------------
		--- Insert text into the edit box.
		-- @name EditBox:Insert
		-- @class function
		-- @param text Text to be inserted
		-- @usage EditBox:Insert("    ")
		------------------------------------

		-- Insert
		["Insert"] = function(self, ...)
			return self.__UI:Insert(...)
		end,

		------------------------------------
		--- Determine if the EditBox has autofocus enabled
		-- @name EditBox:IsAutoFocus
		-- @class function
		-- @return true if the EditBox has autofocus enabled
		-- @usage EditBox:IsAutoFocus()
		------------------------------------

		-- IsAutoFocus
		["IsAutoFocus"] = function(self, ...)
			return self.__UI:IsAutoFocus(...)
		end,

		------------------------------------
		--- Determine if the EditBox accepts multiple lines
		-- @name EditBox:IsMultiLine
		-- @class function
		-- @return true if the EditBox accepts multiple lines
		-- @usage EditBox:IsMultiLine()
		------------------------------------

		-- IsMultiLine
		["IsMultiLine"] = function(self, ...)
			return self.__UI:IsMultiLine(...)
		end,

		------------------------------------
		--- Determine if the EditBox only accepts numeric input
		-- @name EditBox:IsNumeric
		-- @class function
		-- @return true if the EditBox only accepts numeric input
		-- @usage EditBox:IsNumeric()
		------------------------------------

		-- IsNumeric
		["IsNumeric"] = function(self, ...)
			return self.__UI:IsNumeric(...)
		end,

		------------------------------------
		--- Determine if the EditBox performs password masking
		-- @name EditBox:IsPassword
		-- @class function
		-- @return true if the EditBox performs password masking
		-- @usage EditBox:IsPassword()
		------------------------------------

		-- IsPassword
		["IsPassword"] = function(self, ...)
			return self.__UI:IsPassword(...)
		end,

		------------------------------------
		--- Make only alt+arrow keys work for navigating the edit box, not arrow keys alone.
		-- @name EditBox:SetAltArrowKeyMode
		-- @class function
		-- @param enable True to cause the edit box to ignore arrow key presses unless the Alt key is held; false to allow unmodified arrow key presses for cursor movement
		-- @usage EditBox:SetAltArrowKeyMode(true)
		------------------------------------

		-- SetAltArrowKeyMode
		["SetAltArrowKeyMode"] = function(self, ...)
			return self.__UI:SetAltArrowKeyMode(...)
		end,

		------------------------------------
		--- Set whether or not the editbox will attempt to get input focus when it gets shown (default: true)
		-- @name EditBox:SetAutoFocus
		-- @class function
		-- @param enable True to enable the edit box to automatically acquire keyboard input focus; false to disable
		-- @usage EditBox:SetAutoFocus()
		------------------------------------

		-- SetAutoFocus
		["SetAutoFocus"] = function(self, ...)
			return self.__UI:SetAutoFocus(...)
		end,

		------------------------------------
		--- Sets the rate at which the text insertion blinks when the edit box is focused
		-- @name EditBox:SetBlinkSpeed
		-- @class function
		-- @param duration Amount of time for which the cursor is visible during each "blink" (in seconds)
		-- @usage EditBox:SetBlinkSpeed(2)
		------------------------------------

		-- SetBlinkSpeed
		["SetBlinkSpeed"] = function(self, ...)
			return self.__UI:SetBlinkSpeed(...)
		end,

		------------------------------------
		--- Set the position of the cursor within the EditBox
		-- @name EditBox:SetCursorPosition
		-- @class function
		-- @param position New position for the keyboard input cursor (between 0, for the position before the first character, and editbox:GetNumLetters(), for the position after the last character)
		-- @usage EditBox:SetCursorPosition(123)
		------------------------------------

		-- SetCursorPosition
		["SetCursorPosition"] = function(self, ...)
			return self.__UI:SetCursorPosition(...)
		end,

		------------------------------------
		--- Move input focus (the cursor) to this editbox
		-- @name EditBox:SetFocus
		-- @class function
		-- @usage EditBox:SetFocus()
		------------------------------------

		-- SetFocus
		["SetFocus"] = function(self, ...)
			return self.__UI:SetFocus(...)
		end,

		------------------------------------
		--- Sets the maximum number of history lines stored by the edit box
		-- @name EditBox:SetHistoryLines
		-- @class function
		-- @param count Maximum number of history lines to be stored by the edit box
		-- @usage EditBox:SetHistoryLines(12)
		------------------------------------

		-- SetHistoryLines
		["SetHistoryLines"] = function(self, ...)
			return self.__UI:SetHistoryLines(...)
		end,

		------------------------------------
		--- Sets the maximum number of bytes of text allowed in the edit box
		-- @name EditBox:SetMaxBytes
		-- @class function
		-- @param maxBytes Maximum number of text bytes allowed in the edit box, or 0 for no limit
		-- @usage EditBox:SetMaxBytes(1024)
		------------------------------------

		-- SetMaxBytes
		["SetMaxBytes"] = function(self, ...)
			return self.__UI:SetMaxBytes(...)
		end,

		------------------------------------
		--- Sets the maximum number of text characters allowed in the edit box
		-- @name EditBox:SetMaxLetters
		-- @class function
		-- @param maxLetters Maximum number of text characters allowed in the edit box, or 0 for no limit
		-- @usage EditBox:SetMaxLetters(1024)
		------------------------------------

		-- SetMaxLetters
		["SetMaxLetters"] = function(self, ...)
			return self.__UI:SetMaxLetters(...)
		end,

		------------------------------------
		--- Sets whether the edit box shows more than one line of text
		-- @name EditBox:SetMultiLine
		-- @class function
		-- @param multiLine True to allow the edit box to display more than one line of text; false for single-line display
		-- @usage EditBox:SetMultiLine(true)
		------------------------------------

		-- SetMultiLine
		["SetMultiLine"] = function(self, ...)
			return self.__UI:SetMultiLine(...)
		end,

		------------------------------------
		--- Sets the contents of the edit box to a number
		-- @name EditBox:SetNumber
		-- @class function
		-- @param num New numeric content for the edit box
		-- @usage EditBox:SetNumber(1234)
		------------------------------------

		-- SetNumber
		["SetNumber"] = function(self, ...)
			return self.__UI:SetNumber(...)
		end,

		------------------------------------
		--- Sets whether the edit box only accepts numeric input
		-- @name EditBox:SetNumeric
		-- @class function
		-- @param enable True to allow only numeric input; false to allow any text
		-- @usage EditBox:SetNumeric(false)
		------------------------------------

		-- SetNumeric
		["SetNumeric"] = function(self, ...)
			return self.__UI:SetNumeric(...)
		end,

		------------------------------------
		--- Sets whether the text entered in the edit box is masked
		-- @name EditBox:SetPassword
		-- @class function
		-- @param enable True to mask text entered in the edit box with asterisk characters (*); false to show the actual text entered
		-- @usage EditBox:SetPassword(false)
		------------------------------------

		-- SetPassword
		["SetPassword"] = function(self, ...)
			return self.__UI:SetPassword(...)
		end,

		------------------------------------
		--- Sets the edit box's text contents
		-- @name EditBox:SetText
		-- @class function
		-- @param text Text to be placed in the edit box
		-- @usage EditBox:SetText("Hello World")
		------------------------------------

		-- SetText
		["SetText"] = function(self, ...)
			return self.__UI:SetText(...)
		end,

		------------------------------------
		--- Sets the insets from the edit box's edges which determine its interactive text area
		-- @name EditBox:SetTextInsets
		-- @class function
		-- @param left Distance from the left edge of the edit box to the left edge of its interactive text area (in pixels)
		-- @param right Distance from the right edge of the edit box to the right edge of its interactive text area (in pixels)
		-- @param top Distance from the top edge of the edit box to the top edge of its interactive text area (in pixels)
		-- @param bottom Distance from the bottom edge of the edit box to the bottom edge of its interactive text area (in pixels)
		-- @usage EditBox:SetTextInsets(4, 4, 6, 6)
		------------------------------------

		-- SetTextInsets
		["SetTextInsets"] = function(self, ...)
			return self.__UI:SetTextInsets(...)
		end,

		------------------------------------
		--- Switches the edit box's language input mode
		-- @name EditBox:ToggleInputLanguage
		-- @class function
		-- @usage EditBox:ToggleInputLanguage()
		------------------------------------

		-- ToggleInputLanguage
		["ToggleInputLanguage"] = function(self, ...)
			return self.__UI:ToggleInputLanguage(...)
		end,

		------------------------------------
		--- Returns whether the edit box is currently focused for keyboard input
		-- @name EditBox:HasFocus
		-- @class function
		-- @return True if the edit box is currently focused for keyboard input
		-- @usage EditBox:HasFocus()
		------------------------------------

		-- HasFocus
		["HasFocus"] = function(self, ...)
			return self.__UI:HasFocus(...)
		end,
    }

	-- Property
	local _Property = {
        -- MultiLine
        ["MultiLine"] = {
			["Set"] = function(self, state)
				self.__UI:SetMultiLine(state)
			end,

			["Get"] = function(self)
				return (self.__UI:IsMultiLine() and true) or false
			end,

			["Type"] = "boolean",
		},

        -- NumericOnly
        ["NumericOnly"] = {
			["Set"] = function(self, state)
				self.__UI:SetNumeric(state)
			end,

			["Get"] = function(self)
				return (self.__UI:IsNumeric() and true) or false
			end,

			["Type"] = "boolean",
		},

        -- Password
        ["Password"] = {
			["Set"] = function(self, state)
				self.__UI:SetPassword(state)
			end,

			["Get"] = function(self)
				return (self.__UI:IsPassword() and true) or false
			end,

			["Type"] = "boolean",
		},

        -- AutoFocus
        ["AutoFocus"] = {
			["Set"] = function(self, state)
				self.__UI:SetAutoFocus(state)
			end,

			["Get"] = function(self)
				return (self.__UI:IsAutoFocus() and true) or false
			end,

			["Type"] = "boolean",
		},

        -- HistoryLines
        ["HistoryLines"] = {
			["Set"] = function(self, num)
				self.__UI:SetHistoryLines(num)
			end,

			["Get"] = function(self)
				return self.__UI:GetHistoryLines()
			end,

			["Type"] = "number",
		},

        -- Focus
        ["Focused"] = {
			["Set"] = function(self, focus)
				if focus then
					self.__UI:SetFocus()
				else
					self.__UI:ClearFocus()
				end
			end,

			["Get"] = function(self)
				return (self.__UI:HasFocus() and true) or false
			end,

			["Type"] = "boolean",
		},

        -- AltArrowKeyMode
        ["AltArrowKeyMode"] = {
			["Set"] = function(self, enable)
				self.__UI:SetAltArrowKeyMode(enable)
			end,

			["Get"] = function(self)
				return (self.__UI:GetAltArrowKeyMode() and true) or false
			end,

			["Type"] = "boolean",
		},

        -- BlinkSpeed
        ["BlinkSpeed"] = {
			["Set"] = function(self, speed)
				self.__UI:SetBlinkSpeed(speed)
			end,

			["Get"] = function(self)
				return self.__UI:GetBlinkSpeed()
			end,

			["Type"] = "number",
		},

        -- CursorPosition
        ["CursorPosition"] = {
			["Set"] = function(self, position)
				self.__UI:SetCursorPosition(position)
			end,

			["Get"] = function(self)
				return self.__UI:GetCursorPosition()
			end,

			["Type"] = "number",
		},

        -- MaxBytes
        ["MaxBytes"] = {
			["Set"] = function(self, maxBytes)
				self.__UI:SetMaxBytes(maxBytes)
			end,

			["Get"] = function(self)
				return self.__UI:GetMaxBytes()
			end,

			["Type"] = "number",
		},

        -- MaxLetters
        ["MaxLetters"] = {
			["Set"] = function(self, maxLetters)
				self.__UI:SetMaxLetters(maxLetters)
			end,

			["Get"] = function(self)
				return self.__UI:GetMaxLetters()
			end,

			["Type"] = "number",
		},

        -- Number
        ["Number"] = {
			["Set"] = function(self, number)
				self.__UI:SetNumber(number)
			end,

			["Get"] = function(self)
				return self.__UI:GetNumber()
			end,

			["Type"] = "number",
		},

        -- Text
        ["Text"] = {
			["Set"] = function(self, text)
				self.__UI:SetText(text)
			end,

			["Get"] = function(self)
				return self.__UI:GetText()
			end,

			["Type"] = "string",
		},

		-- TextInsets
		["TextInsets"] = {
			["Set"] = function(self, RectInset)
				self.__UI:SetTextInsets(RectInset.left, RectInset.right, RectInset.top, RectInset.bottom)
			end,

			["Get"] = function(self)
				local RectInset = {}
				RectInset.left, RectInset.right, RectInset.top, RectInset.bottom = self.__UI:GetTextInsets()
				return RectInset
			end,

			["Type"] = "RectInset",
		},

        -- Editable
        ["Editable"] = {
			["Set"] = function(self, flag)
				self.MouseEnabled = flag
				if not flag then
					self.AutoFocus = false
					if self:HasFocus() then
						self:ClearFocus()
					end
				end
			end,

			["Get"] = function(self)
				return self.MouseEnabled
			end,

			["Type"] = "boolean",
        },
    }

    -- New
    local _New = function(_parent,inheritFrame)
        -- New Frame
		return CreateFrame(_WidgetName,nil,IGAS:GetUI(_parent),inheritFrame)
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true, true)
end