﻿-- Author      : Kurapica
-- Create Date : 7/16/2008 15:10

----------------------------------------------------------------------------------------------------------------------------------------
--- The DressUpModel type was added to provide support for the "dressing room" functionality when it was introduced. This model can be set to a particular unit, and then given different pieces of gear to display on that unit with the TryOn function. It also provides an Undress feature which can be used to view how your character's gear will look without concealing articles such as a cloak or tabard that you might be wearing.
-- <br><br>inherit <a href=".\PlayerModel.html">PlayerModel</a> For all methods, properties and scriptTypes
-- @name DressUpModel
-- @class table
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.DressUpModel", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "DressUpModel"
    local _Base = "PlayerModel"

	-- ScriptType
	local _ScriptType = {
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Set the model to reflect the character's current inventory.
		-- @name DressUpModel:Dress
		-- @class function
		-- @usage DressUpModel:Dress()
		------------------------------------

		-- Dress
		["Dress"] = function(self, ...)
			return self.__UI:Dress(...)
		end,

		------------------------------------
		--- Add the specified item to the model.
		-- @name DressUpModel:TryOn
		-- @class function
		-- @param item An item's ID or An item's name or An item's hyperlink, or any string containing the itemString  portion of an item link
		-- @usage DressUpModel:TryOn(43211)
		------------------------------------

		-- TryOn
		["TryOn"] = function(self, ...)
			return self.__UI:TryOn(...)
		end,

		------------------------------------
		--- Set the model to reflect the character without inventory.
		-- @name DressUpModel:Undress
		-- @class function
		-- @usage DressUpModel:Undress()
		------------------------------------

		-- Undress
		["Undress"] = function(self, ...)
			return self.__UI:Undress(...)
		end,
    }

	-- Property
	local _Property = {
	}

    -- New
    local _New = function(_parent,inheritFrame)
        -- New Frame
		return CreateFrame(_WidgetName,nil,IGAS:GetUI(_parent),inheritFrame)
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true, true)
end