﻿-- Author      : Kurapica
-- Create Date : 7/16/2008 11:05

----------------------------------------------------------------------------------------------------------------------------------------
--- Cooldown is a specialized variety of Frame that displays the little "clock" effect over abilities and buffs. It can be set with its running time, whether it should appear to "fill up" or "empty out", and whether or not there should be a bright edge where it's changing between dim and bright.
-- <br><br>inherit <a href=".\Frame.html">Frame</a> For all methods, properties and scriptTypes
-- @name Cooldown
-- @class table
-- @field Reverse true if the cooldown animation "sweeps" an area of darkness over the underlying image; false if the animation darkens the underlying image and "sweeps" the darkened area away
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.Cooldown", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "Cooldown"
    local _Base = "Frame"

	-- ScriptType
	local _ScriptType = {
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Sets up the parameters for a Cooldown model
		-- @name Cooldown:SetCooldown
		-- @class function
		-- @param start Value of GetTime()  at the start of the cooldown animation
		-- @param duration Duration of the cooldown animation (excluding that of the final "flash" animation)
		-- @usage Cooldown:SetCooldown(GetTime() - 5, 10)
		------------------------------------

		-- SetCooldown
		["SetCooldown"] = function(self, ...)
			return self.__UI:SetCooldown(...)
		end,

		------------------------------------
		--- Sets whether to invert the bright and dark portions of the cooldown animation
		-- @name Cooldown:SetReverse
		-- @class function
		-- @param reverse True for an animation "sweeping" an area of darkness over the underlying image; false for the default animation of darkening the underlying image and "sweeping" the darkened area away
		-- @usage Cooldown:SetReverse(true)
		------------------------------------

		-- SetReverse
		["SetReverse"] = function(self, ...)
			return self.__UI:SetReverse(...)
		end,
    }

	-- Property
	local _Property = {
        -- Reverse
        ["Reverse"] = {
			["Set"] = function(self, enabled)
				self:SetReverse(enabled)
			end,

			["Type"] = "boolean",
		},
    }

    -- New
    local _New = function(_parent,inheritFrame)
        -- New Frame
		return CreateFrame(_WidgetName,nil,IGAS:GetUI(_parent),inheritFrame)
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true, true)
end