﻿-- Author      : Kurapica
-- Create Date : 7/16/2008 11:15

----------------------------------------------------------------------------------------------------------------------------------------
--- ColorSelect is a very specialized type of frame with a specific purpose; to allow the user to interactively select a color, typically to control the appearance of another UI element.
-- <br><br>inherit <a href=".\Frame.html">Frame</a> For all methods, properties and scriptTypes
-- @name ColorSelect
-- @class table
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.ColorSelect", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "ColorSelect"
    local _Base = "Frame"

	-- ScriptType
	local _ScriptType = {
		------------------------------------
		--- ScriptType, Run when the color select frame's color selection changes
		-- @name ColorSelect:OnColorSelect
		-- @class function
		-- @param r Red component of the selected color (0.0 - 1.0)
		-- @param g Green component of the selected color (0.0 - 1.0)
		-- @param b Blue component of the selected color (0.0 - 1.0)
		-- @usage function ColorSelect:OnColorSelect(r, g, b)<br>
		--    -- do someting<br>
		-- end
		------------------------------------
		["OnColorSelect"] = true,
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Get the HSV values of the selected color.
		-- @name ColorSelect:GetColorHSV
		-- @class function
		-- @return hue Hue of the selected color (angle on the color wheel in degrees; 0 = red, increasing counter-clockwise)
		-- @return saturation Saturation of the selected color (0.0 - 1.0)
		-- @return value Value of the selected color (0.0 - 1.0)
		-- @usage ColorSelect:GetColorHSV()
		------------------------------------

		-- GetColorHSV
		["GetColorHSV"] = function(self, ...)
			return self.__UI:GetColorHSV(...)
		end,

		------------------------------------
		--- Get the RGB values of the selected color.
		-- @name ColorSelect:GetColorRGB
		-- @class function
		-- @return red Red component of the color (0.0 - 1.0)
		-- @return blue Blue component of the color (0.0 - 1.0)
		-- @return green Green component of the color (0.0 - 1.0)
		-- @usage ColorSelect:GetColorRGB()
		------------------------------------

		-- GetColorRGB
		["GetColorRGB"] = function(self, ...)
			return self.__UI:GetColorRGB(...)
		end,

		------------------------------------
		--- Get the texture used to show color value
		-- @name ColorSelect:GetColorValueTexture
		-- @class function
		-- @return texture Reference to the Texture object used for drawing the value slider background
		-- @usage ColorSelect:GetColorValueTexture()
		------------------------------------

		-- GetColorValueTexture
		["GetColorValueTexture"] = function(self, ...)
			return IGAS:GetWrapper(self.__UI:GetColorValueTexture(...))
		end,

		------------------------------------
		--- Get the texture for the color value thumb
		-- @name ColorSelect:GetColorValueThumbTexture
		-- @class function
		-- @return texture Reference to the Texture object used for drawing the slider thumb
		-- @usage ColorSelect:GetColorValueThumbTexture()
		------------------------------------

		-- GetColorValueThumbTexture
		["GetColorValueThumbTexture"] = function(self, ...)
			return IGAS:GetWrapper(self.__UI:GetColorValueThumbTexture(...))
		end,

		------------------------------------
		--- Get the texture for the color wheel
		-- @name ColorSelect:GetColorWheelTexture
		-- @class function
		-- @return texture Reference to the Texture object used for drawing the hue/saturation wheel
		-- @usage ColorSelect:GetColorWheelTexture()
		------------------------------------

		-- GetColorWheelTexture
		["GetColorWheelTexture"] = function(self, ...)
			return IGAS:GetWrapper(self.__UI:GetColorWheelTexture(...))
		end,

		------------------------------------
		--- Get the texture for the color wheel thumb
		-- @name ColorSelect:GetColorWheelThumbTexture
		-- @class function
		-- @return texture Reference to the Texture object used for drawing the hue/saturation wheel's selection indicator
		-- @usage ColorSelect:GetColorWheelThumbTexture()
		------------------------------------

		-- GetColorWheelThumbTexture
		["GetColorWheelThumbTexture"] = function(self, ...)
			return IGAS:GetWrapper(self.__UI:GetColorWheelThumbTexture(...))
		end,

		------------------------------------
		--- Set to a specific HSV color.
		-- @name ColorSelect:SetColorHSV
		-- @class function
		-- @param hue Hue of a color (angle on the color wheel in degrees; 0 = red, increasing counter-clockwise)
		-- @param saturation Saturation of a color (0.0 - 1.0)
		-- @param value Value of a color (0.0 - 1.0)
		-- @usage ColorSelect:SetColorHSV(0, 0.5, 04)
		------------------------------------

		-- SetColorHSV
		["SetColorHSV"] = function(self, ...)
			return self.__UI:SetColorHSV(...)
		end,

		------------------------------------
		--- Set to a specific RGB color.
		-- @name ColorSelect:SetColorRGB
		-- @class function
		-- @param red Red component of a color (0.0 - 1.0)
		-- @param blue Blue component of a color (0.0 - 1.0)
		-- @param green Green component of a color (0.0 - 1.0)
		-- @usage ColorSelect:SetColorRGB(0.4, 0.5, 0.6)
		------------------------------------

		-- SetColorRGB
		["SetColorRGB"] = function(self, ...)
			return self.__UI:SetColorRGB(...)
		end,

		------------------------------------
		--- Set the texture used to show color value
		-- @name ColorSelect:SetColorValueTexture
		-- @class function
		-- @param texture Optional,Reference to the Texture object used for drawing the value slider background
		-- @usage ColorSelect:SetColorValueTexture(nil)
		------------------------------------

		-- SetColorValueTexture
		["SetColorValueTexture"] = function(self, texture, ...)
			return self.__UI:SetColorValueTexture(IGAS:GetUI(texture), ...)
		end,

		------------------------------------
		--- Set the texture for the color value thumb
		-- @name ColorSelect:SetColorValueThumbTexture
		-- @class function
		-- @param texture Optional,Reference to the Texture object used for drawing the slider thumb
		-- @usage ColorSelect:SetColorValueThumbTexture()
		------------------------------------

		-- SetColorValueThumbTexture
		["SetColorValueThumbTexture"] = function(self, texture, ...)
			return self.__UI:SetColorValueThumbTexture(IGAS:GetUI(texture), ...)
		end,

		------------------------------------
		--- Set the texture for the color wheel
		-- @name ColorSelect:SetColorWheelTexture
		-- @class function
		-- @param texture Optional,Reference to the Texture object used for drawing the hue/saturation wheel
		-- @usage ColorSelect:SetColorWheelTexture()
		------------------------------------

		-- SetColorWheelTexture
		["SetColorWheelTexture"] = function(self, texture, ...)
			return self.__UI:SetColorWheelTexture(IGAS:GetUI(texture), ...)
		end,

		------------------------------------
		--- Set the texture for the color wheel thumb
		-- @name ColorSelect:SetColorWheelThumbTexture
		-- @class function
		-- @param texture Optional,Reference to the Texture object used for drawing the hue/saturation wheel's selection indicator
		-- @usage ColorSelect:SetColorWheelThumbTexture()
		------------------------------------

		-- SetColorWheelThumbTexture
		["SetColorWheelThumbTexture"] = function(self, texture, ...)
			return self.__UI:SetColorWheelThumbTexture(IGAS:GetUI(texture), ...)
		end,
    }

	-- Property
	local _Property = {
	}

    -- New
    local _New = function(_parent,inheritFrame)
        -- New Frame
		return CreateFrame(_WidgetName,nil,IGAS:GetUI(_parent),inheritFrame)
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

    IGAS:NewWidget(_WidgetInfo, true, true)
end