﻿-- Author      : Kurapica
-- Create Date : 8/18/2009

----------------------------------------------------------------------------------------------------------------------------------------
--- Alpha is a type of animation that automatically changes the transparency level of its attached region as it progresses. You can set the degree by which it will change the alpha as a fraction; for instance, a change of -1 will fade out a region completely
-- <br><br>inherit <a href=".\Animation.html">Animation</a> For all methods, properties and scriptTypes
-- @name Alpha
-- @class table
-- @field Change Property, number, the animation's amount of alpha (opacity) change
----------------------------------------------------------------------------------------------------------------------------------------
do
	-- Check Version
	local version = 2
	if not IGAS:NewAddon("IGAS.GUI.Alpha", version) then
		return
	end

    local CreateFrame = CreateFrame

	local _WidgetName = "Alpha"
    local _Base = "Animation"

	-- ScriptType
	local _ScriptType = {
	}

	-- FuncProxy
	local _FuncProxy = {
		------------------------------------
		--- Sets the amount that the alpha value of this animation's parent Region changes by.
		-- @name Alpha:SetChange
		-- @class function
		-- @param change Amount by which the region's alpha value should change over the animation's duration (between -1 and 1)
		-- @usage Alpha:SetChange(0.5)
		------------------------------------

		-- SetChange
		["SetChange"] = function(self, change)
			return self.__UI:SetChange(change)
		end,

		------------------------------------
		--- Gets the amount that the alpha value of this animation's parent Region changes by.
		-- @name Alpha:GetChange
		-- @class function
		-- @return Amount by which the region's alpha value should change over the animation's duration (between -1 and 1)
		-- @usage Alpha:GetChange()
		------------------------------------

		-- GetChange
		["GetChange"] = function(self)
			return self.__UI:GetChange()
		end,
	}

	-- Property
	local _Property = {
        -- Change
        ["Change"] = {
			["Set"] = function(self, change)
				self:SetChange(change)
			end,

			["Get"] = function(self)
				return self:GetChange()
			end,

			["Type"] = "number",
		},
	}

    -- New
    local _New = function(_parent,inheritsFrom)
		if _parent and _parent["CreateAnimation"] then
			return IGAS:GetUI(_parent):CreateAnimation(_WidgetName, nil, inheritsFrom)
		end
    end

    local _WidgetInfo = {
        ["WidgetName"] = _WidgetName,
        ["Base"] = _Base,
        ["FuncProxy"] = _FuncProxy,
        ["Property"] = _Property,
        ["ScriptType"] = _ScriptType,
        ["New"] = _New,
    }

	local _ScanFrameParent = IGAS:NewFrame("AnimationGroup")

    IGAS:NewWidget(_WidgetInfo, true, true, _ScanFrameParent)

	_ScanFrameParent:Dispose()
end