﻿-- Author      : Kurapica
-- Create Date : 6/12/2008 1:10:38 AM

-- Enum
do
	local version = 1

	if not IGAS:NewAddon("IGAS.GUI.Enum", version) then
		return
	end

	local wipe = table.wipe

	_Enums = _Enums or {}

	-- namespace
	IGAS.GUI.Enum = _Enums

	-- Register API

	------------------------------------
	--- create or get a new enum type
	-- @name IGAS:NewEnum
	-- @class function
	-- @param enumName the name of the enum
	-- @param enums a table contains a list of string
	-- @return the enum type
	-- @usage IGAS:NewEnum("Style", {"NORMAL", "GRAY", "CLOSE", "HIT"})
	------------------------------------
	IGAS:RegisterFunction("NewEnum", function(self, enumName, enums)
		if enumName and type(enumName) == "string" and enumName ~= "" and enums and type(enums) == "table" and next(enums) then
			-- if exists, rewrite it, not make a new table
			_Enums[enumName] = _Enums[enumName] or {}
			wipe(_Enums[enumName])

			for _, v in pairs(enums) do
				if v and type(v) == "string" then
					_Enums[enumName][v] = v
				end
			end
		end
		return (enumName and _Enums[enumName]) or nil
	end)

	------------------------------------
	--- get a enum type
	-- @name IGAS:GetEnum
	-- @class function
	-- @param enumName the name of the enum
	-- @return the enum type
	-- @usage IGAS:GetEnum("Style")
	------------------------------------
	IGAS:RegisterFunction("GetEnum", function(self, enumName)
		return (enumName and _Enums[enumName]) or nil
	end)

	-- Default
	-- ScriptType
	IGAS:NewEnum("ScriptType", {
		"OnAttributeChanged",
		"OnSizeChanged",
		"OnEvent",
		"OnUpdate",
		"OnShow",
		"OnHide",
		"OnEnter",
		"OnLeave",
		"OnMouseDown",
		"OnMouseUp",
		"OnMouseWheel",
		"OnJoystickStickMotion",
		"OnJoystickAxisMotion",
		"OnJoystickButtonDown",
		"OnJoystickButtonUp",
		"OnJoystickHatMotion",
		"OnDragStart",
		"OnDragStop",
		"OnReceiveDrag",
		"PreClick",
		"OnClick",
		"PostClick",
		"OnDoubleClick",
		"OnValueChanged",
		"OnUpdateModel",
		"OnAnimFinished",
		"OnEnterPressed",
		"OnEscapePressed",
		"OnSpacePressed",
		"OnTabPressed",
		"OnTextChanged",
		"OnTextSet",
		"OnCursorChanged",
		"OnInputLanguageChanged",
		"OnEditFocusGained",
		"OnEditFocusLost",
		"OnHorizontalScroll",
		"OnVerticalScroll",
		"OnScrollRangeChanged",
		"OnCharComposition",
		"OnChar",
		"OnKeyDown",
		"OnKeyUp",
		"OnColorSelect",
		"OnHyperlinkEnter",
		"OnHyperlinkLeave",
		"OnHyperlinkClick",
		"OnMessageScrollChanged",
		"OnMovieFinished",
		"OnMovieShowSubtitle",
		"OnMovieHideSubtitle",
		"OnTooltipSetDefaultAnchor",
		"OnTooltipCleared",
		"OnTooltipAddMoney",
		"OnTooltipSetUnit",
		"OnTooltipSetItem",
		"OnTooltipSetSpell",
		"OnTooltipSetQuest",
		"OnTooltipSetAchievement",
		"OnLoad",
		"OnPlay",
		"OnPause",
		"OnStop",
		"OnUpdate",
		"OnFinished",
	})
	--- OutLineType
	IGAS:NewEnum("OutLineType", {
		"NONE",
		"NORMAL",
		"THICK",
	})
	--- FrameStrata
	IGAS:NewEnum("FrameStrata", {
		"PARENT",
		"BACKGROUND",
		"LOW",
		"MEDIUM",
		"HIGH",
		"DIALOG",
		"FULLSCREEN",
		"FULLSCREEN_DIALOG",
		"TOOLTIP",
	})
	--- JustifyH
	IGAS:NewEnum("JustifyHType", {
		"LEFT",
		"CENTER",
		"RIGHT",
	})
	--- JustifyV
	IGAS:NewEnum("JustifyVType", {
		"TOP",
		"MIDDLE",
		"BOTTOM",
	})
	--- FramePoint
	IGAS:NewEnum("FramePoint", {
		"CENTER",
		"TOP",
		"BOTTOM",
		"LEFT",
		"RIGHT",
		"TOPLEFT",
		"TOPRIGHT",
		"BOTTOMLEFT",
		"BOTTOMRIGHT",
	})
	--- DrawLayer
	IGAS:NewEnum("DrawLayer", {
		"BACKGROUND", 			-- Level 0. Place the background of your frame here.
		"BORDER",		 			-- Level 1. Place the artwork of your frame here .
		"ARTWORK", 				-- Level 2. Place the artwork of your frame here.
		"OVERLAY", 				-- Level 3. Place your text, objects, and buttons in this level.
		"HIGHLIGHT", 			-- Level 4. Place your text, objects, and buttons in this level.
	})
	--- AlphaMode
	IGAS:NewEnum("AlphaMode", {
		"DISABLE",				-- opaque texture
		"BLEND",					-- normal painting on top of the background, obeying alpha channels if present in the image (uses alpha)
		"ALPHAKEY",				-- one-bit alpha
		"ADD",						-- additive blend
		"MOD",						-- modulating blend
	})
	--- ButtonState
	IGAS:NewEnum("ButtonState", {
		"PUSHED",
		"NORMAL",
	})
	--- InsertMode
	IGAS:NewEnum("InsertMode", {
		"TOP",
		"BOTTOM",
	})
	--- Orientation
	IGAS:NewEnum("Orientation", {
		"HORIZONTAL",
		"VERTICAL",
	})
	-- Anchor
	IGAS:NewEnum("Anchor", {
		"ANCHOR_TOPRIGHT",
		"ANCHOR_RIGHT",
		"ANCHOR_BOTTOMRIGHT",
		"ANCHOR_TOPLEFT",
		"ANCHOR_LEFT",
		"ANCHOR_BOTTOMLEFT",
		"ANCHOR_CURSOR",
		"ANCHOR_PRESERVE",
		"ANCHOR_NONE",
	})
end