﻿-- Author      : Kurapica
-- Create Date : 6/27/2008

do
	local version = 1

	------------------------------------------------------
	-- Version Check
	------------------------------------------------------
	local _Pool = (IGAS and getmetatable(IGAS).__Pool) or {}
	if _Pool.IGAS_BASE_VERSION and _Pool.IGAS_BASE_VERSION >= version then
		return
	end
	_Pool.IGAS_BASE_VERSION = version

	------------------------------------------------------
	-- Main Trunk
	------------------------------------------------------

	------------------------------------
	--- Register a function to IGAS
	-- @name IGAS:RegisterFunction
	-- @class function
	-- @param name the function name
	-- @param func the function
	-- @return nil
	-- @usage IGAS:RegisterFunction("Print", function(self, ...) print(...) end)  -- then can use IGAS:Print("Hello World")
	------------------------------------
	_Pool["RegisterFunction"] = function(self, name, func)
		assert(name and func and type(name)=="string" and type(func)=="function")

		-- No need to store functions in _Pool, _Pool is used to store tables and variables
		rawset(self, name, func)
	end

	------------------------------------------------------
	-- Naming Space
	------------------------------------------------------
	IGAS = setmetatable(IGAS or {}, {
		__index = function(_table, _key)
			return _Pool[_key]
		end,

		__newindex = function(_table,_key,_value)
            if _key == "RegisterFunction" or _key == "NewEnv" then
			    error("This key is read-only", 2)
            end

            rawset(_Pool,_key,_value)
		end,

		-- such as IGAS("NewAddon", "MyAddon1") instead of IGAS:NewAddon("MyAddon1"), IGAS("NewFrame", "Form", "TestForm") instead of IGAS:NewFrame("Form", "TestForm"). etc
		-- special using: if the fist arg is not a method of IGAS, it will using "GetAddon" to handle the args.so IGAS("MyAddon") instead of IGAS:GetAddon("MyAddon")
		__call = function(_table, func, ...)
			if _table[func] and type(_table[func]) == "function" then
				return _table[func](_table, ...)
			elseif _table.GetAddon then
				return _table:GetAddon(func)
			end
		end,

		__Pool = _Pool,
	})
end
