﻿-- Author  : Kurapica
-- Create Date : 2009/11/16

do
	-- Check Version
	local version = 2

	------------------------------------------------------
	-- Version Check
	------------------------------------------------------
	local _G = _G
	local rawset = rawset
	local rawget = rawget
	local setfenv = setfenv
	
	IGAS.__CSTMEVT_ENV = IGAS.__CSTMEVT_ENV or setmetatable({}, {
		__index = function(self, key)
			if _G[key] then
				rawset(self, key, _G[key])
				
				return rawget(self, key)
			end
		end,
	})	
	setfenv(1, IGAS.__CSTMEVT_ENV)
	
	if IGAS_CSTMEVT_VERSION and IGAS_CSTMEVT_VERSION >= version then
		return
	end
	IGAS_CSTMEVT_VERSION = version

	------------------------------------------------------
	-- Main Trunk
	------------------------------------------------------
	local function errorhandler(err)
		return geterrorhandler()(err)
	end

	-- Custom Event System
	_CstmEvtDistrbt = _CstmEvtDistrbt or {}
	_CstmEvtSource = _CstmEvtSource or {}

	-- Weak Table
	local _meta = {__mode = "k"}

	-- Register API

	------------------------------------
	--- Register a custom event for an object
	-- @name IGAS:RegisterCustomEvent
	-- @class function
	-- @param object must be a table, can be a IGAS's frame
	-- @param event the event's name, must not be a system event's name
	-- @return nil
	-- @usage IGAS:RegisterCustomEvent(MyFrame1, "CUSTOM_EVENT_1")
	------------------------------------
	IGAS:RegisterFunction("RegisterCustomEvent", function(self, frame, event)
		if frame and type(frame) == "table" and event and type(event) == "string" and event ~= "" then
			_CstmEvtDistrbt[event] = _CstmEvtDistrbt[event] or setmetatable({}, _meta)

			_CstmEvtDistrbt[event][frame] = true
		end
	end)

	------------------------------------
	--- Check if  a custom event is registered for an object
	-- @name IGAS:IsCustomEventRegistered
	-- @class function
	-- @param object must be a table, can be a IGAS's frame
	-- @param event the event's name, must not be a system event's name
	-- @return true if the event is registered to that object
	-- @usage IGAS:IsCustomEventRegistered(MyFrame1, "CUSTOM_EVENT_1")
	------------------------------------
	IGAS:RegisterFunction("IsCustomEventRegistered", function(self, frame, event)
		if frame and type(frame) == "table" and event and type(event) == "string" and event ~= "" then
			return (_CstmEvtDistrbt[event] and _CstmEvtDistrbt[event][frame] and true) or false
		else
			return false
		end
	end)

	------------------------------------
	--- Undo register all events for the object
	-- @name IGAS:UnregisterAllCustomEvents
	-- @class function
	-- @param object must be a table, can be a IGAS's frame
	-- @return nil
	-- @usage IGAS:UnregisterAllCustomEvents(MyFrame1)
	------------------------------------
	IGAS:RegisterFunction("UnregisterAllCustomEvents", function(self, frame)
		if frame and type(frame) == "table" and event and type(event) == "string" and event ~= "" then
			for _, s in pairs(_CstmEvtDistrbt) do
				s[frame] = nil
			end
		end
	end)

	------------------------------------
	--- Undo Register a custom event for an object
	-- @name IGAS:UnregisterCustomEvent
	-- @class function
	-- @param object must be a table, can be a IGAS's frame
	-- @param event the event's name, must not be a system event's name
	-- @return nil
	-- @usage IGAS:UnregisterCustomEvent(MyFrame1, "CUSTOM_EVENT_1")
	------------------------------------
	IGAS:RegisterFunction("UnregisterCustomEvent", function(self, frame, event)
		if frame and type(frame) == "table" and event and type(event) == "string" and event ~= "" then
			if _CstmEvtDistrbt[event] then
				_CstmEvtDistrbt[event][frame] = nil
			end
		end
	end)

	------------------------------------
	--- Fire a custom event
	-- @name IGAS:FireCustomEvent
	-- @class function
	-- @param object must be a table, can be a IGAS's frame, the source of the event
	-- @param event the event's name, must not be a system event's name
	-- @param ... the parameters for the event
	-- @return nil
	-- @usage IGAS:FireCustomEvent(MyFrame1, "CUSTOM_EVENT_1", arg1, arg2, arg3, ...)
	------------------------------------
	IGAS:RegisterFunction("FireCustomEvent", function(self, frame, event, ...)
		local chk, ret

		if not frame or type(frame) ~= "table" or not event or type(event) ~= "string" or event == "" then
			return
		end

		if _CstmEvtSource[event] then
			-- On time one event can only have one source,
			return
		end

		-- Set the event's source
		_CstmEvtSource[event] = frame

		if _CstmEvtDistrbt[event] then
			for v in pairs(_CstmEvtDistrbt[event]) do
				if v.Fire and type(v.Fire) == "function" then
					chk, ret = pcall(v.Fire, v, "OnEvent", event, ...)
					if not chk then
						errorhandler(ret)
					end
				elseif v[event] and type(v[event]) == "function" then
					chk, ret = pcall(v[event], v, event, ...)
					if not chk then
						errorhandler(ret)
					end
				end
			end
		end

		-- Finish, clear the event's source
		_CstmEvtSource[event] = nil
	end)
end