﻿--[[-------------------------------------------------------------------------------------------------
Debug Frame Script
--]]-------------------------------------------------------------------------------------------------
do
	-- Addon Initialize
	IGAS:NewAddon("Cube.Mdl_Cube_Debug")

    local OnToggle
    local index = 0
    local selectNode

    local function Format(i, v)
        local value = ""

        if v and type(v) == "userdata" then
            return tostring(i), tostring(i)
        end

        if i == nil then
			return "", ""
		elseif type(i) == "string" then
            value = string.format("%q", i)
		else
			value = tostring(i)
		end

        if v and type(v) == "table" and getmetatable(v) then
            return "\124cff1eff00[M]\124h\124r"..value, value
        else
            return value, value
        end
    end

	local function GeteTextByValue(...)
		local value, e

		if select('#', ...) == 0 then
			return ""
		end

		value = ""
		for i = 1, select('#', ...) do
			e = select(i, ...)
			if e and type(e) == "string" then
				if value == "" then
					value = e
				else
					value = value.."["..e.."]"
				end
			end
		end

		return value
	end

	local function GetLastWord(...)
		local e

		if select('#', ...) == 0 then
			return ""
		end

		e = select(select('#', ...), ...)

		return e or ""
	end

	local function GetTextByNode(node, last)
		if not last then
			return GeteTextByValue(node:GetValue())
		else
			return GetLastWord(node:GetValue())
		end
	end

    local function GetModValue()
        local code = "return "..(txtValue.Text or "")

        local func, err
        local t

        func, err = loadstring(code)
        if func then
            return func()
        end
    end

    local function UpdateType(node)
        local v = node.BaseValue

        selectNode = node

        txtValue:ClearFocus()
		txtIn.Text = GetTextByNode(node)
        if v == nil then
            txtValue.Visible = false
            btnCommit.Visible = false
        elseif type(v) == "table" then
            txtValue.Visible = true
            txtValue.MouseEnabled = false
            btnCommit.Visible = false
            txtValue.Text = Format(v)
        elseif type(v) == "string" then
            txtValue.Visible = true
            txtValue.MouseEnabled = true
            btnCommit.Visible = true
            txtValue.Text = Format(v)
        elseif type(v) == "number" then
            txtValue.Visible = true
            txtValue.MouseEnabled = true
            btnCommit.Visible = true
            txtValue.Text = Format(v)
        elseif type(v) == "boolean" then
            txtValue.Visible = true
            txtValue.MouseEnabled = true
            btnCommit.Visible = true
            txtValue.Text = Format(v)
        elseif type(v) == "function" then
            txtValue.Visible = true
            txtValue.MouseEnabled = false
            btnCommit.Visible = false
            txtValue.Text = Format(v)
		elseif type(v) == "userdata" then
            txtValue.Visible = true
            txtValue.MouseEnabled = false
            btnCommit.Visible = false
            txtValue.Text = Format(v)
        end

        if node.__Root == node.Parent then
            txtValue.MouseEnabled = false
        end
    end

	local function UpdateChild(node)
		local chNode, text, value
		if node.BaseValue and type(node.BaseValue) == "table" and (not node.CanToggle) and next(node.BaseValue) and node.BaseValue ~= _G then
			for i, v in pairsByKeys(node.BaseValue) do
                text, value = Format(i, v)
				chNode = node:AddNode{["Text"] = text, ["Value"] = value,}
                if chNode then
                    chNode.Menu = Menu
                    chNode.BaseValue = v
                    chNode.BaseKey = i
                    chNode.OnToggle = OnToggle
                end
			end
		end
	end

    local function OnNodeSelected(self, ...)
        local node = self:GetNodeByValue(...)
        UpdateType(node)
    end

	OnToggle = function(self)
		if self.ToggleState == true then
			-- Update Child
			for i = 1, self.ChildNodeNum do
				UpdateChild(self:GetNode(i))
			end
		end
	end
	
    local function newView()
        index = index + 1

        local tab = tabF:AddTab("Watch"..index)
        local container = tab.Container
        local view = CreateFrame("TreeView", "View", container)
		
        view:SetPoint("TOPLEFT", container)
        container.Height = tabF.Height - 60
        view.Height = tabF.Height - 20
        view.Width = tabF.Width - 2

		view.OnNodeSelected = OnNodeSelected

        tab.Selected = true

        return view
    end

    function tabF:OnSizeChanged()
        local tabCon = self.__HeaderContainer
        local tab
        if tabCon.__TabNum and tabCon.__TabNum > 0 then
            for i = 1, tabCon.__TabNum do
                tab = tabCon:GetChild("TabButton"..i).Container
                tab.Height = self.Height - 60
                tab.View.Height = self.Height - 20
                tab.View.Width = self.Width - 2
            end
        end
    end

    function txtIn:OnEnterPressed()
        local func, err, text
        local t, view, node

        if txtIn.Text ~= "" then
            func, err = loadstring("return "..txtIn.Text)
            if func then
                t = func()
            else
                Cube_Debug.Message = L["Error Input."]
				timer.Interval = 2
            end
        end

        if t then
			txtIn:ClearFocus()
            view = newView()
            text = txtIn.Text
            if getmetatable(t) then
                text = "\124cff1eff00[M]\124h\124r"..text
            end
            node = view:AddNode{["Text"] = text, ["Value"] = txtIn.Text,}
            node.Menu = Menu
            node.BaseValue = t
            node.OnToggle = OnToggle
			UpdateChild(node)
            node:Select()
        end
    end

	function timer:OnTimer()
		self.Parent.Message = ""
		self.Interval = 0
	end

    function Cube_Debug:OnHide()
        Menu.Visible = false
    end

    function Menu:OnShow()
        local node = self.Parent
		if node.__Root ~= node.Parent then
			-- this is not first node
			mnuShow:Enable()
			mnuDel:Enable()
		else
			mnuShow:Disable()
			mnuDel:Disable()
		end
        if node.BaseValue and type(node.BaseValue) == "table" and getmetatable(node.BaseValue) then
            mnuShowMeta:Enable()
        else
            mnuShowMeta:Disable()
        end
		if node.BaseKey and type(node.BaseKey) == "table" then
			mnuShowKey:Enable()
		else
			mnuShowKey:Disable()
		end
    end

    function mnuShow:OnClick()
        local node = Menu.Parent
        local text, value, baseValue, view

        value = GetTextByNode(node)
        baseValue = node.BaseValue

        if value then
            view = newView()
            text = value
            if getmetatable(baseValue) then
                text = "\124cff1eff00[M]\124h\124r"..text
            end
            node = view:AddNode{["Text"] = text, ["Value"] = value,}
            node.Menu = Menu
            node.BaseValue = baseValue
            node.OnToggle = OnToggle
			UpdateChild(node)
            node:Select()
        end
    end

    function mnuShowMeta:OnClick()
        local node = Menu.Parent
        local text, value, baseValue, view

        value = GetTextByNode(node)
        baseValue = getmetatable(node.BaseValue)
        value = "getmetatable("..value..")"

        if value then
            view = newView()
            text = value
            if getmetatable(baseValue) then
                text = "\124cff1eff00[M]\124h\124r"..text
            end
            node = view:AddNode{["Text"] = text, ["Value"] = value,}
            node.Menu = Menu
            node.BaseValue = baseValue
            node.OnToggle = OnToggle
			UpdateChild(node)
            node:Select()
        end
    end

	function mnuShowKey:OnClick()
		local node = Menu.Parent
        local text, value, baseValue, view

        value = tostring(node.BaseKey)
        baseValue = node.BaseKey

        if value then
            view = newView()
            text = value
            if getmetatable(baseValue) then
                text = "\124cff1eff00[M]\124h\124r"..text
            end
            node = view:AddNode{["Text"] = text, ["Value"] = value,}
            node.Menu = Menu
            node.BaseValue = baseValue
            node.OnToggle = OnToggle
			UpdateChild(node)
            node:Select()
        end
	end

	function mnuDel:OnClick()
		DelPopup:Show()
	end

	function btnCommit:OnClick()
        local value = GetModValue()

        if value and value ~= selectNode.BaseValue then
            CommitPopup.CheckNode = selectNode
            CommitPopup:Show()
        end
	end

	function DelPopup:OnOkay()
		local node = Menu.Parent

        node.Parent.BaseValue[node.BaseKey] = nil
        node:Dispose()
	end

	function CommitPopup:OnOkay()
        local value = GetModValue()
        local node = self.CheckNode

        node.BaseValue = value
        node.Parent.BaseValue[node.BaseKey] = value
        UpdateChild(self.CheckNode)
        self.CheckNode = nil
	end

    function CommitPopup:OnNo()
        UpdateType(selectNode)
        self.CheckNode = nil
    end

    function code:OnClick()
        if Cube_Debug.Parent:GetChild("Cube_Main") then
            Cube_Debug.Parent:GetChild("Cube_Main").Visible = true
        end
    end

    function bugList:OnClick()
        if Cube_Debug.Parent:GetChild("Cube_BugList") then
            Cube_Debug.Parent:GetChild("Cube_BugList").Visible = true
        end
    end
end