﻿--[[-------------------------------------------------------------------------------------------------
Debug Frame Designer
--]]-------------------------------------------------------------------------------------------------
do
	-- Addon Initialize
	IGAS:NewAddon("Cube.Mdl_Cube_Debug")

    Cube_Debug = CreateFrame("Form", "Cube_Debug")
    Cube_Debug.Height = 480
    Cube_Debug.Width = 560
    Cube_Debug.Caption = "Cube - "..L["Simple Debug Tool"]
    Cube_Debug.Visible = false
    
    txtIn = CreateFrame("SingleTextBox", "Input", Cube_Debug)
    txtIn:SetPoint("TOPLEFT", Cube_Debug, "TOPLEFT", 14, -26)
    txtIn:SetPoint("RIGHT", Cube_Debug, "RIGHT", -14, 0)
    
    tabF = CreateFrame("TabGroup", "TabF", Cube_Debug)
    tabF:SetPoint("TOPLEFT", Cube_Debug, "TOPLEFT", 4, -50)
    tabF:SetPoint("BOTTOMRIGHT", Cube_Debug, "BOTTOMRIGHT", -4, 50)

    -- BugList Button
    bugList = CreateFrame("Button", "BugList", Cube_Debug)
    bugList.Height = 24
    bugList.Width = 60
    bugList.Style = "NORMAL"
    bugList.Text = L["BugList"]
    width = bugList:GetTextWidth()
	if ( width > 50 ) then
		bugList:SetWidth(width + 20)
	else
		bugList:SetWidth(60)
	end
    bugList:SetPoint("BOTTOMRIGHT", Cube_Debug, "BOTTOMRIGHT", -4, 20)
    
    -- Code Button
    code = CreateFrame("Button", "Code", Cube_Debug)
    code.Height = 24
    code.Width = 60
    code.Style = "NORMAL"
    code.Text = L["Code"]
    width = code:GetTextWidth()
	if ( width > 50 ) then
		code:SetWidth(width + 20)
	else
		code:SetWidth(60)
	end
    code:SetPoint("RIGHT", bugList, "LEFT", -6, 0)
    
    -- Value Input
    txtValue = CreateFrame("SingleTextBox", "Value", Cube_Debug)
    txtValue.Height = 24
    txtValue.Width = 200
    txtValue.Visible = false
    txtValue:SetPoint("BOTTOMLEFT",Cube_Debug,"BOTTOMLEFT", 10, 20)
    
    -- Commit Button
    btnCommit = CreateFrame("Button", "Commit", Cube_Debug)
    btnCommit.Height = 24
    btnCommit.Width = 100
    btnCommit.Style = "NORMAL"
    btnCommit.Visible = false
    btnCommit.Text = L["Commit"]
    btnCommit:SetPoint("LEFT", txtValue, "RIGHT", 6, 0)
	
	-- Timer for message
	timer = CreateFrame("Timer", "MsgTimer", Cube_Debug)
	timer.Interval = 0
    
    -- Menu
    Menu = CreateFrame("DropDownList", "Menu", Cube_Debug)
    mnuShow = Menu:AddMenuButton(L["Show in new page"])
    mnuShowMeta = Menu:AddMenuButton(L["Show metatable in new page"])
	mnuShowKey = Menu:AddMenuButton(L["Show key in new page"])
    mnuDel = Menu:AddMenuButton(L["Delete this"])
	
	-- PopupDialogs
	DelPopup = CreateFrame("PopupDialog", "DelPop", Cube_Debug)
	DelPopup.Message = L["Are you sure to delete this key?"]
	DelPopup.ShowCancelButton = false
	
	CommitPopup = CreateFrame("PopupDialog", "CommitPop", Cube_Debug)
	CommitPopup.Message = L["Are you sure to change the value?"]
	CommitPopup.ShowCancelButton = false
	
	-- Add Frame to Addon
	_Addon:AddFrame(Cube_Debug)
end