﻿--[[-------------------------------------------------------------------------------------------------
Cube Frame Script
--]]-------------------------------------------------------------------------------------------------
do
	-- Addon Initialize
	IGAS:NewAddon("Cube.Mdl_Cube_Main")

	local lUnit = _Addon:GetModule("lUnit")

    -- Script
    function cboCode:OnValueChanged(value)
        if CubeSave.CodeList[value] then
            codeName.Text = value
            code.Text = CubeSave.CodeList[value]
            chkAuto.Checked = (CubeSave.AutoList[value] and true) or false
        end

		lstUnitTest.Visible = false
		frmResult.Visible = false
    end

    function chkAuto:OnValueChanged(value)
        if codeName.Text ~= "" and CubeSave.CodeList[codeName.Text] then
            CubeSave.AutoList[codeName.Text] = value
        end
    end

    function InitTimer:OnTimer()
        local func, err
        self.Interval = 0

        -- Auto Init Code
        for code in pairs(CubeSave.AutoList) do
            if CubeSave.AutoList[code] and CubeSave.CodeList[code] then
                Log(2, "Cube Loading ......"..code)
                func, err = loadstring(CubeSave.CodeList[code])
                if func then
                    func()
                else
                    Log(2, err)
                    if Cube_Main.Parent:GetChild("Cube_BugList") then
                        Cube_Main.Parent:GetChild("Cube_BugList").grabError(err)
                    end
                end
            end
        end

        self:Dispose()
    end

    function new:OnClick()
        Cube_Main.Message = ""
        codeName.Text = ""
        code.Text = ""
        cboCode.Text = ""
        chkAuto.Checked = false
		lstUnitTest.Visible = false
		frmResult.Visible = false
    end

    function save:OnClick()
        Cube_Main.Message = ""

        if codeName.Text == "" then
            Cube_Main.Message = L["Must set code name."]
            return
        end

        if code.Text == "" then
            Cube_Main.Message = L["Must set code."]
            return
        end

		if not CubeSave.CodeList[codeName.Text] then
	        cboCode:AddItem(codeName.Text, codeName.Text)
	        cboCode.Value = codeName.Text
		end
        CubeSave.AutoList[codeName.Text] = chkAuto.Checked
        CubeSave.CodeList[codeName.Text] = code.Text
    end

    function del:OnClick()
        Cube_Main.Message = ""

        if codeName.Text ~= "" then
            CubeSave.AutoList[codeName.Text] = nil
            CubeSave.CodeList[codeName.Text] = nil
            cboCode:RemoveItem(codeName.Text)
            cboCode.Text = ""
        end
        codeName.Text = ""
        code.Text = ""
        chkAuto.Checked = false

		lstUnitTest.Visible = false
		frmResult.Visible = false
    end

    function run:OnClick()
        Cube_Main.Message = ""
		lstUnitTest.Visible = false
		frmResult.Visible = false

        local func, err, status

        if code.Text ~= "" then
            func, err = loadstring(code.Text)

            if func then
				status, err = pcall(func)

				if not status then
					frmResult.Visible = true
					frmResult:ClearAllPoints()
					frmResult:SetPoint("TOPLEFT", Cube_Main, "TOPRIGHT")
					txtResult.Text = GetErrMsg(err)
				end
            else
				frmResult.Visible = true
				frmResult:ClearAllPoints()
				frmResult:SetPoint("TOPLEFT", Cube_Main, "TOPRIGHT")
				txtResult.Text = GetErrMsg(err)
            end
        end
    end

	function btnUnit:OnClick()
        Cube_Main.Message = ""

        local sm

        if code.Text ~= "" then
			lstUnitTest.Report = lUnit.Run(code.Text)

			lstUnitTest:Clear()
			lstUnitTest.Visible = true
			lstUnitTest:SuspendLayout()
			for func, msg in pairsByKeys(lstUnitTest.Report) do
				if next(msg) then
					sm = RED..func.." : ERR!"
				else
					sm = GRN..func.." : Ok!"
				end
				lstUnitTest:AddItem(func, sm)
			end
			lstUnitTest:ResumeLayout()

			frmResult.Visible = true
			frmResult:ClearAllPoints()
			frmResult:SetPoint("TOPLEFT", Cube_Main, "TOPRIGHT")
        end
	end

	function lstUnitTest:OnItemChoosed(key, text)
		if lstUnitTest.Report[key] and next(lstUnitTest.Report[key]) then
			txtResult.Text = table.concat(lstUnitTest.Report[key], "\n\n")
		else
			txtResult.Text = ""
		end
	end

	function lstUnitTest:OnShow()
		txtResult:SetPoint("TOPLEFT", lstUnitTest, "TOPRIGHT")
	end

	function lstUnitTest:OnHide()
		txtResult:SetPoint("TOPLEFT", frmResult, "TOPLEFT", 4, -20)
	end

    function debug:OnClick()
        if Cube_Main.Parent:GetChild("Cube_Debug") then
            Cube_Main.Parent:GetChild("Cube_Debug").Visible = true
        end
    end

    function bugList:OnClick()
        if Cube_Main.Parent:GetChild("Cube_BugList") then
            Cube_Main.Parent:GetChild("Cube_BugList").Visible = true
        end
    end

	-- Count Line
	local line
	function code:OnCursorChanged()
		_, line = string.gsub(string.sub(code.__Text.__UI:GetText(true), 1, self:GetCursorPosition()), "\n", "\n")
		Cube_Main.Message = "Line "..(line+1)
	end
end