﻿--[[-------------------------------------------------------------------------------------------------
Cube Frame Designer
--]]-------------------------------------------------------------------------------------------------
do
	-- Addon Initialize
	IGAS:NewAddon("Cube.Mdl_Cube_Main")
	
	local width
	
    -- Main Form
    Cube_Main = CreateFrame("Form", "Cube_Main")
    Cube_Main.Height = 480
    Cube_Main.Width = 560
    Cube_Main.Caption = "Cube - "..L["Simple Dev Tool"]
    Cube_Main.Visible = false
	
    -- Timer
    InitTimer = CreateFrame("Timer", "InitTimer", Cube_Main)
    
    -- Code List
    cboCode = CreateFrame("ComboBox", "CodeList", Cube_Main)
    cboCode.Editable = false
    cboCode:SetPoint("TOPLEFT", Cube_Main, "TOPLEFT", 4, -26)
    
    -- Code Name
    codeName = CreateFrame("SingleTextBox", "Name", Cube_Main)
    codeName.Width = 100
    codeName:SetPoint("LEFT", cboCode, "RIGHT", 20, 0)
	
    -- Check AutoRun
    chkAuto = CreateFrame("CheckBox", "AutoRun", Cube_Main)
    chkAuto.Text = L["AutoRun"]
    chkAuto:SetPoint("TOPRIGHT", Cube_Main, "TOPRIGHT", -4, -20)
    
    -- Code Form
    code = CreateFrame("MultiLineTextBox", "Code", Cube_Main)
    code:SetPoint("TOPLEFT", cboCode, "BOTTOMLEFT", 0, -4)
    code:SetPoint("BOTTOMRIGHT", Cube_Main, "BOTTOMRIGHT", -4, 50)
	-- Bind Editbox
	Indent.enable(code.__Text.__UI, nil, 4)
    
    -- New Button
    new = CreateFrame("Button", "New", Cube_Main)
	new.Height = 24
	new.Width = 60
	new.Style = "NORMAL"
    new.Text = L["New"]
    width = new:GetTextWidth()
	if ( width > 50 ) then
		new:SetWidth(width + 20)
	else
		new:SetWidth(60)
	end
    new:SetPoint("BOTTOMLEFT", Cube_Main, "BOTTOMLEFT", 4, 20)
    
    -- Save Button
    save = CreateFrame("Button", "Save", Cube_Main)
	save.Height = 24
	save.Width = 60
	save.Style = "NORMAL"
    save.Text = L["Save"]
	width = save:GetTextWidth()
	if ( width > 50 ) then
		save:SetWidth(width + 20)
	else
		save:SetWidth(60)
	end
    save:SetPoint("LEFT", new, "RIGHT", 6, 0)
    
    -- Del Button
    del = CreateFrame("Button", "Del", Cube_Main)
	del.Height = 24
	del.Width = 60
	del.Style = "NORMAL"
    del.Text = L["Del"]
    width = del:GetTextWidth()
	if ( width > 50 ) then
		del:SetWidth(width + 20)
	else
		del:SetWidth(60)
	end
    del:SetPoint("LEFT", save, "RIGHT", 6, 0)
    
    -- Debug Button
    debug = CreateFrame("Button", "Debug", Cube_Main)
	debug.Height = 24
	debug.Width = 60
	debug.Style = "NORMAL"
    debug.Text = L["Debug"]
    width = debug:GetTextWidth()
	if ( width > 50 ) then
		debug:SetWidth(width + 20)
	else
		debug:SetWidth(60)
	end
    debug:SetPoint("LEFT", del, "RIGHT", 6, 0)
    
    -- BugList Button
    bugList = CreateFrame("Button", "BugList", Cube_Main)
	bugList.Height = 24
	bugList.Width = 60
	bugList.Style = "NORMAL"
    bugList.Text = L["BugList"]
    width = bugList:GetTextWidth()
	if ( width > 50 ) then
		bugList:SetWidth(width + 20)
	else
		bugList:SetWidth(60)
	end
    bugList:SetPoint("LEFT", debug, "RIGHT", 6, 0)
    
    -- Run Button
    run = CreateFrame("Button", "Run", Cube_Main)
	run.Height = 24
	run.Width = 60
	run.Style = "NORMAL"
    run.Text = L["Run"]
    width = run:GetTextWidth()
	if ( width > 50 ) then
		run:SetWidth(width + 20)
	else
		run:SetWidth(60)
	end
    run:SetPoint("BOTTOMRIGHT", Cube_Main, "BOTTOMRIGHT", -4, 20)

	-- Result Button
	btnUnit = CreateFrame("Button", "Result", Cube_Main)
	btnUnit.Height = 24
	btnUnit.Width = 60
	btnUnit.Style = "NORMAL"
	btnUnit.Text = L["Unit Test"]
    width = btnUnit:GetTextWidth()
	if ( width > 50 ) then
		btnUnit:SetWidth(width + 20)
	else
		btnUnit:SetWidth(60)
	end
    btnUnit:SetPoint("RIGHT", run, "LEFT", -6, 0)	
	
	-- Result Frame
	frmResult = CreateFrame("Form", "frmResult", Cube_Main)
	frmResult.Width = 400
	frmResult.Height = 300
	frmResult.Visible = false
	frmResult.Caption = ""
	frmResult.HasTitleBar = false
	frmResult:SetMinResize(400, 300)
	frmResult:ClearAllPoints()
	frmResult:SetPoint("TOPLEFT", Cube_Main, "TOPRIGHT")
	
	lstUnitTest = CreateFrame("List", "lstUnitTest", frmResult)
	lstUnitTest:SetPoint("TOPLEFT", frmResult, "TOPLEFT", 4, -20)
	lstUnitTest:SetPoint("BOTTOMLEFT", frmResult, "BOTTOMLEFT", 4, -4)
	lstUnitTest:SetPoint("RIGHT", frmResult, "CENTER", -40, 0)
	lstUnitTest.Visible = false

    txtResult = CreateFrame("MultiLineTextBox", "Result", frmResult)
	txtResult:SetPoint("TOPLEFT", frmResult, "TOPLEFT", 4, -20)
    txtResult:SetPoint("BOTTOMRIGHT", frmResult, "BOTTOMRIGHT", -4, 4)
	
	-- Add Frame to Addon
	_Addon:AddFrame(Cube_Main)
	_Addon:AddFrame(InitTimer)
end