﻿--[[-------------------------------------------------------------------------------------------------
BugList Frame Designer
--]]-------------------------------------------------------------------------------------------------
do
	-- Addon Initialize
	IGAS:NewAddon("Cube.Mdl_Cube_BugList")
    
    local width

    Cube_BugList = CreateFrame("Form", "Cube_BugList")
    Cube_BugList.Height = 480
    Cube_BugList.Width = 560
	Cube_BugList.TitleBarHeight = 32
    Cube_BugList.Caption = "Cube - "..L["Simple Bug List"]
    Cube_BugList.Visible = false
    
    btnRight = CreateFrame("Button", "RightBtn", Cube_BugList)
    btnRight.FrameLevel = Cube_BugList.FrameLevel + 2
    btnRight:SetWidth(32)
    btnRight:SetHeight(32)
    btnRight:ClearAllPoints()
    btnRight:SetPoint("TOPRIGHT", Cube_BugList, "TOPRIGHT", -26, -4)
    btnRight:SetNormalTexture("Interface\\BUTTONS\\UI-SpellbookIcon-NextPage-Up")
    btnRight:SetPushedTexture("Interface\\BUTTONS\\UI-SpellbookIcon-NextPage-Down")
    btnRight:SetDisabledTexture("Interface\\BUTTONS\\UI-SpellbookIcon-NextPage-Disabled")
    btnRight:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight", "ADD")
    btnRight:Disable()
    rightNum = CreateFrame("FontString", "RightNum", btnRight, "ARTWORK", "GameFontHighlight")
    rightNum:SetAllPoints(btnRight)
    
    btnLeft = CreateFrame("Button", "LeftBtn", Cube_BugList)
    btnLeft.FrameLevel = Cube_BugList.FrameLevel + 2
    btnLeft:SetWidth(32)
    btnLeft:SetHeight(32)
    btnLeft:ClearAllPoints()
    btnLeft:SetPoint("RIGHT", btnRight, "LEFT", 0, 0)
    btnLeft:SetNormalTexture("Interface\\BUTTONS\\UI-SpellbookIcon-PrevPage-Up")
    btnLeft:SetPushedTexture("Interface\\BUTTONS\\UI-SpellbookIcon-PrevPage-Down")
    btnLeft:SetDisabledTexture("Interface\\BUTTONS\\UI-SpellbookIcon-PrevPage-Disabled")
    btnLeft:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight", "ADD")
    btnLeft:Disable()    
    leftNum = CreateFrame("FontString", "LeftNum", btnLeft, "ARTWORK", "GameFontHighlight")
    leftNum:SetAllPoints(btnLeft)

    -- Text View
    textView = CreateFrame("MultiLineTextBox", "Text", Cube_BugList)
    textView:SetPoint("TOPLEFT", Cube_BugList, "TOPLEFT", 6, -34)
    textView:SetPoint("BOTTOMRIGHT", Cube_BugList, "BOTTOMRIGHT", -6, 50)
    
    -- Debug Button
    debug = CreateFrame("Button", "Debug", Cube_BugList)
    debug.Height = 24
    debug.Width = 60
    debug.Style = "NORMAL"
    debug.Text = L["Debug"]
    width = debug:GetTextWidth()
    if ( width > 50 ) then
        debug:SetWidth(width + 20)
    else
        debug:SetWidth(60)
    end
    debug:SetPoint("BOTTOMRIGHT", Cube_BugList, "BOTTOMRIGHT", -4, 20)
    
    -- Code Button
    code = CreateFrame("Button", "Code", Cube_BugList)
    code.Height = 24
    code.Width = 60
    code.Style = "NORMAL"
    code.Text = L["Code"]
    width = code:GetTextWidth()
    if ( width > 50 ) then
        code:SetWidth(width + 20)
    else
        code:SetWidth(60)
    end
    code:SetPoint("RIGHT", debug, "LEFT", -6, 0)
    
    -- Clear Button
    clear = CreateFrame("Button", "Clear", Cube_BugList)
    clear.Height = 24
    clear.Width = 60
    clear.Style = "NORMAL"
    clear.Text = L["Clear"]
    width = clear:GetTextWidth()
    if ( width > 50 ) then
        clear:SetWidth(width + 20)
    else
        clear:SetWidth(60)
    end
    clear:SetPoint("BOTTOMLEFT", Cube_BugList, "BOTTOMLEFT", 4, 20)
    
    -- ClearAll Button
    clearAll = CreateFrame("Button", "ClearAll", Cube_BugList)
    clearAll.Height = 24
    clearAll.Width = 60
    clearAll.Style = "NORMAL"
    clearAll.Text = L["Clear All"]
    width = clearAll:GetTextWidth()
    if ( width > 50 ) then
        clearAll:SetWidth(width + 20)
    else
        clearAll:SetWidth(60)
    end
    clearAll:SetPoint("LEFT", clear, "RIGHT", 6, 0)
    
    -- Enable Button
    enable = CreateFrame("Button", "EnableButton", Cube_BugList)
    enable.Height = 24
    enable.Width = 60
    enable.Style = "NORMAL"
    enable.Text = L["Enabled"]
    width = enable:GetTextWidth()
    if ( width > 50 ) then
        enable:SetWidth(width + 20)
    else
        enable:SetWidth(60)
    end
    enable:SetPoint("LEFT", clearAll, "RIGHT", 6, 0)
    
    -- Minimap Icon
    icon = CreateFrame("MinimapIcon", "MapIcon", Cube_BugList)
    icon:SetIcon("Interface\\Icons\\INV_Misc_QuestionMark")
    icon.Tooltip = L["Simple Bug List"]
    icon.Visible = false
    
	-- Add Frame to Addon
	_Addon:AddFrame(Cube_BugList)
end