﻿--[[-------------------------------------------------------------------------------------------------
Cube Main
--]]-------------------------------------------------------------------------------------------------

do
	-- Addon Initialize
	IGAS:NewAddon("Cube")

    -- System Event
    _Addon:RegisterEvent("PLAYER_ENTERING_WORLD")
    _Addon:RegisterEvent("VARIABLES_LOADED")

    function _Addon:VARIABLES_LOADED()
        local cboCode = Cube_Main:GetChild("CodeList")

        CubeSave.AutoList = CubeSave.AutoList or {}
        CubeSave.CodeList = CubeSave.CodeList or {}

        -- Init Code List
        if next(CubeSave.CodeList) then
            for i in pairs(CubeSave.CodeList) do
                cboCode:AddItem(i, i)
            end
        end

        -- Init BugList
        if Cube_BugList then
            if not CubeSave.DisableBugList then
                Cube_BugList:Fire("OnEnable")
            else
                Cube_BugList:Fire("OnDisable")
            end
            if CubeSave.IconPosition then
                Cube_BugList:GetChild("MapIcon").Position = CubeSave.IconPosition
            end
            Cube_BugList:GetChild("MapIcon").Init = true
        end
		
		-- Init Log View
		if Cube_LogView then
			CubeSave.LogViewList = CubeSave.LogViewList or {}
			
			for i in pairs(CubeSave.LogViewList) do
				Cube_LogView.AddLogger(i)
			end
		end
    end

    function _Addon:PLAYER_ENTERING_WORLD()
		self:AddSlashCmd("/cube")
        InitTimer.Interval = 3
    end

	function _Addon:OnSlashCmd(msg)
		local cmd = strupper(strmatch(msg, "^%w+") or "")

		if cmd == "CODE" then
			if Cube_Main then
				Cube_Main.Visible = true
			end
			return
		elseif cmd == "BUG" then
			if Cube_BugList then
				Cube_BugList.Visible = true
			end
			return
		elseif cmd == "DEBUG" then
			if Cube_Debug then
				Cube_Debug.Visible = true
			end
			return
		elseif cmd == "LOG" then
			if Cube_LogView then
				Cube_LogView.Visible = true
			end
			return
		end

		Log(2, "/cube code  ("..L["Open the code editor"]..")")
		Log(2, "/cube bug   ("..L["Open the buglist"]..")")
		Log(2, "/cube debug ("..L["Open the debug tool"]..")")
		Log(2, "/cube log   ("..L["Open the log view"]..")")
	end
end