	-- Global variables:
local name = "CritZ"
local version = "2.0.1"

	-- Colors:
local cMarine = "|cFF0070DE"
local cPurple = "|cFFF900F9"
local cWhite = "|cFFFFFFFF"
local cRed = "|cFFFF0000"
local cLime = "|cFF00FF00"

	-- Other:
local PlayerEvent = CreateFrame("Frame")
local CombatLogEvent = CreateFrame("Frame")

local STAT_Frame = nil
local STAT_Btn_Settings = nil
local STAT_Btn_Save = nil
local STAT_Edits = {}

local SET_Frame = nil
local SET_Btn_PAdd = nil
local SET_Btn_SAdd = nil
local SET_Btn_GAdd = nil
local SET_Btn_PRemove = nil
local SET_Btn_SRemove = nil
local SET_Btn_GRemove = nil
local SET_Primary = nil
local SET_Secondary = nil
local SET_Global = nil
local SET_Btn_Reset = nil

local FILT_Frame = nil
local FILT_Btn_Save = nil
local FILT_Edits = {}

local prefix = cPurple .. "[" .. name .. "] " .. cMarine
local boot = false
local editMode = "None"
local settings = false

local charName = nil
local charSpecId = nil
local charSpecNum = nil
local charSpecNumStr = nil
local charSpecName = nil



-- Preform events
function Clean_Filter()
	-- Empty all slots with checked boxes for damage
	local arrayName = editMode .. "Filter"
	
	local i = 1
	if (arrayName == "GlobalFilter") then
		for key, value in pairs(LediiData[name][arrayName]) do
			if (FILT_Edits[i]:GetChecked() == 1) then
				LediiData[name][arrayName][key] = nil
			end
			i = i + 1
		end
	else
		for key, value in pairs(LediiData[name][charName][arrayName]) do
			if (FILT_Edits[i]:GetChecked() == 1) then
				LediiData[name][charName][arrayName][key] = nil
			end
			i = i + 1
		end
	end

	-- Update tables
	--editMode = "None"
	--Load_Tables()
	FILT_Frame:Hide()
end

function Load_Filters()
	--print(prefix .. "Loaded " .. cWhite .. editMode .. cMarine .. " filter!")
	if (settings == true) then
		local critStr = editMode .. " Filter" .. cMarine .. "\n\n\nAbilities:"
		
		local arrayName = editMode .. "Filter"
		local array = LediiData[name][charName][arrayName]
		local lineLength = 24.5
		
		-- Disable old buttons
		for key, box in pairs(FILT_Edits) do
			box:Disable()
			box:Hide()
		end
		
		-- Load data from tables if aviable
		if (not(array == nil)) then
			local i = 1
			for key, value in pairs(LediiData[name][charName][arrayName]) do
				critStr = critStr .. "\n\n" .. cWhite .. key
				
				FILT_Edits[i] = CreateFrame("CheckButton", "myCheckButton_GlobalName", FILT_Frame, "ChatConfigCheckButtonTemplate")
				FILT_Edits[i]:SetPoint("TOPLEFT", 260, 11 + (-lineLength * 3) + (-lineLength * i))
				FILT_Edits[i].tooltip = "Mark if you want to show this ability.";
				
				i = i + 1
			end
		else
			local i = 1
			for key, value in pairs(LediiData[name][arrayName]) do
				critStr = critStr .. "\n\n" .. cWhite .. key
				
				FILT_Edits[i] = CreateFrame("CheckButton", "myCheckButton_GlobalName", FILT_Frame, "ChatConfigCheckButtonTemplate")
				FILT_Edits[i]:SetPoint("TOPLEFT", 260, 11 + (-lineLength * 3) + (-lineLength * i))
				FILT_Edits[i].tooltip = "Mark if you want to show this ability.";
				
				i = i + 1
			end
		end
		
		-- Activate new buttons
		for key, box in pairs(FILT_Edits) do
			box:SetScript("OnClick", function()
				--print(prefix .. "Checked number " .. key .. "!")
			end)
		end
		
		FILT_Frame.text:SetText(critStr)
		FILT_Frame:Show()
	else
		FILT_Frame:Hide()
	end
end

function Apply_Filter()
	-- Empty all slots with checked boxes for damage
	local arrayName = editMode .. "Filter"
	
	local i = 1
	for key, value in pairs(LediiData[name][charName][charSpecNumStr]["Damage"]) do
		if (STAT_Edits[i]:GetChecked() == 1) then
			if (arrayName == "GlobalFilter") then
				LediiData[name][arrayName][key] = value
			else
				LediiData[name][charName][arrayName][key] = value
			end
			
			LediiData[name][charName][charSpecNumStr]["Damage"][key] = nil
			LediiData[name][charName][charSpecNumStr]["Healing"][key] = nil
		end
		i = i + 1
	end

	-- Empty all slots with checked boxes for healing
	for key, value in pairs(LediiData[name][charName][charSpecNumStr]["Healing"]) do
		if (STAT_Edits[i]:GetChecked() == 1) then
			if (arrayName == "GlobalFilter") then
				LediiData[name][arrayName][key] = value
			else
				LediiData[name][charName][arrayName][key] = value
			end
			
			LediiData[name][charName][charSpecNumStr]["Damage"][key] = nil
			LediiData[name][charName][charSpecNumStr]["Healing"][key] = nil
		end
		i = i + 1
	end

	-- Update tables
	editMode = "None"
	Load_Tables()
	--print(prefix .. "Filter was applied!")
end

function Load_Tables(listType)
	listType = listType or nil
	local critStr = "Specialization: " .. charSpecName .. " (" .. charSpecNumStr .. ")" .. cMarine
	
	local damageCount = LediiData[name][charName][charSpecNumStr]["Damage"]
	local healCount = LediiData[name][charName][charSpecNumStr]["Healing"]
	local typeCount = damageCount
	local cCrits = cRed
	local lineLength = 24.5
	if (listType == "Healing") then
		typeCount = healCount
		cCrits = cLime
	end
	
	-- Disable old buttons
	for key, box in pairs(STAT_Edits) do
		box:Disable()
		box:Hide()
	end
	
	if (editMode == "None" or not(editMode == charSpecNumStr or editMode == "Global")) then
		STAT_Btn_Save:Hide()
	else
		STAT_Btn_Save:Show()
	end
	
	-- Load data from tables if aviable
	if (listType == nil and not(damageCount == nil or healCount == nil)) then
		critStr = critStr .. "\n\n\nDamage:"
		local i = 1
		for key, value in pairs(LediiData[name][charName][charSpecNumStr]["Damage"]) do
			critStr = critStr .. "\n\n" .. cWhite .. key .. cMarine .. " - " .. cRed .. value .. cMarine
			
			if ((not (editMode == "None")) and (editMode == charSpecNumStr or editMode == "Global") and settings == true) then
				STAT_Edits[i] = CreateFrame("CheckButton", "myCheckButton_GlobalName", STAT_Frame, "ChatConfigCheckButtonTemplate")
				STAT_Edits[i]:SetPoint("TOPLEFT", 260, 11 + (-lineLength * 3) + (-lineLength * i))
				STAT_Edits[i].tooltip = "Mark if you want to hide this ability.";
			end
			
			i = i + 1
		end
		
		critStr = critStr .. "\n\n\nHealing:"
		for key, value in pairs(LediiData[name][charName][charSpecNumStr]["Healing"]) do
			critStr = critStr .. "\n\n" .. cWhite .. key .. cMarine .. " - " .. cLime .. value .. cMarine
			
			if ((not (editMode == "None")) and (editMode == charSpecNumStr or editMode == "Global") and settings == true) then
				STAT_Edits[i] = CreateFrame("CheckButton", "myCheckButton_GlobalName", STAT_Frame, "ChatConfigCheckButtonTemplate")
				STAT_Edits[i]:SetPoint("TOPLEFT", 260, 23 + (-lineLength * 5) + (-lineLength * i))
				STAT_Edits[i].tooltip = "Mark if you want to hide this ability."
			end
			
			i = i + 1
		end
		--print(prefix .. "Loaded both tables!")
	elseif (not(typeCount == nil)) then
		critStr = critStr .. "\n\n\n" .. listType .. ":"
		for key, value in pairs(LediiData[name][charName][charSpecNumStr][listType]) do
			critStr = critStr .. "\n\n" .. cWhite .. key .. cMarine .. " - " .. cCrits .. value .. cMarine
		end
		--print(prefix .. "Loaded specific table!")
	else
		--print(prefix .. "Table is empty!")
	end
	
	-- Activate new buttons
	for key, box in pairs(STAT_Edits) do
		box:SetScript("OnClick", function()
			--print(prefix .. "Checked number " .. key .. "!")
		end)
	end
	
	STAT_Frame.text:SetText(critStr)
end

function Load_Class_Info()
	-- Load class data
	charSpecId = GetSpecialization()
	charSpecNum = GetActiveSpecGroup()
	
	-- Check for spec number
	if (charSpecNum == 1) then
		charSpecNumStr = "Primary"
	else
		charSpecNumStr = "Secondary"
	end
	
	-- Check if has spec
	if not(charSpecId == nil) then
		charSpecName = select(2, GetSpecializationInfo(charSpecId))
	else
		charSpecId = "0"
		charSpecName = "None"
	end
	
	-- Create character tables
	if (LediiData[name][charName][charSpecNumStr] == nil) then
		LediiData[name][charName][charSpecNumStr] = {}
		LediiData[name][charName][charSpecNumStr]["Damage"] = {}
		LediiData[name][charName][charSpecNumStr]["Healing"] = {}
		--print(prefix .. "Created first-time data for " .. charSpecNumStr .. " specialisation!")			
	end
	
	Load_Tables()
	--print(prefix .. "Spec: " .. charSpecName .. " (" .. charSpecNumStr .. ")")
end

function Initialize()
	-- Make sure no arrays are nil
	if (LediiData == nil) then
		LediiData = {}
	end
	if (LediiData[name] == nil) then
		LediiData[name] = {}
		LediiData[name]["GlobalFilter"] = {}
	end
	if (LediiData[name][charName] == nil) then
		LediiData[name][charName] = {}
		LediiData[name][charName]["PrimaryFilter"] = {}
		LediiData[name][charName]["SecondaryFilter"] = {}
		--print(prefix .. "Created first-time data for " .. charName)			
	end
	
	Load_Class_Info()
end

function Handle_Events(self, event, ...)
	charName = GetRealmName() .. " - " .. UnitName("Player")
	--print(prefix .. "WoW-version " .. select(4, GetBuildInfo())) -- Gets the build info
	
	-- Player login:
	if (event == "PLAYER_LOGIN") then
		print(prefix .. "Version " .. version .. " loaded!")
		print(prefix .. "Type " .. cWhite .. "/critz help" .. cMarine .. " to show the list of commands.")
		
		-- Statistics:
		STAT_Frame = CreateFrame("Frame", "Frame", UIParent)
		STAT_Frame:ClearAllPoints()
		STAT_Frame:SetBackdrop(StaticPopup1:GetBackdrop())
		STAT_Frame:SetHeight(700)
		STAT_Frame:SetWidth(300)
		STAT_Frame:SetMovable(true)
		STAT_Frame:EnableMouse(true)
		STAT_Frame:RegisterForDrag("LeftButton")
		STAT_Frame:SetScript("OnDragStart", STAT_Frame.StartMoving)
		STAT_Frame:SetScript("OnDragStop", STAT_Frame.StopMovingOrSizing)
		STAT_Frame:SetPoint("CENTER", 0, 0)
		STAT_Frame.text = STAT_Frame:CreateFontString(nil, "BACKGROUND", "GameFontNormal")
		STAT_Frame.text:SetPoint("TOPLEFT", 30, -30);
		STAT_Frame.text:SetJustifyH("LEFT")
		STAT_Frame:Hide()
		
		STAT_Btn_Settings = CreateFrame("Button", nil, STAT_Frame)
		STAT_Btn_Settings:SetPoint("CENTER", -60, -300)
		STAT_Btn_Settings:SetWidth(100)
		STAT_Btn_Settings:SetHeight(30)
		STAT_Btn_Settings:SetText("Settings")
		STAT_Btn_Settings:SetNormalFontObject("GameFontNormal")
		
		local ntex = STAT_Btn_Settings:CreateTexture()
		ntex:SetTexture("Interface/Buttons/UI-Panel-Button-Up")
		ntex:SetTexCoord(0, 0.625, 0, 0.6875)
		ntex:SetAllPoints()
		local htex = STAT_Btn_Settings:CreateTexture()
		htex:SetTexture("Interface/Buttons/UI-Panel-Button-Highlight")
		htex:SetTexCoord(0, 0.625, 0, 0.6875)
		htex:SetAllPoints()
		local ptex = STAT_Btn_Settings:CreateTexture()
		ptex:SetTexture("Interface/Buttons/UI-Panel-Button-Down")
		ptex:SetTexCoord(0, 0.625, 0, 0.6875)
		ptex:SetAllPoints()
		
		STAT_Btn_Settings:SetNormalTexture(ntex)
		STAT_Btn_Settings:SetHighlightTexture(htex)
		STAT_Btn_Settings:SetPushedTexture(ptex)
		STAT_Btn_Settings:SetScript("OnClick", function()
			if (settings == true) then
				SET_Frame:Hide()
				settings = false
				editMode = "None"
				Load_Tables()
				Load_Filters()
			else
				SET_Frame:Show()
				settings = true
			end
		end)
		
		STAT_Btn_Save = CreateFrame("Button", nil, STAT_Frame)
		STAT_Btn_Save:SetPoint("CENTER", 60, -300)
		STAT_Btn_Save:SetWidth(100)
		STAT_Btn_Save:SetHeight(30)
		STAT_Btn_Save:SetText("Save Filter")
		STAT_Btn_Save:SetNormalFontObject("GameFontNormal")
		
		local ntex = STAT_Btn_Save:CreateTexture()
		ntex:SetTexture("Interface/Buttons/UI-Panel-Button-Up")
		ntex:SetTexCoord(0, 0.625, 0, 0.6875)
		ntex:SetAllPoints()
		local htex = STAT_Btn_Save:CreateTexture()
		htex:SetTexture("Interface/Buttons/UI-Panel-Button-Highlight")
		htex:SetTexCoord(0, 0.625, 0, 0.6875)
		htex:SetAllPoints()
		local ptex = STAT_Btn_Save:CreateTexture()
		ptex:SetTexture("Interface/Buttons/UI-Panel-Button-Down")
		ptex:SetTexCoord(0, 0.625, 0, 0.6875)
		ptex:SetAllPoints()
	
		STAT_Btn_Save:SetNormalTexture(ntex)
		STAT_Btn_Save:SetHighlightTexture(htex)
		STAT_Btn_Save:SetPushedTexture(ptex)
		STAT_Btn_Save:Hide()
		STAT_Btn_Save:SetScript("OnClick", function()
			Apply_Filter()
		end)
		
		-- Settings:
		SET_Frame = CreateFrame("Frame", "Frame", UIParent)
		SET_Frame:ClearAllPoints()
		SET_Frame:SetBackdrop(StaticPopup1:GetBackdrop())
		SET_Frame:SetHeight(500)
		SET_Frame:SetWidth(400)
		SET_Frame:SetMovable(true)
		SET_Frame:EnableMouse(true)
		SET_Frame:RegisterForDrag("LeftButton")
		SET_Frame:SetScript("OnDragStart", SET_Frame.StartMoving)
		SET_Frame:SetScript("OnDragStop", SET_Frame.StopMovingOrSizing)
		SET_Frame:SetPoint("CENTER", 350, 0)
		SET_Frame.text = SET_Frame:CreateFontString(nil, "BACKGROUND", "GameFontNormal")
		SET_Frame.text:SetPoint("TOPLEFT", 30, -30);
		SET_Frame.text:SetJustifyH("LEFT")
		SET_Frame.text:SetText("Settings" .. cMarine .. "\n\n\nFilter settings:" .. cWhite .. "\n\nPrimary specialization\n\n\nSecondary specialization\n\n\nGlobal" .. cMarine .. "\n\n\nGenerel settings:" .. cWhite .. "\n\nComming soon...")
		SET_Frame:Hide()
		
		--Add buttons
		SET_Btn_PAdd = CreateFrame("Button", nil, SET_Frame)
		SET_Btn_PAdd:SetPoint("TOPRIGHT", -140, -85)
		SET_Btn_PAdd:SetWidth(50)
		SET_Btn_PAdd:SetHeight(30)
		SET_Btn_PAdd:SetText("Add")
		SET_Btn_PAdd:SetNormalFontObject("GameFontNormal")
		
		local ntex = SET_Btn_PAdd:CreateTexture()
		ntex:SetTexture("Interface/Buttons/UI-Panel-Button-Up")
		ntex:SetTexCoord(0, 0.625, 0, 0.6875)
		ntex:SetAllPoints()
		local htex = SET_Btn_PAdd:CreateTexture()
		htex:SetTexture("Interface/Buttons/UI-Panel-Button-Highlight")
		htex:SetTexCoord(0, 0.625, 0, 0.6875)
		htex:SetAllPoints()
		local ptex = SET_Btn_PAdd:CreateTexture()
		ptex:SetTexture("Interface/Buttons/UI-Panel-Button-Down")
		ptex:SetTexCoord(0, 0.625, 0, 0.6875)
		ptex:SetAllPoints()
		
		SET_Btn_PAdd:SetNormalTexture(ntex)
		SET_Btn_PAdd:SetHighlightTexture(htex)
		SET_Btn_PAdd:SetPushedTexture(ptex)
		SET_Btn_PAdd:SetScript("OnClick", function()
			editMode = "Primary"
			Load_Tables()
			FILT_Frame:Hide()
		end)
		
		SET_Btn_SAdd = CreateFrame("Button", nil, SET_Frame)
		SET_Btn_SAdd:SetPoint("TOPRIGHT", -140, -120)
		SET_Btn_SAdd:SetWidth(50)
		SET_Btn_SAdd:SetHeight(30)
		SET_Btn_SAdd:SetText("Add")
		SET_Btn_SAdd:SetNormalFontObject("GameFontNormal")
		
		local ntex = SET_Btn_SAdd:CreateTexture()
		ntex:SetTexture("Interface/Buttons/UI-Panel-Button-Up")
		ntex:SetTexCoord(0, 0.625, 0, 0.6875)
		ntex:SetAllPoints()
		local htex = SET_Btn_SAdd:CreateTexture()
		htex:SetTexture("Interface/Buttons/UI-Panel-Button-Highlight")
		htex:SetTexCoord(0, 0.625, 0, 0.6875)
		htex:SetAllPoints()
		local ptex = SET_Btn_SAdd:CreateTexture()
		ptex:SetTexture("Interface/Buttons/UI-Panel-Button-Down")
		ptex:SetTexCoord(0, 0.625, 0, 0.6875)
		ptex:SetAllPoints()
		
		SET_Btn_SAdd:SetNormalTexture(ntex)
		SET_Btn_SAdd:SetHighlightTexture(htex)
		SET_Btn_SAdd:SetPushedTexture(ptex)
		SET_Btn_SAdd:SetScript("OnClick", function()
			editMode = "Secondary"
			Load_Tables()
			FILT_Frame:Hide()
		end)
		
		SET_Btn_GAdd = CreateFrame("Button", nil, SET_Frame)
		SET_Btn_GAdd:SetPoint("TOPRIGHT", -140, -155)
		SET_Btn_GAdd:SetWidth(50)
		SET_Btn_GAdd:SetHeight(30)
		SET_Btn_GAdd:SetText("Add")
		SET_Btn_GAdd:SetNormalFontObject("GameFontNormal")
		
		local ntex = SET_Btn_GAdd:CreateTexture()
		ntex:SetTexture("Interface/Buttons/UI-Panel-Button-Up")
		ntex:SetTexCoord(0, 0.625, 0, 0.6875)
		ntex:SetAllPoints()
		local htex = SET_Btn_GAdd:CreateTexture()
		htex:SetTexture("Interface/Buttons/UI-Panel-Button-Highlight")
		htex:SetTexCoord(0, 0.625, 0, 0.6875)
		htex:SetAllPoints()
		local ptex = SET_Btn_GAdd:CreateTexture()
		ptex:SetTexture("Interface/Buttons/UI-Panel-Button-Down")
		ptex:SetTexCoord(0, 0.625, 0, 0.6875)
		ptex:SetAllPoints()
		
		SET_Btn_GAdd:SetNormalTexture(ntex)
		SET_Btn_GAdd:SetHighlightTexture(htex)
		SET_Btn_GAdd:SetPushedTexture(ptex)
		SET_Btn_GAdd:SetScript("OnClick", function()
			editMode = "Global"
			Load_Tables()
			FILT_Frame:Hide()
		end)
		
		--Remove buttons
		SET_Btn_PRemove = CreateFrame("Button", nil, SET_Frame)
		SET_Btn_PRemove:SetPoint("TOPRIGHT", -40, -85)
		SET_Btn_PRemove:SetWidth(100)
		SET_Btn_PRemove:SetHeight(30)
		SET_Btn_PRemove:SetText("Remove")
		SET_Btn_PRemove:SetNormalFontObject("GameFontNormal")
		
		local ntex = SET_Btn_PRemove:CreateTexture()
		ntex:SetTexture("Interface/Buttons/UI-Panel-Button-Up")
		ntex:SetTexCoord(0, 0.625, 0, 0.6875)
		ntex:SetAllPoints()
		local htex = SET_Btn_PRemove:CreateTexture()
		htex:SetTexture("Interface/Buttons/UI-Panel-Button-Highlight")
		htex:SetTexCoord(0, 0.625, 0, 0.6875)
		htex:SetAllPoints()
		local ptex = SET_Btn_PRemove:CreateTexture()
		ptex:SetTexture("Interface/Buttons/UI-Panel-Button-Down")
		ptex:SetTexCoord(0, 0.625, 0, 0.6875)
		ptex:SetAllPoints()
		
		SET_Btn_PRemove:SetNormalTexture(ntex)
		SET_Btn_PRemove:SetHighlightTexture(htex)
		SET_Btn_PRemove:SetPushedTexture(ptex)
		SET_Btn_PRemove:SetScript("OnClick", function()
			editMode = "None"
			Load_Tables()
			editMode = "Primary"
			Load_Filters()
		end)
		
		SET_Btn_SRemove = CreateFrame("Button", nil, SET_Frame)
		SET_Btn_SRemove:SetPoint("TOPRIGHT", -40, -120)
		SET_Btn_SRemove:SetWidth(100)
		SET_Btn_SRemove:SetHeight(30)
		SET_Btn_SRemove:SetText("Remove")
		SET_Btn_SRemove:SetNormalFontObject("GameFontNormal")
		
		local ntex = SET_Btn_SRemove:CreateTexture()
		ntex:SetTexture("Interface/Buttons/UI-Panel-Button-Up")
		ntex:SetTexCoord(0, 0.625, 0, 0.6875)
		ntex:SetAllPoints()
		local htex = SET_Btn_SRemove:CreateTexture()
		htex:SetTexture("Interface/Buttons/UI-Panel-Button-Highlight")
		htex:SetTexCoord(0, 0.625, 0, 0.6875)
		htex:SetAllPoints()
		local ptex = SET_Btn_SRemove:CreateTexture()
		ptex:SetTexture("Interface/Buttons/UI-Panel-Button-Down")
		ptex:SetTexCoord(0, 0.625, 0, 0.6875)
		ptex:SetAllPoints()
		
		SET_Btn_SRemove:SetNormalTexture(ntex)
		SET_Btn_SRemove:SetHighlightTexture(htex)
		SET_Btn_SRemove:SetPushedTexture(ptex)
		SET_Btn_SRemove:SetScript("OnClick", function()
			editMode = "None"
			Load_Tables()
			editMode = "Secondary"
			Load_Filters()
		end)
		
		SET_Btn_GRemove = CreateFrame("Button", nil, SET_Frame)
		SET_Btn_GRemove:SetPoint("TOPRIGHT", -40, -155)
		SET_Btn_GRemove:SetWidth(100)
		SET_Btn_GRemove:SetHeight(30)
		SET_Btn_GRemove:SetText("Remove")
		SET_Btn_GRemove:SetNormalFontObject("GameFontNormal")
		
		local ntex = SET_Btn_GRemove:CreateTexture()
		ntex:SetTexture("Interface/Buttons/UI-Panel-Button-Up")
		ntex:SetTexCoord(0, 0.625, 0, 0.6875)
		ntex:SetAllPoints()
		local htex = SET_Btn_GRemove:CreateTexture()
		htex:SetTexture("Interface/Buttons/UI-Panel-Button-Highlight")
		htex:SetTexCoord(0, 0.625, 0, 0.6875)
		htex:SetAllPoints()
		local ptex = SET_Btn_GRemove:CreateTexture()
		ptex:SetTexture("Interface/Buttons/UI-Panel-Button-Down")
		ptex:SetTexCoord(0, 0.625, 0, 0.6875)
		ptex:SetAllPoints()
		
		SET_Btn_GRemove:SetNormalTexture(ntex)
		SET_Btn_GRemove:SetHighlightTexture(htex)
		SET_Btn_GRemove:SetPushedTexture(ptex)
		SET_Btn_GRemove:SetScript("OnClick", function()
			editMode = "None"
			Load_Tables()
			editMode = "Global"
			Load_Filters()
		end)
		
		-- Reset button
		SET_Btn_Reset = CreateFrame("Button", nil, SET_Frame)
		SET_Btn_Reset:SetPoint("CENTER", 0, -200)
		SET_Btn_Reset:SetWidth(170)
		SET_Btn_Reset:SetHeight(30)
		SET_Btn_Reset:SetText("Reset Character Data")
		SET_Btn_Reset:SetNormalFontObject("GameFontNormal")
		
		local ntex = SET_Btn_Reset:CreateTexture()
		ntex:SetTexture("Interface/Buttons/UI-Panel-Button-Up")
		ntex:SetTexCoord(0, 0.625, 0, 0.6875)
		ntex:SetAllPoints()
		local htex = SET_Btn_Reset:CreateTexture()
		htex:SetTexture("Interface/Buttons/UI-Panel-Button-Highlight")
		htex:SetTexCoord(0, 0.625, 0, 0.6875)
		htex:SetAllPoints()
		local ptex = SET_Btn_Reset:CreateTexture()
		ptex:SetTexture("Interface/Buttons/UI-Panel-Button-Down")
		ptex:SetTexCoord(0, 0.625, 0, 0.6875)
		ptex:SetAllPoints()
		
		SET_Btn_Reset:SetNormalTexture(ntex)
		SET_Btn_Reset:SetHighlightTexture(htex)
		SET_Btn_Reset:SetPushedTexture(ptex)
		SET_Btn_Reset:SetScript("OnClick", function()
			LediiData[name][charName] = nil
			editMode = "None"
			Initialize()
			FILT_Frame:Hide()
			print(prefix .. "All data for this character is now reset!")
		end)
		
		--Filters
		FILT_Frame = CreateFrame("Frame", "Frame", UIParent)
		FILT_Frame:ClearAllPoints()
		FILT_Frame:SetBackdrop(StaticPopup1:GetBackdrop())
		FILT_Frame:SetHeight(700)
		FILT_Frame:SetWidth(300)
		FILT_Frame:SetMovable(true)
		FILT_Frame:EnableMouse(true)
		FILT_Frame:RegisterForDrag("LeftButton")
		FILT_Frame:SetScript("OnDragStart", FILT_Frame.StartMoving)
		FILT_Frame:SetScript("OnDragStop", FILT_Frame.StopMovingOrSizing)
		FILT_Frame:SetPoint("CENTER", -350, 0)
		FILT_Frame.text = FILT_Frame:CreateFontString(nil, "BACKGROUND", "GameFontNormal")
		FILT_Frame.text:SetPoint("TOPLEFT", 30, -30);
		FILT_Frame.text:SetJustifyH("LEFT")
		FILT_Frame:Hide()
		
		FILT_Btn_Save = CreateFrame("Button", nil, FILT_Frame)
		FILT_Btn_Save:SetPoint("CENTER", 0, -300)
		FILT_Btn_Save:SetWidth(150)
		FILT_Btn_Save:SetHeight(30)
		FILT_Btn_Save:SetText("Save Filter")
		FILT_Btn_Save:SetNormalFontObject("GameFontNormal")
		
		local ntex = FILT_Btn_Save:CreateTexture()
		ntex:SetTexture("Interface/Buttons/UI-Panel-Button-Up")
		ntex:SetTexCoord(0, 0.625, 0, 0.6875)
		ntex:SetAllPoints()
		local htex = FILT_Btn_Save:CreateTexture()
		htex:SetTexture("Interface/Buttons/UI-Panel-Button-Highlight")
		htex:SetTexCoord(0, 0.625, 0, 0.6875)
		htex:SetAllPoints()
		local ptex = FILT_Btn_Save:CreateTexture()
		ptex:SetTexture("Interface/Buttons/UI-Panel-Button-Down")
		ptex:SetTexCoord(0, 0.625, 0, 0.6875)
		ptex:SetAllPoints()
		
		FILT_Btn_Save:SetNormalTexture(ntex)
		FILT_Btn_Save:SetHighlightTexture(htex)
		FILT_Btn_Save:SetPushedTexture(ptex)
		FILT_Btn_Save:SetScript("OnClick", function()
			Clean_Filter()
			--Load_Filters()
		end)

		
		Initialize()
		boot = true
	end
	
	if (event == "ACTIVE_TALENT_GROUP_CHANGED" and boot == true) then
		--print(prefix .. "Talent specialisation changed!")
		Load_Class_Info()
	end
end

function Combat_Log(timestamp, event, hideCaster, sourceGUID, sourceName, sourceFlags, source, destGUID, destName, destFlags, target, spellId, spellName, spellSchool, ability, arg5, amount, overkill, school, blocked, absorbed, critical, glancing, crushing)
	-- Check if the event is one of your abilities
	if (amount ~= nil and source ~= nil and ability ~= nil and target ~= nil) then
		local tag = GetRealmName() .. " - " .. source
		
		-- Check caster
		if (tag == charName) then
			
			local allowed = true
			local arrayName = charSpecNumStr .. "Filter"
			if (not(LediiData[name]["GlobalFilter"][ability] == nil)) then
				allowed = false
				-- Globally filtered
			elseif (not(LediiData[name][charName][arrayName][ability] == nil)) then
				allowed = false
				-- Spec filtered
			end
			
			-- If not filtered
			if (allowed == true) then
			
				if (not(string.find(sourceGUID, "_HEAL") == nil)) then
					-- Check for heal record
					local bestHeal = LediiData[name][charName][charSpecNumStr]["Healing"][ability]
					if (bestHeal == nil or amount > bestHeal) then
						LediiData[name][charName][charSpecNumStr]["Healing"][ability] = amount
						
						local heal = prefix .. "New record for " .. cWhite .. ability .. cMarine .. " is " .. cLime .. amount .. cMarine .. "!"
						RaidNotice_AddMessage(RaidWarningFrame, heal, ChatTypeInfo["RAID_WARNING"])
						print(heal)
						editMode = "None"
						Load_Tables()
					end
					
				else
					-- Check for damage record
					local bestDamage = LediiData[name][charName][charSpecNumStr]["Damage"][ability]
					if (bestDamage == nil or amount > bestDamage) then
						LediiData[name][charName][charSpecNumStr]["Damage"][ability] = amount
						
						local damage = prefix .. "New record for " .. cWhite .. ability .. cMarine .. " is " .. cRed .. amount .. cMarine .. "!"
						RaidNotice_AddMessage(RaidWarningFrame, damage, ChatTypeInfo["RAID_WARNING"])
						print(damage)
						editMode = "None"
						Load_Tables()
					end
				end
			end
		end
	end
end


-- Chat commands:
SLASH_CRITZ1 = "/critz"
function SlashCmdList.CRITZ(msg, editbox)
	if (msg == "") then
		STAT_Frame:Show()
		Load_Tables()
	elseif (msg == "help") then
		print(prefix .. cWhite .. "/critz" .. cMarine .. " - Show data for CritZ.")
		print(prefix .. cWhite .. "/critz close" .. cMarine .. " - Hide data for CritZ.")
		--print(prefix .. cWhite .. "/critz banned" .. cMarine .. " - Show list of banned abilities.")
		--print(prefix .. cWhite .. "/critz gbanned" .. cMarine .. " - Show global list of banned abilities.")
		print(prefix .. cWhite .. "/critz version" .. cMarine .. " - Display current version of CritZ and Client.")
		print(prefix .. cWhite .. "/critz reset" .. cMarine .. " - Deletes all the stored records.")
		--print(prefix .. cWhite .. "/clearcritz [Ability]" .. cMarine .. " - Removes data for [Ability]. (All if empty!)")
		--print(prefix .. cWhite .. "/bancritz [Ability]" .. cMarine .. " - Bans [Ability]. (Will no longer be registered!)")
		--print(prefix .. cWhite .. "/gbancritz [Ability]" .. cMarine .. " - Bans [Ability] for all characters and specs.")
		--print(prefix .. cWhite .. "/unbancritz [Ability]" .. cMarine .. " - Unbans [Ability]. (Will register new data!)")
		--print(prefix .. cWhite .. "/debugcritz" .. cMarine .. " - Toggle debug info. (Use to report problems!)")
	elseif (msg == "close") then
		STAT_Frame:Hide()
	elseif (msg == "version") then
		print(prefix .. "The current version is " .. cWhite .. version .. cMarine .. "!")
	elseif (msg == "reset") then
		LediiData[name] = nil
		Initialize()
		print(prefix .. "All data is now reset!")
	end
end

--SLASH_CLEARCRITZ1 = "/clearcritz"
--function SlashCmdList.CLEARCRITZ(msg, editbox)
	--LediiData[name] = nil
	--Initialize()
	--print(prefix .. "All data is now reset!")
--end


-- Events to register:
PlayerEvent:RegisterEvent("PLAYER_LOGIN")
PlayerEvent:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
PlayerEvent:SetScript("OnEvent", Handle_Events)

CombatLogEvent:RegisterEvent("COMBAT_LOG_EVENT")
CombatLogEvent:SetScript("OnEvent", Combat_Log)