﻿local MyAddon = LibStub("AceAddon-3.0"):NewAddon("crafthelper", "AceEvent-3.0", "AceHook-3.0")

local L = {}

if GetLocale() == "deDE" then
	L["about"] = " - by Angelike (EU/Gilneas)"
	L["optimal"]	= "optimal";
	L["medium"]	= "normal";
	L["easy"]		= "leicht";
	L["trivial"]	= "trivial";
	L["crafthelper"] = "CraftHelper 1.0"
	L["only_show"] = "Zeigen nur Rezepte ab"
else
	L["about"] = " - by Angelike (EU/Gilneas)"
	L["optimal"]	= "optimal";
	L["medium"]	= "medium";
	L["easy"]		= "easy";
	L["trivial"]	= "trivial";
	L["crafthelper"] = "CraftHelper 1.0"
	L["only_show"] = "Only show recipes starting from"
end

local MODNAME	= "Crafthelper"
local VERSION = 1.0

local timeSoFar = 0
local stage = 0
local scandone

local MyAddonframe = {}

MyAddon.rdb = {}
MyAddon.header = {}
MyAddon.headeridx = {}
MyAddon.cHeader = {}
MyAddon.cAll = {}
MyAddon.ScanNr = 0

-- translate strings to numbers for better comparing
local TradeSkillLevel = { };
TradeSkillLevel["optimal"]	= 3;
TradeSkillLevel["medium"]	= 2;
TradeSkillLevel["easy"]		= 1;
TradeSkillLevel["trivial"]	= 0;
TradeSkillLevel["header"]	= -1;

-- just a debug filter
local TradeSkillNeed = 1

-- do some locals to speed things up
local	tostring = tostring
local GetTradeSkillInfo = GetTradeSkillInfo
local GetNumTradeSkills = GetNumTradeSkills
local table = table
local ExpandTradeSkillSubClass = ExpandTradeSkillSubClass
local CollapseTradeSkillSubClass = CollapseTradeSkillSubClass
local GetTradeSkillLine = GetTradeSkillLine
local TradeSkillCollapseAllButton_OnClick_Script  -- placeholder

local function print(text)
	DEFAULT_CHAT_FRAME:AddMessage("Crafthelper: " .. tostring(text))
end


-- Events

function MyAddon:OnInitialize()
	print("init crafthelper")
end

function MyAddon:OnEnable()
	if not IsAddOnLoaded("Blizzard_TradeSkillUI") then
		LoadAddOn("Blizzard_TradeSkillUI")
	end
	print("enable crafthelper")
	MyAddon:RegisterEvent("TRADE_SKILL_SHOW")
	MyAddon:RegisterEvent("TRADE_SKILL_UPDATE", "update")
	MyAddon:RegisterEvent("TRADE_SKILL_FILTER_UPDATE", "update")
	MyAddon:RegisterEvent("SKILL_LINES_CHANGED", "TradeSkillFrame_Update")
	MyAddon:RegisterEvent("CHAT_MSG_SYSTEM")

	if #MyAddonframe == 0 then
		MyAddon:InitFrames()
	end

	MyAddon:RawHook("TradeSkillFrame_Update", true)
	MyAddon:RawHook("GetFirstTradeSkill", true)
	MyAddon:RawHook("TradeSkillSkillButton_OnClick", true)
	
	-- hooking <OnClick function="*"/> is terrible
	TradeSkillCollapseAllButton_OnClick_Script = TradeSkillCollapseAllButton:GetScript("OnClick")
	TradeSkillCollapseAllButton:SetScript("OnClick", function(self) MyAddon:TradeSkillCollapseAllButton_OnClick(self) end)

end

function MyAddon:OnDisable()
	print("disable crafthelper")

	MyAddon:UnregisterEvent("TRADE_SKILL_SHOW")
	MyAddon:UnregisterEvent("TRADE_SKILL_UPDATE");
	MyAddon:UnregisterEvent("TRADE_SKILL_FILTER_UPDATE");
	MyAddon:UnregisterEvent("SKILL_LINES_CHANGED");
	MyAddon:UnregisterEvent("CHAT_MSG_SYSTEM")

	MyAddon:Unhook("TradeSkillFrame_Update")
	MyAddon:Unhook("GetFirstTradeSkill")
	MyAddon:Unhook("TradeSkillSkillButton_OnClick")
	
	TradeSkillCollapseAllButton:SetScript("OnClick", function(self) MyAddon:TradeSkillCollapseAllButton_OnClick_Script(self) end)
end

-- checks TradeSkillFrame on schow event
function MyAddon:TRADE_SKILL_SHOW()
	if not MyAddonframe.enablebutton:GetChecked() then
		if MyAddon.cHeader[GetTradeSkillLine()] then
			-- perform an update and restore old status
			return MyAddon:RestoreTradeSkill(GetTradeSkillLine())
		end
		return
	end
end

-- observe system chat for learning an recipe
function MyAddon:CHAT_MSG_SYSTEM (event, msg)
	local stringpattern = ERR_LEARN_RECIPE_S:gsub('(% %%s.?$?.)', '')
	if strmatch(msg, stringpattern) then
		if TradeSkillFrame:IsVisible() then
			for k,v in pairs(MyAddon.header) do
				if GetTradeSkillLine() ~= k then
					-- reset all invisible tradeskilldata
					MyAddon.header[k] = {}
					MyAddon.cHeader[k] = {}
				end
				
				-- and update visible frame
				return MyAddon:update()
			end
		else
			-- reset all data
			MyAddon.header = {}
			MyAddon.cHeader = {}
		end
	end
end


-- Hooks

function MyAddon:GetFirstTradeSkill()
	local oldid = MyAddon.hooks.GetFirstTradeSkill()
	if not MyAddonframe.enablebutton:GetChecked() then
		return MyAddon.hooks.GetFirstTradeSkill()
	end
	
	if MyAddon.Scanning then
		return 0
	end

	-- do a scan befor retun something
	if not scandone then
		MyAddon:Scan()
	end
	
	for _,v in pairs(MyAddon.rdb) do
		local skillName , skillType = GetTradeSkillInfo(v)
		if skillType ~= "header" then
			-- return first useable tradeskill in list
			return v
		end
	end
	return 0
end

function MyAddon:TradeSkillSkillButton_OnClick(self, button)
	if not MyAddonframe.enablebutton:GetChecked() then
		return MyAddon.hooks.TradeSkillSkillButton_OnClick(self, button)
	end
	
	if ( button ~= "LeftButton" ) then
		return
	end

	local oldid, newid
	if self.header then
		-- a header clicked, do a rescan
		oldid = GetTradeSkillSelectionIndex()
		MyAddon:Scan(self:GetID())
		
		for k,v in ipairs(MyAddon.rdb) do
			if v == oldid then
				-- old selected item is visible
				newid = v
			end
			if v > oldid and not newid then
				-- old item isn't visible anymore
				local skillname, skilltype = GetTradeSkillInfo(v)
				if skilltype ~= "header" then
					-- select first item after old item
					newid = v
				end
			end
		end
		
		if not newid then
			-- if we found an id, set as selected
			TradeSkillFrame_SetSelection(GetFirstTradeSkill())
		else
			-- select first visible
			TradeSkillFrame_SetSelection(newid)
		end
	else
		-- direct click on a item, select it
		TradeSkillFrame_SetSelection(self:GetID());
	end

	TradeSkillFrame_Update();
end

function MyAddon:TradeSkillFrame_Update(this, ...)
	if not MyAddonframe.enablebutton:GetChecked() then
		return MyAddon.hooks.TradeSkillFrame_Update(this,...)
	end
	
	if not TradeSkillFrame:IsVisible() then
		return
	end
	
	if MyAddon.Scanning or MyAddon.Updating then
		-- expand collapse protection from MyAddon:Scan()
		return
	end

	MyAddon.Updating = true;
	
	local name, rank, maxRank = GetTradeSkillLine();
        
	if ( CURRENT_TRADESKILL ~= name ) then
		StopTradeSkillRepeat();
		if ( CURRENT_TRADESKILL ~= "" ) then
			-- To fix problem with switching between two tradeskills
			UIDropDownMenu_Initialize(TradeSkillInvSlotDropDown, TradeSkillInvSlotDropDown_Initialize);
			UIDropDownMenu_SetSelectedID(TradeSkillInvSlotDropDown, 1);

			UIDropDownMenu_Initialize(TradeSkillSubClassDropDown, TradeSkillSubClassDropDown_Initialize);
			UIDropDownMenu_SetSelectedID(TradeSkillSubClassDropDown, 1);
		end
		CURRENT_TRADESKILL = name;
	end

	local skillName, skillType, numAvailable, isExpanded, altVerb;
	
	local numTradeSkills = #MyAddon.rdb;
	local skillOffset = FauxScrollFrame_GetOffset(TradeSkillListScrollFrame);
	-- If no tradeskills
	if ( numTradeSkills == 0 ) then
		TradeSkillFrameTitleText:SetFormattedText(TRADE_SKILL_TITLE, GetTradeSkillLine());
		TradeSkillSkillName:Hide();
--		TradeSkillSkillLineName:Hide();
		TradeSkillSkillIcon:Hide();
		TradeSkillRequirementLabel:Hide();
		TradeSkillRequirementText:SetText("");
		TradeSkillCollapseAllButton:Disable();
		for i=1, MAX_TRADE_SKILL_REAGENTS, 1 do
			_G["TradeSkillReagent"..i]:Hide();
		end
	else
		TradeSkillSkillName:Show();
--		TradeSkillSkillLineName:Show();
		TradeSkillSkillIcon:Show();
		TradeSkillCollapseAllButton:Enable();
	end

	if ( rank < 75 ) and ( not IsTradeSkillLinked() ) then
		TradeSkillFrameEditBox:Hide();
		SetTradeSkillItemNameFilter("");	--In case they are switching from an inspect WITH a filter directly to their own without.
	else
		TradeSkillFrameEditBox:Show();
	end
	-- ScrollFrame update
	FauxScrollFrame_Update(TradeSkillListScrollFrame, numTradeSkills, TRADE_SKILLS_DISPLAYED, TRADE_SKILL_HEIGHT, nil, nil, nil, TradeSkillHighlightFrame, 293, 316 );
	
	TradeSkillHighlightFrame:Hide();
	local skillIndex, skillButton, skillButtonText, skillButtonCount;
	local nameWidth, countWidth;
	
	local skillNamePrefix = " ";
	for i=1, TRADE_SKILLS_DISPLAYED, 1 do
		skillIndex = i + skillOffset;
		skillButton = _G["TradeSkillSkill"..i];
		skillButtonText = _G["TradeSkillSkill"..i.."Text"];
		skillButtonCount = _G["TradeSkillSkill"..i.."Count"];
		if ( skillIndex <= numTradeSkills ) then
			skillName, skillType, numAvailable, isExpanded, altVerb = GetTradeSkillInfo(MyAddon.rdb[skillIndex]);
			-- Set button widths if scrollbar is shown or hidden
			if ( TradeSkillListScrollFrame:IsShown() ) then
				skillButton:SetWidth(293);
			else
				skillButton:SetWidth(323);
			end
			local color = TradeSkillTypeColor[skillType];
			if ( color ) then
				skillButton:SetNormalFontObject(color.font);
				skillButtonCount:SetVertexColor(color.r, color.g, color.b);
				skillButton.r = color.r;
				skillButton.g = color.g;
				skillButton.b = color.b;
			end
			
			if ( ENABLE_COLORBLIND_MODE == "1" ) then
				skillNamePrefix = TradeSkillTypePrefix[skillType] or " ";
			end
			
			skillButton:SetID(MyAddon.rdb[skillIndex]);
			skillButton:Show();
			-- Handle headers
			if ( skillType == "header" ) then
				skillButton.header = true
				skillButton:SetText(skillName);
				skillButtonText:SetWidth(TRADE_SKILL_TEXT_WIDTH);
				skillButtonCount:SetText("");
				if ( MyAddon.headeridx[CURRENT_TRADESKILL][MyAddon.rdb[skillIndex]] ) then
					-- expanded
					skillButton:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up");
				else
					-- collapsed
					skillButton:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up");
				end
				_G["TradeSkillSkill"..i.."Highlight"]:SetTexture("Interface\\Buttons\\UI-PlusButton-Hilight");
				_G["TradeSkillSkill"..i]:UnlockHighlight();
			else
				if ( not skillName ) then
					MyAddon.Updating = nil;
					return;
				end
				skillButton.header = nil
				skillButton:SetNormalTexture("");
				_G["TradeSkillSkill"..i.."Highlight"]:SetTexture("");
				if ( numAvailable <= 0 ) then
					skillButton:SetText(skillNamePrefix..skillName);
					skillButtonText:SetWidth(TRADE_SKILL_TEXT_WIDTH);
					skillButtonCount:SetText(skillCountPrefix);
				else
					skillName = skillNamePrefix..skillName;
					skillButtonCount:SetText("["..numAvailable.."]");
					TradeSkillFrameDummyString:SetText(skillName);
					nameWidth = TradeSkillFrameDummyString:GetWidth();
					countWidth = skillButtonCount:GetWidth();
					skillButtonText:SetText(skillName);
					if ( nameWidth + 2 + countWidth > TRADE_SKILL_TEXT_WIDTH ) then
						skillButtonText:SetWidth(TRADE_SKILL_TEXT_WIDTH-2-countWidth);
					else
						skillButtonText:SetWidth(0);
					end
				end
				
				-- Place the highlight and lock the highlight state
				if ( GetTradeSkillSelectionIndex() == MyAddon.rdb[skillIndex] ) then
					TradeSkillHighlightFrame:SetPoint("TOPLEFT", "TradeSkillSkill"..i, "TOPLEFT", 0, 0);
					TradeSkillHighlightFrame:Show();
					skillButtonCount:SetVertexColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
					skillButton:LockHighlight();
					skillButton.isHighlighted = true;
				else
					skillButton:UnlockHighlight();
					skillButton.isHighlighted = false;
				end
			end
			
		else
			skillButton:Hide();
		end
	end
	
	-- Set the expand/collapse all button texture
	local numHeaders = 0;
	for i=1, numTradeSkills, 1 do
		local skillName, skillType, numAvailable, isExpanded, altVerb = GetTradeSkillInfo(MyAddon.rdb[i]);
		if ( skillName and skillType == "header" ) then
			numHeaders = numHeaders + 1;
		end
		if ( GetTradeSkillSelectionIndex() == MyAddon.rdb[i] ) then
			-- Set the max makeable items for the create all button
			TradeSkillFrame.numAvailable = math.abs(numAvailable);
		end
	end
	-- If all headers are not expanded then show collapse button, otherwise show the expand button
	if ( numTradeSkills ~= numHeaders ) then
		MyAddon.cAll[GetTradeSkillLine()] = nil
		TradeSkillCollapseAllButton:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up");
	else
		MyAddon.cAll[GetTradeSkillLine()] = true
		TradeSkillCollapseAllButton:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up");
	end
	
	MyAddon.Updating = nil;
	scandone = nil
end

function MyAddon:TradeSkillCollapseAllButton_OnClick(self)
	if not MyAddonframe.enablebutton:GetChecked() then
		return TradeSkillCollapseAllButton_OnClick_Script(self)
	end
	
	local collids = {}
	
	local addheader, skillName, skillType

	for i=GetNumTradeSkills(), 1, -1  do
		skillName, skillType = GetTradeSkillInfo(i)

		if skillType == "header" then --header
			if not collids[skillName] then 
				collids[skillName] = 1
			else
				collids[skillName] = collids[skillName] +1
			end

			if addheader then
				if MyAddon.cAll[GetTradeSkillLine()] then
					MyAddon.cHeader[CURRENT_TRADESKILL][skillName.. tostring(collids[skillName])] = "expanded"
				else
					MyAddon.cHeader[CURRENT_TRADESKILL][skillName.. tostring(collids[skillName])] = "collapsed"
				end
				addheader = nil
			end
		end
		
		if TradeSkillLevel[skillType] >= TradeSkillNeed  then
			addheader = true
		end
	end

	
	if (MyAddon.cAll[GetTradeSkillLine()] ) then
		--expand all headers
		MyAddon.cAll[GetTradeSkillLine()] = nil
	else
		MyAddon.cAll[GetTradeSkillLine()] = true
		-- collapse all headers
	end
	
	MyAddon:update()
end

-- User Functions

function MyAddon:update(event,...)
	if not MyAddonframe.enablebutton:GetChecked() or not TradeSkillFrame:IsVisible() then
		-- addon not active
		return
	end
	

	if event == "TRADE_SKILL_FILTER_UPDATE" then
		-- reset header visible filter
		MyAddon.header[GetTradeSkillLine()] = {}
	end

	-- Update data and display it
	MyAddon:Scan()
	TradeSkillFrame_Update()
end

function MyAddon:Scan(id)
	-- id is only set, if we clicked on a header
	
	if MyAddon.Scanning then
		return
	end
	
	MyAddon.Scanning = true;
	MyAddon.Updating = true;

	if not MyAddon.ScanNr then
		MyAddon.ScanNr = 1
	else
		MyAddon.ScanNr = MyAddon.ScanNr + 1
	end

	
	local CURRENT_TRADESKILL = GetTradeSkillLine();
	
	if not MyAddon.headeridx[CURRENT_TRADESKILL] then
		MyAddon.headeridx[CURRENT_TRADESKILL] = {}
	end
	if not MyAddon.cHeader[CURRENT_TRADESKILL] then
		MyAddon.cHeader[CURRENT_TRADESKILL] = {}
	end
	if not MyAddon.header[CURRENT_TRADESKILL] then
		MyAddon.header[CURRENT_TRADESKILL] = {}
	end
	
	
	local NumCHeaders = 0
	local ids = {}
	local curHeader, addskills
	local skillName, skillType, _, isExpanded
	
	-- check all headers
	for i= GetNumTradeSkills(), 1, -1 do
		skillName, skillType, _, isExpanded = GetTradeSkillInfo(i)
		if skillType == "header" then --header
			if not ids[skillName] then 
				ids[skillName] = 1
			else
				ids[skillName] = ids[skillName] +1
			end
			ids.id = ids[skillName]
			curHeader = skillName .. tostring(ids.id)
			if not MyAddon.header[CURRENT_TRADESKILL][curHeader] then
				-- curHeader not found, add them
				MyAddon.header[CURRENT_TRADESKILL][curHeader] = 0
			end

			if isExpanded == nil then
				if not MyAddon.cHeader[CURRENT_TRADESKILL][curHeader] then
					-- back up collapsed status for virtual list, because it is faster
					MyAddon.cHeader[CURRENT_TRADESKILL][curHeader] = "collapsed"
				end
				NumCHeaders = NumCHeaders + 1
			else
				if not MyAddon.cHeader[CURRENT_TRADESKILL][curHeader] then
					-- back up collapsed status for virtual list, because it is faster
					MyAddon.cHeader[CURRENT_TRADESKILL][curHeader] = "expanded"
				end
			end
		end
	end
	
	-- in background all headers are expanded, so we expand them all
	if NumCHeaders > 0 then
			ExpandTradeSkillSubClass(0);
	end


	local collids = {}
	
	local addheader
	-- scan in collapsed headers with skillable skills
	for i=GetNumTradeSkills(), 1, -1  do
		skillName, skillType = GetTradeSkillInfo(i)

		if skillType == "header" then --header
			if not collids[skillName] then 
				collids[skillName] = 1
			else
				collids[skillName] = collids[skillName] +1
			end

			if addheader then
				if MyAddon.header[CURRENT_TRADESKILL][skillName .. tostring(collids[skillName])] == 0 then
					MyAddon.header[CURRENT_TRADESKILL][skillName .. tostring(collids[skillName])] = 1
				end
				addheader = nil
			else
				MyAddon.header[CURRENT_TRADESKILL][skillName .. tostring(collids[skillName])] = -1
			end
		end
		
		if TradeSkillLevel[skillType] >= TradeSkillNeed  then
			addheader = true
		end
	end
	

	
	-- scan all shown skills
	MyAddon.rdb = {}
	local j = 1
	for i=1, GetNumTradeSkills() do
		skillName, skillType = GetTradeSkillInfo(i)

		if skillType == "header" then -- header
			if i == id then
				-- we clicked on a header - toggle status
				if MyAddon.cHeader[CURRENT_TRADESKILL][skillName.. tostring(ids[skillName])] == "collapsed" then
					MyAddon.cHeader[CURRENT_TRADESKILL][skillName.. tostring(ids[skillName])] = "expanded"
				else
					MyAddon.cHeader[CURRENT_TRADESKILL][skillName.. tostring(ids[skillName])] = "collapsed"
				end
			end
			
			
			-- create a numeric index for expand/collapsed status in TradeSkillFrame_Update
			if MyAddon.cHeader[CURRENT_TRADESKILL][skillName.. tostring(ids[skillName])] == "expanded" then
				MyAddon.headeridx[CURRENT_TRADESKILL][i] = 1
			else
				MyAddon.headeridx[CURRENT_TRADESKILL][i] = nil
			end
			
			if MyAddon.header[CURRENT_TRADESKILL][skillName.. tostring(ids[skillName])] > 0 then
				-- header with skills, add to list
				MyAddon.rdb[j] = i
				j = j +1
				if MyAddon.cHeader[CURRENT_TRADESKILL][skillName.. tostring(ids[skillName])] == "collapsed" then
					addskills = nil
				else
					-- show skill in header
					addskills = true
				end
			end
			ids[skillName] = ids[skillName] - 1
		elseif TradeSkillLevel[skillType] >= TradeSkillNeed and addskills then
			MyAddon.rdb[j] = i
			j = j +1
		end
	end
	
	
	MyAddon.Scanning = nil;
	MyAddon.Updating = nil;
	scandone = true
end

function MyAddon:InitFrames()

		-- main frame
		MyAddonframe.mainframe = CreateFrame("Frame", "CrafthelperFrame")
		MyAddonframe.mainframe:SetBackdrop({
			bgFile="Interface\\Tooltips\\UI-Tooltip-Background",
			edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile = true, edgeSize = 16, tileSize = 16,
			insets = { left= 4, right = 4, top = 4, bottom = 4 }
		})
		MyAddonframe.mainframe:SetBackdropColor(TOOLTIP_DEFAULT_BACKGROUND_COLOR.r,TOOLTIP_DEFAULT_BACKGROUND_COLOR.g,TOOLTIP_DEFAULT_BACKGROUND_COLOR.b)
		MyAddonframe.mainframe:SetHeight(66)
		MyAddonframe.mainframe:Hide()
		MyAddonframe.mainframe:Show()
		MyAddonframe.mainframe:ClearAllPoints()
		MyAddonframe.mainframe:SetParent(TradeSkillFrame)
		MyAddonframe.mainframe:SetPoint("TOPLEFT",TradeSkillFrame, "BOTTOMLEFT", 10,70)
		MyAddonframe.mainframe:SetPoint("TOPRIGHT",TradeSkillFrame, "BOTTOMRIGHT", -35,70)

		MyAddonframe.title = CreateFrame("Frame", "CrafthelperFrameTitle", MyAddonframe.mainframe)
		MyAddonframe.title:SetHeight(32)
		MyAddonframe.title:ClearAllPoints()
		MyAddonframe.title:SetPoint("TOPLEFT",MyAddonframe.mainframe, "TOPLEFT", 3,-3)
		MyAddonframe.title:SetPoint("TOPRIGHT",MyAddonframe.mainframe, "TOPRIGHT", -3,-3)
		MyAddonframe.title:SetBackdrop({
--			bgFile="Interface\\Tooltips\\UI-Tooltip-Background",
			edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile = true, edgeSize = 16, tileSize = 16,
			insets = { left= 4, right = 4, top = 4, bottom = 4 }
		})
		MyAddonframe.title:Show()
		MyAddonframe.title:SetBackdropBorderColor(TOOLTIP_DEFAULT_BACKGROUND_COLOR.r,TOOLTIP_DEFAULT_BACKGROUND_COLOR.g,TOOLTIP_DEFAULT_BACKGROUND_COLOR.b)
--		MyAddonframe.title:SetBackdropColor(TOOLTIP_DEFAULT_BACKGROUND_COLOR.r,TOOLTIP_DEFAULT_BACKGROUND_COLOR.g,TOOLTIP_DEFAULT_BACKGROUND_COLOR.b)

		MyAddonframe.title.Text = MyAddonframe.title:CreateFontString("CrafthelperFrameTitleText","BACKGROUND","GameFontNormal")
		MyAddonframe.title.Text:SetPoint("LEFT",10,0.5)
		MyAddonframe.title.Text:SetAlpha(1)
		MyAddonframe.title.Text:SetText(L["crafthelper"])
		
		MyAddonframe.title.about = MyAddonframe.title:CreateFontString("CrafthelperFrameTitleText","BACKGROUND","GameFontNormalSmall")
		MyAddonframe.title.about:SetPoint("LEFT",MyAddonframe.title.Text:GetWidth() + 10,0)
		MyAddonframe.title.about:SetAlpha(1)
		MyAddonframe.title.about:SetText(L["about"])
		
		MyAddonframe.options = CreateFrame("Frame", "CrafthelperFrameOptions", MyAddonframe.mainframe)
		MyAddonframe.options:ClearAllPoints()
		MyAddonframe.options:SetPoint("TOPLEFT",MyAddonframe.mainframe, "TOPLEFT", 3,-3)
		MyAddonframe.options:SetPoint("TOPRIGHT",MyAddonframe.mainframe, "TOPRIGHT", -3,-3)
		MyAddonframe.options:SetPoint("BOTTOMLEFT",MyAddonframe.mainframe, "BOTTOMLEFT", 3,3)
		MyAddonframe.options:SetPoint("BOTTOMRIGHT",MyAddonframe.mainframe, "BOTTOMRIGHT", -3,3)
		MyAddonframe.options:SetBackdrop({
--			bgFile="Interface\\Tooltips\\UI-Tooltip-Background",
			edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile = true, edgeSize = 16, tileSize = 16,
			insets = { left= 4, right = 4, top = 4, bottom = 4 }
		})
		MyAddonframe.options:Show()
		MyAddonframe.options:SetBackdropBorderColor(TOOLTIP_DEFAULT_BACKGROUND_COLOR.r,TOOLTIP_DEFAULT_BACKGROUND_COLOR.g,TOOLTIP_DEFAULT_BACKGROUND_COLOR.b)
		
		
		MyAddonframe.enablebutton = CreateFrame("CheckButton", "CraftHelperEnableButton", MyAddonframe.options , "UICheckButtonTemplate")
		MyAddonframe.enablebutton:ClearAllPoints()
		MyAddonframe.enablebutton:SetPoint("BOTTOMLEFT",MyAddonframe.mainframe, "BOTTOMLEFT", 7,7)
		MyAddonframe.enablebutton:Show()
		MyAddonframe.enablebutton:SetHeight(24)
		MyAddonframe.enablebutton:SetWidth(24)
		MyAddonframe.enablebutton:SetScript("OnClick", function()
			
			if not MyAddonframe.enablebutton:GetChecked() then
				return MyAddon:RestoreTradeSkill(GetTradeSkillLine())
			end
			
			MyAddon:Scan()
			TradeSkillFrame_Update()
		end)

		MyAddonframe.enablebutton.text = getglobal("CraftHelperEnableButtonText")
		MyAddonframe.enablebutton.text:SetText(L["only_show"])
		
		MyAddonframe.skill = CreateFrame("Frame", "CraftHelperSkillSelect", MyAddonframe.options , "UIDropDownMenuTemplate")
		UIDropDownMenu_Initialize(MyAddonframe.skill, MyAddon.InitSkillSelect)---, "MENU");
		UIDropDownMenu_SetSelectedValue(MyAddonframe.skill, 1);
		MyAddonframe.skill:ClearAllPoints()
		MyAddonframe.skill:SetPoint("TOPLEFT",MyAddonframe.mainframe, "TOPLEFT", 185,-32)
		MyAddonframe.skill:Show()
		MyAddonframe.skill:SetHeight(24)
		MyAddonframe.skill:SetWidth(24)
		MyAddonframe.skill:Show()
		
end

function MyAddon:InitSkillSelect(this)
	local CraftHelperSkillSelect = MyAddonframe.skill
	local info = UIDropDownMenu_CreateInfo();
	table.sort(TradeSkillLevel)
	
	local selectedValue = UIDropDownMenu_GetSelectedValue(CraftHelperSkillSelect);
	if not selectedValue then
		TradeSkillNeed = 1
		selectedValue = 1
	end

	for name, level in pairs(TradeSkillLevel) do
		if level >= 0 then
			info.text = L[name];
			info.func = function(this) 
					if not this.value then
						return
					end
					UIDropDownMenu_SetSelectedValue(CraftHelperSkillSelect,this.value);
					if this.value < TradeSkillNeed then
						MyAddon.header[GetTradeSkillLine()] = {}
					end
					TradeSkillNeed = this.value
					
					if MyAddonframe.enablebutton:GetChecked() then
						MyAddon:update()
						if GetFirstTradeSkill() ~= GetTradeSkillSelectionIndex() then
							TradeSkillFrame_SetSelection(GetFirstTradeSkill());
						end
					else
						TradeSkillFrame_Update()
					end
				end;
			info.value = level;
			info.tooltipTitle = L[name];
			info.tooltipText = L[name];
			if ( info.value == selectedValue ) then
				info.checked = 1;
			else
				info.checked = nil;
			end
			UIDropDownMenu_AddButton(info);
		end
	end
end

function MyAddon:RestoreTradeSkill(TradeSkillName)

	if (not MyAddon.cHeader[TradeSkillName]) or type(MyAddon.cHeader[TradeSkillName]) ~= 'table' then
		return
	end
	
	local NumHeaders = 0
	local NumHeadersCollapsed = 0
	for k,v in pairs (MyAddon.cHeader[TradeSkillName]) do
		if v == "collapsed" then
			NumHeadersCollapsed = NumHeadersCollapsed +1
		end
		NumHeaders = NumHeaders +1
	end
	
	local skillName, skillType
	local ids = {}
	
	-- by default all headers are expanded
	if (NumHeaders/2) > NumHeadersCollapsed then
		-- only collapse collapsed headers
		for i=GetNumTradeSkills(),1 , -1 do
			skillName, skillType = GetTradeSkillInfo(i)
			if not ids[skillName] then 
				ids[skillName] = 1
			else
				ids[skillName] = ids[skillName] +1
			end
			
			if MyAddon.cHeader[TradeSkillName][skillName .. tostring(ids[skillName])] == "collapsed" then
				CollapseTradeSkillSubClass(i)
			end
		end
	else
		-- collapse all and open the expanded headers
		CollapseTradeSkillSubClass(0)
		for i=GetNumTradeSkills(),1 , -1 do
			skillName = GetTradeSkillInfo(i)
			if not ids[skillName] then 
				ids[skillName] = 1
			else
				ids[skillName] = ids[skillName] +1
			end
			
			if MyAddon.cHeader[TradeSkillName][skillName .. tostring(ids[skillName])] == "expanded" then
				ExpandTradeSkillSubClass(i)
			end
		end
	end
	MyAddon.cHeader[TradeSkillName] = nil
	MyAddon.header[TradeSkillName] = nil
	
	TradeSkillFrame_Update()
end
