﻿CooldownCount = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "AceHook-2.1", "AceConsole-2.0")
local L = AceLibrary("AceLocale-2.2"):new("CooldownCount")
local SM = AceLibrary("SharedMedia-1.0")
local blacklist = { "TargetFrame", "PetAction" }

function CooldownCount:OnInitialize()
	self:RegisterDB("CooldownCountDB")
	self:RegisterDefaults("profile", {
		shine = false,
		shineScale = 2,
		minimumDuration = 3,
		hideAnimation = false,
		font = "Friz Quadrata TT",
		color1 = {r=1, g=1, b=0.2},
		color2 = {r=1, g=0, b=0},
		size = {[1] = 18, [2] = 24, [3] = 28, [4] = 34},
	})
	self:RegisterChatCommand(
		{ "/cooldowncount", "/cc" },
		{
			type = "group",
			args = {
				shine = {
					type = "toggle",
					name = L["shine"],
					desc = L["Toggle icon shine display after finish cooldown."],
					get = function() return self.db.profile.shine end,
					set = function(t) self.db.profile.shine = t end
				},
				shinescale = {
					type = "range",
					name = L["shinescale"],
					desc = L["Adjust icon shine scale."],
					min = 0,
					max = 100,
					step = 0.1,
					get = function() return self.db.profile.shineScale end,
					set = function(r) self.db.profile.shineScale = r end
				},
				minimum_duration = {
					type = "range",
					name = L["minimum duration"],
					desc = L["Minimum duration for display cooldown count."],
					min = 0.5,
					max = 100,
					step = 0.5,
					get = function() return self.db.profile.minimumDuration end,
					set = function(r) self.db.profile.minimumDuration = r end
				},
				hide_animation = {
					type = "toggle",
					name = L["hide animation"],
					desc = L["Hide Bliz origin cooldown animation."],
					get = function() return self.db.profile.hideAnimation end,
					set = function(t) 
						self.db.profile.hideAnimation = t
						self:UnhookAll()
						self:OnEnable()
					end
				},
				font = {
					type = "text",
					name = L["font"],
					desc = L["Set cooldown value display font."],
					get = function() return self.db.profile.font end,
					set = function(f) self.db.profile.font = f end,
					validate = SM:List('font'),
				},
				color1 = {
					type = "color",
					name = L["common color"],
					desc = L["Setup the common color for value display."],
					get = function() return self.db.profile.color1.r, self.db.profile.color1.g, self.db.profile.color1.b end,
					set = function(r, g, b, a) self.db.profile.color1.r, self.db.profile.color1.g, self.db.profile.color1.b = r, g, b end,
				},
				color2 = {
					type = "color",
					name = L["warning color"],
					desc = L["Setup the warning color for value display."],
					get = function() return self.db.profile.color2.r, self.db.profile.color2.g, self.db.profile.color2.b end,
					set = function(r, g, b, a) self.db.profile.color2.r, self.db.profile.color2.g, self.db.profile.color2.b = r, g, b end,
				},
				size = {
					type = "group",
					name = L["font size"],
					desc = L["Setup cooldown value display font size."],
					args = {
						small = {
							type = "range",
							name = L["small size"],
							desc = L["Small font size for cooldown is longer than 10 minutes."],
							min = 10,
							max = 45,
							step = 1,
							get = function() return self.db.profile.size[1] end,
							set = function(r) self.db.profile.size[1] = r end
						},
						medium = {
							type = "range",
							name = L["medium size"],
							desc = L["Medium font size for cooldown is longer than 1 minute and less than 10 minutes."],
							min = 10,
							max = 45,
							step = 1,
							get = function() return self.db.profile.size[2] end,
							set = function(r) self.db.profile.size[2] = r end
						},
						large = {
							type = "range",
							name = L["large size"],
							desc = L["Large font size for cooldown is longer than 10 seconds and less than 1 minutes."],
							min = 10,
							max = 45,
							step = 1,
							get = function() return self.db.profile.size[3] end,
							set = function(r) self.db.profile.size[3] = r end
						},
						warn = {
							type = "range",
							name = L["warning size"],
							desc = L["Warning font size for cooldown is less than 10 seconds."],
							min = 10,
							max = 45,
							step = 1,
							get = function() return self.db.profile.size[4] end,
							set = function(r) self.db.profile.size[4] = r end
						}
					}
				}
			}
		}
	)
end

function CooldownCount:OnEnable()
	if self.db.profile.hideAnimation then
		self:Hook("CooldownFrame_SetTimer", "CooldownFrame_SetTimer_HideAnimation", true)
	else
		self:SecureHook("CooldownFrame_SetTimer")
	end
end

function CooldownCount:CooldownFrame_SetTimer_HideAnimation(cooldownFrame, start, duration, enable)
	if CooldownCount:CheckBlacklist(cooldownFrame:GetName()) then
		self.hooks.CooldownFrame_SetTimer(cooldownFrame, start, duration, enable)
		return
	end

	cooldownFrame:Hide()

	if start > 0 and duration > self.db.profile.minimumDuration and enable > 0 then
		local cooldownCount = cooldownFrame.textFrame or CooldownCount:CreateCooldownCount(cooldownFrame, start, duration)
		cooldownCount.start = start
		cooldownCount.duration = duration
		cooldownCount.timeToNextUpdate = 0
		cooldownCount:Show()
	elseif cooldownFrame.textFrame then
		cooldownFrame.textFrame:Hide()
	end
end

function CooldownCount:CooldownFrame_SetTimer(cooldownFrame, start, duration, enable)
	if CooldownCount:CheckBlacklist(cooldownFrame:GetName()) then
		return
	end

	if start > 0 and duration > self.db.profile.minimumDuration and enable > 0 then
		local cooldownCount = cooldownFrame.textFrame or CooldownCount:CreateCooldownCount(cooldownFrame, start, duration)
		cooldownCount.start = start
		cooldownCount.duration = duration
		cooldownCount.timeToNextUpdate = 0
		cooldownCount:Show()
	elseif cooldownFrame.textFrame then
		cooldownFrame.textFrame:Hide()
	end
end

function CooldownCount:CreateCooldownCount(cooldown, start, duration)
	local textFrame = CreateFrame("Frame", nil, cooldown:GetParent())
	cooldown.textFrame = textFrame

	textFrame:SetAllPoints(cooldown:GetParent())
	textFrame:SetFrameLevel(cooldown.textFrame:GetFrameLevel() + 1)

	textFrame.text = cooldown.textFrame:CreateFontString(nil, "OVERLAY")
	textFrame.text:SetPoint("CENTER", cooldown.textFrame, "CENTER", 0, -1)

	textFrame.icon =
		--standard action button icon, $parentIcon
		getglobal(cooldown:GetParent():GetName() .. "Icon") or
		--standard item button icon,  $parentIconTexture
		getglobal(cooldown:GetParent():GetName() .. "IconTexture") or
		--discord action button, $parent_Icon
		getglobal(cooldown:GetParent():GetName() .. "_Icon")

	if textFrame.icon then
		textFrame:SetScript("OnUpdate", CooldownCount.Text_OnUpdate)
	end

	textFrame:Hide()

	return textFrame
end

function CooldownCount:Text_OnUpdate()
	if this.timeToNextUpdate <= 0 or not this.icon:IsVisible() then
		--i still havn't any idea for it
		if GetTime() < this.start then return end
		local remain = this.duration - (GetTime() - this.start)

		if floor(remain + 0.5) > 0 and this.icon:IsVisible() then
			local text, toNextUpdate, size, twoColor = CooldownCount:GetFormattedTime(remain)
			this.text:SetFont(SM:Fetch('font', CooldownCount.db.profile.font), size, "OUTLINE")

			color = CooldownCount.db.profile.color1
			if twoColor then
				if this.twoColor then
					color = CooldownCount.db.profile.color2
					this.twoColor = nil
				else
					this.twoColor = true
				end
			end
			this.text:SetTextColor(color.r, color.g, color.b)

			this.text:SetText( text )
			this.timeToNextUpdate = toNextUpdate
		else
			if CooldownCount.db.profile.shine and this.icon:IsVisible() then
				CooldownCount:StartToShine(this);
			end
			this.twoColor = nil
			this:Hide()
		end
	else
		this.timeToNextUpdate = this.timeToNextUpdate - arg1
	end
end

function CooldownCount:GetFormattedTime(secs)
	-- return cc now value, next update value, font size, toggle two color
	if secs >= 86400 then
		return ceil(secs / 86400) .. L["d"], mod(secs, 86400), CooldownCount.db.profile.size[1]
	elseif secs >= 3600 then
		return ceil(secs / 3600) .. L["h"], mod(secs, 3600), CooldownCount.db.profile.size[1]
	elseif secs >= 600 then
		return ceil(secs / 60) .. L["m"], mod(secs, 60), CooldownCount.db.profile.size[1]
	elseif secs >= 60 then
		return ceil(secs / 60) .. L["m"], mod(secs, 60), CooldownCount.db.profile.size[2]
	elseif secs >= 10 then
		return floor(secs + 0.5), secs - floor(secs), CooldownCount.db.profile.size[3]
	end
	return floor(secs + 0.5), 0.5, CooldownCount.db.profile.size[4], true
end


--[[ Shine Codes ]]--
function CooldownCount:StartToShine(textFrame)
	local shineFrame = textFrame.shine or CooldownCount:CreateShineFrame(textFrame:GetParent())

	shineFrame.shine:SetAlpha(shineFrame:GetParent():GetAlpha())
	shineFrame.shine:SetHeight(shineFrame:GetHeight() * CooldownCount.db.profile.shineScale)
	shineFrame.shine:SetWidth(shineFrame:GetWidth() * CooldownCount.db.profile.shineScale)

	shineFrame:Show()
end

function CooldownCount:CreateShineFrame(parent)
	local shineFrame = CreateFrame("Frame", nil, parent)
	shineFrame:SetAllPoints(parent)

	local shine = shineFrame:CreateTexture(nil, "OVERLAY")
	shine:SetTexture("Interface\\Cooldown\\star4")
	shine:SetPoint("CENTER", shineFrame, "CENTER")
	shine:SetBlendMode("ADD")
	shineFrame.shine = shine

	shineFrame:Hide()
	shineFrame:SetScript("OnUpdate", CooldownCount.Shine_Update)
	shineFrame:SetAlpha(parent:GetAlpha())

	return shineFrame
end

function CooldownCount:Shine_Update()
	local shine = this.shine
	local alpha = shine:GetAlpha()
	shine:SetAlpha(alpha * 0.95)

	if alpha < 0.1 then
		this:Hide()
	else
		shine:SetHeight(alpha * this:GetHeight() * CooldownCount.db.profile.shineScale)
		shine:SetWidth(alpha * this:GetWidth() * CooldownCount.db.profile.shineScale)
	end
end

function CooldownCount:CheckBlacklist(frameName)
	if not frameName or getglobal(frameName).noCooldownCount then
		return true
	end
	for _, v in ipairs(blacklist) do
		if strfind(frameName, v) then
			getglobal(frameName).noCooldownCount=1
			return true
		end
	end
end
