--[[--------------------------------------------------------------------
	ConfirmLeaveParty
	Asks for confirmation when leaving a group inside an instance.
	Written by Phanx <addons@phanx.net>
	http://www.wowinterface.com/downloads/info16676-ConfirmLeaveParty.html
	http://www.curse.com/addons/wow/confirmleaveparty
----------------------------------------------------------------------]]

local CONFIRM_LEAVE_PARTY = "Do you really want to leave the group?"

if GetLocale() == "deDE" then
	CONFIRM_LEAVE_PARTY = "Willst du wirklich die Gruppe verlassen?" -- by Shantalya @ WoWI
elseif GetLocale() == "esES" or GetLocale() == "esMX" then
	CONFIRM_LEAVE_PARTY = "¿Realmente quiere dejar el grupo?" -- by Google Translate
elseif GetLocale() == "frFR" then
	CONFIRM_LEAVE_PARTY = "Veux-tu vraiment à quitter le groupe?" -- by Google Translate
elseif GetLocale() == "itIT" then
	CONFIRM_LEAVE_PARTY = "Vuoi lasciare veramente il gruppo?" -- by Google Translate
elseif GetLocale() == "ptBR" then
	CONFIRM_LEAVE_PARTY = "Tem certeza de que deseja sair o grupo?" -- by Google Translate
elseif GetLocale() == "ruRU" then
	CONFIRM_LEAVE_PARTY = "Вы действительно хотите выйти из группы?" -- by Google Translate
elseif GetLocale() == "koKR" then
	CONFIRM_LEAVE_PARTY = "당신이 정말로 그룹을 떠나시겠습니까?" -- by Google Translate
elseif GetLocale() == "zhCN" then
	CONFIRM_LEAVE_PARTY = "难道你真的想离开组吗?" -- by Google Translate
elseif GetLocale() == "zhTW" then
	CONFIRM_LEAVE_PARTY = "難道你真的想離開組嗎?" -- by Google Translate
end

------------------------------------------------------------------------

local ReallyLeaveParty = LeaveParty

StaticPopupDialogs["CONFIRM_LEAVE_PARTY"] = {
	text = CONFIRM_LEAVE_PARTY,
	button1 = YES,
	button2 = NO,
	enterClicksFirstButton = 1, -- YES on enter
	hideOnEscape = 1, -- NO on escape
	timeout = 0,
	preferredIndex = 3, -- helps prevent taint; see http://forums.wowace.com/showthread.php?t=19960
	OnAccept = ReallyLeaveParty,
}

LeaveParty = function()
	local _, instanceType = IsInInstance()
	if instanceType == "party" or instanceType == "raid" then
		local check
		if IsInRaid then
			-- Mists of Pandaria
			check = IsInGroup() or IsInRaid()
		else
			-- Cataclysm
			check = GetNumPartyMembers() > 0 or GetNumRaidMembers() > 0
		end
		if check then
			return StaticPopup_Show("CONFIRM_LEAVE_PARTY")
		end
	end
	ReallyLeaveParty()
end