Claw_Resources = {}

local c = select(2, UnitClass('player'))
local spellGCD, spellAnticipation

if c == 'ROGUE' then
	spellGCD = 2098 -- Eviscerate
	spellAnticipation = (GetSpellInfo(115190))
elseif c == 'DRUID' then
	spellGCD = 33876 -- Mangle
	spellLacerate = (GetSpellInfo(33745))
elseif c == 'PALADIN' then
	spellGCD = 31801 -- Seal of Truth
elseif c == 'MONK' then
	spellGCD = 100780 -- Jab
else
    DisableAddOn('Claw_Resources')
    return
end

SLASH_Claw_Resources1, SLASH_Claw_Resources2 = '/clawres', '/cres'

local function InitializeVariables()
	Claw_Resources.locked = Claw_Resources.locked == nil and false or Claw_Resources.locked
	Claw_Resources.scale = Claw_Resources.scale == nil and 1 or Claw_Resources.scale
	Claw_Resources.frequency = Claw_Resources.frequency == nil and 0.01 or Claw_Resources.frequency
	Claw_Resources.cpalert = Claw_Resources.cpalert == nil and 0 or Claw_Resources.cpalert
	Claw_Resources.hpalert = Claw_Resources.hpalert == nil and 0 or Claw_Resources.hpalert
end

local events = {}

local pointBar = {
	points = {},
	width = 168,
	height = 11,
	max = 0
}

local backDrop = {
    bgFile = 'Interface\\Addons\\Claw_Resources\\white16x16',
    edgeFile = 'Interface\\Addons\\Claw_Resources\\white16x16',
    edgeSize = 1,
    tile = true,
    tileSize = 16
}

local lastUpdate, lastPower = 0, 0
local updaterFrame = CreateFrame('Frame', nil, UIParent)
updaterFrame:SetPoint('TOPLEFT', -1, 1)
updaterFrame:SetSize(0, 0)
local pointFrame = CreateFrame('Frame', 'Claw_PointFrame', UIParent)
pointFrame:SetFrameStrata('BACKGROUND')
pointFrame:SetPoint('CENTER', 0, -222)
pointFrame:SetSize(pointBar.width, pointBar.height)
pointFrame:RegisterForDrag('LeftButton')
pointFrame:SetScript('OnDragStart', pointFrame.StartMoving)
pointFrame:SetScript('OnDragStop', pointFrame.StopMovingOrSizing)
pointFrame:SetMovable(true)
pointFrame:Hide()
for i = 1, 5 do
	pointBar.points[i] = CreateFrame('Frame', nil, pointFrame)
	pointBar.points[i]:SetFrameStrata('BACKGROUND')
	pointBar.points[i]:SetBackdrop(backDrop)
end
local powerFrame = CreateFrame('Frame', 'Claw_PowerFrame', UIParent)
powerFrame:SetFrameStrata('BACKGROUND')
powerFrame:SetPoint('TOPLEFT', pointFrame, 'BOTTOMLEFT', 0, -3)
powerFrame:SetSize(168, 11)
powerFrame:SetBackdrop(backDrop)
powerFrame:SetBackdropColor(0, 0, 0, 0.4)
powerFrame:SetBackdropBorderColor(0, 0, 0, 0.6)
powerFrame:Hide()
local powerBar = CreateFrame('Frame', nil, powerFrame)
powerBar:SetFrameStrata('BACKGROUND')
powerBar:SetPoint('LEFT', 1, 0)
powerBar:SetHeight(9)
powerBar:SetBackdrop(backDrop)
local powerText = powerBar:CreateFontString(nil, 'OVERLAY')
powerText:SetFont('Fonts\\FRIZQT__.TTF', 8, '')
powerText:SetShadowOffset(1, -1)
powerText:SetShadowColor(0, 0, 0, 0.8)
powerText:SetPoint('CENTER', powerFrame)
local pointText = powerBar:CreateFontString(nil, 'OVERLAY')
pointText:SetFont('Fonts\\FRIZQT__.TTF', 8, '')
pointText:SetShadowOffset(1, -1)
pointText:SetShadowColor(0, 0, 0, 0.8)
pointText:SetPoint('CENTER', pointFrame)
local gcdFrame = CreateFrame('Frame', 'Claw_GCDFrame', UIParent)
gcdFrame:SetFrameStrata('BACKGROUND')
gcdFrame:SetPoint('BOTTOMLEFT', pointFrame, 'TOPLEFT', 0, 3)
gcdFrame:SetHeight(4)
gcdFrame:SetBackdrop(backDrop)
gcdFrame:SetBackdropColor(0, 0, 0, 0.4)
gcdFrame:SetBackdropBorderColor(0, 0, 0, 0.6)
gcdFrame:Hide()

function pointBar:setMax(m)
	self.max = m
	local pointWidth = (self.width - (m - 1) * 2) / m
	for i = 1, #self.points do
		if i <= m then
			self.points[i]:SetSize(pointWidth, self.height)
			self.points[i]:SetPoint('LEFT', pointFrame, 'LEFT', (i - 1) * (pointWidth + 2), 0)
			self.points[i]:Show()
		else
			self.points[i]:Hide()
		end
	end
end

local function UpdatePointBar()
	if c == 'DRUID' and UnitPowerType('player') == 1 then
		local _, _, _, stacks, _, _, expires = UnitAura('target', spellLacerate, nil, 'HARMFUL|PLAYER')
		if pointBar.max ~= 3 then
			pointBar:setMax(3)
			pointText:Show()
		end
		for i = 1, 3 do
			if (stacks or 0) >= i then
				pointBar.points[i]:SetBackdropColor(0.73, 0.46, 0.4, 1)
				pointBar.points[i]:SetBackdropBorderColor(0.6, 0, 0, 1)
			else
				pointBar.points[i]:SetBackdropColor(0, 0, 0, 0.6)
				pointBar.points[i]:SetBackdropBorderColor(0, 0, 0, 0.4)
			end
		end
		pointText:SetText(stacks and format('%.1fs', expires - GetTime()))
	elseif c == 'PALADIN' then
		local power = UnitPower('player', 9)
		if pointBar.max ~= 3 then
			pointBar:setMax(3)
		end
		for i = 1, 3 do
			if power >= i then
				pointBar.points[i]:SetBackdropColor(0.8, 0.8, 0, 1)
				pointBar.points[i]:SetBackdropBorderColor(0.9, 0.9, 0.1, 1)
				if Claw_Resources.hpalert > 0 and i == Claw_Resources.hpalert and lastPower == i - 1 then
					PlaySoundFile('Interface\\Addons\\Claw_Resources\\sounds\\' .. math.random(1, 11) .. '.mp3', 'Master')
				end
			else
				pointBar.points[i]:SetBackdropColor(0, 0, 0, 0.6)
				pointBar.points[i]:SetBackdropBorderColor(0, 0, 0, 0.4)
			end
		end
		lastPower = power
	elseif (c == 'ROGUE') or (c == 'DRUID' and UnitPowerType('player') == 3) then
		local points, anticipation = GetComboPoints('player', 'target')
		if pointBar.max ~= 5 then
			pointBar:setMax(5)
			pointText:Hide()
		end
		if c == 'ROGUE' then
			anticipation = select(4, UnitBuff('player', spellAnticipation)) or 0
		end
		for i = 1, 5 do
			if c == 'ROGUE' and points == 5 and anticipation >= i then
				pointBar.points[i]:SetBackdropColor(0, 0.35, 0.6, 1)
				pointBar.points[i]:SetBackdropBorderColor(0.2, 0.8, 1, 1)
			elseif points >= i then
				pointBar.points[i]:SetBackdropColor(0.6, 0, 0, 1)
				pointBar.points[i]:SetBackdropBorderColor(0.8, 0.8, 0.1, 1)
			else
				pointBar.points[i]:SetBackdropColor(0, 0, 0, 0.6)
				pointBar.points[i]:SetBackdropBorderColor(0, 0, 0, 0.4)
			end
		end
		if Claw_Resources.cpalert > 0 and points == Claw_Resources.cpalert and lastPower == points - 1 then
			PlaySoundFile('Interface\\Addons\\Claw_Resources\\sounds\\' .. math.random(1, 11) .. '.mp3', 'Master')
		end
		lastPower = points
	elseif (c == 'MONK') then
		local chi, chiMax = UnitPower('player', 12), UnitPowerMax('player', 12)
		if pointBar.max ~= chiMax then
			pointBar:setMax(chiMax)
		end
		for i = 1, chiMax do
			if chi >= i then
				pointBar.points[i]:SetBackdropColor(0, 0.85, 0.6, 1)
				pointBar.points[i]:SetBackdropBorderColor(0, 0.55, 0.4, 1)
			else
				pointBar.points[i]:SetBackdropColor(0, 0, 0, 0.6)
				pointBar.points[i]:SetBackdropBorderColor(0, 0, 0, 0.4)
			end
		end
	elseif pointBar.max ~= 0 then
		pointBar:setMax(0)
		pointText:Hide()
	end
end

local function UpdatePowerBar()
	local resource = UnitPower('player')
	if resource == 0 then
		powerBar:DisableDrawLayer('BACKGROUND')
		powerBar:DisableDrawLayer('BORDER')
	else
		if UnitPowerType('player') == 3 then
			powerBar:SetBackdropColor(0.7, 0.7, 0, 1)
			powerBar:SetBackdropBorderColor(0.8, 0.8, 0.1, 1)
		elseif UnitPowerType('player') == 1 then
			powerBar:SetBackdropColor(0.7, 0, 0, 1)
			powerBar:SetBackdropBorderColor(0.8, 0.1, 0.1, 1)
		else
			powerBar:SetBackdropColor(0, 0, 0.7, 1)
			powerBar:SetBackdropBorderColor(0.1, 0.1, 0.8, 1)
		end
		powerBar:SetWidth(166 * (resource / UnitPowerMax('player')))
		powerBar:EnableDrawLayer('BACKGROUND')
		powerBar:EnableDrawLayer('BORDER')
	end
	powerText:SetText(resource .. '/' .. UnitPowerMax('player'))
end

local function UpdateGCDBar()
	local gcdStart, gcdDuration = GetSpellCooldown(spellGCD)
	if gcdStart ~= 0 then
		gcdFrame:SetWidth(168 - 168 * ((GetTime() - gcdStart) / gcdDuration))
		gcdFrame:EnableDrawLayer('BACKGROUND')
		gcdFrame:EnableDrawLayer('BORDER')
	else
		gcdFrame:DisableDrawLayer('BACKGROUND')
		gcdFrame:DisableDrawLayer('BORDER')
	end
end

function events:UNIT_COMBO_POINTS()
    UpdatePointBar()
end

function events:ADDON_LOADED(name)
	if name == 'Claw_Resources' then
		InitializeVariables()
		pointFrame:SetScale(Claw_Resources.scale)
		powerFrame:SetScale(Claw_Resources.scale)
		gcdFrame:SetScale(Claw_Resources.scale)
		pointFrame:EnableMouse(not Claw_Resources.locked)
	end
end

updaterFrame:SetScript('OnUpdate', function(self, elapsed)
    lastUpdate = lastUpdate + elapsed
    if lastUpdate >= Claw_Resources.frequency then
		if UnitCanAttack('player', 'target') then
			pointFrame:Show()
			powerFrame:Show()
			gcdFrame:Show()
			UpdatePointBar()
			UpdatePowerBar()
			UpdateGCDBar()
		else
			pointFrame:Hide()
			powerFrame:Hide()
			gcdFrame:Hide()
		end
        lastUpdate = 0
    end
end)

updaterFrame:SetScript('OnEvent', function(self, event, ...) events[event](self, ...) end)
for k in pairs(events) do
    updaterFrame:RegisterEvent(k)
end

function SlashCmdList.Claw_Resources(msg, editbox)
    msg = { strsplit(' ', strlower(msg)) }
	if msg[1] == 'locked' then
        if msg[2] then Claw_Resources.locked = msg[2] == 'on' end
        pointFrame:EnableMouse(not Claw_Resources.locked)
        print('Claw Resources - Locked: ' .. (Claw_Resources.locked and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'scale' then
        if msg[2] then
			Claw_Resources.scale = tonumber(msg[2]) or 1
			pointFrame:SetScale(Claw_Resources.scale)
			powerFrame:SetScale(Claw_Resources.scale)
			gcdFrame:SetScale(Claw_Resources.scale)
		end
		print('Claw Resources - Scale: |cFFFFD000' .. Claw_Resources.scale .. '|r times')
	elseif msg[1] == 'frequency' then
		Claw_Resources.frequency = tonumber(msg[2]) or 0.01
		print('Claw Resources - Update frequency: Every |cFFFFD000' .. Claw_Resources.frequency .. '|r seconds')
	elseif (c == 'DRUID' or c == 'ROGUE') and msg[1] == 'cpalert' then
		if msg[2] then Claw_Resources.cpalert = msg[2] == 'off' and 0 or tonumber(msg[2]) or 5 end
		print('Claw Resources - Alert at: ' .. (Claw_Resources.cpalert > 0 and '|cFFFFD000' .. Claw_Resources.cpalert .. '|r combo points' or '|cFFC00000Never'))
	elseif c == 'PALADIN' and msg[1] == 'hpalert' then
		if msg[2] then Claw_Resources.hpalert = msg[2] == 'off' and 0 or tonumber(msg[2]) or 3 end
		print('Claw Resources - Alert at: ' .. (Claw_Resources.hpalert > 0 and '|cFFFFD000' .. Claw_Resources.hpalert .. '|r holy power' or '|cFFC00000Never'))
    elseif msg[1] == 'reset' then
		pointFrame:ClearAllPoints()
        pointFrame:SetPoint('CENTER', 0, -222)
		powerFrame:ClearAllPoints()
		powerFrame:SetPoint('TOPLEFT', pointFrame, 'BOTTOMLEFT', 0, -3)
		gcdFrame:ClearAllPoints()
		gcdFrame:SetPoint('BOTTOMLEFT', pointFrame, 'TOPLEFT', 0, 3)
		print('Claw Resources - Position has been reset to default')
    else
		print('Claw Resources (version: |cFFFFD000' .. GetAddOnMetadata('Claw_Resources', 'Version') .. '|r) - Commands:')
	    print('  /cres locked |cFF00C000on|r/|cFFC00000off|r - lock the Claw Resources frame so that it can\'t be moved')
		print('  /cres scale |cFFFFD000[number]|r - set the scale of the Claw Resources UI (default is 1.0 times)')
		print('  /cres frequency |cFFFFD000[number]|r - set the update frequency (default is every 0.01 seconds)')
        print('  /cres |cFFFFD000reset|r - reset the location of Claw Resources to default')
		if c == 'DRUID' or c == 'ROGUE' then
			print('  /cres cpalert |cFFFFD000[#combo points]|r/|cFFC00000off|r - enable/disable the sound effect alert at x combo points')
		elseif c == 'PALADIN' then
			print('  /cres hpalert |cFFFFD000[#holy power]|r/|cFFC00000off|r - enable/disable the sound effect alert at x holy power')
		end
    end
end
