if select(2, UnitClass('player')) ~= 'DRUID' then
	DisableAddOn('Claw')
	return
end

Claw = {}

SLASH_Claw1, SLASH_Claw2 = '/claw', '/clawesome'

local function InitializeVariables()
	for k, v in pairs({ -- defaults
		locked = false,
		scales = {
			main = 1,
			previous = 0.7,
			cooldown = 0.7
		},
		frequency = 0.05,
		latency = 0.2,
		previous = true,
		cooldown = true,
		gcd = true,
		miss_effect = true,
		energy_dim = true,
		glow = true,
		boss_only = false,
		front = false,
		cat = true,
		bear = true,
		faerie_fire = true,
		tigersfury_berserk = false,
		mark_of_the_wild = true,
		pot = false,
	}) do
		if Claw[k] == nil then
			Claw[k] = v
		end
	end
end

local events = {}
local me, abilityTimer, currentTime, T14P = 0, 0, 0, 0
local glyphOfSavagery, glyphOfShred = false, false
local actionButtons

local clawPanel = CreateFrame('Frame', 'clawPanel', UIParent)
clawPanel:SetPoint('CENTER', 0, -169)
clawPanel:SetFrameStrata('BACKGROUND')
clawPanel:SetSize(64, 64)
clawPanel:Hide()
clawPanel:RegisterForDrag('LeftButton')
clawPanel:SetScript('OnDragStart', clawPanel.StartMoving)
clawPanel:SetScript('OnDragStop', clawPanel.StopMovingOrSizing)
clawPanel:SetMovable(true)
clawPanel.icon = clawPanel:CreateTexture(nil, 'BACKGROUND')
clawPanel.icon:SetAllPoints(clawPanel)
clawPanel.icon:SetTexCoord(0.05, 0.95, 0.05, 0.95)
clawPanel.border = clawPanel:CreateTexture(nil, 'BORDER')
clawPanel.border:SetAllPoints(clawPanel)
clawPanel.border:SetTexture('Interface\\AddOns\\Claw\\border.blp')
clawPanel.gcd = CreateFrame('Cooldown', nil, clawPanel, 'CooldownFrameTemplate')
clawPanel.gcd:SetAllPoints(clawPanel)
clawPanel.dimmer = clawPanel:CreateTexture(nil, 'OVERLAY')
clawPanel.dimmer:SetAllPoints(clawPanel)
clawPanel.dimmer:SetTexture(0, 0, 0, 0.6)
clawPanel.dimmer:Hide()
local clawPreviousPanel = CreateFrame('Frame', 'clawPreviousPanel', UIParent)
clawPreviousPanel:SetPoint('BOTTOMRIGHT', clawPanel, 'BOTTOMLEFT', -10, -5)
clawPreviousPanel:SetFrameStrata('BACKGROUND')
clawPreviousPanel:SetSize(64, 64)
clawPreviousPanel:Hide()
clawPreviousPanel:RegisterForDrag('LeftButton')
clawPreviousPanel:SetScript('OnDragStart', clawPreviousPanel.StartMoving)
clawPreviousPanel:SetScript('OnDragStop', clawPreviousPanel.StopMovingOrSizing)
clawPreviousPanel:SetMovable(true)
clawPreviousPanel.icon = clawPreviousPanel:CreateTexture(nil, 'BACKGROUND')
clawPreviousPanel.icon:SetAllPoints(clawPreviousPanel)
clawPreviousPanel.icon:SetTexCoord(0.05, 0.95, 0.05, 0.95)
clawPreviousPanel.border = clawPreviousPanel:CreateTexture(nil, 'BORDER')
clawPreviousPanel.border:SetAllPoints(clawPreviousPanel)
clawPreviousPanel.border:SetTexture('Interface\\AddOns\\Claw\\border.blp')
local clawCooldownPanel = CreateFrame('Frame', 'clawCooldownPanel', UIParent)
clawCooldownPanel:SetPoint('BOTTOMLEFT', clawPanel, 'BOTTOMRIGHT', 10, -5)
clawCooldownPanel:SetSize(64, 64)
clawCooldownPanel:SetFrameStrata('BACKGROUND')
clawCooldownPanel:Hide()
clawCooldownPanel:RegisterForDrag('LeftButton')
clawCooldownPanel:SetScript('OnDragStart', clawCooldownPanel.StartMoving)
clawCooldownPanel:SetScript('OnDragStop', clawCooldownPanel.StopMovingOrSizing)
clawCooldownPanel:SetMovable(true)
clawCooldownPanel.icon = clawCooldownPanel:CreateTexture(nil, 'BACKGROUND')
clawCooldownPanel.icon:SetAllPoints(clawCooldownPanel)
clawCooldownPanel.icon:SetTexCoord(0.05, 0.95, 0.05, 0.95)
clawCooldownPanel.border = clawCooldownPanel:CreateTexture(nil, 'BORDER')
clawCooldownPanel.border:SetAllPoints(clawCooldownPanel)
clawCooldownPanel.border:SetTexture('Interface\\AddOns\\Claw\\border.blp')

local function GetGCD()
	local startTime, duration = GetSpellCooldown(768)
	return max(duration - (currentTime - startTime) - Claw.latency, 0)
end

local Ability = {}
Ability.__index = Ability

function Ability.add(spellId, buff, playerCast)
	local name, _, icon, cost = GetSpellInfo(spellId)
	local ability = {
		spellId = spellId,
		name = name,
		icon = icon,
		auraTarget = buff and 'player' or 'target',
		auraFilter = (buff and 'HELPFUL' or 'HARMFUL') .. (playerCast and '|PLAYER' or ''),
		hasCost = cost ~= nil
	}
	setmetatable(ability, Ability)
	return ability
end

function Ability:ready(seconds)
	return self:cooldown() <= max(seconds or 0, GetGCD())
end

function Ability:remains()
	local _, id, expires
	for i = 1, 40 do
		_, _, _, _, _, _, expires, _, _, _, id = UnitAura(self.auraTarget, i, self.auraFilter)
		if id == self.spellId then
			return max(expires - currentTime - Claw.latency, 0)
		end
	end
	return 0
end

function Ability:up()
	local _, id, duration, expires
	for i = 1, 40 do
		_, _, _, _, _, duration, expires, _, _, _, id = UnitAura(self.auraTarget, i, self.auraFilter)
		if id == self.spellId then
			return duration == 0 or expires - currentTime - Claw.latency > 0
		end
	end
end

function Ability:down()
	return not self:up()
end

function Ability:cooldown()
	local startTime, duration = GetSpellCooldown(self.spellId)
	return max(duration - (currentTime - startTime) - Claw.latency, 0)
end

function Ability:stack()
	local _, id, count
	for i = 1, 40 do
		_, _, _, count, _, _, _, _, _, _, id = UnitAura(self.auraTarget, i, self.auraFilter)
		if id == self.spellId then
			return count
		end
	end
	return 0
end

function Ability:known()
	return GetSpellBookItemInfo(self.name) and true or false
end

function Ability:checkButtonAndGlow(button, on)
	if button and button:IsVisible() and button.icon:GetTexture() == self.icon then
		if on then
			ActionButton_ShowOverlayGlow(button)
		else
			ActionButton_HideOverlayGlow(button)
		end
	end
end

function Ability:glow(on)
	for i = 1, #actionButtons do
		self:checkButtonAndGlow(actionButtons[i], on)
	end
end

-- Druid abilities
local DreamOfCenarius = Ability.add(108373, true, true)
local FaerieFire = Ability.add(770, false, false)
local ForceOfNature = Ability.add(106737, false, true)
local HealingTouch = Ability.add(5185, true, true)
local NaturesVigil = Ability.add(124974, true, true)
local OmenOfClarity = Ability.add(135700, true, true)
-- Cat abilities
local Berserk = Ability.add(106951, true, true)
local CatForm = Ability.add(768, true, true)
DreamOfCenarius.feral = Ability.add(145152, true, true)
local FeralFury = Ability.add(144865, true, true)
local FeralRage = Ability.add(146874, true, true)
local FerociousBite = Ability.add(22568, false, true)
local IncarnationFeral = Ability.add(102543, true, true)
local Mangle = Ability.add(33876, false, false)
local PredatorySwiftness = Ability.add(69369, true, true)
local Prowl = Ability.add(5215, true, true)
local Rake = Ability.add(1822, false, true)
local Ravage = Ability.add(6785, false, true)
local Rip = Ability.add(1079, false, true)
local SavageRoar = Ability.add(127538, true, true)
SavageRoar.cp = Ability.add(52610, true, true)
SavageRoar.glyph = Ability.add(127538, true, true)
local Shred = Ability.add(5221, false, true)
local Thrash = Ability.add(106830, false, true)
local TigersFury = Ability.add(5217, true, true)
-- Bear abilities
local BearForm = Ability.add(5487, true, true)
local BerserkBear = Ability.add(50334, true, true)
local Enrage = Ability.add(5229, true, true)
local Lacerate = Ability.add(33745, false, true)
local MangleBear = Ability.add(33878, false, false)
local Maul = Ability.add(6807, false, true)
local SwipeBear = Ability.add(779, false, true)
local ThrashBear = Ability.add(77758, false, true)
-- 10% stat buff
local BlessingOfKings = Ability.add(20217, true)
local EmbraceOfTheShaleSpider = Ability.add(90363, true)
local LegacyOfTheEmperor = Ability.add(117666, true)
local MarkOfTheWild = Ability.add(1126, true)
-- 12% armor reduction
local WeakenedArmor = Ability.add(113746)
-- 4% physical damage taken
local PhysicalVulnerability = Ability.add(81326)
-- Potions
local VirmensBite = Ability.add(105697, true, true)
-- Trinkets
local RuneOfReorigination = Ability.add(0)
RuneOfReorigination.crit = Ability.add(139117, true, true)
RuneOfReorigination.haste = Ability.add(139121, true, true)
RuneOfReorigination.mastery = Ability.add(139120, true, true)
local TickingEbonDetonator = Ability.add(146310, true, true)
-- Non-existent spell
local NoSpell = Ability.add(0)

local abilityMain, lastAbilityMain, abilityPrevious, abilityCD = NoSpell, NoSpell, NoSpell, NoSpell

Rake.targets, Rip.targets = {}, {}

local function ComboPoints()
	return GetComboPoints('player', 'target')
end

local EnergyRegen = GetPowerRegen

local function Energy()
	return CatForm:up() and min(UnitPower('player', 3) + (EnergyRegen() * Claw.latency), 100) or 100
end

local function Mana()
	return UnitPower('player', 0)
end

local function EnergyTimeToMax()
	return (100 - Energy()) / EnergyRegen()
end

local InCombat = InCombatLockdown

local function Rage()
	return BearForm:up() and UnitPower('player') or 0
end

local function GetAverageMeleeDamage()
	local minDmg, maxDmg, _, _, _, _, dmgMult = UnitDamage('player')
	return (minDmg + maxDmg) / 4 / dmgMult
end

local function BleedMultiplier()
	return 1 + GetMasteryEffect() / 100
end

local Target = {
	boss = false,
	guid = 0,
	healthArray = {},
	hostile = false
}

local ArmorValuesByLevel = { [90] = 19680, [91] = 21400, [92] = 23115, [-1] = 24835 }

Target.armorMultiplier = function()
	local armor = (ArmorValuesByLevel[Target.level] or 0) * (1 - WeakenedArmor:stack() * 0.04)
	return 1 - max(min(armor / 46257.5 / (1 + armor / 46257.5), 75), 0)
end

Target.healthPercentage = function()
	return UnitHealth('target') / UnitHealthMax('target') * 100
end

Target.chanceToCrit = function()
	return GetCritChance() - max(Target.level - 90, 0)
end

Target.damageMultiplier = function()
	return select(7, UnitDamage('player')) * (DreamOfCenarius:up() and 1.3 or 1) * (PhysicalVulnerability:up() and 1.04 or 1)
end

Target.timeToDie = function()
	local ttd = UnitHealth('target') / ((Target.healthArray[1] - Target.healthArray[#Target.healthArray]) / 3) - Claw.latency
	return ttd >= 0 and ttd or 600
end

function DreamOfCenarius:remains()
	return self.feral:remains()
end

function DreamOfCenarius:up()
	return self.feral:up()
end

function ForceOfNature:charges()
	return (GetSpellCharges(self.spellId))
end

local function CritAverageMultiplier()
	return 1 + 1 * Target.chanceToCrit() / 100
end

function Mangle:damage()
	return (GetAverageMeleeDamage() * 5 + 390) * (1 + (FeralFury:up() and .5 or 0) + (T14P >= 2 and .05 or 0)) * Target.damageMultiplier() * Target.armorMultiplier() * CritAverageMultiplier()
end

function Rake:newTickDamage()
	return (99 + 0.3 * UnitAttackPower('player')) * BleedMultiplier() * Target.damageMultiplier() * CritAverageMultiplier()
end

function Rake:tickDamage()
	return self:up() and self.targets[Target.guid] or 0
end

function Rip:newTickDamage()
	return (113 + ComboPoints() * (384 + 0.05808 * UnitAttackPower('player'))) * BleedMultiplier() * Target.damageMultiplier() * CritAverageMultiplier()
end

function Rip:tickDamage()
	return self:up() and self.targets[Target.guid] or 0
end

function RuneOfReorigination:remains()
	return max(self.crit:remains(), self.haste:remains(), self.mastery:remains())
end

function RuneOfReorigination:up()
	return self.crit:up() or self.haste:up() or self.mastery:up()
end

function SavageRoar:remains()
	return max(self.cp:remains(), self.glyph:remains())
end

function SavageRoar:up()
	return self.cp:up() or self.glyph:up()
end

function VirmensBite:cooldown()
	local startTime, duration = GetItemCooldown(76089)
	return max(duration - (currentTime - startTime) - Claw.latency, 0)
end

local function StatBuffActive()
	return BlessingOfKings:up() or EmbraceOfTheShaleSpider:up() or LegacyOfTheEmperor:up() or MarkOfTheWild:up()
end

local function DetermineAbilityCat() -- Adapted and modified for actual gameplay from SimulationCraft (Druid_Feral_T16H_Adv_Rotation.simc, rev 17897, October 14, 2013), includes some enhancements by Defeat @ US-Arthas
	if Claw.cooldown and (not Claw.boss_only or Target.boss) then
		if Claw.tigersfury_berserk and Berserk:ready() and ((TigersFury:ready() and Energy() <= 35 and OmenOfClarity:down()) or (Target.timeToDie() < 18 and not TigersFury:ready(6))) then
			abilityCD = Berserk
		elseif TigersFury:ready() and Energy() <= 35 and Berserk:down() and OmenOfClarity:down() then
			abilityCD = TigersFury
		elseif Berserk:ready() and (TigersFury:up() or (Target.timeToDie() < 18 and not TigersFury:ready(6))) then
			abilityCD = Berserk
		elseif NaturesVigil:known() and NaturesVigil:ready() and Berserk:up() then
			abilityCD = NaturesVigil
		elseif IncarnationFeral:known() and IncarnationFeral:ready() and Berserk:up() then
			abilityCD = IncarnationFeral
		elseif Claw.pot and VirmensBite:ready() and Target.boss and ((RuneOfReorigination.equipped and ComboPoints() == 5 and (Target.timeToDie() * (Target.healthPercentage() - 25) / Target.healthPercentage()) < 15 and RuneOfReorigination:up()) or Target.timeToDie() < 40) then
			abilityCD = VirmensBite
		elseif ForceOfNature:known() and ForceOfNature:ready() and (ForceOfNature:charges() == 3 or (TickingEbonDetonator.equipped and TickingEbonDetonator:up()) or (RuneOfReorigination.equipped and RuneOfReorigination:up() and RuneOfReorigination:remains() < 2) or Target.timeToDie() < 20) then
			abilityCD = ForceOfNature
		else
			abilityCD = NoSpell
		end
	else
		abilityCD = NoSpell
	end
	if Claw.mark_of_the_wild and not StatBuffActive() then
		return MarkOfTheWild
	elseif not InCombat() then
		if DreamOfCenarius:known() and DreamOfCenarius:down() then
			return HealingTouch
		elseif CatForm:down() then
			return CatForm
		elseif SavageRoar:remains() < 6 and (ComboPoints() ~= 0 or glyphOfSavagery) then
			return SavageRoar
		end
	end
	if Prowl:up() then
		return Ravage
	elseif ComboPoints() ~= 0 and Rip:up() and Rip:remains() < 3 and Target.healthPercentage() < 25 then
		return FerociousBite
	elseif Claw.faerie_fire and FaerieFire:ready() and WeakenedArmor:stack() ~= 3 and EnergyTimeToMax() > 1 then
		return FaerieFire
	elseif DreamOfCenarius:known() and (DreamOfCenarius:down() and PredatorySwiftness:up() and (PredatorySwiftness:remains() < 1.5 or ComboPoints() >= 4)) then
		return HealingTouch
	elseif (ComboPoints() ~= 0 or glyphOfSavagery) and SavageRoar:down() then
		return SavageRoar
	elseif OmenOfClarity:up() and Thrash:remains() < 3 and Target.timeToDie() > 6 then
		return Thrash
	elseif ComboPoints() >= 3 and Target.timeToDie() < 1 then
		return FerociousBite
	elseif (ComboPoints() ~= 0 or glyphOfSavagery) and SavageRoar:remains() < 3 and Target.healthPercentage() < 25 then
		return SavageRoar
	elseif (ComboPoints() == 5 or (RuneOfReorigination.equipped and RuneOfReorigination:up() and RuneOfReorigination:remains() < 1.5 and ComboPoints() >= 4)) and Rip:newTickDamage() / Rip:tickDamage() > 1.1 and Target.timeToDie() > 30 then
		return Rip
	elseif ComboPoints() == 5 and Rip:up() and Target.healthPercentage() < 25 then
		return Energy() < (Berserk:up() and 25 or 50) and NoSpell or FerociousBite
	elseif ComboPoints() == 5 and Target.timeToDie() > 6 and Rip:remains() < 2 and (Berserk:up() or Rip:remains() + 1.9 < TigersFury:cooldown()) then
		return Rip
	elseif (ComboPoints() ~= 0 and SavageRoar:remains() < 3 and SavageRoar:remains() + 2 > Rip:remains()) or (ComboPoints() == 5 and SavageRoar:remains() < 6 and Rip:up() and SavageRoar:remains() + 2 < Rip:remains()) or (ComboPoints() == 5 and SavageRoar:remains() < 12 and Rip:up() and EnergyTimeToMax() < 1 and SavageRoar:remains() < Rip:remains() + 6) then
		return SavageRoar
	elseif Rake:down() or (Target.timeToDie() - Rake:remains() > 3 and (Rake:newTickDamage() / Rake:tickDamage() > 1.1 or (Rake:remains() < 3 and Rake:newTickDamage() / Rake:tickDamage() >= 0.8))) or (RuneOfReorigination.equipped and RuneOfReorigination:up() and Rake:remains() < 9 and RuneOfReorigination:remains() < 1.5) then
		return Rake
	elseif Target.timeToDie() > 6 and Rip:up() and (Thrash:remains() < 3 and (ComboPoints() == 5 or Berserk:up() or (Rip:remains() > 8 and SavageRoar:remains() > 12))) or (RuneOfReorigination.equipped and Thrash:remains() < 9 and RuneOfReorigination:up() and RuneOfReorigination:remains() < 1.5) then
		return Thrash
	elseif ComboPoints() == 5 and Rip:up() then
		return (EnergyTimeToMax() < 1 or (Berserk:up() and Energy() >= 25) or (FeralRage:up() and FeralRage:remains() < 1)) and FerociousBite or NoSpell
	elseif OmenOfClarity:up() or FeralFury:up() or TigersFury:up() or Berserk:up() or NaturesVigil:up() or TigersFury:ready(3) or EnergyTimeToMax() < 1.5 or (ComboPoints() ~= 5 and Rip:remains() < 3) or (ComboPoints() == 0 and SavageRoar:remains() < 2) or (DreamOfCenarius:known() and ComboPoints() < 3 and PredatorySwiftness:up()) or Target.timeToDie() < 8.5 then
		if IncarnationFeral:up() then
			return Ravage
		elseif Target.timeToDie() - Rake:remains() > 3 and Rake:newTickDamage() * (Rake:remains() / 4.5 + 1) - Rake:tickDamage() * (Rake:remains() / 4.5) > Mangle:damage() then
			return Rake
		elseif (not Claw.front or (glyphOfShred and (Berserk:up() or TigersFury:up()))) and (OmenOfClarity:up() or Berserk:up() or EnergyRegen() > 15) then
			return Shred
		end
		return Mangle
	elseif ForceOfNature:known() and ForceOfNature:ready() then
		return ForceOfNature
	elseif Claw.faerie_fire and FaerieFire:ready() and WeakenedArmor:remains() < 6 and EnergyTimeToMax() > 1 then
		return FaerieFire
	end
	return NoSpell
end

local function DetermineAbilityBear() -- By myself, no simulation testing
	if Claw.cooldown and (not Claw.boss_only or Target.boss) then
		if Maul:ready() and Rage() >= 50 then
			abilityCD = Maul
		elseif Enrage:ready() and Rage() <= 30 then
			abilityCD = Enrage
		else
			abilityCD = NoSpell
		end
	else
		abilityCD = NoSpell
	end
	if Claw.mark_of_the_wild and not StatBuffActive() then
		return MarkOfTheWild
	elseif not InCombat() and BearForm:down() then
		return BearForm
	elseif MangleBear:ready(0.4) then
		return MangleBear
	elseif ThrashBear:ready(0.4) and ThrashBear:remains() < 2 then
		return ThrashBear
	elseif Lacerate:ready(0.4) and Lacerate:stack() ~= 3 then
		return Lacerate
	elseif FaerieFire:ready(0.4) and WeakenedArmor:stack() ~= 3 then
		return FaerieFire
	elseif Lacerate:ready(0.4) then
		return Lacerate
	elseif FaerieFire:ready(0.4) then
		return FaerieFire
	elseif SwipeBear:ready(0.4) then
		return SwipeBear
	else
		return NoSpell
	end
end

local function DetermineAbility()
	if Claw.cat and BearForm:down() and GetSpecialization() == 2 then
		return DetermineAbilityCat()
	elseif Claw.bear and CatForm:down() and GetSpecialization() == 3 then
		return DetermineAbilityBear()
	else
		clawPreviousPanel:Hide()
		abilityCD = NoSpell
		return NoSpell
	end
end

function events:PLAYER_TARGET_CHANGED()
	local previouslyHostile = Target.hostile
	Target.hostile = UnitCanAttack('player', 'target') and not UnitInVehicle('player')
	if Target.hostile then
		Target.guid = UnitGUID('target')
		Target.level = UnitLevel('target')
		Target.boss = Target.level == -1 or (Target.level >= 92 and not UnitInRaid('player'))
		for i = 1, #Target.healthArray do
			Target.healthArray[i] = UnitHealth('target')
		end
		abilityTimer = Claw.frequency
		clawPanel:Show()
	elseif previouslyHostile then
		if Claw.glow then
			abilityMain:glow(false)
			abilityCD:glow(false)
		end
		abilityMain = NoSpell
		abilityCD = NoSpell
		clawPanel:Hide()
		clawPreviousPanel:Hide()
		clawCooldownPanel:Hide()
	end
end

function events:UNIT_FACTION(unitID)
	if unitID == 'target' then
		events:PLAYER_TARGET_CHANGED()
	end
end

function events:ACTIVE_TALENT_GROUP_CHANGED()
	glyphOfSavagery, glyphOfShred = false, false
	for i = 1, GetNumGlyphSockets() do
		if select(4, GetGlyphSocketInfo(i)) == 127540 then
			glyphOfSavagery = true
		end
		if select(4, GetGlyphSocketInfo(i)) == 114234 then
			glyphOfShred = true
		end
	end
end

local function Equipped(slot, item)
	return (GetInventoryItemLink('player', slot) or ''):match('%[([^%]]*)%]') == item and 1 or 0
end

function events:PLAYER_EQUIPMENT_CHANGED()
	T14P = Equipped(1, 'Eternal Blossom Headpiece') + Equipped(3, 'Eternal Blossom Spaulders') + Equipped(5, 'Eternal Blossom Raiment') + Equipped(7, 'Eternal Blossom Legguards') + Equipped(10, 'Eternal Blossom Grips')
	RuneOfReorigination.equipped = Equipped(13, 'Rune Of Re-Origination') + Equipped(14, 'Rune Of Re-Origination') >= 1
	TickingEbonDetonator.equipped = Equipped(13, 'Ticking Ebon Detonator') + Equipped(14, 'Ticking Ebon Detonator') >= 1
end

function events:PLAYER_REGEN_ENABLED()
    Rake.targets, Rip.targets = {}, {}
end

local function StoreActionButtons()
	actionButtons = {}
	if Bartender4 then
		for i = 1, 120 do
			actionButtons[#actionButtons + 1] = _G['BT4Button' .. i]
		end
	else
		for i = 1, 12 do
			actionButtons[#actionButtons + 1] = _G['ActionButton' .. i]
			actionButtons[#actionButtons + 1] = _G['MultiBarLeftButton' .. i]
			actionButtons[#actionButtons + 1] = _G['MultiBarRightButton' .. i]
			actionButtons[#actionButtons + 1] = _G['MultiBarBottomLeftButton' .. i]
			actionButtons[#actionButtons + 1] = _G['MultiBarBottomRightButton' .. i]
		end
		if Dominos then
			for i = 1, 60 do
				actionButtons[#actionButtons + 1] = _G['DominosActionButton' .. i]
			end
		end
	end
end

function events:PLAYER_LOGIN()
	events:ACTIVE_TALENT_GROUP_CHANGED()
	events:PLAYER_EQUIPMENT_CHANGED()
	me = UnitGUID('player')
	StoreActionButtons()
end

function events:ZONE_CHANGED_NEW_AREA()
	events:PLAYER_EQUIPMENT_CHANGED()
	clawPanel:UnregisterEvent('ZONE_CHANGED_NEW_AREA')
end

function events:ADDON_LOADED(name)
	if name == 'Claw' then
		if not Claw.frequency then
			print('It looks like this is your first time running Claw, why don\'t you take some time to familiarize yourself with the commands?')
			print('Type |cFFFFD000/claw|r for a list of commands.')
		end
		InitializeVariables()
		clawPanel:SetScale(Claw.scales.main)
		clawPanel:EnableMouse(not Claw.locked)
		clawPreviousPanel:SetScale(Claw.scales.previous)
		clawPreviousPanel:EnableMouse(not Claw.locked)
		clawCooldownPanel:SetScale(Claw.scales.cooldown)
		clawCooldownPanel:EnableMouse(not Claw.locked)
		for i = 1, floor(3 / Claw.frequency) do
			Target.healthArray[i] = 0
		end
	end
end

function events:COMBAT_LOG_EVENT_UNFILTERED(self, eventType, hideCaster, srcGUID, srcName, srcFlags, srcRaidFlags, dstGUID, dstName, dstFlags, dstRaidFlags, spellId, spellName, spellSchool, auraType)
	if srcGUID == me then
		if eventType == 'SPELL_MISSED' and Claw.previous and Claw.miss_effect and spellId == abilityPrevious.spellId then
			clawPreviousPanel.border:SetTexture('Interface\\AddOns\\Claw\\misseffect.blp')
		elseif eventType == 'SPELL_CAST_SUCCESS' then
			if Claw.previous and spellId == abilityMain.spellId then
				abilityPrevious = abilityMain
				clawPreviousPanel.border:SetTexture('Interface\\AddOns\\Claw\\border.blp')
				clawPreviousPanel.icon:SetTexture(abilityPrevious.icon)
				clawPreviousPanel:Show()
			end
			if spellId == Rake.spellId then
				Rake.targets[dstGUID] = Rake:newTickDamage()
			elseif spellId == Rip.spellId then
				Rip.targets[dstGUID] = Rip:newTickDamage()
			end
		end
	end
end

clawPanel:SetScript('OnUpdate', function(self, elapsed)
	abilityTimer = abilityTimer + elapsed
	if abilityTimer >= Claw.frequency then
		Target.healthArray[#Target.healthArray + 1] = UnitHealth('target')
		table.remove(Target.healthArray, 1)
		lastAbilityMain = abilityMain
		lastAbilityCD = abilityCD
		currentTime = GetTime()
		abilityMain = DetermineAbility()
		if abilityMain.spellId ~= lastAbilityMain.spellId then
			if abilityMain.icon then
				clawPanel.icon:SetTexture(abilityMain.icon)
				clawPanel.icon:Show()
				clawPanel.border:Show()
			else
				clawPanel.icon:Hide()
				clawPanel.border:Hide()
			end
			if Claw.glow then
				lastAbilityMain:glow(false)
			end
		end
		if abilityCD.spellId ~= lastAbilityCD.spellId then
			if abilityCD.icon then
				clawCooldownPanel.icon:SetTexture(abilityCD.icon)
				clawCooldownPanel:Show()
			else
				clawCooldownPanel:Hide()
			end
			if Claw.glow then
				lastAbilityCD:glow(false)
			end
		end
		if Claw.glow then
			abilityMain:glow(true)
			abilityCD:glow(true)
		end
		if Claw.gcd then
			local gcdStart, gcdDuration = GetSpellCooldown(2098)
			if gcdStart == 0 then
				clawPanel.gcd:Hide()
			else
				clawPanel.gcd:SetCooldown(gcdStart, gcdDuration)
				clawPanel.gcd:Show()
			end
		end
		if Claw.energy_dim then
			if abilityMain.hasCost then
				local _, _, _, cost, _, costType = GetSpellInfo(abilityMain.spellId)
				if (costType == 0 and Mana() or Energy()) < cost then
					clawPanel.dimmer:Show()
				else
					clawPanel.dimmer:Hide()
				end
			else
				clawPanel.dimmer:Hide()
			end
		end
		abilityTimer = 0
	end
end)

clawPanel:SetScript('OnEvent', function(self, event, ...) events[event](self, ...) end)
for event in pairs(events) do
	clawPanel:RegisterEvent(event)
end

function SlashCmdList.Claw(msg, editbox)
	msg = { strsplit(' ', strlower(msg)) }
	if msg[1] == 'locked' then
		if msg[2] then
			Claw.locked = msg[2] == 'on'
			clawPanel:EnableMouse(not Claw.locked and clawPanel.icon:IsVisible())
			clawPreviousPanel:EnableMouse(not Claw.locked)
			clawCooldownPanel:EnableMouse(not Claw.locked)
		end
		print('Claw - Locked: ' .. (Claw.locked and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'scale' then
		if msg[2] == 'prev' then
			if msg[3] then
				Claw.scales.previous = tonumber(msg[3]) or 0.66
				clawPreviousPanel:SetScale(Claw.scales.previous)
			end
			print('Claw - Previous ability icon scale set to: |cFFFFD000' .. Claw.scales.previous .. '|r times')
		elseif msg[2] == 'main' then
			if msg[3] then
				Claw.scales.main = tonumber(msg[3]) or 1
				clawPanel:SetScale(Claw.scales.main)
			end
			print('Claw - Main ability icon scale set to: |cFFFFD000' .. Claw.scales.main .. '|r times')
		elseif msg[2] == 'cd' then
			if msg[3] then
				Claw.scales.cooldown = tonumber(msg[3]) or 0.66
				clawCooldownPanel:SetScale(Claw.scales.cooldown)
			end
			print('Claw - Cooldown ability icon scale set to: |cFFFFD000' .. Claw.scales.cooldown .. '|r times')
		else
			print('Claw - Default icon scale options are |cFFFFD000prev 0.66|r, |cFFFFD000main 1|r, and |cFFFFD000cd 0.66|r')
		end
	elseif msg[1] == 'frequency' then
		Claw.frequency = tonumber(msg[2]) or 0.05
		print('Claw - Calculation frequency: Every |cFFFFD000' .. Claw.frequency .. '|r seconds')
	elseif msg[1] == 'latency' then
		Claw.latency = tonumber(msg[2]) or 0.2
		print('Claw - Player reaction time: |cFFFFD000' .. Claw.latency .. '|r seconds')
	elseif msg[1] == 'glow' then
		if msg[2] then
			Claw.glow = msg[2] == 'on'
			abilityMain:glow(Claw.glow)
			abilityCD:glow(Claw.glow)
		end
		print('Claw - Glowing ability buttons: ' .. (Claw.glow and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'previous' then
		if msg[2] then Claw.previous = msg[2] == 'on' end
		print('Claw - Previous ability icon: ' .. (Claw.previous and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'cd' then
		if msg[2] then Claw.cooldown = msg[2] == 'on' end
		print('Claw - Cooldown ability icon: ' .. (Claw.cooldown and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'gcd' then
		if msg[2] then Claw.gcd = msg[2] == 'on' end
		if not Claw.gcd then
			clawPanel.gcd:Hide()
		end
		print('Claw - Global cooldown swipe: ' .. (Claw.gcd and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'misseffect' then
		if msg[2] then Claw.miss_effect = msg[2] == 'on' end
		print('Claw - Red border around previous ability when it fails to hit: ' .. (Claw.miss_effect and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'dimmer' then
		if msg[2] then Claw.energy_dim = msg[2] == 'on' end
		clawPanel.dimmer:Hide()
		print('Claw - Dim main ability icon when you don\'t have enough energy to use it: ' .. (Claw.energy_dim and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'bossonly' then
		if msg[2] then Claw.boss_only = msg[2] == 'on' end
		print('Claw - Only use cooldowns on bosses: ' .. (Claw.boss_only and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'cat' then
		if msg[2] then Claw.cat = msg[2] == 'on' end
		print('Claw - Show Claw UI in cat (feral) specialization: ' .. (Claw.cat and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'bear' then
		if msg[2] then Claw.bear = msg[2] == 'on' end
		print('Claw - Show Claw UI in bear (guardian) specialization: ' .. (Claw.bear and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'ff' then
		if msg[2] then Claw.faerie_fire = msg[2] == 'on' end
		print('Claw - Faerie Fire on non-boss mobs (bear and cat): ' .. (Claw.faerie_fire and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'tfberserk' then
		if msg[2] then Claw.tigersfury_berserk = msg[2] == 'on' end
		print('Claw - Tiger\'s Fury is macro\'d to Berserk (cat only): ' .. (Claw.tigersfury_berserk and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'motw' then
		if msg[2] then Claw.mark_of_the_wild = msg[2] == 'on' end
		print('Claw - Mark of the Wild: ' .. (Claw.mark_of_the_wild and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'front' then
		if msg[2] then Claw.front = msg[2] == 'on' end
		print('Claw - In front of enemy (Mangle replaces Shred): ' .. (Claw.front and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'pot' then
		if msg[2] then Claw.pot = msg[2] == 'on' end
		print('Claw - show Virmen\'s Bite potions in cooldown UI (cat only): ' .. (Claw.pot and '|cFF00C000On' or '|cFFC00000Off'))
	elseif msg[1] == 'reset' then
		clawPanel:ClearAllPoints()
		clawPanel:SetPoint('CENTER', 0, -169)
		clawPreviousPanel:ClearAllPoints()
		clawPreviousPanel:SetPoint('BOTTOMRIGHT', clawPanel, 'BOTTOMLEFT', -10, -5)
		clawCooldownPanel:ClearAllPoints()
		clawCooldownPanel:SetPoint('BOTTOMLEFT', clawPanel, 'BOTTOMRIGHT', 10, -5)
		print('Claw - Position has been reset to default')
	else
		print('Claw (version: |cFFFFD000' .. GetAddOnMetadata('Claw', 'Version') .. '|r) - Commands:')
		print('  /claw locked |cFF00C000on|r/|cFFC00000off|r - lock the Claw UI so that it can\'t be moved')
		print('  /claw scale |cFFFFD000prev|r/|cFFFFD000main|r/|cFFFFD000cd|r |cFFFFD000[number]|r - adjust the scale of the Claw UI icons')
		print('  /claw frequency |cFFFFD000[number]|r - set the calculation frequency (default is every 0.05 seconds)')
		print('  /claw latency |cFFFFD000[number]|r - player\'s reaction time (default is 0.2 seconds)')
		print('  /claw glow |cFF00C000on|r/|cFFC00000off|r - glowing ability buttons on action bars')
		print('  /claw previous |cFF00C000on|r/|cFFC00000off|r - previous ability icon')
		print('  /claw cd |cFF00C000on|r/|cFFC00000off|r - cooldown ability icon (turn off for manual cooldown management)')
		print('  /claw gcd |cFF00C000on|r/|cFFC00000off|r - show global cooldown swipe on main ability icon')
		print('  /claw misseffect |cFF00C000on|r/|cFFC00000off|r - red border around previous ability when it fails to hit')
		print('  /claw dimmer |cFF00C000on|r/|cFFC00000off|r - dim main ability icon when you don\'t have enough energy to use it')
		print('  /claw bossonly |cFF00C000on|r/|cFFC00000off|r - only use cooldowns on bosses')
		print('  /claw cat |cFF00C000on|r/|cFFC00000off|r - show Claw UI in cat (feral) specialization')
		print('  /claw bear |cFF00C000on|r/|cFFC00000off|r - show Claw UI in bear (guardian) specialization')
		print('  /claw ff |cFF00C000on|r/|cFFC00000off|r - use Faerie Fire (cat only)')
		print('  /claw tfberserk |cFF00C000on|r/|cFFC00000off|r - Tiger\'s Fury is macro\'d to Berserk (cat only)')
		print('  /claw motw |cFF00C000on|r/|cFFC00000off|r - use Mark of the Wild')
		print('  /claw front |cFF00C000on|r/|cFFC00000off|r - in front of enemy (Mangle replaces Shred)')
		print('  /claw pot |cFF00C000on|r/|cFFC00000off|r - show Virmen\'s Bite potions in cooldown UI (cat only)')
		print('  /claw |cFFFFD000reset|r - reset the location of the Claw UI to default')
		if Claw_Resources then
			print('For Claw Resources commands, please type |cFFFFD000/cres|r.')
		end
	end
end