--[[ 
	CircleHUD
	by Chrome67
	available @ Curse.com and WoWInterface.com
	(fan updated and mod'ed version of AlarmHUDpie by lab1702)

	==Change Log==
	- v1.0 	- Initial release
	- v1.1 	- minor visual enhancement
	- v1.2 	- Additions:
				- Slash Commands: '/chud' or '/circlehud' will toggle between 'show only during combat/targeting' mode and 'always on' mode
				- Slash Command: '/rl' will Reload UI (got tired of typing '/console reloadui' all the time...)
				- Class-based Target Low Health indicator: The target health circle shows where casting certain spells is applicable given
					the current target's health.  The following are the class based indicators:
						Mage - 35%
						Rogue - 35% for Murderous Intent
						Shadow Priest - 25% for Shadow Word:Death
						Paladin - 20% for Hammer of Wrath
						Warrior - 20% for Execute
						All others - 25%
	- v1.3 	- TOC update for compatibility
	- v1.4 	- TOC update for compatibility
			- Additions:
				- User configurable variables in CircleHUD.lua
					- pieRadius: Sets how large the Circles are (Values > 0 only)
					- XScale: Relative offset left and right from center screen.
                               ** Negative numbers will cause circles to switch sides **
							   (e.g., player on right, target on left)
							   (Values from 0.01 to ??, large values may send the circles off your screen. Default: "1")
					- YScale: Relative offset up and down from center screen.
								(Values from -5.00 (bottom of screen?) to 5.00 (top of screen?). Default: "-1")
	- v1.5	- TOC update for compatibility
	- v1.6	- fixed compute by 0 error for MoP (MoP PTR servers only)
]]

--[[ *** User Configurable Variables *** ]] --

local pieRadius = 50      	-- [[ Sets how large the Circles are. Default: "50" ]] --

local XScale = 1.00       	--[[ Relative offset left and right from center screen.
								Negative numbers will cause circles to switch sides
								(e.g., player on right, target on left)
								(Values from 0.01 to ??, large values may send the circles off your screen. Default: "1.00") ]]--

local YScale = -2.00       	--[[ Relative offset up and down from center screen 
								(Values from -5.00 (bottom of screen?) to 5.00 (top of screen?). Default: "-1.00") ]] --


--[[ *** DO NOT CHANGE ANYTHING BELOW THIS LINE UNLESS YOU KNOW LUA CODING *** ]]--

local version = "v1.5"
local Graph = LibStub:GetLibrary("LibGraph-2.0")

local frame = CreateFrame("FRAME"); -- Need a frame to respond to events
frame:RegisterEvent("ADDON_LOADED"); -- Fired when saved variables are loaded
frame:RegisterEvent("PLAYER_LOGOUT"); -- Fired when about to log out
frame:RegisterEvent("PLAYER_LOGIN"); -- Fired on login

frame:SetScript("OnEvent", 
  function(frame, event, addon, ...)
	if event == "ADDON_LOADED" and addon == "CircleHUD" then
	
	  -- Our saved variables are ready at this point. If there are none, variables will be set to defaults.
	  
		if (CircleHUD_Config == nil) then
			CircleHUD_Config = "N"
		end

	else 
		if event == "PLAYER_LOGIN" then
			DEFAULT_CHAT_FRAME:AddMessage("|cffffd700<CircleHUD>|r " .. version .. " by |cff66ccffChrome67|r loaded...")
		end

	end
  end
)



local function CircleHUD_ShortNumber(h)
  if h > 999999 then
    return format("%.1fm", h / 1000000)
  elseif h > 9999 then
    return format("%.1fk", h / 1000)
  else
    return format("%d", h)
  end
end

local pieOffsetX = (UIParent:GetWidth() / 7) * XScale
local pieOffsetY = (UIParent:GetHeight() / 7) * YScale
local ShadowpieOffsetX = (UIParent:GetWidth() / 7) * XScale
local ShadowpieOffsetY = (UIParent:GetHeight() / 7) * YScale

local targetPieShadow = Graph:CreateGraphPieChart("CircleHUDtargetShadow", UIParent, "CENTER", "CENTER", ShadowpieOffsetX, ShadowpieOffsetY, pieRadius * 1.4, pieRadius * 1.4)
targetPieShadow:SetFrameLevel(targetPieShadow:GetFrameLevel() - 1)

targetPieShadow:RegisterEvent("PLAYER_TARGET_CHANGED")

targetPieShadow:SetScript("OnEvent",
  function(frame, event, unit, ...)
    if unit == "target" or event == "PLAYER_TARGET_CHANGED" then
		frame:ResetPie()
		if UnitExists("target") then
			frame:CompletePie({0, 0, 0})
		end
	end
  end
)

local targetPowerPie = Graph:CreateGraphPieChart("CircleHUDTargetPower", UIParent, "CENTER", "CENTER", pieOffsetX, pieOffsetY, pieRadius * 1.3, pieRadius * 1.3)

targetPowerPie:RegisterEvent("PLAYER_TARGET_CHANGED")
targetPowerPie:RegisterEvent("UNIT_DISPLAYPOWER")
targetPowerPie:RegisterEvent("UNIT_POWER")
targetPowerPie:RegisterEvent("UNIT_MAXPOWER")

targetPowerPie:SetScript("OnEvent",
  function(frame, event, unit, ...)
    if unit == "target" or event == "PLAYER_TARGET_CHANGED" then
      frame:ResetPie()

      if UnitExists("target") then
		local targPow = UnitPowerMax("target")
		if targPow == 0 then targPow = 1 end
        local p = (100 * UnitPower("target")) / targPow
        local col = PowerBarColor[UnitPowerType("target")]

        if p >= 100 then
          frame:CompletePie({col.r, col.g, col.b})
        else
          frame:AddPie(p, {col.r, col.g, col.b})
          frame:CompletePie({0, 0, 0})
        end
      end
    end
  end
)


local targetPie = Graph:CreateGraphPieChart("CircleHUDTarget", UIParent, "CENTER", "CENTER", pieOffsetX, pieOffsetY, pieRadius, pieRadius)
targetPie:SetFrameLevel(targetPie:GetFrameLevel() + 1)

local targetNumber = UIParent:CreateFontString("CircleHUDTargetNumber", "LOW", "GameFontNormalHuge")
targetNumber:SetPoint("LEFT", targetPowerPie, "RIGHT", (pieRadius * 0.1), 0)

local targetName = UIParent:CreateFontString("CircleHUDTargetName", "LOW", "GameFontNormal")
targetName:SetPoint("BOTTOM", targetPowerPie, "TOP", 0, (pieRadius * 0.1))

local targetPercent = UIParent:CreateFontString("CircleHUDTargetPercent", "LOW", "GameFontNormal")
targetPercent:SetPoint("TOP", targetPowerPie, "BOTTOM", 0, -(pieRadius * 0.1))

local targetIcon = UIParent:CreateTexture("CircleHUDTargetIcon", "OVERLAY")
targetIcon:SetHeight(pieRadius * 0.75)
targetIcon:SetWidth(pieRadius * 0.75)
targetIcon:SetTexture("Interface\\TargetingFrame\\UI-RaidTargetingIcons")
targetIcon:SetPoint("RIGHT", targetPowerPie, "LEFT", -(pieRadius * 0.1), 0)
targetIcon:Hide()

targetPie:RegisterEvent("PLAYER_TARGET_CHANGED")
targetPie:RegisterEvent("RAID_TARGET_UPDATE")
targetPie:RegisterEvent("UNIT_HEALTH")
targetPie:RegisterEvent("UNIT_MAXHEALTH")

targetPie:SetScript("OnEvent",
  function(frame, event, unit, ...)
    if unit == "target" or event == "PLAYER_TARGET_CHANGED" or event == "RAID_TARGET_UPDATE" then
      frame:ResetPie()

      if UnitExists("target") then
        local p = (100 * UnitHealth("target")) / UnitHealthMax("target")
        local _, c = UnitClass("target")

        if not c then
          c = "WARRIOR"
        end

        local col = RAID_CLASS_COLORS[c]
        local idx = GetRaidTargetIndex("target")

        if idx then
          SetRaidTargetIconTexture(targetIcon, idx)
          targetIcon:Show()
        else
          targetIcon:Hide()
        end

        if event == "PLAYER_TARGET_CHANGED" then
          targetName:SetText(UnitName("target"))
          targetName:SetTextColor(col.r, col.g, col.b)
        end

        targetNumber:SetText(CircleHUD_ShortNumber(UnitHealth("target")))
        targetPercent:SetFormattedText("%d%%", (100 * UnitHealth("target")) / UnitHealthMax("target"))
		
		if select(2, UnitClass("player")) == ("MAGE" or "ROGUE") then
			if p >= 100 then
			  frame:AddPie(35, {0.7, 0.2, 0.2})
			  frame:CompletePie({0.6, 0.2, 0.2})
			elseif p > 35 then
			  frame:AddPie(35, {0.7, 0.2, 0.2})
			  frame:AddPie(p - 35, {0.6, 0.2, 0.2})
			  frame:CompletePie({0, 0, 0})
			else
			  frame:AddPie(p, {1, 0.2, 0.2})
			  frame:CompletePie({0, 0, 0})
			end
		elseif select(2, UnitClass("player")) == ("PALADIN" or "WARRIOR") then
			if p >= 100 then
			  frame:AddPie(20, {0.7, 0.2, 0.2})
			  frame:CompletePie({0.6, 0.2, 0.2})
			elseif p > 20 then
			  frame:AddPie(20, {0.7, 0.2, 0.2})
			  frame:AddPie(p - 20, {0.6, 0.2, 0.2})
			  frame:CompletePie({0, 0, 0})
			else
			  frame:AddPie(p, {1, 0.2, 0.2})
			  frame:CompletePie({0, 0, 0})
			end
		else
			if p >= 100 then
			  frame:AddPie(25, {0.7, 0.2, 0.2})
			  frame:CompletePie({0.6, 0.2, 0.2})
			elseif p > 25 then
			  frame:AddPie(25, {0.7, 0.2, 0.2})
			  frame:AddPie(p - 25, {0.6, 0.2, 0.2})
			  frame:CompletePie({0, 0, 0})
			else
			  frame:AddPie(p, {1, 0.2, 0.2})
			  frame:CompletePie({0, 0, 0})
			end
		end	
      else
        targetName:SetText("")
        targetNumber:SetText("")
        targetPercent:SetText("")
        targetIcon:Hide()
      end
    end
  end
)

local healthPieShadow = Graph:CreateGraphPieChart("CircleHUDHealthShadow", UIParent, "CENTER", "CENTER", -ShadowpieOffsetX, ShadowpieOffsetY, pieRadius * 1.4, pieRadius * 1.4)
healthPieShadow:SetFrameLevel(healthPieShadow:GetFrameLevel() - 1)

healthPieShadow:RegisterEvent("PLAYER_ENTERING_WORLD")
healthPieShadow:RegisterEvent("PLAYER_TARGET_CHANGED")

healthPieShadow:SetScript("OnEvent",
  function(frame, event, unit, ...)
	if CircleHUD_Config == "Y" then
		if (unit == "player" or event == "PLAYER_ENTERING_WORLD" or event == "PLAYER_TARGET_CHANGED") then
			frame:ResetPie()
			if UnitExists("playertarget") then
				frame:CompletePie({0, 0, 0})
			end
		end
	else 
		if (unit == "player" or event == "PLAYER_ENTERING_WORLD" or event == "PLAYER_TARGET_CHANGED") then
			frame:ResetPie()
			if UnitExists("player") then
				frame:CompletePie({0, 0, 0})
			end
		end
	end	
  end
)


local powerPie = Graph:CreateGraphPieChart("CircleHUDPower", UIParent, "CENTER", "CENTER", -pieOffsetX, pieOffsetY, pieRadius * 1.3, pieRadius * 1.3)

local powerValue = UIParent:CreateFontString("CircleHUDPowerValue", "LOW", "GameFontNormal")
powerValue:SetPoint("BOTTOM", powerPie, "LEFT", -(pieRadius * 0.3), 0)

local powerMaxValue = UIParent:CreateFontString("CircleHUDPowerMaxValue", "LOW", "GameFontNormalSmall")
powerMaxValue:SetPoint("TOP", powerPie, "LEFT", -(pieRadius * 0.3), 0)

powerPie:RegisterEvent("PLAYER_ENTERING_WORLD")
powerPie:RegisterEvent("UNIT_DISPLAYPOWER")
powerPie:RegisterEvent("UNIT_POWER")
powerPie:RegisterEvent("UNIT_MAXPOWER")
powerPie:RegisterEvent("PLAYER_TARGET_CHANGED")


powerPie:SetScript("OnEvent",
  function(frame, event, unit, ...)
    if CircleHUD_Config == "Y" then
		if (unit == "player" or event == "PLAYER_ENTERING_WORLD" or event == "PLAYER_TARGET_CHANGED") then

		  frame:ResetPie()
		  if UnitExists("playertarget") then
			local p = (100 * UnitPower("player")) / UnitPowerMax("player")
			local c = PowerBarColor[UnitPowerType("player")]

			powerMaxValue:SetText(CircleHUD_ShortNumber(UnitPowerMax("player")))
			powerValue:SetText(CircleHUD_ShortNumber(UnitPower("player")))

				if p >= 100 then
				  frame:CompletePie({c.r, c.g, c.b})
				else
				  frame:AddPie(p, {c.r, c.g, c.b})
				  frame:CompletePie({1, 1, 1})
			end
		  else
			powerMaxValue:SetText("")
			powerValue:SetText("")
		  end
		end 
	else 
		if (unit == "player" or event == "PLAYER_ENTERING_WORLD" or event == "PLAYER_TARGET_CHANGED") then
		  frame:ResetPie()
		  if UnitExists("player") then
		
			local p = (100 * UnitPower("player")) / UnitPowerMax("player")
			local c = PowerBarColor[UnitPowerType("player")]

			powerMaxValue:SetText(CircleHUD_ShortNumber(UnitPowerMax("player")))
			powerValue:SetText(CircleHUD_ShortNumber(UnitPower("player")))

			if p >= 100 then
			  frame:CompletePie({c.r, c.g, c.b})
			else
			  frame:AddPie(p, {c.r, c.g, c.b})
			  frame:CompletePie({1, 1, 1})
			end
		  else
			powerMaxValue:SetText("")
			powerValue:SetText("")
		  end
		end
    end
  end
)

local healthPie = Graph:CreateGraphPieChart("CircleHUDHealth", UIParent, "CENTER", "CENTER", -pieOffsetX, pieOffsetY, pieRadius, pieRadius)
healthPie:SetFrameLevel(healthPie:GetFrameLevel() + 1)

local healthValue = UIParent:CreateFontString("CircleHUDHealthValue", "LOW", "GameFontNormal")
healthValue:SetPoint("BOTTOM", healthPie, "RIGHT", (pieRadius * 0.5), 0)

local healthMaxValue = UIParent:CreateFontString("CircleHUDHealthMaxValue", "LOW", "GameFontNormalSmall")
healthMaxValue:SetPoint("TOP", healthPie, "RIGHT", (pieRadius * 0.5), 0)

healthPie:RegisterEvent("PLAYER_ENTERING_WORLD")
healthPie:RegisterEvent("UNIT_HEALTH")
healthPie:RegisterEvent("UNIT_MAXHEALTH")
healthPie:RegisterEvent("PLAYER_TARGET_CHANGED")

healthPie:SetScript("OnEvent",
  function(frame, event, unit, ...)
    if CircleHUD_Config == "Y" then
		if (unit == "player" or event == "PLAYER_ENTERING_WORLD" or event == "PLAYER_TARGET_CHANGED") then

			frame:ResetPie()
			if UnitExists("playertarget") then
				local p = (100 * UnitHealth("player")) / UnitHealthMax("player")

				healthMaxValue:SetText(CircleHUD_ShortNumber(UnitHealthMax("player")))  
				healthValue:SetText(CircleHUD_ShortNumber(UnitHealth("player")))  

				if p >= 100 then
					frame:CompletePie({0, 1, 0})
				else
					frame:AddPie(p, {0, 1, 0})
					frame:CompletePie({0, 0, 0})
				end
			else
				healthMaxValue:SetText("")
				healthValue:SetText("")
			end
		end
	else
		
		if (unit == "player" or event == "PLAYER_ENTERING_WORLD" or event == "PLAYER_TARGET_CHANGED") then
	
			frame:ResetPie()
			if UnitExists("player") then
				local p = (100 * UnitHealth("player")) / UnitHealthMax("player")

				healthMaxValue:SetText(CircleHUD_ShortNumber(UnitHealthMax("player")))  
				healthValue:SetText(CircleHUD_ShortNumber(UnitHealth("player")))  
		
				if p >= 100 then
					frame:CompletePie({0, 1, 0})
				else
					frame:AddPie(p, {0, 1, 0})
					frame:CompletePie({0, 0, 0})
				end
			else
				healthMaxValue:SetText("")
				healthValue:SetText("")
			end
		end
    end
  end
)

--[[ Slash Commands ]]--

SLASH_CIRCLEHUD1 = "/chud"
SLASH_CIRCLEHUD2 = "/circlehud"
SlashCmdList["CIRCLEHUD"] = function(cmd)
	if CircleHUD_Config == "Y" then 
		CircleHUD_Config = "N"
		print("|cffffd700<CircleHUD>|r " .. version .. " is now always ON!")
		
	else 
		CircleHUD_Config = "Y"
		print("|cffffd700<CircleHUD>|r " .. version .. " will now show only when in combat or targeting.")
		powerPie:ResetPie()
		healthPie:ResetPie()
		healthPieShadow:ResetPie()
		healthMaxValue:SetText("")
		healthValue:SetText("")
		powerMaxValue:SetText("")
		powerValue:SetText("")
	end
	
end

SLASH_RELOAD1 = "/rl"
SlashCmdList["RELOAD"] = function(cmd)
	ReloadUI()
end



