-- Addon:	ChiBar: widget generating function for the optionpanel
-- Author:	Fushui(EU-Azshara)

if select(2, UnitClass("player")) ~= "MONK" then
    return
end

function ChiBar:createCheckbox(parentFrame, elementName, script, dbData, localisedText, point, relativeTo, relativePoint, ofsx, ofsy)

	local enable = {}
	enable.element = CreateFrame("CheckButton", elementName, parentFrame, "OptionsBaseCheckButtonTemplate")
	enable.element:SetPoint(point, relativeTo, relativePoint, ofsx, ofsy)
	enable.element:SetChecked(dbData)
	enable.element:SetScript("OnClick", script)
	enable.text = parentFrame:CreateFontString(nil, "ARTWORK", "GameFontHighlight")
	enable.text:SetPoint("LEFT", enable.element, "RIGHT", 10, 1)
	enable.text:SetJustifyH("LEFT")
	enable.text:SetText(localisedText)

	return enable
end

function ChiBar:createTitle(parentFrame, text, textsizeType, point, relativeTo, relativePoint, ofsx, ofsy)

	if parentFrame and text and textsizeType and point and relativeTo and relativePoint and ofsx and ofsy then

		local title = parentFrame:CreateFontString(nil, "ARTWORK", textsizeType)
		title:SetPoint(point, relativeTo, relativePoint, ofsx, ofsy)
		title:SetText(text)

		return title
	else
		-- if not all 8 needed arguments are given, we assume that we want to create a Fontstring with a specific
		-- position and not a relative one
		local new_ofsx = relativeTo
		local new_ofsy = relativePoint

		local title = parentFrame:CreateFontString(nil, "ARTWORK", textsizeType)
		title:SetPoint(point, new_ofsx, new_ofsy)
		title:SetText(text)

		return title
	end
end

function ChiBar:createButton(parentFrame, elementName, text, script, point, relativeTo, relativePoint, ofsx, ofsy)

	local button = CreateFrame("Button", elementName, parentFrame, "GameMenuButtonTemplate")
	button:SetHeight(25)
	button:SetWidth(100)
	button:SetPoint(point, relativeTo, relativePoint, ofsx, ofsy)
	button:SetText(text)
	button:SetScript("OnClick", script)

	return button
end

function ChiBar:createSlider(parentFrame, elementName, script, dbData, flooringFactor, minValue, maxValue, point, relativeTo, relativePoint, ofsx, ofsy)

	local slider = CreateFrame('Slider', elementName, parentFrame, 'OptionsSliderTemplate')
	slider:SetPoint(point, relativeTo, relativePoint, ofsx, ofsy)
	slider:SetMinMaxValues(minValue, maxValue)
	slider:SetValue(ChiBarDB[dbData])
	getglobal(slider:GetName() .. 'Low'):SetText(minValue)
	getglobal(slider:GetName() .. 'High'):SetText(maxValue)

	slider:SetScript("OnValueChanged", function()
		ChiBarDB[dbData] = floor(slider:GetValue()*flooringFactor)/flooringFactor
		script()
	end)

	return slider
end

function ChiBar:createDropdownMenu(parentFrame, elementName, script, items, dbData, point, relativeTo, relativePoint, ofsx, ofsy)

	local menu = {}

	menu.element = CreateFrame("Frame", elementName, parentFrame, "UIDropDownMenuTemplate")
	menu.element:SetPoint(point, relativeTo, relativePoint, ofsx, ofsy)
	menu.items = items
	local function OnClick(self)
		UIDropDownMenu_SetSelectedID(menu.element, self:GetID())
		ChiBarDB[dbData] = self:GetID()
		script()
	end
	local function initialize(self, level)
		local info = UIDropDownMenu_CreateInfo()
		for k, v in pairs(menu.items) do
			info = UIDropDownMenu_CreateInfo()
			info.text = v
			info.value = v
			info.func = OnClick
			UIDropDownMenu_AddButton(info, level)
		end
	end
	UIDropDownMenu_Initialize(menu.element, initialize)
	UIDropDownMenu_SetWidth(menu.element, 120)
	UIDropDownMenu_SetButtonWidth(menu.element, 120)
	UIDropDownMenu_JustifyText(menu.element, "LEFT")
	UIDropDownMenu_SetSelectedID(menu.element, ChiBarDB[dbData])

	return menu
end

function ChiBar:createEditBox(parentFrame, textsizeType, script, dbData, flooringFactor, minValue, maxValue, point, relativeTo, relativePoint, ofsx, ofsy)

	local editbox = CreateFrame("EditBox", nil, parentFrame)
	editbox:SetWidth(50)
	editbox:SetHeight(20)
	editbox:SetPoint(point, relativeTo, relativePoint, ofsx, ofsy)
	editbox:SetFontObject(textsizeType)
	editbox:SetMultiLine(false)
	editbox:SetAutoFocus(false)
	editbox:SetBackdrop({bgFile = "Interface\\ChatFrame\\ChatFrameBackground",
                			edgeFile = "Interface\\ChatFrame\\ChatFrameBackground",
                			tile = true, edgeSize = 1, tileSize = 5,
        				})
	editbox:SetBackdropColor(0, 0, 0, 0.2)
    editbox:SetBackdropBorderColor(0.3, 0.3, 0.30, 0.80)
    editbox:SetJustifyH("CENTER")
	editbox:SetText(ChiBarDB[dbData])
	editbox:SetCursorPosition(0)
	editbox:SetScript("OnEnterPressed", function()
		editbox:ClearFocus()
		local textAsNumber = tonumber(editbox:GetText())
		if textAsNumber ~= nil and textAsNumber <= maxValue and textAsNumber >= minValue then
			ChiBarDB[dbData] = floor(textAsNumber*flooringFactor)/flooringFactor
		end
		script()
	end)

	editbox:SetScript("OnEscapePressed", function()
		editbox:ClearFocus()
		editbox:SetText(ChiBarDB[dbData])
	end)

	editbox:SetScript("OnEditFocusLost", function(self)
		editbox:ClearFocus()
	end)

	return editbox
end