-- Addon:	ChiBar: option panel
-- Author:	Fushui(EU-Azshara)

if select(2, UnitClass("player")) ~= "MONK" then
    return
end


------------------------------------------
--		OptionsPanel					--
------------------------------------------

function ChiBar:createOptionsUI()
	ChiBar.opanel = CreateFrame("Frame", "ChiBarOptionsPanel", UIParent)
	ChiBar.opanel.name = "ChiBar";
	InterfaceOptions_AddCategory(ChiBar.opanel);

	-- Widget
	ChiBar.Widgets = {}

	-- VersionTitle
	ChiBar.Widgets.title = ChiBar:createTitle(ChiBar.opanel, ChiBar.VERSIONTEXT_1, "GameFontNormalLarge", "TOPLEFT", 16, -16)
	ChiBar.Widgets.title2 = ChiBar:createTitle(ChiBar.opanel, ChiBar.VERSIONTEXT_2, "GameFontHighlight", "TOPLEFT", 16, -35)
	
	-- MainSettingTitle
	ChiBar.Widgets.mainsettTitle = ChiBar:createTitle(ChiBar.opanel, ChiBarLocalization.OP_MAINTITLE, "GameFontNormalLarge", "TOPLEFT", 16, -70)
	
	-- EnableCheckBox
	ChiBar.Widgets.enableBox = ChiBar:createCheckbox(ChiBar.opanel, "EnableCheckBox",
		ChiBar.enable, ChiBarDB.enable, ChiBarLocalization.OP_ENABLE,
		"TOPLEFT", ChiBar.Widgets.mainsettTitle, "BOTTOMLEFT", 0, -5)
	
	-- AutohideCheckBox
	ChiBar.Widgets.autohideBox = ChiBar:createCheckbox(ChiBar.opanel, "AutohideCheckBox",
		ChiBar.autohide, ChiBarDB.autohide, ChiBarLocalization.OP_AUTOHIDE,
		"TOPLEFT", ChiBar.Widgets.enableBox.element, "BOTTOMLEFT", 0, -1)
	
	-- HideStandardChiBar
	ChiBar.Widgets.hideStandardBox = ChiBar:createCheckbox(ChiBar.opanel, "AutohideCheckBox",
		ChiBar.hideStandard, ChiBarDB.hideStandard, ChiBarLocalization.OP_HIDESTANDARD,
		"TOPLEFT", ChiBar.Widgets.autohideBox.element, "BOTTOMLEFT", 0, -1)

	-- ScaleTitle
	ChiBar.Widgets.scaleTitle = ChiBar:createTitle(ChiBar.opanel, ChiBarLocalization.OP_SCALETITLE, "GameFontNormalLarge",
		"TOPLEFT", ChiBar.Widgets.hideStandardBox.element, "BOTTOMLEFT", 0, -10)

	-- ScaleSlider
	ChiBar.Widgets.scaleSlider = ChiBar:createSlider(ChiBar.opanel, 'ScaleSlider', ChiBar.scaleUI, "scale", 1000, 0.1, 2,
		"TOPLEFT", ChiBar.Widgets.scaleTitle, "BOTTOMLEFT", 0, -10)
	
	-- CurrentScale
	ChiBar.Widgets.currScaleText = ChiBar:createEditBox(ChiBar.opanel, "GameFontHighlightSmall", ChiBar.scaleUI, "scale", 1000, 0.1, 2,
		"LEFT", ChiBar.Widgets.scaleSlider, "RIGHT", 20, 0)
	
	-- OrientationTitle
	ChiBar.Widgets.orientationTitle = ChiBar:createTitle(ChiBar.opanel, ChiBarLocalization.OP_GROW_TITLE, "GameFontNormalLarge",
		"LEFT", ChiBar.Widgets.mainsettTitle, "RIGHT", 125, 0)
	
	-- OrientationBox1
	ChiBar.Widgets.verticalBox = ChiBar:createCheckbox(ChiBar.opanel, "AutohideCheckBox",
		ChiBar.updateVertHor, ChiBarDB.grow1, ChiBarLocalization.OP_GROW_VERTICAL,
		"TOPLEFT", ChiBar.Widgets.orientationTitle, "BOTTOMLEFT", 0, -5)
	
	-- OrientationBox2
	ChiBar.Widgets.horizontalBox = ChiBar:createCheckbox(ChiBar.opanel, "AutohideCheckBox",
		ChiBar.updateVertHor, not ChiBarDB.grow1, ChiBarLocalization.OP_GROW_HORIZONTAL,
		"TOPLEFT", ChiBar.Widgets.verticalBox.element, "BOTTOMLEFT", 0, -1)
	
	-- OrientationBox3
	local text = ChiBarDB.grow1 and ChiBarLocalization.OP_GROW_RIGHT or ChiBarLocalization.OP_GROW_TOP
	ChiBar.Widgets.leftbottomBox = ChiBar:createCheckbox(ChiBar.opanel, "AutohideCheckBox",
		ChiBar.updateGrowthDirec, ChiBarDB.grow2, text,
		"LEFT", ChiBar.Widgets.verticalBox.text, "RIGHT", 50, 0)
	
	-- OrientationBox4
	local text = ChiBarDB.grow1 and ChiBarLocalization.OP_GROW_LEFT or ChiBarLocalization.OP_GROW_BOTTOM
	ChiBar.Widgets.righttopBox = ChiBar:createCheckbox(ChiBar.opanel, "AutohideCheckBox",
		ChiBar.updateGrowthDirec, not ChiBarDB.grow2, text,
		"TOPLEFT", ChiBar.Widgets.leftbottomBox.element, "BOTTOMLEFT", 0, -1)
	
	--DropboxTitle
	ChiBar.Widgets.dropdownTitle = ChiBar:createTitle(ChiBar.opanel, ChiBarLocalization.OP_DROPBOXTITLE, "GameFontNormalLarge",
		"TOPLEFT", ChiBar.Widgets.scaleSlider, "BOTTOMLEFT", 0, -50)
	
	-- TextureDropDown
	local textureMenuItems = {}
	local index
	for index = 1, #ChiBar.TEXTURES do
		textureMenuItems[index] = ChiBar.TEXTURES[index][1]
	end
	ChiBar.Widgets.dropdownMenu = ChiBar:createDropdownMenu(ChiBar.opanel, "TextureMenu", ChiBar.changeTexture, textureMenuItems, "savedTexture",
		"TOPLEFT", ChiBar.Widgets.dropdownTitle, "BOTTOMLEFT", -10, -10)
	
	-- LayerTitle
	ChiBar.Widgets.layerTitle = ChiBar:createTitle(ChiBar.opanel, ChiBarLocalization.OP_LAYERTITLE, "GameFontNormalLarge",
		"LEFT", ChiBar.Widgets.scaleTitle, "RIGHT", 140, 0)
	
	-- StrataTitle
	ChiBar.Widgets.layerSubTitle1 = ChiBar:createTitle(ChiBar.opanel, ChiBarLocalization.OP_LAYERSUBTITLE1, "GameFontHighlight",
		"TOPLEFT", ChiBar.Widgets.layerTitle, "BOTTOMLEFT", 0, -10)
	
	-- StrataDropdown
	ChiBar.Widgets.strataMenu = ChiBar:createDropdownMenu(ChiBar.opanel, "StrataMenu", ChiBar.updateLayerLevel, {"LOW", "MEDIUM", "HIGH", "DIALOG"}, "strata",
		"TOPLEFT", ChiBar.Widgets.layerSubTitle1, "BOTTOMLEFT", -15, -10)
	
	-- LayerTitle
	ChiBar.Widgets.layerSubTitle2 = ChiBar:createTitle(ChiBar.opanel, ChiBarLocalization.OP_LAYERSUBTITLE2, "GameFontHighlight",
		"LEFT", ChiBar.Widgets.layerSubTitle1, "RIGHT", 80, 0)
	
	-- LayerDropdown
	ChiBar.Widgets.mainLayerMenu = ChiBar:createDropdownMenu(ChiBar.opanel, "LayerMenu", ChiBar.updateLayerLevel, {"BACKGROUND", "BORDER", "ARTWORK", "OVERLAY"}, "mainLayer",
		"TOPLEFT", ChiBar.Widgets.layerSubTitle2, "BOTTOMLEFT", -15, -10)
	

	-- OpacityTitle
	ChiBar.Widgets.opacityTitle = ChiBar:createTitle(ChiBar.opanel, ChiBarLocalization.OP_OPACITYTITLE, "GameFontNormalLarge",
		"LEFT", ChiBar.Widgets.dropdownTitle, "RIGHT", 125, 0)
	
	-- SeperateBox
	ChiBar.Widgets.seperateBox = ChiBar:createCheckbox(ChiBar.opanel, "SeperateCheckBox",
		ChiBar.enableSeperateOpacity, ChiBarDB.seperate, ChiBarLocalization.OP_SEPERATE,
		"TOPLEFT", ChiBar.Widgets.opacityTitle, "BOTTOMLEFT", 0, -5)
	
	-- OpacitySubTitle1
	local text = ChiBarDB.seperate and ChiBarLocalization.OP_OPACITYSUBTITLE1_2 or ChiBarLocalization.OP_OPACITYSUBTITLE1_1
	ChiBar.Widgets.opacitySubTitle1 = ChiBar:createTitle(ChiBar.opanel, text, "GameFontNormalMed3",
		"TOPLEFT", ChiBar.Widgets.seperateBox.element, "BOTTOMLEFT", 5, -10)
	
	-- OpacitySlider1
	ChiBar.Widgets.opacitySlider1 = ChiBar:createSlider(ChiBar.opanel, 'OpacitySlider1', ChiBar.adjustOpacity, "alpha1", 1000, 0, 1,
		"TOPLEFT", ChiBar.Widgets.opacitySubTitle1, "BOTTOMLEFT", 0, -10)
	
	-- CurrentOpacity1
	ChiBar.Widgets.currOpacityText1 = ChiBar:createEditBox(ChiBar.opanel, "GameFontHighlightSmall", ChiBar.adjustOpacity, "alpha1", 1000, 0, 1,
		"LEFT", ChiBar.Widgets.opacitySlider1, "RIGHT", 20, 0)
	
	-- OpacitySubTitle2
	ChiBar.Widgets.opacitySubTitle2 = ChiBar:createTitle(ChiBar.opanel, ChiBarLocalization.OP_OPACITYSUBTITLE2, "GameFontNormalMed3",
		"TOPLEFT", ChiBar.Widgets.opacitySlider1, "BOTTOMLEFT", 0, -20)
	
	-- OpacitySlider2
	ChiBar.Widgets.opacitySlider2 = ChiBar:createSlider(ChiBar.opanel, 'OpacitySlider2', ChiBar.adjustOpacity, "alpha2", 1000, 0, 1,
		"TOPLEFT", ChiBar.Widgets.opacitySubTitle2, "BOTTOMLEFT", 0, -10)
	
	-- CurrentOpacity2
	ChiBar.Widgets.currOpacityText2 = ChiBar:createEditBox(ChiBar.opanel, "GameFontHighlightSmall", ChiBar.adjustOpacity, "alpha2", 1000, 0, 1,
		"LEFT", ChiBar.Widgets.opacitySlider2, "RIGHT", 20, 0)
	
	if not ChiBarDB.seperate then
		ChiBar.Widgets.opacitySubTitle2:Hide()
		ChiBar.Widgets.opacitySlider2:Hide()
		ChiBar.Widgets.currOpacityText2:Hide()
	end
	
	-- OffsetTitle
	ChiBar.Widgets.offsetTitle = ChiBar:createTitle(ChiBar.opanel, ChiBarLocalization.OP_OFFSETTITLE, "GameFontNormalLarge",
		"TOPLEFT", ChiBar.Widgets.dropdownMenu.element, "BOTTOMLEFT", 10, -15)
	
	-- OffsetSlider
	ChiBar.Widgets.offsetSlider = ChiBar:createSlider(ChiBar.opanel, 'OffsetSlider', ChiBar.updateOffset, "offset", 1, 0, 100,
		"TOPLEFT", ChiBar.Widgets.offsetTitle, "BOTTOMLEFT", 0, -10)
	
	-- CurrentOffset
	ChiBar.Widgets.currOffsetText = ChiBar:createEditBox(ChiBar.opanel, "GameFontHighlightSmall", ChiBar.updateOffset, "offset", 1, 0, 100,
		"LEFT", ChiBar.Widgets.offsetSlider, "RIGHT", 20, 0)
	
	-- ChangeColorButton
	ChiBar.Widgets.colorButton = ChiBar:createButton(ChiBar.opanel, "ColorButton", ChiBarLocalization.OP_COLORBTN, ChiBar.openColorPicker,
		"TOPLEFT", ChiBar.Widgets.offsetSlider, "BOTTOMLEFT", 0, -25)
	
	-- ResetColorButton
	ChiBar.Widgets.resetColorButton = ChiBar:createButton(ChiBar.opanel, "ResetColorButton", ChiBarLocalization.OP_RESETCOLORBTN, ChiBar.resetColor,
		"TOPLEFT", ChiBar.Widgets.colorButton, "BOTTOMLEFT", 0, -5)
	
	-- LockButton
	ChiBar.Widgets.lockButton = ChiBar:createButton(ChiBar.opanel, "LockButton", ChiBarLocalization.OP_LOCKBTN1, ChiBar.unlockFrame,
		"TOPLEFT", ChiBar.Widgets.colorButton, "TOPRIGHT", 5, 0)
	
	-- ResetButton
	ChiBar.Widgets.resetButton = ChiBar:createButton(ChiBar.opanel, "ResetButton", ChiBarLocalization.OP_RESET, ChiBar.confirmReset,
		"TOPLEFT", ChiBar.Widgets.lockButton, "BOTTOMLEFT", 0, -5)
end


------------------------------------------
--		PopUpHandling					--
------------------------------------------

-- PopUpHandling for Unlocking
StaticPopupDialogs["CHIBAR_UNLOCKFRAME"] = {
  text = ChiBarLocalization.OP_UNLOCKTEXT,
  button1 = ChiBarLocalization.OP_LOCKBTN2,
  OnAccept = function()
      ChiBar:lockFrame()
	  InterfaceOptionsFrame_OpenToCategory(ChiBar.opanel)
  end,
  OnCancel = function()
      ChiBar:lockFrame()
	  InterfaceOptionsFrame_OpenToCategory(ChiBar.opanel)
  end,
  timeout = 0,
  whileDead = true,
  hideOnEscape = true,
  preferredIndex = 3,  -- avoid some UI taint, see http://www.wowace.com/announcements/how-to-avoid-some-ui-taint/
}

-- PopUpHandling for Resetting
StaticPopupDialogs["CHIBAR_RESETFRAME"] = {
  text = ChiBarLocalization.OP_RESETTEXT,
  button1 = YES,
  button2 = NO,
  OnAccept = function()
      ChiBar:reset()
  end,
  OnCancel = function()
	  InterfaceOptionsFrame_OpenToCategory(ChiBar.opanel)
  end,
  timeout = 0,
  whileDead = true,
  hideOnEscape = true,
  preferredIndex = 3,  -- avoid some UI taint, see http://www.wowace.com/announcements/how-to-avoid-some-ui-taint/
}


------------------------------------------
--		End of Script					--
------------------------------------------