--[[ 
TO-DO:	READY_CHECK_FINISHED event support

v2.11	BUG: Group slash override options addressed
		BUG: Ready check failure addressed
		
v2.1	Major re-write for additional features.
		There are 4 settings to choose from for each group type.  You can now individually control the output for these groups:
			- Self
			- Party
			- Raid 10
			- Raid 20
			- Raid 25
			- Raid 40
			- Battleground 10
			- Battleground 15
			- Battleground 40
		Settings for each group type can be Disabled/Totals/Names/Details:
			- Disabled, no announcements at all.
			- Totals will display only the numbers of people food buffed and elixir/flask buffed.
			- Names will list all team members names which do not have a food or elixir/flask buff.
			- Details displays all team members food buff and elixir/flask with minutes remaining and links to the buff details.
			
v2.0	Added flask and elixir support.
		Moved the options to the Blizzard addons interface.
		
v1.0	For public consumption.
 ]]
 
--define global vars and defaults (saved between sessions)
local function SetDefaults()
	KChefTime_Settings = {
		["Version"] = tonumber(GetAddOnMetadata("KChefTime", "Version")),
		["Self"] = 4,
		["SelfAuto"] = true,
		["Party"] = 3,
		["PartyAuto"] = true,
		["Raid10"] = 3,
		["Raid10Auto"] = true,
		["Raid20"] = 2,
		["Raid20Auto"] = true,
		["Raid25"] = 2,
		["Raid25Auto"] = true,
		["Raid40"] = 2,
		["Raid40Auto"] = true,
		["Arena"] = 2,
		["ArenaAuto"] = true,
		["Battleground10"] = 3,
		["Battleground10Auto"] = true,
		["Battleground15"] = 2,
		["Battleground15Auto"] = true,
		["Battleground40"] = 2,
		["Battleground40Auto"] = true,
	}
	if KChefTime_Settings.Version == nil then KChefTime_Settings.Version = 0; end	--in case the setting did not exist
end
SetDefaults()
local DebugMode = false

local function GetGroupUnitType()
	if UnitInRaid("player") then
		return "RAID"
	elseif GetNumPartyMembers() > 0 then
		return "PARTY"
	else
		return "player"
	end
end

local function GetGroupChatType()
	if UnitInBattleground("player") then
		return "BATTLEGROUND"
	elseif UnitInRaid("player") then
		return "RAID"
	elseif GetNumPartyMembers() > 0 then
		return "PARTY"
	else
		return "SAY"
	end
end

local function GetGroupCount()
	if UnitInRaid("player") then
		return GetNumRaidMembers()
	elseif GetNumPartyMembers() > 0 then
		return GetNumPartyMembers() + 1
	else
		return 1
	end
end

local LastUnitIDType
local LastUnitIDIndex
local function GetNextGroupUnitID(Reset)
	local RetValue
	if GetGroupUnitType() == "player" then
		UnitIDIndex = nil
		return GetGroupUnitType()
	else --party or raid
		if LastUnitIDType ~= GetGroupUnitType() then
		  --the group type changed to reset automatically
		  LastUnitIDIndex = nil
		end
		if Reset then LastUnitIDIndex = nil; end
		
		--figure out the index
		if LastUnitIDIndex then
			--restore next index
			UnitIDIndex = LastUnitIDIndex + 1
		else
			--first index
			UnitIDIndex = 1
		end
		if UnitIDIndex > GetGroupCount() then
			UnitIDIndex = 1
		end
		
		--build the string
		if GetGroupUnitType() == "PARTY" then
			if UnitIDIndex == 1 then
				RetValue = "player"
			else
				RetValue = GetGroupUnitType()..(UnitIDIndex - 1)
			end
		else	--raid
			RetValue = GetGroupUnitType()..UnitIDIndex
		end
	end
	
	--save values for next call
	LastUnitIDIndex = UnitIDIndex
	LastUnitIDType = GetGroupUnitType()
	return RetValue
end

local function GroupPrint(Msg,ChatType)
	if DebugMode then
		print(ChatType..": "..Msg)
	else
		SendChatMessage(Msg, ChatType)
	end
end

local function GetGroupType()
	if GetGroupChatType() == "SAY" then return "Self"; 
	elseif GetGroupChatType() == "PARTY" then return "Party"; 
	elseif GetGroupChatType() == "RAID" and GetGroupCount() <= 10 then return "Raid10";
	elseif GetGroupChatType() == "RAID" and GetGroupCount() >= 11 and GetGroupCount() <= 20 then return "Raid20";
	elseif GetGroupChatType() == "RAID" and GetGroupCount() >= 21 and GetGroupCount() <= 25 then return "Raid25";
	elseif GetGroupChatType() == "RAID" and GetGroupCount() >= 26 and GetGroupCount() <= 40 then return "Raid40";
	elseif GetGroupChatType() == "BATTLEGROUND" and GetGroupCount() <= 10 then return "Battleground10";
	elseif GetGroupChatType() == "BATTLEGROUND" and GetGroupCount() >= 11 and GetGroupCount() <= 15 then return "Raid";
	elseif GetGroupChatType() == "BATTLEGROUND" and GetGroupCount() >= 16 and GetGroupCount() <= 40 then return "Battleground40";
	else
		return nil
	end
end

local function DoPrintToGroup(OutputLevel, AutoOnCheck)
	if KChefTime_Settings[GetGroupType()] == OutputLevel and not AutoOnCheck or 
		KChefTime_Settings[GetGroupType()] == OutputLevel and AutoOnCheck and KChefTime_Settings[GetGroupType().."Auto"] then
		return true
	else
		return false
	end
end

function KChefTime_Command(Msg)
	local Override = false
	local OverrideSelf = ""
	local OverrideGroup = ""
	local AutoOnCheck = false

	if Msg == nil then Msg = ""; end
	if Msg then Msg=strlower(Msg); end
	if Msg == "help" or Msg == "?" then
		InterfaceOptionsFrame_OpenToCategory(KChefTimeHelpFrame)
	elseif Msg == "o" then
		InterfaceOptionsFrame_OpenToCategory(KChefTimeOptionsFrame)
	else
		--setup local variables
		local InInstance, InstanceType = IsInInstance()  --none, pvp, arena, party, raid
		local GroupIndex, UnitType, BuffIndex
		local ToonName, BuffName, ExpirationTime, SpellID
		local Toons={} --Name, WellFedMins, WellFedSpellID, ElixirName, ElixirMins, ElixirSpellID
		local OutputSumFed, OutputSumElixir, OutputDetails, OutputDetailsMsg, OutputTotals
		local FedCount = 0
		local ElixiredCount = 0
		local Index
		local GroupType
		
		if Msg == "auto" then 
			--is this event driven?
			AutoOnCheck = true
		else
			--are we using manual override options from user?
			if string.find(Msg,"st") then
				OverrideSelf = "st"
				Override = true
			elseif string.find(Msg,"sn") then
				OverrideSelf = "sn"
				Override = true
			elseif string.find(Msg,"sd") then
				OverrideSelf = "sd"
				Override = true
			end
			if string.find(Msg,"gt") then
				OverrideGroup = "gt"
				Override = true
			elseif string.find(Msg,"gn") then
				OverrideGroup = "gn"
				Override = true
			elseif string.find(Msg,"gd") then
				OverrideGroup = "gd"
				Override = true
			end
		end

		--gather data
		UnitType = GetNextGroupUnitID(true)
		for GroupIndex = 1, GetGroupCount() do
			ToonName = GetUnitName(UnitType)
			Toons[ToonName]={WellFed=0,WellFedSpellID=nil,ElixirName="",ElixirExpiration=0,ElixirSpellID=nil}
			BuffIndex = 1
			BuffName, _, _, _, _, _, ExpirationTime, _, _, _, SpellID = UnitBuff(UnitType, BuffIndex)
			while BuffName do
				if BuffName == "Well Fed" then
					Toons[ToonName].WellFed = floor(((ExpirationTime-GetTime())/60)+1)
					Toons[ToonName].WellFedSpellID = SpellID
				elseif strfind(strlower(BuffName), "elixir") then
					Toons[ToonName].ElixirName = BuffName
					Toons[ToonName].ElixirExpiration = floor(((ExpirationTime-GetTime())/60)+1)
					Toons[ToonName].ElixirSpellID = SpellID
				elseif strfind(strlower(BuffName), "flask") then
					Toons[ToonName].ElixirName = BuffName
					Toons[ToonName].ElixirExpiration = floor(((ExpirationTime-GetTime())/60)+1)
					Toons[ToonName].ElixirSpellID = SpellID
				end
				BuffIndex = BuffIndex + 1
				BuffName, _, _, _, _, _, ExpirationTime, _, _, _, SpellID = UnitBuff(UnitType, BuffIndex)
			end
			UnitType = GetNextGroupUnitID()
		end
		
		--build print results
		OutputSumFed = ""
		OutputSumElixir = ""
		OutputDetails = {}
		OutputDetailsMsg = ""
		UnitType = GetNextGroupUnitID(true)
		for GroupIndex = 1, GetGroupCount() do
			ToonName = GetUnitName(UnitType)
			if Toons[ToonName].WellFed > 0 then
				if Toons[ToonName].WellFed > 0 then
					OutputDetailsMsg = ToonName..": "..GetSpellLink(Toons[ToonName].WellFedSpellID).." ("..Toons[ToonName].WellFed..")"
				else
					OutputDetailsMsg = ToonName..": "..GetSpellLink(Toons[ToonName].WellFedSpellID)
				end
				FedCount = FedCount + 1
			else
				if OutputSumFed ~= "" then OutputSumFed = OutputSumFed..", "; end
				OutputSumFed = OutputSumFed..ToonName
				OutputDetailsMsg = ToonName..": Not well fed"
			end
			if Toons[ToonName].ElixirName ~= "" then
				if Toons[ToonName].ElixirExpiration > 0 then
					OutputDetailsMsg = OutputDetailsMsg.." with "..GetSpellLink(Toons[ToonName].ElixirSpellID).." ("..Toons[ToonName].ElixirExpiration..")."
				else
					OutputDetailsMsg = OutputDetailsMsg.." with "..GetSpellLink(Toons[ToonName].ElixirSpellID).."."
				end
				ElixiredCount = ElixiredCount + 1
			else
				if OutputSumElixir ~= "" then OutputSumElixir = OutputSumElixir..", "; end
				OutputSumElixir = OutputSumElixir..ToonName
				OutputDetailsMsg = OutputDetailsMsg..": not elixired/flasked."
			end
			table.insert(OutputDetails, OutputDetailsMsg)
			UnitType = GetNextGroupUnitID()
		end
		OutputTotals = "Of "..GetGroupCount()..", there are "..FedCount.." well fed & "..ElixiredCount.." are elixired/flasked."

		--print header
		if not Override then
			print("Chef Time:")
		else
			local TempStr = ""
			if OverrideSelf ~= "" then TempStr = "("..OverrideSelf..")"; end
			if OverrideGroup ~= "" then TempStr = TempStr.."("..OverrideGroup..")"; end
			print("Chef Time "..TempStr..":")
		end

		--TOTALS
		--print totals summary results to self?
		if not Override and KChefTime_Settings.Self == 2 and not AutoOnCheck or 
			not Override and KChefTime_Settings.Self == 2 and AutoOnCheck and KChefTime_Settings.SelfAuto or 
			OverrideSelf == "st" then
			DEFAULT_CHAT_FRAME:AddMessage(OutputTotals, 1, 1, 1)
		end
		--print totals summary results to group?
		if GetGroupChatType() ~= "SAY" and not Override and DoPrintToGroup(2, AutoOnCheck) or
			GetGroupChatType() ~= "SAY" and OverrideGroup == "gt" then
			GroupPrint(OutputTotals, GetGroupChatType())
		end

		--NAMES
		--print names summary results to self?
		if not Override and KChefTime_Settings.Self == 3 and not AutoOnCheck or 
			not Override and KChefTime_Settings.Self == 3 and AutoOnCheck and KChefTime_Settings.SelfAuto or 
			OverrideSelf == "sn" then
			if OutputSumFed ~= "" then
				DEFAULT_CHAT_FRAME:AddMessage("Not well fed: "..OutputSumFed, 1, 1, 1)
			else
				DEFAULT_CHAT_FRAME:AddMessage("Everyone is well fed", 1, 1, 1)
			end
			if OutputSumElixir ~= "" then
				DEFAULT_CHAT_FRAME:AddMessage("Not elixired/flasked: "..OutputSumElixir, 1, 1, 1)
			else
				DEFAULT_CHAT_FRAME:AddMessage("Everyone is elixired/flasked", 1, 1, 1)
			end
		end
		--print names summary results to group?
		if GetGroupChatType() ~= "SAY" and not Override and DoPrintToGroup(3, AutoOnCheck) or
			GetGroupChatType() ~= "SAY" and OverrideGroup == "gn" then
			if OutputSumFed ~= "" then
				GroupPrint("Not well fed: "..OutputSumFed, GetGroupChatType())
			else
				GroupPrint("Everyone is well fed", GetGroupChatType())
			end
			if OutputSumElixir ~= "" then
				GroupPrint("Not elixired/flasked: "..OutputSumElixir, GetGroupChatType())
			else
				GroupPrint("Everyone is elixired/flasked", GetGroupChatType())
			end
		end
		
		--DETAILS
		--print detailed results to self?
		if not Override and KChefTime_Settings.Self == 4 and not AutoOnCheck or 
			not Override and KChefTime_Settings.Self == 4 and AutoOnCheck and KChefTime_Settings.SelfAuto or 
			OverrideSelf == "sd" then
			for Index=1, #OutputDetails, 1 do 
				DEFAULT_CHAT_FRAME:AddMessage(Index..": "..OutputDetails[Index], 1, 1, 1)
			end
		end
		--print detailed results to group?
		if GetGroupChatType() ~= "SAY" and not Override and DoPrintToGroup(4, AutoOnCheck) or 
			GetGroupChatType() ~= "SAY" and OverrideGroup == "gd" then
			for Index=1, #OutputDetails, 1 do 
				GroupPrint(Index..": "..OutputDetails[Index], GetGroupChatType())
			end
		end
	end
end

function KChefTimeFrame_OnEvent(self,event,...)
	if event == "READY_CHECK" and 
		KChefTime_Settings["SelfAuto"] or 
		event == "READY_CHECK" and 
		KChefTime_Settings[GetGroupType().."Auto"] or 
		DebugMode and event == "ZONE_CHANGED_NEW_AREA" then
		KChefTime_Command("auto")
	end
	if event == "ADDON_LOADED" and select(1,...) == "KChefTime" then
		--vars loaded from saved settings
		
		--check ver of settings and upgrade if needed
		KChefTime_Settings.Version = tonumber(KChefTime_Settings.Version) --bugfix for v2 bug
		if KChefTime_Settings.Version == nil then KChefTime_Settings.Version = 0; end	--in case the setting did not exist
		if KChefTime_Settings.Version < tonumber(GetAddOnMetadata("KChefTime", "Version")) then
			--upgrade older version settings
			local OldVerOptions = KChefTime_Settings    --save loaded settings
			SetDefaults()    --load default settings again
			for k,v in pairs(OldVerOptions) do
				if OldVerOptions[k] ~= nil then
					KChefTime_Settings[k] = OldVerOptions[k]
				end
			end
			KChefTime_Settings.Version = tonumber(GetAddOnMetadata("KChefTime", "Version"))	--reset correct version number
		end
		KChefTime_LoadOptionSettings() --load global vars to option controls
	end
end

function KChefTimeFrame_OnLoad(self)
 	SlashCmdList["KChefTime"]=KChefTime_Command
	SLASH_KChefTime1, SLASH_KChefTime2="/KChef","/Chef"
	KChefTimeFrame:RegisterEvent("READY_CHECK")
	--KChefTimeFrame:RegisterEvent("READY_CHECK_FINISHED")
	KChefTimeFrame:RegisterEvent("ADDON_LOADED")
	if DebugMode then KChefTimeFrame:RegisterEvent("ZONE_CHANGED_NEW_AREA"); end
	print(GetAddOnMetadata("KChefTime", "Title").." v"..GetAddOnMetadata("KChefTime", "Version"))
	print("Use /KChef ? for help")
end


function KChefTimeOptionsFrame_OnLoad(panel)
	local WoWver = select(4, GetBuildInfo())
	-- Set the name for the Category for the Panel
	panel.name = GetAddOnMetadata("KChefTime", "Title").." v"..GetAddOnMetadata("KChefTime", "Version")
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Title:SetText(GetAddOnMetadata("KChefTime", "Title").." v"..GetAddOnMetadata("KChefTime", "Version"))

	--define the functions that will run when the user clicks on the associated buttons
	panel.okay = function(self) KChefTimeOptionsFrame_Close(); end
	panel.cancel = function(self) KChefTimeOptionsFrame_Cancel(); end
	panel.default = function(self) KChefTimeOptionsFrame_Defaults(); end
	--panel.parent = ""
	--panel.refresh = function(self)  KChefTimeOptions_Refresh();  end

	-- Add the panel to the Interface Options
	InterfaceOptions_AddCategory(panel)
end

function KChefTimeOptionsFrame_Close()
	--save option control settings to global vars
	KChefTime_Settings.Self = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_SelfSlider:GetValue()
	KChefTime_Settings.SelfAuto = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_SelfSliderAuto:GetChecked()
	KChefTime_Settings.Party = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_PartySlider:GetValue()
	KChefTime_Settings.PartyAuto = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_PartySliderAuto:GetChecked()
	KChefTime_Settings.Raid10 = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid10Slider:GetValue()
	KChefTime_Settings.Raid10Auto = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid10SliderAuto:GetChecked()
	KChefTime_Settings.Raid20 = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid20Slider:GetValue()
	KChefTime_Settings.Raid20Auto = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid20SliderAuto:GetChecked()
	KChefTime_Settings.Raid25 = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid25Slider:GetValue()
	KChefTime_Settings.Raid25Auto = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid25SliderAuto:GetChecked()
	KChefTime_Settings.Raid40 = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid40Slider:GetValue()
	KChefTime_Settings.Raid40Auto = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid40SliderAuto:GetChecked()
--[[ 	KChefTime_Settings.Arena = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_ArenaSlider:GetValue()
	KChefTime_Settings.ArenaAuto = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_ArenaSliderAuto:GetChecked() ]]
	KChefTime_Settings.Battleground10 = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Battleground10Slider:GetValue()
	KChefTime_Settings.Battleground10Auto = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Battleground10SliderAuto:GetChecked()
	KChefTime_Settings.Battleground15 = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Battleground15Slider:GetValue()
	KChefTime_Settings.Battleground15Auto = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Battleground15SliderAuto:GetChecked()
	KChefTime_Settings.Battleground40 = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Battleground40Slider:GetValue()
	KChefTime_Settings.Battleground40Auto = KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Battleground40SliderAuto:GetChecked()
end

function KChefTimeOptionsFrame_Cancel()
	KChefTime_LoadOptionSettings()
end

function KChefTimeOptionsFrame_Defaults()
	SetDefaults()
	KChefTime_LoadOptionSettings()
end
	
function KChefTime_LoadOptionSettings()
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_SelfSlider:SetValue(KChefTime_Settings.Self)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_SelfSliderAuto:SetChecked(KChefTime_Settings.SelfAuto)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_PartySlider:SetValue(KChefTime_Settings.Party)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_PartySliderAuto:SetChecked(KChefTime_Settings.PartyAuto)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid10Slider:SetValue(KChefTime_Settings.Raid10)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid10SliderAuto:SetChecked(KChefTime_Settings.Raid10Auto)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid20Slider:SetValue(KChefTime_Settings.Raid20)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid20SliderAuto:SetChecked(KChefTime_Settings.Raid20Auto)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid25Slider:SetValue(KChefTime_Settings.Raid25)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid25SliderAuto:SetChecked(KChefTime_Settings.Raid25Auto)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid40Slider:SetValue(KChefTime_Settings.Raid40)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Raid40SliderAuto:SetChecked(KChefTime_Settings.Raid40Auto)
--[[ 	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_ArenaSlider:SetValue(KChefTime_Settings.Arena)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_ArenaSliderAuto:SetChecked(KChefTime_Settings.ArenaAuto) ]]
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Battleground10Slider:SetValue(KChefTime_Settings.Battleground10)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Battleground10SliderAuto:SetChecked(KChefTime_Settings.Battleground10Auto)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Battleground15Slider:SetValue(KChefTime_Settings.Battleground15)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Battleground15SliderAuto:SetChecked(KChefTime_Settings.Battleground15Auto)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Battleground40Slider:SetValue(KChefTime_Settings.Battleground40)
	KChefTimeOptionsFrame_ScrollFrame_ScrollChild_Battleground40SliderAuto:SetChecked(KChefTime_Settings.Battleground40Auto)
end

function KChefTimeHelpFrame_OnLoad(panel)
	-- Set the name for the Category for the Panel
	panel.name = "help"

	--define the functions that will run when the user clicks on the associated buttons
	panel.okay = function(self) KChefTimeOptionsFrame_Close(); end
	panel.cancel = function(self) KChefTimeOptionsFrame_Cancel(); end
	panel.parent = KChefTimeOptionsFrame.name

	-- Add the panel to the Interface Options
	InterfaceOptions_AddCategory(panel)
	
	--set the help text
	KChefTimeHelpFrame_Text:SetText(
	"Chef Time commands can be type with /kchef or /chef.\n"..
	"Using the Chef Time command alone will display the results based on the options configured in the options panel.\n"..
	"Additionally there are options you can use with the slash command.\n"..
	"To use the options type the slash command followed by the options such as /chef (options).\n"..
	"\n"..
	"Options:\n"..
	"\n"..
	"o displays the options panel.\n"..
	"? displays the this help panel.\n"..
	"\n"..
	"Override options will ignore the set options in the options panel and output based on the typed options.\n"..
	"s = self.\n"..
	"g = group.\n"..
	"t = totals.\n"..
	"n = names.\n"..
	"d = details.\n"..
	"\n"..
	"Specify self (s) or group (g) with a type of output (t,n,g).\n"..
	"\n"..
	"Examples:\n"..
	"/chef st.\n"..
	"/chef gn.\n"..
	"/chef stgn.\n"
	)
end
