﻿--inviteStatus 

--CALENDAR_INVITESTATUS_INVITED      = 1
--CALENDAR_INVITESTATUS_ACCEPTED     = 2
--CALENDAR_INVITESTATUS_DECLINED     = 3
--CALENDAR_INVITESTATUS_CONFIRMED    = 4
--CALENDAR_INVITESTATUS_OUT          = 5
--CALENDAR_INVITESTATUS_STANDBY      = 6
--CALENDAR_INVITESTATUS_SIGNEDUP     = 7
--CALENDAR_INVITESTATUS_NOT_SIGNEDUP = 8
--CALENDAR_INVITESTATUS_TENTATIVE    = 9


local frame = CreateFrame("Frame", nil, UIParent)
frame:SetAllPoints(GameTimeFrame)


frame:RegisterEvent("CALENDAR_UPDATE_PENDING_INVITES")
frame:RegisterEvent("CALENDAR_EVENT_ALARM")
frame:RegisterEvent("PLAYER_ENTERING_WORLD")
frame:RegisterEvent("CALENDAR_UPDATE_EVENT_LIST")
frame:RegisterEvent("CALENDAR_UPDATE_GUILD_EVENTS")


	-- Change text here --
local font = frame:CreateFontString("NewInvite", "OVERLAY", "GameFontNormal") -- The number representing Invites

-- position here: "LEFT", "RIGHT", "TOP", "BOTTOM" in relation to the calendar button
font:SetPoint("RIGHT", GameTimeFrame, "RIGHT", 0, 0) 

-- change color here: any combination numbers between 0 and 1
font:SetTextColor(0, 1, 0) 

-- change font style here: font path, text size, and modifiers such as "OUTLINE", MONOCHROME", "THICKOUTLINE" or leave blank for none
font:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE") 


local font2 = frame:CreateFontString("NewEvent", "OVERLAY", "GameFontNormal") -- The number representing Guild Events

-- position here: "LEFT", "RIGHT", "TOP", "BOTTOM" in relation to the calendar button
font2:SetPoint("LEFT", GameTimeFrame, "LEFT", 0, 0)

-- change color here: any combination numbers between 0 and 1
font2:SetTextColor(0, 1, 0)

-- change font style here: font path, text size, and modifiers such as "OUTLINE", MONOCHROME", "THICKOUTLINE" or leave blank for none
font2:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")


local font3 = frame:CreateFontString("Reminder", "OVERLAY", "GameFontNormal") -- The number representing events occuring today

-- position here: "LEFT", "RIGHT", "TOP", "BOTTOM" in relation to the calendar button
font3:SetPoint("TOP", GameTimeFrame, "TOP", 0, 0)

-- change color here: any combination numbers between 0 and 1
font3:SetTextColor(.2, .8, 1)

-- change font style here: font path, text size, and modifiers such as "OUTLINE", MONOCHROME", "THICKOUTLINE" or leave blank for none
font3:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")


local function CheckToday()
local curweekday, curmonth, curday, curyear = CalendarGetDate()
local numtodaysEvents = CalendarGetNumDayEvents(0, curday)	
local todaysevents = 0		
	font3:SetText("")
	if numtodaysEvents ~= 0 then
		for i = 1, numtodaysEvents do
		local title3, hour3, minute3, calendarType3, _, _, _, _, inviteStatus3, invitedBy3 = CalendarGetDayEvent(0, curday, i)
		if calendarType3 == "PLAYER" or calendarType3 == "GUILD_EVENT" then
			if inviteStatus3 == 8 or inviteStatus3 == 3 or inviteStatus3 == 5 then
				return
			else
			--DEFAULT_CHAT_FRAME:AddMessage(string.format("|cffffff00CalendarHUD:|r %s is scheduled for today at %02d:%02d.", title3, hour3, minute3 ))			
				todaysevents = todaysevents + 1
				font3:SetText(todaysevents)
			end
		end
		end
	end
end

local function GetInvites()
font:SetText("")
	if CalendarGetNumPendingInvites() ~= 0 then	
		font:SetText(CalendarGetNumPendingInvites())	
	end	
end

local function GetGuildEvents()
local pendinginvites = 0
local numguildEvents = CalendarGetNumGuildEvents()
local currentweekday, currentmonth, currentday, currentyear = CalendarGetDate()
	font2:SetText("")
	for eventIndex = 1, numguildEvents do
		
		local month, day, weekday, hour, minute, eventType, title, calendarType, textureName = CalendarGetGuildEventInfo(eventIndex)
		local monthOffset = month - currentmonth
		local numEvents = CalendarGetNumDayEvents(monthOffset, day)
		
		if numEvents ~= 0 then
			for i = 1, numEvents do
			local title2, hour2, minute2, calendarType2, _, _, _, _, inviteStatus, invitedBy = CalendarGetDayEvent(monthOffset, day, i)
				if inviteStatus == 8 then
					pendinginvites = pendinginvites + 1
					font2:SetText(pendinginvites)
				end	
			end
		end
	end
end 
 
local function eventHandler(self, event, ...)
	if event == "CALENDAR_EVENT_ALARM" then
	local title, hour, minute = ...;
		UIErrorsFrame:AddMessage(string.format("%s begins in 15 minutes", title), 0, 1, 0, nil, 15)
		PlaySound("AlarmClockwarning3")
	elseif event == "PLAYER_ENTERING_WORLD" then
		local _, todaysmonth, _, todaysyear = CalendarGetDate()
		CalendarSetAbsMonth(todaysmonth, todaysyear)
		OpenCalendar()
		GetInvites() 
		GetGuildEvents()
		CheckToday()
		frame:UnregisterEvent("PLAYER_ENTERING_WORLD")
	elseif event == "CALENDAR_UPDATE_PENDING_INVITES" or event == "CALENDAR_UPDATE_EVENT_LIST" or event == "CALENDAR_UPDATE_GUILD_EVENTS" then
		GetInvites() 
		GetGuildEvents()
		CheckToday()
	end
end
frame:SetScript("OnEvent", eventHandler)

