local BabbleZone = LibStub("LibBabble-Zone-3.0"):GetLookupTable();

-----------------------------------------------------------------------------
-- instance table, if you create a new instance module you must add it here
--usage max 3 levels in the table
--Entry: Instancename,your_module_name, "Submenu"
-----------------------------------------------------------------------------


local L = LibStub("AceLocale-3.0"):GetLocale("BossTactics")

function BossTactics:RegisterInstances()

	self.instanceTable =
		{
		 ["WoW"] = {
		 	["func"] = function (arg1, arg2) self:InstanceDropdownClick(arg1, arg2) end,
			["values"] = {}
		 },
		 ["BC"] = {
		 	["func"] = function (arg1, arg2) self:InstanceDropdownClick(arg1, arg2) end,
			["values"] = {
                [BabbleZone["Eastern Kingdoms"]] = {
                        { BabbleZone["Karazhan"], "BT_Kara", nil },
                        { BabbleZone["Zul'Aman"], "BT_ZA", nil },
                        { BabbleZone["Sunwell Plateau"], "BT_SW", nil },
                },
                [BabbleZone["Kalimdor"]] = {
                        { BabbleZone["Hyjal Summit"], "BT_MH", nil },
                },
                [BabbleZone["Outland"]] = {
                        { BabbleZone["Gruul's Lair"], "BT_Gruul", nil },
                        { BabbleZone["Magtheridon's Lair"], "BT_Maggi", nil },
                        { BabbleZone["Serpentshrine Cavern"], "BT_SSC", nil },
                        { BabbleZone["The Eye"], "BT_Eye", "Submenu" },
                        { BabbleZone["Black Temple"], "BT_BlackTemple", nil },
                        { L["Outdoor"], "BT_BCout", nil },
                },
          	},
        },
        ["WOTLK"] = {
		 	["func"] = function (arg1, arg2) self:InstanceDropdownClick(arg1, arg2) end,
			["values"] = {
                [BabbleZone["Northrend"]] = {
                        { BabbleZone["Naxxramas"], "BT_Naxx", nil },
                        { BabbleZone["The Obsidian Sanctum"], "BT_Obsid", nil },
                        { BabbleZone["Vault of Archavon"], "BT_Arch", nil },
                        { BabbleZone["The Eye of Eternity"], "BT_Malygos", nil },
                        { BabbleZone["Ulduar"], "BT_Ulduar", "Submenu" },
                        { BabbleZone["The Argent Coliseum"], "BT_ArgentCol", nil,
                            {
                                {
                                    name = BabbleZone["Trial of the Crusader"],
                                },
        					},
        				},
        				{ BabbleZone["Icecrown Citadel"], "BT_ICC", nil },
        				{ BabbleZone["The Ruby Sanctum"], "BT_Ruby", nil },
                },
                [BabbleZone["Kalimdor"]] = {
                        { BabbleZone["Onyxia's Lair"], "BT_Onyxia", nil },
                },
                [L["5-man instances"]] = {
                		{ BabbleZone["The Violet Hold"], "BT_WOTLK5man", BabbleZone["The Violet Hold"]},
                		{ BabbleZone["Azjol-Nerub"], "BT_WOTLK5man", BabbleZone["Azjol-Nerub"]},
                		{ BabbleZone["Ahn'kahet: The Old Kingdom"], "BT_WOTLK5man", BabbleZone["Ahn'kahet: The Old Kingdom"]},
                		{ BabbleZone["The Culling of Stratholme"], "BT_WOTLK5man", BabbleZone["The Culling of Stratholme"]},
                		{ BabbleZone["Trial of the Champion"], "BT_WOTLK5man", BabbleZone["Trial of the Champion"]},
                		{ BabbleZone["The Forge of Souls"], "BT_WOTLK5man", BabbleZone["The Forge of Souls"]},
                		{ BabbleZone["Pit of Saron"], "BT_WOTLK5man", BabbleZone["Pit of Saron"]},
                		{ BabbleZone["Halls of Reflection"], "BT_WOTLK5man", BabbleZone["Halls of Reflection"]},
                		{ BabbleZone["Halls of Stone"], "BT_WOTLK5man", BabbleZone["Halls of Stone"]},
                		{ BabbleZone["Halls of Lightning"], "BT_WOTLK5man", BabbleZone["Halls of Lightning"]},
                		{ BabbleZone["The Nexus"], "BT_WOTLK5man", BabbleZone["The Nexus"]},
                		{ BabbleZone["The Oculus"], "BT_WOTLK5man", BabbleZone["The Oculus"]},
                		{ BabbleZone["Gundrak"], "BT_WOTLK5man", BabbleZone["Gundrak"]},
                		{ BabbleZone["Drak'Tharon Keep"], "BT_WOTLK5man", BabbleZone["Drak'Tharon Keep"]},
                		{ BabbleZone["Utgarde Keep"], "BT_WOTLK5man", BabbleZone["Utgarde Keep"]},
                		{ BabbleZone["Utgarde Pinnacle"], "BT_WOTLK5man", BabbleZone["Utgarde Pinnacle"]},
                }
          	},
        },
	}

end