

local L = LibStub("AceLocale-3.0"):GetLocale("BossTactics")


---------------------------------------------------------------
-- create the main frame
-- main frame komponents: MainWindow
-- MainWindow: LeftPane,RightPane
---------------------------------------------------------------

function BossTactics:CreateMainFrame()
    if(self:IsDebug()) then
        self:Print("CreateMainFrame aufgerufen")
    end

    local screenX = GetScreenWidth() -140
    local screenY = GetScreenHeight()-130

    local mainX = 1075
    local mainY = 830

    local scale = 1.0

    if(screenY < mainY)then
        scale = screenY/mainY
    elseif(screenX < mainX)then
        scale = screenX/mainX
    end


    --self:Print(mainX.." "..scale)

    self.MainWindow = CreateFrame("Frame", "BT_MainFrame",UIParent)
    --create the main frame-window
    local theFrame = self.MainWindow
    theFrame.stateMove = false
    theFrame:ClearAllPoints()
    theFrame:SetPoint("CENTER",UIParent,"CENTER",0,40)
    theFrame:SetHeight(mainY)
    theFrame:SetFrameLevel(100)
    theFrame:SetToplevel(true)
    theFrame:SetWidth(mainX)
    theFrame:SetScale(scale)

    theFrame.TitleTexture = theFrame:CreateTexture("BT_TitleBG","BACKGROUND")
    theFrame.TitleTexture:SetPoint("TOPLEFT",theFrame,"TOPLEFT",7,-5)
    theFrame.TitleTexture:SetWidth(theFrame:GetWidth()-15)
    theFrame.TitleTexture:SetHeight(25)
    theFrame.TitleTexture:SetTexture(16/255,24/255,177/255)

    theFrame:SetBackdrop({
        bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 12,
        --edgeFile = "Interface\\Addons\\BossTactics\\Textures\\otravi-semi-full-border", edgeSize = 32,
        edgeFile = "Interface/Tooltips/UI-Tooltip-Border", edgeSize = 32,
        insets = {left = 7, right = 7, top = 7, bottom = 7},
    })
    theFrame:SetBackdropBorderColor(0,0,1.0)
    theFrame:SetBackdropColor(24/255, 24/255, 24/255)
    theFrame:EnableMouse(true)
    theFrame:SetMovable(false)

    theFrame:SetScript("OnMouseUp", function()
    				if(self.MainWindow.stateMove)then
    					 if ( this.isMoving ) then
                          this:StopMovingOrSizing();
                          this.isMoving = false;
                         end
                    elseif(self:IsRaidLeader() and self.MainWindow.LeftPane.PingPaintBtn.statePaint)then
                        theFrame.LeftPane.ImgPane.drawing = false
                    else
                        if(not self:IsRaidLeader()) then return end
                        local x, y = GetCursorPosition()
                        local imgPane = this.LeftPane.ImgPane
                        y = y/imgPane:GetEffectiveScale()
                        x = x/imgPane:GetEffectiveScale()
                        x = x-imgPane:GetLeft()-((imgPane.Ping:GetRight()-imgPane.Ping:GetLeft())/2)
                        y = y-imgPane:GetBottom()-((imgPane.Ping:GetTop()-imgPane.Ping:GetBottom())/2)

                        if((x>-30 and x<=imgPane:GetWidth()-30) and (y>-30 and y<=imgPane:GetHeight()-30) and self.currInstanceId ~= "EMPTY" and self:IsSession())then
                            imgPane.Ping:ClearAllPoints()
                            PlaySound("MapPing");
                            imgPane.Ping:SetPoint("BOTTOMLEFT", imgPane, "BOTTOMLEFT",x,y)
                            imgPane.Ping:Show()
                            imgPane.Ping.timer = 2
                            imgPane.Ping:SetAlpha(1)
                            imgPane.PingTimer:ScheduleRepeatingTimer("BT_PingTimer", function () BossTactics:FadePing() end, 0.2)
                            self:BT_SendDataMessage("{LPING:"..x..":"..y.."}")
                        end
                    end
                    end)



    theFrame:SetScript("OnMouseDown", function()
    				if(self.MainWindow.stateMove)then
    					 if (arg1 == "LeftButton") then
                          this:StartMoving();
                          this.isMoving = true;
                     	 end
                    elseif(self:IsRaidLeader() and self.MainWindow.LeftPane.PingPaintBtn.statePaint)then
                        theFrame.LeftPane.ImgPane.drawing = true
                        theFrame.LeftPane.ImgPane.lines[self.currInstanceId][self.currInstanceMode][self.currBossId][self.currImgId].deleted = false
                        theFrame.LeftPane.ImgPane.PaintDelBtn:Show()
                    end
                        end)

    theFrame.Title=theFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
    theFrame.Title:SetPoint("TOPLEFT",theFrame,"TOPLEFT",12,-12)
    theFrame.Title:SetTextColor(1.0,1.0,1.0,1.0)
    theFrame.Title:SetText("BossTactics")

    theFrame.CloseButton=CreateFrame("Button","BT_closemainframe",theFrame)
    theFrame.CloseButton:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
    theFrame.CloseButton:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
    theFrame.CloseButton:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
    theFrame.CloseButton:SetWidth(22)
    theFrame.CloseButton:SetHeight(22)
    theFrame.CloseButton:SetPoint("TOPRIGHT",theFrame,"TOPRIGHT",-9,-9)
    theFrame.CloseButton:SetScript("OnClick",function() self:HandleCloseMainWindow() end)

    theFrame.MoveButton=CreateFrame("Button","BT_movemainframe",theFrame)
    theFrame.MoveButton:SetNormalTexture("Interface\\Buttons\\UI-AttributeButton-Encourage-Up.blp")
    theFrame.MoveButton:SetPushedTexture("Interface\\Buttons\\UI-AttributeButton-Encourage-Down.blp")
    theFrame.MoveButton:SetHighlightTexture("Interface\\Buttons\\UI-AttributeButton-Encourage-Hilight.blp")
    theFrame.MoveButton:SetWidth(18)
    theFrame.MoveButton:SetHeight(18)
    theFrame.MoveButton:SetPoint("TOPRIGHT",theFrame,"TOPRIGHT",-30,-11)
    theFrame.MoveButton:SetScript("OnClick",function()
    		if(theFrame.stateMove)then
    			self:Print(L["move end"])
    			theFrame.stateMove = false
    			theFrame:SetMovable(false)
    		else
    			self:Print(L["move start"])
    			theFrame.stateMove = true
    			theFrame:SetMovable(true)
    		end
     end)

end;

function BossTactics:IsRaidFrameShown()
	if(self.MainWindow == nil)then return false end
	return self.MainWindow:IsVisible()
end

--------------------------------------------------------
-- create the left panel for normal users
--------------------------------------------------------

function BossTactics:CreateLeftPanel()
    if(self.MainWindow ~= nil) then
        local theFrame = self.MainWindow;
        theFrame.LeftPane = CreateFrame("Frame","BT_LeftPane",theFrame)
        theFrame.LeftPane:ClearAllPoints()
        theFrame.LeftPane:SetPoint("TOPLEFT",theFrame,"TOPLEFT",0,-30)
        theFrame.LeftPane:SetHeight(theFrame:GetHeight()-30)
        theFrame.LeftPane:SetWidth(theFrame:GetWidth()/2)

		self:CreateTopButtonBar(theFrame.LeftPane)

        theFrame.LeftPane.SyncBtn = CreateFrame("Button","BT_SyncBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
        theFrame.LeftPane.SyncBtn:SetWidth(120)
        theFrame.LeftPane.SyncBtn:SetHeight(20)
        theFrame.LeftPane.SyncBtn:SetText(L["Sync"])
        theFrame.LeftPane.SyncBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",240,-730)
        theFrame.LeftPane.SyncBtn:SetScript("OnClick",function()
                        if(self:IsSession() and self.isSessionLeader) then
                            self.syncDraw = true
                            self:SyncRaid(true)
                        else
                            self.isNotWatchingAsked = true
                            self.isNotWatching = false
                            self:BT_SendDataMessage("{SYNCREQ}")
                        end
                          end)

        theFrame.LeftPane.PrevImgBtn = CreateFrame("Button","BT_PrevImgBtn",theFrame.LeftPane)
        theFrame.LeftPane.PrevImgBtn:SetWidth(32)
        theFrame.LeftPane.PrevImgBtn:SetHeight(32)
        theFrame.LeftPane.PrevImgBtn:SetNormalTexture("Interface\\Buttons\\UI-SpellbookIcon-PrevPage-Up.blp")
        theFrame.LeftPane.PrevImgBtn:SetPushedTexture("Interface\\Buttons\\UI-SpellbookIcon-PrevPage-Down.blp")
        theFrame.LeftPane.PrevImgBtn:SetDisabledTexture("Interface\\Buttons\\UI-SpellbookIcon-PrevPage-Disabled.blp")
        theFrame.LeftPane.PrevImgBtn:Disable()
        theFrame.LeftPane.PrevImgBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",20,-50)
        theFrame.LeftPane.PrevImgBtn:SetScript("OnClick",function()
                            self:ShowBossImage(self.currImgId-1)
                            if(self:IsRaidLeader() and self:IsSession())then
                                self:BT_SendDataMessage("{RLPR:"..self.currInstanceId..":"..self.currBossId..":"..self.currImgId.."}")
                                self:SyncRaid(true)
                            elseif(self:IsSession())then
                                BossTactics:BT_SendDataMessage("{UICH}")
                            end
                          end)
        theFrame.LeftPane.NextImgBtn = CreateFrame("Button","BT_NextImgBtn",theFrame.LeftPane)
        theFrame.LeftPane.NextImgBtn:SetWidth(32)
        theFrame.LeftPane.NextImgBtn:SetHeight(32)
        theFrame.LeftPane.NextImgBtn:SetNormalTexture("Interface\\Buttons\\UI-SpellbookIcon-NextPage-Up.blp")
        theFrame.LeftPane.NextImgBtn:SetPushedTexture("Interface\\Buttons\\UI-SpellbookIcon-NextPage-Down.blp")
        theFrame.LeftPane.NextImgBtn:SetDisabledTexture("Interface\\Buttons\\UI-SpellbookIcon-NextPage-Disabled.blp")
        theFrame.LeftPane.NextImgBtn:Disable()
        theFrame.LeftPane.NextImgBtn:SetPoint("TOPRIGHT",theFrame.LeftPane,"TOPRIGHT",-20,-50)
        theFrame.LeftPane.NextImgBtn:SetScript("OnClick",function()
                        self:ShowBossImage(self.currImgId+1)
                        if(self:IsRaidLeader() and self:IsSession())then
                            self:BT_SendDataMessage("{RLNX:"..self.currInstanceId..":"..self.currBossId..":"..self.currImgId.."}")
                            self:SyncRaid(true)
                        elseif(self:IsSession())then
                                BossTactics:BT_SendDataMessage("{UICH}")
                        end
                          end)

        theFrame.LeftPane.titleLeftPane = theFrame.LeftPane:CreateFontString(nil,"OVERLAY","MailTextFontNormal")
        theFrame.LeftPane.titleLeftPane:SetTextColor(226/255,186/255,0)
        theFrame.LeftPane.titleLeftPane:SetText("BossTactics")
        theFrame.LeftPane.titleLeftPane:SetPoint("TOP",theFrame.LeftPane,"Top",0,-55)

        theFrame.LeftPane.InfoBtn = CreateFrame("Button","BT_InfoBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
        theFrame.LeftPane.InfoBtn:SetWidth(70)
        theFrame.LeftPane.InfoBtn:SetHeight(20)
        theFrame.LeftPane.InfoBtn:SetText(L["Info"])
        theFrame.LeftPane.InfoBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",40,-700)
        theFrame.LeftPane.InfoBtn:SetScript("OnClick",function()
                            BossTactics:ShowInfoFrame()
                              end)
        theFrame.LeftPane.SaveBtn = CreateFrame("Button","BT_SaveBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
        theFrame.LeftPane.SaveBtn:SetWidth(100)
        theFrame.LeftPane.SaveBtn:SetHeight(20)
        theFrame.LeftPane.SaveBtn:SetText(L["Save"])
        theFrame.LeftPane.SaveBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",120,-700)
        theFrame.LeftPane.SaveBtn:Disable()
        theFrame.LeftPane.SaveBtn:SetScript("OnClick",function()
                            self:SaveValues()
                              end)
        theFrame.LeftPane.StdBtn = CreateFrame("Button","BT_StdBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
        theFrame.LeftPane.StdBtn:SetWidth(190)
        theFrame.LeftPane.StdBtn:SetHeight(20)
        theFrame.LeftPane.StdBtn:SetText(L["Recover Standard"])
        theFrame.LeftPane.StdBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",230,-700)
        theFrame.LeftPane.StdBtn:SetScript("OnClick",function()
                            self:RestoreDefaults()
                              end)
        theFrame.LeftPane.StdBtn:Disable()
        theFrame.LeftPane.SessResetBtn = CreateFrame("Button","BT_SessResetBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
        theFrame.LeftPane.SessResetBtn:SetWidth(190)
        theFrame.LeftPane.SessResetBtn:SetHeight(20)
        theFrame.LeftPane.SessResetBtn:SetText(L["Recover Session"])
        theFrame.LeftPane.SessResetBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",40,-730)
        theFrame.LeftPane.SessResetBtn:Disable()
        theFrame.LeftPane.SessResetBtn:SetScript("OnClick",function()
                            self:ResetSessionData()
                              end)
        theFrame.LeftPane.RaidLeadModeBtn = CreateFrame("Button","BT_RaidLeadModeBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
        theFrame.LeftPane.RaidLeadModeBtn:SetWidth(100)
        theFrame.LeftPane.RaidLeadModeBtn:SetHeight(20)
        theFrame.LeftPane.RaidLeadModeBtn:SetText(L["Tactic Mode"])
        theFrame.LeftPane.RaidLeadModeBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",40,-760)
        theFrame.LeftPane.RaidLeadModeBtn:Enable()
        theFrame.LeftPane.RaidLeadModeBtn:SetScript("OnClick",function()
                            self:EnableTacticMode()
                              end)
        theFrame.LeftPane.RaidLeadActionsBtn = CreateFrame("Button","BT_RaidLeadActionsBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
        theFrame.LeftPane.RaidLeadActionsBtn:SetWidth(140)
        theFrame.LeftPane.RaidLeadActionsBtn:SetHeight(20)
        theFrame.LeftPane.RaidLeadActionsBtn:SetText(L["Raidleader Actions"])
        theFrame.LeftPane.RaidLeadActionsBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",370,-730)
        theFrame.LeftPane.RaidLeadActionsBtn:Enable()
        self.currPossibleRLActions = {}
        theFrame.LeftPane.RaidLeadActionsBtn:SetScript("OnClick",function()
                            self.currDropdownTable = {
                                ["func"] = function (arg1) self:RLActionsDropdownClick(arg1) end,
                                ["values"] = self.currPossibleRLActions
                            }
                        ToggleDropDownMenu(1, nil, theFrame.LeftPane.RLActionsDropdown,this, 0, 0);
                              end)
    	theFrame.LeftPane.RLActionsDropdown = CreateFrame("Frame", "BT_RLActionsDropdown", theFrame.LeftPane.RaidLeadActionsBtn, "UIDropDownMenuTemplate");
        UIDropDownMenu_Initialize(theFrame.LeftPane.RLActionsDropdown, function () BossTactics:DropDownOneLevel_Initialize() end, "MENU");

        theFrame.LeftPane.NoneFont = theFrame.LeftPane:CreateFontString(nil,"OVERLAY","GameFontNormalLarge")
        theFrame.LeftPane.NoneFont:ClearAllPoints()
        theFrame.LeftPane.NoneFont:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",15,-290)
        theFrame.LeftPane.NoneFont:SetWidth(512)
        theFrame.LeftPane.NoneFont:SetText(L["No picture"])
        theFrame.LeftPane.NoneFont:SetTextColor(1,1,1)

        theFrame.LeftPane.ImgPane = CreateFrame("Frame","BT_imgPane",theFrame.LeftPane)
        theFrame.LeftPane.ImgPane:ClearAllPoints()
        theFrame.LeftPane.ImgPane:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",15,-90)
        theFrame.LeftPane.ImgPane:SetHeight(550)
        theFrame.LeftPane.ImgPane:SetWidth(512)
       -- theFrame.LeftPane.ImgPane:EnableMouse(true)
       -- theFrame.LeftPane.ImgPane:SetToplevel(true)
        theFrame.LeftPane.ImgPane.fontstrings = {}

        theFrame.LeftPane.ImgPane.texture1 = theFrame.LeftPane.ImgPane:CreateTexture("BT_img1Tx","BACKGROUND")
        theFrame.LeftPane.ImgPane.texture1:SetWidth(550)
        theFrame.LeftPane.ImgPane.texture1:SetHeight(512)
        theFrame.LeftPane.ImgPane.texture1:SetPoint("TOPLEFT",theFrame.LeftPane.ImgPane,"TOPLEFT",0,0)
        theFrame.LeftPane.ImgPane.texture1:SetPoint("BOTTOMRIGHT",theFrame.LeftPane.ImgPane,"BOTTOMRIGHT",0,0)

        theFrame.LeftPane.ImgPane.texture2 = theFrame.LeftPane.ImgPane:CreateTexture("BT_img2Tx","BACKGROUND")
        theFrame.LeftPane.ImgPane.texture2:SetWidth(550)
        theFrame.LeftPane.ImgPane.texture2:SetHeight(512)
        theFrame.LeftPane.ImgPane.texture2:SetPoint("TOPLEFT",theFrame.LeftPane.ImgPane,"TOPLEFT",512,0)
        theFrame.LeftPane.ImgPane.texture2:SetPoint("BOTTOMRIGHT",theFrame.LeftPane.ImgPane,"BOTTOMRIGHT",0,0)
        theFrame.LeftPane.ImgPane.texture2:Hide()

        theFrame.LeftPane.ImgPane.LegendPane = CreateFrame("Frame","BT_legendPane",theFrame.LeftPane.ImgPane)
        theFrame.LeftPane.ImgPane.LegendPane:ClearAllPoints()
        theFrame.LeftPane.ImgPane.LegendPane:SetPoint("BOTTOMLEFT",self.MainWindow.LeftPane.ImgPane,"BOTTOMLEFT",0,5)
        theFrame.LeftPane.ImgPane.LegendPane:SetWidth(500)
        theFrame.LeftPane.ImgPane.LegendPane:SetHeight(70)
        theFrame.LeftPane.ImgPane.LegendPane.buttons = {}
        theFrame.LeftPane.ImgPane.LegendPane.buttonPool = {}
        theFrame.LeftPane.ImgPane.LegendPane.fontstrings = {}

        theFrame.LeftPane.ImgPane.Ping = CreateFrame("Model","Bt_imgPing", theFrame.LeftPane.ImgPane)
        theFrame.LeftPane.ImgPane.Ping:SetModel("Interface\\MiniMap\\Ping\\MinimapPing.mdx")
        theFrame.LeftPane.ImgPane.Ping:SetModelScale(0.7)
        theFrame.LeftPane.ImgPane.Ping:SetWidth(60)
        theFrame.LeftPane.ImgPane.Ping:SetHeight(60)
        theFrame.LeftPane.ImgPane.Ping:SetPoint("CENTER",theFrame.LeftPane.ImgPane,"CENTER")

        local Scale = theFrame.LeftPane:GetEffectiveScale();
        local Hypotenuse = ( ( GetScreenWidth() * Scale ) ^ 2 + ( GetScreenHeight() * Scale ) ^ 2 ) ^ 0.5;

        local CoordRight = ( theFrame.LeftPane.ImgPane.Ping:GetRight() -theFrame.LeftPane.ImgPane.Ping:GetLeft() ) / Hypotenuse; -- X
        local CoordTop = ( theFrame.LeftPane.ImgPane.Ping:GetTop() - theFrame.LeftPane.ImgPane.Ping:GetBottom() ) / Hypotenuse; -- Y
        theFrame.LeftPane.ImgPane.Ping:SetPosition(CoordRight/2,CoordTop/2,0)
        theFrame.LeftPane.ImgPane.Ping:SetAlpha(1)
        theFrame.LeftPane.ImgPane.Ping:Hide()
        theFrame.LeftPane.ImgPane.PingTimer = LibStub("LibSimpleTimer-1.0")
        theFrame.LeftPane.ImgPane.Ping.timer=0
        theFrame.LeftPane.ImgPane.PaintTimer = LibStub("LibSimpleTimer-1.0")
        theFrame.LeftPane.ImgPane.optColor = {}
        theFrame.LeftPane.ImgPane.optColor[1] = 1.0
        theFrame.LeftPane.ImgPane.optColor[2] = 1.0
        theFrame.LeftPane.ImgPane.optColor[3] = 1.0
        theFrame.LeftPane.ImgPane.optColor[4] = 1.0
        theFrame.LeftPane.ImgPane.drawing = false
        theFrame.LeftPane.ImgPane.linewidth = 64
        theFrame.LeftPane.ImgPane.lines = {}

        theFrame.LeftPane.ImgPane.Action1Btn = CreateFrame("Button","BT_Action1Btn",theFrame.LeftPane.ImgPane,"UIPanelButtonTemplate")
        theFrame.LeftPane.ImgPane.Action1Btn:SetWidth(100)
        theFrame.LeftPane.ImgPane.Action1Btn:SetHeight(20)
        theFrame.LeftPane.ImgPane.Action1Btn:SetAlpha(0.7)
        theFrame.LeftPane.ImgPane.Action1Btn:SetPoint("TOPLEFT",theFrame.LeftPane.ImgPane,"TOPLEFT",3,-3)
        theFrame.LeftPane.ImgPane.Action1Btn:Hide()
        theFrame.LeftPane.ImgPane.Action1Btn:SetScript("OnClick",function()
                            this:ClickAction()
                              end)
        theFrame.LeftPane.ImgPane.Action1Btn:SetScript("OnEnter",function()
                    this:SetAlpha(1)
                end)
        theFrame.LeftPane.ImgPane.Action1Btn:SetScript("OnLeave",function()
                    this:SetAlpha(0.7)
                end)

        theFrame.LeftPane.ImgPane.Action2Btn = CreateFrame("Button","BT_Action2Btn",theFrame.LeftPane.ImgPane,"UIPanelButtonTemplate")
        theFrame.LeftPane.ImgPane.Action2Btn:SetWidth(100)
        theFrame.LeftPane.ImgPane.Action2Btn:SetHeight(20)
        theFrame.LeftPane.ImgPane.Action2Btn:SetAlpha(0.7)
        theFrame.LeftPane.ImgPane.Action2Btn:SetPoint("TOPLEFT",theFrame.LeftPane.ImgPane,"TOPLEFT",108,-3)
        theFrame.LeftPane.ImgPane.Action2Btn:Hide()
        theFrame.LeftPane.ImgPane.Action2Btn:SetScript("OnClick",function()
                            this:ClickAction()
                              end)
        theFrame.LeftPane.ImgPane.Action2Btn:SetScript("OnEnter",function()
                    this:SetAlpha(1)
                end)
        theFrame.LeftPane.ImgPane.Action2Btn:SetScript("OnLeave",function()
                    this:SetAlpha(0.7)
                end)
        theFrame.LeftPane.ImgPane.Action3Btn = CreateFrame("Button","BT_Action3Btn",theFrame.LeftPane.ImgPane,"UIPanelButtonTemplate")
        theFrame.LeftPane.ImgPane.Action3Btn:SetWidth(100)
        theFrame.LeftPane.ImgPane.Action3Btn:SetHeight(20)
        theFrame.LeftPane.ImgPane.Action3Btn:SetAlpha(0.7)
        theFrame.LeftPane.ImgPane.Action3Btn:SetPoint("TOPLEFT",theFrame.LeftPane.ImgPane,"TOPLEFT",213,-3)
        theFrame.LeftPane.ImgPane.Action3Btn:Hide()
        theFrame.LeftPane.ImgPane.Action3Btn:SetScript("OnClick",function()
                            this:ClickAction()
                              end)
        theFrame.LeftPane.ImgPane.Action3Btn:SetScript("OnEnter",function()
                    this:SetAlpha(1)
                end)
        theFrame.LeftPane.ImgPane.Action3Btn:SetScript("OnLeave",function()
                    this:SetAlpha(0.7)
                end)

        theFrame.LeftPane.ImgPane:SetScript("OnMouseUp", function()
    				--self:IncreaseImagePane()
                        end)

        theFrame.LeftPane.buttons = {}
        theFrame.LeftPane.buttonPool = {}

    elseif(self:IsDebug()) then
        self:Print("CreateLeftPanel: MainWindow is nil")
    end
end;

function BossTactics:CreateTopButtonBar(theFrame)

	if(not theFrame)then return end

	theFrame.AddonBtn = CreateFrame("Button","BT_AddonBtn",theFrame,"UIPanelButtonTemplate")
    theFrame.AddonBtn:SetWidth(70)
    theFrame.AddonBtn:SetHeight(20)
    theFrame.AddonBtn:SetText(self.currAddon)
    theFrame.AddonBtn:SetPoint("TOPLEFT",theFrame,"TOPLEFT",30,-10)
    theFrame.AddonBtn.currAddon = self.currAddon
    theFrame.AddonBtn:SetScript("OnClick",function()
                        local addonTable = {}
                        table.foreach(self.instanceTable, function (i,v) tinsert(addonTable,{i,i}) end)
                        self.currDropdownTable = {
                            ["func"] = function (arg1) self:AddonDropdownClick(arg1) end,
                            ["values"] = addonTable
                        }
                        ToggleDropDownMenu(1, nil, theFrame.AddonDropdown,this, 0, 0);
                      end)
    theFrame.AddonDropdown = CreateFrame("Frame", "BT_AddonDropdown", theFrame.AddonBtn, "UIDropDownMenuTemplate");
    UIDropDownMenu_Initialize(theFrame.AddonDropdown, function () BossTactics:DropDownOneLevel_Initialize() end, "MENU");

    theFrame.InstanzBtn = CreateFrame("Button","BT_InstBtn",theFrame,"UIPanelButtonTemplate")
    theFrame.InstanzBtn:SetWidth(100)
    theFrame.InstanzBtn:SetHeight(20)
    theFrame.InstanzBtn:SetText(L["Instances"])
    theFrame.InstanzBtn:SetPoint("TOPLEFT",theFrame,"TOPLEFT",110,-10)
    theFrame.InstanzBtn.currInstanceId = self.currInstanceId
    theFrame.InstanzBtn.currModuleId = self.currModuleId
    theFrame.InstanzBtn:SetScript("OnClick",function()
                    self.currDropdownTable = self.instanceTable[self.currAddon];
                    ToggleDropDownMenu(1, nil, theFrame.InstancesDropdown,this, 0, 0);
                      end)
    theFrame.InstancesDropdown = CreateFrame("Frame", "BT_InstanceDropdown", theFrame.InstanzBtn, "UIDropDownMenuTemplate");
    UIDropDownMenu_Initialize(theFrame.InstancesDropdown, function () BossTactics:DropDownTwoLevel_Initialize() end, "MENU");

    theFrame.BossBtn = CreateFrame("Button","BT_BossBtn",theFrame,"UIPanelButtonTemplate")
    theFrame.BossBtn:SetWidth(100)
    theFrame.BossBtn:SetHeight(20)
    theFrame.BossBtn:SetText(L["Bosses"])
    theFrame.BossBtn:SetPoint("TOPLEFT",theFrame,"TOPLEFT",220,-10)
    theFrame.BossBtn:Disable()
    theFrame.BossBtn.currBossId = self.currBossId
    theFrame.BossBtn.currBossTable = {}
    theFrame.BossBtn:SetScript("OnClick",function()
                    self.currDropdownTable = {
                            ["func"] = function (arg1) self:BossDropdownClick(arg1) end,
                            ["values"] = self.currBossTable
                        }
                    ToggleDropDownMenu(1, nil, theFrame.BossDropdown,this, 0, 0);
                      end)
    theFrame.BossDropdown = CreateFrame("Frame", "BT_BossDropdown", theFrame.BossBtn, "UIDropDownMenuTemplate");
    UIDropDownMenu_Initialize(theFrame.BossDropdown, function () BossTactics:DropDownOneLevel_Initialize() end, "MENU");

    theFrame.ModeBtn = CreateFrame("Button","BT_modeBtn",theFrame,"UIPanelButtonTemplate")
    theFrame.ModeBtn:SetWidth(100)
    theFrame.ModeBtn:SetHeight(20)
    theFrame.ModeBtn:SetText(L["mode"])
    theFrame.ModeBtn:SetPoint("TOPLEFT",theFrame,"TOPLEFT",330,-10)
    theFrame.ModeBtn:Disable()
    theFrame.ModeBtn.currInstanceMode = self.currInstanceMode
    theFrame.ModeBtn:SetScript("OnClick",function()
                    self.currDropdownTable = {
                            ["func"] = function (arg1) self:ModeDropdownClick(arg1) end,
                            ["values"] = {{"25","mode25"},{"10","mode10"},{"5","mode5"},{"40","mode40"}}
                        }
                    ToggleDropDownMenu(1, nil, theFrame.ModeDropdown,this, 0, 0);
                      end)
    theFrame.ModeDropdown = CreateFrame("Frame", "BT_ModeDropdown", theFrame.ModeBtn, "UIDropDownMenuTemplate");
    UIDropDownMenu_Initialize(theFrame.ModeDropdown, function () BossTactics:DropDownOneLevel_Initialize() end, "MENU");

    theFrame.Patchlvl = theFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
    theFrame.Patchlvl:SetPoint("TOPLEFT",theFrame,"TOPLEFT",440,-13)
    theFrame.Patchlvl:SetTextColor(1,1,1)

end;

------------------------------------------------------
-- callback of the fading function
------------------------------------------------------

function BossTactics:FadePing()

    if(self.MainWindow.LeftPane.ImgPane.Ping.timer <= 1)then
        self.MainWindow.LeftPane.ImgPane.Ping:SetAlpha(self.MainWindow.LeftPane.ImgPane.Ping.timer)
    end
    self.MainWindow.LeftPane.ImgPane.Ping.timer = self.MainWindow.LeftPane.ImgPane.Ping.timer-0.1
    if(self.MainWindow.LeftPane.ImgPane.Ping.timer <= 0)then
        self.MainWindow.LeftPane.ImgPane.Ping:SetAlpha(1)
        self.MainWindow.LeftPane.ImgPane.Ping:Hide()
        self.MainWindow.LeftPane.ImgPane.PingTimer:CancelTimer("BT_PingTimer");
    end
end

--------------------------------------------------------
--increases the size and state of the image pane
--------------------------------------------------------

function BossTactics:IncreaseImagePane()

	local imgPane = self.MainWindow.LeftPane.ImgPane

	imgPane:EnableMouse(false)
	imgPane:SetWidth(1024)

	imgPane.texture1:ClearAllPoints()
	imgPane.texture1:SetPoint("TOPLEFT",imgPane,"TOPLEFT",0,0)
    imgPane.texture1:SetPoint("BOTTOMRIGHT",imgPane,"BOTTOMRIGHT",-512,0)


    imgPane.texture2:SetTexture(self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId].imgdata[1].source)
    imgPane.texture2:Show()

end;

--------------------------------------------------------
-- enables the tactic mode if the user is not in a raid
--------------------------------------------------------

function BossTactics:EnableTacticMode()
	if(UnitInRaid(self.player)) then return end

	self.tacticMode = true
	--draggable buttons generate if needet


    for i,v in ipairs(self.MainWindow.LeftPane.buttons) do
        if(not v.dragged) then

        else
            self.MainWindow.LeftPane.buttons[i].delBtn:Show()
            self.MainWindow.LeftPane.buttons[i].editBtn:Show()
        end
    end

    BossTactics:CreateNewMapButton(self.buttonTypes.melee, true)
    BossTactics:CreateNewMapButton(self.buttonTypes.rangedDPS, true)
    BossTactics:CreateNewMapButton(self.buttonTypes.healer, true)
    BossTactics:CreateNewMapButton(self.buttonTypes.tank, true)
    BossTactics:CreateNewMapButton(self.buttonTypes.boss, true)
    BossTactics:CreateNewMapButton(self.buttonTypes.boss2, true)
    BossTactics:CreateNewMapButton(self.buttonTypes.boss3, true)
    BossTactics:CreateNewMapButton(self.buttonTypes.boss4, true)

	self.MainWindow.LeftPane.RaidLeadModeBtn:Disable()
end;

---------------------------------------------------------
--- create the right panel for normal users
---------------------------------------------------------
function BossTactics:CreateRightPanel(theFrame, name)
    if(theFrame ~= nil and name ~= nil ) then
        theFrame.RightPane = CreateFrame("Frame","BT_rightpane"..name,theFrame)
        theFrame.RightPane:ClearAllPoints()
        theFrame.RightPane:SetPoint("TOPRIGHT",theFrame,"TOPRIGHT",-7,-30)
        theFrame.RightPane:SetHeight(theFrame:GetHeight()-35)
        theFrame.RightPane:SetWidth((theFrame:GetWidth()/2))
        theFrame.RightPane:SetBackdrop({
            bgFile = "Interface\\TabardFrame\\TabardFrameBackground", tile = false,
            --edgeFile = "Interface\\Addons\\BossTactics\\Textures\\otravi-semi-full-border", edgeSize = 32,
            insets = {left = 1, right = 1, top = 1, bottom = 1},
        })
        theFrame.RightPane:SetAlpha(0.90)
        theFrame.RightPane:SetBackdropColor(100/255, 100/255, 100/255)

        if(self.debug) then
            if(UnitInRaid(self.player))then
                self:Print("Raid:"..UnitInRaid(self.player).." Party"..UnitInParty(self.player))
            end
            if(UnitInParty(self.player))then
                self:Print(" Party"..UnitInParty(self.player))
            end
        end

        theFrame.RightPane.ScrollRight = CreateFrame("ScrollFrame","BT_MainScrollRight"..name,theFrame.RightPane,"UIPanelScrollFrameTemplate")
        theFrame.RightPane.ScrollRight:ClearAllPoints();
        theFrame.RightPane.ScrollRight:SetPoint("TOPLEFT",theFrame.RightPane, "TOPLEFT",0,-20)
        theFrame.RightPane.ScrollRight:SetWidth(theFrame.RightPane:GetWidth()-30);
        local right_edit = CreateFrame("EditBox","BT_rightedit"..name,theFrame.RightPane.ScrollRight)
        right_edit:ClearAllPoints();
        right_edit:SetWidth(theFrame.RightPane:GetWidth()-25)
        right_edit:SetPoint("TOPLEFT",theFrame.RightPane.ScrollRight,"TOPLEFT",0,-25)
        theFrame.RightPane.ScrollRight:SetScrollChild(right_edit)
        right_edit.TextLockFlag = false
        right_edit:SetScript("OnTextChanged", function()
                 ScrollingEdit_OnTextChanged(this, this:GetParent())
                 if(theFrame.RightPane.ScrollRight.LockTextButton.locked and right_edit.TextLockFlag)then
                 	local curs = this:GetCursorPosition()
                    this:SetText(theFrame.RightPane.ScrollRight.LockTextButton.tmpOld)
                    right_edit.TextLockFlag = true
                    this:SetCursorPosition(curs-1)
        		elseif(theFrame.RightPane.ScrollRight.LockTextButton.locked and not right_edit.TextLockFlag)then
        			right_edit.TextLockFlag = true
        			theFrame.RightPane.ScrollRight.LockTextButton.tmpOld = this:GetText()
                else
                    self:InputDataChanged()
                end
                end)
        right_edit:SetScript("OnTextSet", function()
                right_edit.TextLockFlag = false
                 end)
        right_edit:SetScript("OnCursorChanged", function()
                 ScrollingEdit_OnCursorChanged(this, arg1, arg2-10, arg3, arg4) end)
        right_edit:SetScript("OnUpdate", function()
                 ScrollingEdit_OnUpdate(this, this:GetParent()) end)
        right_edit:SetScript("OnEscapePressed", function()
                    this:ClearFocus()
                    end)
        right_edit:SetAutoFocus(false)
        right_edit:SetMultiLine(true)
        right_edit:EnableMouse(true)
        right_edit:SetFont("Fonts\\FRIZQT__.TTF",self.db.profile.tacticFontSize)
        right_edit:SetTextColor(1,1,1)
        right_edit:SetTextInsets(10,10,10,10)

        theFrame.RightPane.ScrollRight.LockTextButton=CreateFrame("Button","BT_LockTextbtn"..name,theFrame.RightPane.ScrollRight)
    	theFrame.RightPane.ScrollRight.LockTextButton:SetNormalTexture("Interface\\Buttons\\CancelButton-Up.blp")
        theFrame.RightPane.ScrollRight.LockTextButton:SetPushedTexture("Interface\\Buttons\\CancelButton-Down.blp")
        theFrame.RightPane.ScrollRight.LockTextButton:SetHighlightTexture("Interface\\Buttons\\CancelButton-Highlight.blp")
        theFrame.RightPane.ScrollRight.LockTextButton:SetWidth(25)
        theFrame.RightPane.ScrollRight.LockTextButton:SetHeight(25)
        theFrame.RightPane.ScrollRight.LockTextButton:SetFrameLevel(theFrame.RightPane.ScrollRight:GetScrollChild():GetFrameLevel() + 1)
        theFrame.RightPane.ScrollRight.LockTextButton:SetPoint("TOPRIGHT",theFrame.RightPane.ScrollRight,"TOPRIGHT",0,0)
        theFrame.RightPane.ScrollRight.LockTextButton.locked = false
        theFrame.RightPane.ScrollRight.LockTextButton:SetScript("OnClick",function()
    			this.locked = not this.locked
    			right_edit.TextLockFlag = true
    			if(this.locked)then
    				this.tmpOld = theFrame.RightPane.ScrollRight:GetScrollChild():GetText()
    			else
    				this.tmpOld = nil
    			end
    			if (GameTooltip:IsVisible() ) then
                    GameTooltip:SetOwner(this, "ANCHOR_LEFT");
                    if(this.locked)then
                        GameTooltip:SetText(L["text lock on"]);
                    else
                        GameTooltip:SetText(L["text lock off"]);
                    end
                    GameTooltip:Show();
        		end
         end)
         theFrame.RightPane.ScrollRight.LockTextButton:SetScript("OnEnter",function()
         	if (GameTooltip:IsVisible() ) then
                return;
            end
            GameTooltip:SetOwner(this, "ANCHOR_LEFT");
            if(this.locked)then
                GameTooltip:SetText(L["text lock on"]);
            else
                GameTooltip:SetText(L["text lock off"]);
            end
            GameTooltip:Show();
          end)
    	  theFrame.RightPane.ScrollRight.LockTextButton:SetScript("OnLeave",function()
            GameTooltip:Hide();
         end)

        theFrame.RightPane.SwitchStdBtn = CreateFrame("Button","BT_SwitchStdBtn"..name,theFrame.RightPane,"UIPanelButtonTemplate")
        theFrame.RightPane.SwitchStdBtn:SetWidth(150)
        theFrame.RightPane.SwitchStdBtn:SetHeight(20)
        theFrame.RightPane.SwitchStdBtn:SetText(L["BossTactics"])
        theFrame.RightPane.SwitchStdBtn:SetPoint("TOPRight",theFrame.RightPane,"TOPRight",-15,0)
        theFrame.RightPane.SwitchStdBtn:Disable()
        theFrame.RightPane.SwitchStdBtn:SetFrameLevel(theFrame.RightPane.ScrollRight:GetFrameLevel()+5)
        theFrame.RightPane.SwitchStdBtn.currId = -1
        theFrame.RightPane.SwitchStdBtn:SetScript("OnClick",function()
        					local bool5man = self.currInstanceMode == "mode5"
        					local bossDB

                            if(bool5man)then
                                bossDB = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.curr5ManInstance][self.currBossId]
                            else
                                bossDB = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId]
                            end
                            local textsDB
                            if(theFrame.RightPane.TrashBtn.stdTactic)then
                                textsDB = bossDB.tactictext
                            else
                                textsDB = bossDB.trash
                            end
                            local textsTable = {}
                            for i,v in ipairs(textsDB) do
                                table.insert(textsTable,{v.name,i})
                            end
                            self.currDropdownTable = {
                                ["func"] = function (arg1) self:SwitchDropdownClick(arg1) end,
                                ["values"] = textsTable
                            }
                            ToggleDropDownMenu(1, nil, theFrame.RightPane.SwitchDropdown,this, 0, 0);
                              end)
        theFrame.RightPane.SwitchDropdown = CreateFrame("Frame", "BT_SwitchDropdown"..name, theFrame.RightPane.SwitchStdBtn, "UIDropDownMenuTemplate");
        UIDropDownMenu_Initialize(theFrame.RightPane.SwitchDropdown, function () BossTactics:DropDownOneLevel_Initialize() end, "MENU");

        theFrame.RightPane.TrashBtn = CreateFrame("Button","BT_TrashBtn",theFrame.RightPane,"UIPanelButtonTemplate")
        theFrame.RightPane.TrashBtn:SetWidth(100)
        theFrame.RightPane.TrashBtn:SetHeight(20)
        theFrame.RightPane.TrashBtn:SetText(L["Trash"])
        theFrame.RightPane.TrashBtn:SetPoint("TOPRIGHT",theFrame.RightPane,"TOPRIGHT",-160,0)
        theFrame.RightPane.TrashBtn:Disable()
        theFrame.RightPane.TrashBtn:SetFrameLevel(theFrame.RightPane.ScrollRight:GetFrameLevel()+5)
        theFrame.RightPane.TrashBtn.stdTactic = true
        theFrame.RightPane.TrashBtn.trashId = 1
        theFrame.RightPane.TrashBtn.tacticId = 1
        theFrame.RightPane.TrashBtn:SetScript("OnClick",function()
                            if(this.stdTactic)then
                                this.stdTactic = false
                                this:GetParent().SaveBtn:Disable()
                                this:SetText(L["Tactic"])
                                self:HandleTacticSwitch(theFrame.RightPane.TrashBtn.trashId)
                            else
                                this:SetText(L["Trash"])
                                this:GetParent().SaveBtn:Disable()
                                this.stdTactic = true
                                self:HandleTacticSwitch(theFrame.RightPane.TrashBtn.tacticId)
                            end
                            if(self:IsSession() and self.isSessionLeader and theFrame.RightPane.TextSyncBtn.sync)then
                            	local boss = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId]
                            	if(this.stdTactic)then
                            		self:BT_SendDataMessage("{TRST:1}")
                            		self:BT_SendDataMessage("{TASW:"..boss.tactictext[this.tacticId].name..":"..tostring(boss.tactictext[this.tacticId].version).."}")
                            	else
                            		self:BT_SendDataMessage("{TRST:0}")
                            		self:BT_SendDataMessage("{TASW:"..boss.trash[this.trashId].name..":"..tostring(boss.trash[this.trashId].version).."}")
                            	end
                            end
                              end)

        theFrame.RightPane.SaveBtn = CreateFrame("Button","BT_SaveBtn"..name,theFrame.RightPane,"UIPanelButtonTemplate")
        theFrame.RightPane.SaveBtn:SetWidth(100)
        theFrame.RightPane.SaveBtn:SetHeight(20)
        theFrame.RightPane.SaveBtn:SetText(L["Save"])
        theFrame.RightPane.SaveBtn:SetPoint("TOPRIGHT",theFrame.RightPane,"TOPRIGHT",-265,0)
        theFrame.RightPane.SaveBtn:Disable()
        theFrame.RightPane.SaveBtn:SetFrameLevel(theFrame.RightPane.ScrollRight:GetFrameLevel()+5)
        theFrame.RightPane.SaveBtn:SetScript("OnClick",function()
                            self:SaveText()
                            if(self:IsSession() and self.isSessionLeader and theFrame.RightPane.TextSyncBtn.sync)then
                            	local boss = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId]
                            	if(this:GetParent().TrashBtn.stdTactic)then
                            		self:BT_SendDataMessage("{TRST:1}")
                            		self:BT_SendDataMessage("{TASW:"..boss.tactictext[this:GetParent().TrashBtn.tacticId].name..":"..tostring(boss.tactictext[this:GetParent().TrashBtn.tacticId].version).."}")
                            	else
                            		self:BT_SendDataMessage("{TRST:0}")
                            		self:BT_SendDataMessage("{TASW:"..boss.trash[this:GetParent().TrashBtn.trashId].name..":"..tostring(boss.trash[this:GetParent().TrashBtn.trashId].version).."}")
                            	end
                            end
                              end)

        theFrame.RightPane.SaveAsBtn = CreateFrame("Button","BT_SaveAsBtn"..name,theFrame.RightPane,"UIPanelButtonTemplate")
        theFrame.RightPane.SaveAsBtn:SetWidth(100)
        theFrame.RightPane.SaveAsBtn:SetHeight(20)
        theFrame.RightPane.SaveAsBtn:SetText(L["SaveAs"])
        theFrame.RightPane.SaveAsBtn:SetPoint("TOPRIGHT",theFrame.RightPane,"TOPRIGHT",-370,0)
        theFrame.RightPane.SaveAsBtn:Disable()
        theFrame.RightPane.SaveAsBtn:SetFrameLevel(theFrame.RightPane.ScrollRight:GetFrameLevel()+5)
        theFrame.RightPane.SaveAsBtn:SetScript("OnClick",function()
                            self:ShowNewTextInputFrame(function(info,arg) self:SaveAsText(arg) end,L["Title New Text Inputframe"],L["New Text info"],theFrame)
                              end)
        theFrame.RightPane.DelBtn = CreateFrame("Button","BT_DelBtn"..name,theFrame.RightPane,"UIPanelButtonTemplate")
        theFrame.RightPane.DelBtn:SetWidth(30)
        theFrame.RightPane.DelBtn:SetHeight(20)
        theFrame.RightPane.DelBtn:SetText("X")
        theFrame.RightPane.DelBtn:SetPoint("TOPRIGHT",theFrame.RightPane,"TOPRIGHT",-475,0)
        theFrame.RightPane.DelBtn:Disable()
        theFrame.RightPane.DelBtn:SetFrameLevel(theFrame.RightPane.ScrollRight:GetFrameLevel()+5)
        theFrame.RightPane.DelBtn:SetScript("OnClick",function()
                            self:ShowQuestionFrame(L["del tactic message"], function() self:DelTacticText()  end)
                              end)


		theFrame.RightPane.ScrollRight:SetHeight(theFrame.RightPane:GetHeight()-30);
        right_edit:SetHeight(theFrame.RightPane:GetHeight())
    elseif(self:IsDebug()) then
        self:Print("CreateRightPanel: MainWindow is nil")
    end
end;

----------------------------------------------------------------
--handels if you become raidleader
----------------------------------------------------------------

function BossTactics:BecomeRaidLeader()

	local theFrame = self.MainWindow
    if(theFrame ~= nil)then
    	local leftpane = theFrame.LeftPane
        --change the left panel
        if(self.currModuleId ~= -1)then
            local boss = self.modules[leftpane.InstanzBtn.currModuleId].bosses[leftpane.ModeBtn.currInstanceMode][leftpane.BossBtn.currBossId]
            local imgPane = theFrame.LeftPane.ImgPane
            --update the action buttons
            if(boss.actionBtn1)then
                imgPane.Action1Btn:Show()
            end
            if(boss.actionBtn2)then
                imgPane.Action2Btn:Show()
            end
            if(boss.actionBtn3)then
                imgPane.Action3Btn:Show()
            end
        end

        if(theFrame.QueryManagerFrame)then
        	theFrame.QueryManagerFrame.ExecuteBtn:Enable()
        end


        theFrame.LeftPane.RaidLeadModeBtn:Hide()
        theFrame.LeftPane.RaidLeadActionsBtn:ClearAllPoints()
        theFrame.LeftPane.RaidLeadActionsBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",40,-760)
        theFrame.LeftPane.SyncBtn:ClearAllPoints()
        if(IsRaidLeader())then
       		 self.currPossibleRLActions = { {L["Task Manager"],"TM"}, {L["RaSend"],"RA"},{L["Vote"],"VO"},{L["VerBtn"],"VER"}, {L["Query Manager"],"QU"}, {L["Raidleader"],"RL"}, {L["Id Info"],"ID"}, {L["5-man instances"],"5M"} }
       	else
       		self.currPossibleRLActions = { {L["Task Manager"],"TM"}, {L["RaSend"],"RA"},{L["Vote"],"VO"},{L["VerBtn"],"VER"}, {L["Query Manager"],"QU"}, {L["Id Info"],"ID"}, {L["5-man instances"],"5M"} }
       	end
        theFrame.LeftPane.SyncBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",180,-760)
        self.tacticMode = false
        if(theFrame.LeftPane.SessBtn == nil)then
            theFrame.LeftPane.SessBtn = CreateFrame("Button","BT_SessBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
            theFrame.LeftPane.SessBtn:SetWidth(150)
            theFrame.LeftPane.SessBtn:SetHeight(20)
            theFrame.LeftPane.SessBtn:SetText(L["Session"])
            theFrame.LeftPane.SessBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",40,-730)
            theFrame.LeftPane.SessBtn:SetScript("OnClick",function()
                            if(not self:IsSession())then
                                this:SetText(L["EndSession"])
                                self:StartSession()
                            else
                                this:SetText(L["Session"])
                                self:EndSession()
                            end
                              end)
        else
            theFrame.LeftPane.SessBtn:Show()
        end

        if(self:IsSession() and not self.isSessionLeader)then
            theFrame.LeftPane.SessBtn:Disable()
        end

        theFrame.LeftPane.SessResetBtn:ClearAllPoints()
        theFrame.LeftPane.SessResetBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",200,-730)

        if(not theFrame.LeftPane.PingPaintBtn)then
            theFrame.LeftPane.PingPaintBtn = CreateFrame("Button","BT_PingPaintBtn",theFrame.LeftPane,"UIPanelButtonTemplate")
            theFrame.LeftPane.PingPaintBtn:SetWidth(100)
            theFrame.LeftPane.PingPaintBtn:SetHeight(20)
            theFrame.LeftPane.PingPaintBtn:SetText(L["PaintBtn"])
            theFrame.LeftPane.PingPaintBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",400,-730)
            theFrame.LeftPane.PingPaintBtn.statePaint = false
            theFrame.LeftPane.PingPaintBtn:SetScript("OnClick",function()
                            if(self.currInstanceId == "EMPTY")then return end
                            this.statePaint = not this.statePaint
                            if(this.statePaint)then
                                this:SetText(L["PingBtn"])
                                self.MainWindow.LeftPane.ImgPane.PaintTimer:ScheduleRepeatingTimer("BT_PaintTimer", function () BossTactics:UpdatePaint() end, 0.05)
                            else
                                this:SetText(L["PaintBtn"])
                                self.MainWindow.LeftPane.ImgPane.PaintTimer:CancelTimer("BT_PaintTimer");
                            end

                              end)
        end

        theFrame.LeftPane.PingPaintBtn:Show()
        theFrame.LeftPane.PingPaintBtn:Disable()

        if(not theFrame.LeftPane.ImgPane.PaintDelBtn)then
            theFrame.LeftPane.ImgPane.PaintDelBtn = CreateFrame("Button","BT_PaintDelBtn",theFrame.LeftPane.ImgPane,"UIPanelButtonTemplate")
            theFrame.LeftPane.ImgPane.PaintDelBtn:SetWidth(140)
            theFrame.LeftPane.ImgPane.PaintDelBtn:SetHeight(20)
            theFrame.LeftPane.ImgPane.PaintDelBtn:SetText(L["PaintDelBtn"])
            theFrame.LeftPane.ImgPane.PaintDelBtn:SetPoint("TOPLEFT",theFrame.LeftPane.ImgPane,"TOPRIGHT",-145,-5)
            theFrame.LeftPane.ImgPane.PaintDelBtn:SetAlpha(0.3)
            theFrame.LeftPane.ImgPane.PaintDelBtn:SetScript("OnClick",function()
                                           this:GetParent().lines[leftpane.InstanzBtn.currInstanceId][leftpane.ModeBtn.currInstanceMode][leftpane.BossBtn.currBossId][self.currImgId].deleted = true
                                self:BT_SendDataMessage("{DRAWDEL}")
                                self:ClearImage()
                                this:Hide()
                              end)
            theFrame.LeftPane.ImgPane.PaintDelBtn:SetScript("OnEnter",function()
                    this:SetAlpha(1)
                end)
            theFrame.LeftPane.ImgPane.PaintDelBtn:SetScript("OnLeave",function()
                    this:SetAlpha(0.3)
                end)
        end

        if(leftpane.InstanzBtn.currInstanceId == "EMPTY" or
                theFrame.LeftPane.ImgPane.lines[leftpane.InstanzBtn.currInstanceId][leftpane.ModeBtn.currInstanceMode][leftpane.BossBtn.currBossId][self.currImgId].deleted) then
             theFrame.LeftPane.ImgPane.PaintDelBtn:Hide()
        else
        	theFrame.LeftPane.ImgPane.PaintDelBtn:Show()
        end

        --right pane elements
        theFrame.RightPane.ScrollRight:SetHeight(theFrame.RightPane:GetHeight()-225);
        theFrame.RightPane.ScrollRight:GetScrollChild():SetHeight(theFrame.RightPane:GetHeight()-200)

		--text sync button
		if(theFrame.RightPane.TextSyncBtn == nil)then
            theFrame.RightPane.TextSyncBtn = CreateFrame("Button","BT_TextSyBtn",theFrame.RightPane,"UIPanelButtonTemplate")
            theFrame.RightPane.TextSyncBtn:SetWidth(30)
            theFrame.RightPane.TextSyncBtn:SetHeight(20)
            theFrame.RightPane.TextSyncBtn:SetText(L["TextSyncBtn"])
            theFrame.RightPane.TextSyncBtn:SetPoint("TOPLEFT",theFrame.RightPane,"TOPLEFT",0,0)
            theFrame.RightPane.TextSyncBtn.sync = false
            theFrame.RightPane.TextSyncBtn:Disable()
            theFrame.RightPane.TextSyncBtn:SetScript("OnClick",function()
                            this.sync = not this.sync
                            if (GameTooltip:IsVisible() ) then
                               if(this.sync)then
                	                GameTooltip:SetText(L["text sync on"]);
                                else
                                    GameTooltip:SetText(L["text sync off"]);
                                end
                                if(self:IsSession() and this.sync and self.currInstanceId ~= "EMPTY")then
                            	    if(this:GetParent().TrashBtn.stdTactic)then
                                        self:BT_SendDataMessage("{TRST:1}")
                                    else
                                        self:BT_SendDataMessage("{TRST:0}")
                                    end

                                    local bossText
	                                if(theFrame.RightPane.TrashBtn.stdTactic)then
                                        bossText = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId].tactictext[theFrame.RightPane.SwitchStdBtn.currId]
                                    else
                                        bossText = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId].trash[theFrame.RightPane.SwitchStdBtn.currId]
                                    end
                                    if(this:GetParent().SwitchStdBtn.currId ~= 1)then
                                    	self:BT_SendDataMessage("{TASW:"..this:GetParent().SwitchStdBtn:GetText()..":"..bossText.version.."}")
                                    end
                            	end
                            end
                              end)
            theFrame.RightPane.TextSyncBtn:SetScript("OnEnter",function()
                if (GameTooltip:IsVisible() ) then
                    return;
                end
                GameTooltip:SetOwner(this, "ANCHOR_LEFT");
                if(this.sync)then
                	GameTooltip:SetText(L["text sync on"]);
                else
                	GameTooltip:SetText(L["text sync off"]);
                end
                GameTooltip:Show();
              end)
             theFrame.RightPane.TextSyncBtn:SetScript("OnLeave",function()
             	GameTooltip:Hide();
             end)
        else
            theFrame.RightPane.TextSyncBtn:Show()
            theFrame.RightPane.TextSyncBtn:Disable()
        end

        --scrollpane for the /ra massages
        if(theFrame.RightPane.ScrollRaidMsgFrame == nil)then
            theFrame.RightPane.ScrollRaidMsgFrame = CreateFrame("ScrollFrame","BT_ScrollRaidMsgFrame",theFrame.RightPane,"UIPanelScrollFrameTemplate")
            theFrame.RightPane.ScrollRaidMsgFrame:ClearAllPoints();
            theFrame.RightPane.ScrollRaidMsgFrame:SetPoint("BOTTOMLEFT",theFrame.RightPane, "BOTTOMLEFT", 0,10)
            theFrame.RightPane.ScrollRaidMsgFrame:SetWidth((theFrame.RightPane:GetWidth()/2)-35);
            theFrame.RightPane.ScrollRaidMsgFrame:SetHeight(75);
        else
            theFrame.RightPane.ScrollRaidMsgFrame:Show()
        end

        --personalize the scrollpane for addonlist
        if(theFrame.RightPane.versionlistFrame == nil)then
            local addonlist_frame = CreateFrame("Frame","BT_addonlistframe",theFrame.RightPane)
            theFrame.RightPane.versionlistFrame = addonlist_frame
            addonlist_frame:ClearAllPoints();
            addonlist_frame:SetPoint("BOTTOMLEFT",theFrame.RightPane, "BOTTOMLEFT", 0,100)
            addonlist_frame:SetWidth(theFrame.RightPane:GetWidth()/2);
            addonlist_frame:SetHeight(90);
            addonlist_frame:SetBackdrop({
            --bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 12,
            --edgeFile = "Interface\\TutorialFrame\\TutorialFrameBorder",
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
            --insets = {left = 1, right = 1, top = 1, bottom = 1},
            })
            addonlist_frame:SetBackdropBorderColor(16/255,24/255,177/255)
            addonlist_frame:SetBackdropColor(24/255, 24/255, 24/255)
            theFrame.RightPane.titleAddonlistScroll = theFrame.RightPane:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
            theFrame.RightPane.titleAddonlistScroll:SetTextColor(1,1,1)
            theFrame.RightPane.titleAddonlistScroll:SetText(L["Title Addonlist"])
            theFrame.RightPane.titleAddonlistScroll:SetPoint("BOTTOMLEFT",theFrame.RightPane,"BOTTOMLEFT",5,192)
            addonlist_frame.offset = 1
            addonlist_frame.scrollUp = false
            addonlist_frame.TextArray = {}

            addonlist_frame.scrollDownBtn=CreateFrame("Button","BT_scrolldown_addonlist",addonlist_frame)
            addonlist_frame.scrollDownBtn:SetNormalTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Up.blp")
            addonlist_frame.scrollDownBtn:SetPushedTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Down.blp")
            addonlist_frame.scrollDownBtn:SetHighlightTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Highlight.blp")
            addonlist_frame.scrollDownBtn:SetWidth(20)
            addonlist_frame.scrollDownBtn:SetHeight(20)
            addonlist_frame.scrollDownBtn:SetPoint("BOTTOMRIGHT",addonlist_frame,"BOTTOMRIGHT",-5,7)
            addonlist_frame.scrollDownBtn:SetScript("OnClick",function()
                    if(this:GetParent().offset< #(this:GetParent().TextArray))then
                        this:GetParent().offset = this:GetParent().offset+1
                        BossTactics:ScrollStringTop(this:GetParent(),this:GetParent().TextArray,false)
                    end
                     end)

            addonlist_frame.scrollUpBtn=CreateFrame("Button","BT_scrollup_addonlist",addonlist_frame)
            addonlist_frame.scrollUpBtn:SetNormalTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Up.blp")
            addonlist_frame.scrollUpBtn:SetPushedTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Down.blp")
            addonlist_frame.scrollUpBtn:SetHighlightTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Highlight.blp")
            addonlist_frame.scrollUpBtn:SetWidth(20)
            addonlist_frame.scrollUpBtn:SetHeight(20)
            addonlist_frame.scrollUpBtn:SetPoint("TOPRIGHT",addonlist_frame,"TOPRIGHT",-5,-7)
            addonlist_frame.scrollUpBtn:SetScript("OnClick",function()
                    if(this:GetParent().offset > 1)then
                        this:GetParent().scrollUp = true;
                        this:GetParent().offset = this:GetParent().offset-1
                        BossTactics:ScrollStringTop(this:GetParent(),this:GetParent().TextArray,false)
                    end
                     end)
        else
            theFrame.RightPane.versionlistFrame:Show()
        end

        --personalize the scrollpane for raidmessages
        if(theFrame.RightPane.ScrollRaidMsgFrame:GetScrollChild() == nil)then
            local raidmsg_edit = CreateFrame("EditBox","BT_raidmsgedit",theFrame.RightPane.ScrollRaidMsgFrame)
            theFrame.RightPane.FrameOfRaidMsg = CreateFrame("Frame","BT_addonlistframe_border",theFrame.RightPane)
            theFrame.RightPane.FrameOfRaidMsg:SetBackdrop({
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
            })
            theFrame.RightPane.FrameOfRaidMsg:SetBackdropBorderColor(16/255,24/255,177/255)
            theFrame.RightPane.FrameOfRaidMsg:SetHeight(95)
            theFrame.RightPane.FrameOfRaidMsg:SetWidth(theFrame.RightPane:GetWidth()/2)
            theFrame.RightPane.FrameOfRaidMsg:ClearAllPoints()
            theFrame.RightPane.FrameOfRaidMsg:SetPoint("BOTTOMLEFT",theFrame.RightPane,"BOTTOMLEFT",0,0)

            raidmsg_edit:ClearAllPoints();
            raidmsg_edit:SetWidth(theFrame.RightPane:GetWidth()/2-30)
            raidmsg_edit:SetHeight(65)
            raidmsg_edit:SetPoint("TOPLEFT")
            theFrame.RightPane.ScrollRaidMsgFrame:SetScrollChild(raidmsg_edit)
            theFrame.RightPane.ScrollRaidMsgFrame:SetBackdropColor(24/255, 24/255, 24/255)
            theFrame.RightPane.titleRaidmsgScroll = theFrame.RightPane:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
            theFrame.RightPane.titleRaidmsgScroll:SetTextColor(1,1,1)
            theFrame.RightPane.titleRaidmsgScroll:SetText(L["Title Raidmessage"])
            theFrame.RightPane.titleRaidmsgScroll:SetPoint("BOTTOMLEFT",theFrame.RightPane,"BOTTOMLEFT",5,92)
            --raidmsg_edit:EnableKeyboard()
            raidmsg_edit:SetScript("OnTextChanged", function()
                     ScrollingEdit_OnTextChanged(this, this:GetParent())
                      end)
            raidmsg_edit:SetScript("OnCursorChanged", function()
                     ScrollingEdit_OnCursorChanged(this, arg1, arg2-10, arg3, arg4) end)
            raidmsg_edit:SetScript("OnUpdate", function()
                     ScrollingEdit_OnUpdate(this, this:GetParent()) end)
            raidmsg_edit:SetScript("OnEscapePressed", function()
                        this:ClearFocus()
                        end)
            raidmsg_edit:SetScript("OnChar", function()
                        self:DataChanged()
                        end)
            raidmsg_edit:SetAutoFocus(false)
            raidmsg_edit:SetMultiLine(true)
            raidmsg_edit:EnableMouse(true)
            raidmsg_edit:SetFontObject("GameFontNormal")
            raidmsg_edit:SetTextColor(223/255,96/255,3/255)
            raidmsg_edit:SetTextInsets(10,10,10,10)
        end
        if(leftpane.InstanzBtn.currInstanceId ~= "EMPTY")then
            local boss = self.modules[leftpane.InstanzBtn.currModuleId].bosses[leftpane.ModeBtn.currInstanceMode][leftpane.BossBtn.currBossId]
            theFrame.RightPane.ScrollRaidMsgFrame:GetScrollChild():SetText(boss.ratext)
        end

        --personalize the scrollpane for leaderchat
        if(theFrame.RightPane.LeaderChatFrame == nil)then
            local leaderchat_frame = CreateFrame("Frame","BT_leaderchatframe",theFrame.RightPane)
            theFrame.RightPane.LeaderChatFrame = leaderchat_frame
            leaderchat_frame:ClearAllPoints();
            leaderchat_frame:SetPoint("BOTTOMRIGHT",theFrame.RightPane, "BOTTOMRIGHT", 0,25)
            leaderchat_frame:SetWidth(theFrame.RightPane:GetWidth()/2);
            leaderchat_frame:SetHeight(175);
            leaderchat_frame.offset = 1
            leaderchat_frame.scrollUp = false

            leaderchat_frame.scrollDownBtn=CreateFrame("Button","BT_scrolldown_leaderchat",leaderchat_frame)
            leaderchat_frame.scrollDownBtn:SetNormalTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Up.blp")
            leaderchat_frame.scrollDownBtn:SetPushedTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Down.blp")
            leaderchat_frame.scrollDownBtn:SetHighlightTexture("Interface\\Buttons\\UI-ScrollBar-ScrollDownButton-Highlight.blp")
            leaderchat_frame.scrollDownBtn:SetWidth(20)
            leaderchat_frame.scrollDownBtn:SetHeight(20)
            leaderchat_frame.scrollDownBtn:SetPoint("BOTTOMRIGHT",leaderchat_frame,"BOTTOMRIGHT",-5,7)
            leaderchat_frame.scrollDownBtn:SetScript("OnClick",function()
                    if(this:GetParent().offset< #(this:GetParent().TextArray))then
                        this:GetParent().offset = this:GetParent().offset+1
                        BossTactics:ScrollString(this:GetParent(),this:GetParent().TextArray,false)
                    end
                     end)

            leaderchat_frame.scrollUpBtn=CreateFrame("Button","BT_scrollup_leaderchat",leaderchat_frame)
            leaderchat_frame.scrollUpBtn:SetNormalTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Up.blp")
            leaderchat_frame.scrollUpBtn:SetPushedTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Down.blp")
            leaderchat_frame.scrollUpBtn:SetHighlightTexture("Interface\\Buttons\\UI-ScrollBar-ScrollUpButton-Highlight.blp")
            leaderchat_frame.scrollUpBtn:SetWidth(20)
            leaderchat_frame.scrollUpBtn:SetHeight(20)
            leaderchat_frame.scrollUpBtn:SetPoint("TOPRIGHT",leaderchat_frame,"TOPRIGHT",-5,-7)
            leaderchat_frame.scrollUpBtn:SetScript("OnClick",function()
                    if(this:GetParent().offset > 1)then
                        this:GetParent().scrollUp = true;
                        this:GetParent().offset = this:GetParent().offset-1
                        BossTactics:ScrollString(this:GetParent(),this:GetParent().TextArray,false)
                    end
                     end)

            leaderchat_frame:SetBackdrop({
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
            insets = {left = 1, right = 1, top = 1, bottom = 1},
            })
            leaderchat_frame:SetBackdropBorderColor(16/255,24/255,177/255)
            leaderchat_frame:SetBackdropColor(24/255, 24/255, 24/255)
            leaderchat_frame.TextArray = {}
            theFrame.RightPane.LeaderChatInput = CreateFrame("EditBox","BT_leaderchat_edit",theFrame.RightPane, "InputBoxTemplate")
            theFrame.RightPane.LeaderChatInput:SetMaxLetters(200)
            theFrame.RightPane.LeaderChatInput:SetPoint("BOTTOMRIGHT",theFrame.RightPane, "BOTTOMRIGHT", 0,5)
            theFrame.RightPane.LeaderChatInput:SetWidth((theFrame.RightPane:GetWidth()/2)-10);
            theFrame.RightPane.LeaderChatInput:SetHeight(20);
            theFrame.RightPane.LeaderChatInput:SetAutoFocus(false)
            theFrame.RightPane.LeaderChatInput:SetScript("OnEnterPressed", function()
                        if(this:GetText() ~= nil and strlen(this:GetText())>0) then
                            BossTactics:BT_SendDataMessage("{LCH}"..this:GetText())
                        end
                        this:SetText("")
                        end)
            theFrame.RightPane.LeaderChatInput:SetScript("OnEscapePressed", function()
                        this:ClearFocus()
                        end)
            else
                theFrame.RightPane.LeaderChatFrame:Show()
                theFrame.RightPane.LeaderChatInput:Show()
                theFrame.RightPane.titleAddonlistScroll:Show()
                theFrame.RightPane.titleRaidmsgScroll:Show()
                theFrame.RightPane.FrameOfRaidMsg:Show()
        end

        --draggable buttons generate if needed
        --local found = false

        for i,v in ipairs(self.MainWindow.LeftPane.buttons) do
            if(not v.dragged) then
                --found = true
            else
                self.MainWindow.LeftPane.buttons[i].delBtn:Show()
                self.MainWindow.LeftPane.buttons[i].editBtn:Show()
            end
        end

            BossTactics:CreateNewMapButton(self.buttonTypes.melee, true)
            BossTactics:CreateNewMapButton(self.buttonTypes.rangedDPS, true)
            BossTactics:CreateNewMapButton(self.buttonTypes.healer, true)
            BossTactics:CreateNewMapButton(self.buttonTypes.tank, true)
            BossTactics:CreateNewMapButton(self.buttonTypes.boss, true)
            BossTactics:CreateNewMapButton(self.buttonTypes.boss2, true)
            BossTactics:CreateNewMapButton(self.buttonTypes.boss3, true)
            BossTactics:CreateNewMapButton(self.buttonTypes.boss4, true)
    end
end;

----------------------------------------------------------------
--handels if you become raidleader
----------------------------------------------------------------

function BossTactics:LooseRaidLeader()

    local theFrame = self.MainWindow
    if(self.MainWindow ~= nil)then
    	local leftpane = theFrame.LeftPane
    	if (not UnitInRaid(self.player)) then
    		self.MainWindow.LeftPane.RaidLeadModeBtn:Enable()
    	else
    		self.MainWindow.LeftPane.RaidLeadModeBtn:Disable()
    	end
    	self.tacticMode = false
    	self.MainWindow.LeftPane.RaidLeadModeBtn:Show()
        theFrame.RightPane.ScrollRight:SetHeight(theFrame.RightPane:GetHeight()-30);
        theFrame.RightPane.ScrollRight:GetScrollChild():SetHeight(theFrame.RightPane:GetHeight())

        theFrame.LeftPane.RaidLeadActionsBtn:ClearAllPoints()
        theFrame.LeftPane.RaidLeadActionsBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",370,-730)

        theFrame.LeftPane.SessResetBtn:ClearAllPoints()
        theFrame.LeftPane.SessResetBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",40,-730)

        theFrame.LeftPane.SyncBtn:ClearAllPoints()
        theFrame.LeftPane.SyncBtn:SetPoint("TOPLEFT",theFrame.LeftPane,"TOPLEFT",240,-730)

        if(leftpane.InstanzBtn.currModuleId ~= -1)then
            local boss = self.modules[leftpane.InstanzBtn.currModuleId].bosses[leftpane.ModeBtn.currInstanceMode][leftpane.BossBtn.currBossId]
            local imgPane = theFrame.LeftPane.ImgPane
            --update the action buttons
            if(boss.actionBtn1 and boss.actionBtn1.raidleadOnly)then
                imgPane.Action1Btn:Hide()
            end
            if(boss.actionBtn2 and boss.actionBtn2.raidleadOnly)then
                imgPane.Action2Btn:Hide()
            end
            if(boss.actionBtn3 and boss.actionBtn3.raidleadOnly)then
                imgPane.Action3Btn:Hide()
            end
        end

        if(theFrame.QueryManagerFrame)then
        	theFrame.QueryManagerFrame.ExecuteBtn:Disable()
        end

        --if the session button was there, the rest is also there
        self.currPossibleRLActions = {{L["Id Info"],"ID"},{L["Task Manager"],"TM"}, {L["5-man instances"],"5M"},{L["Query Manager"],"QU"} }
        if(theFrame.LeftPane.SessBtn ~= nil) then
            theFrame.LeftPane.SessBtn:Hide()
            theFrame.RightPane.ScrollRaidMsgFrame:Hide()
            theFrame.RightPane.LeaderChatFrame:Hide()
            theFrame.RightPane.LeaderChatInput:Hide()
            theFrame.RightPane.versionlistFrame:Hide()
            theFrame.RightPane.titleAddonlistScroll:Hide()
            theFrame.RightPane.titleRaidmsgScroll:Hide()
            theFrame.RightPane.FrameOfRaidMsg:Hide()
            theFrame.LeftPane.PingPaintBtn:Hide()
            theFrame.LeftPane.ImgPane.PaintDelBtn:Hide()
            theFrame.RightPane.TextSyncBtn:Hide()
        end
        for i,v in ipairs(self.MainWindow.LeftPane.buttons) do
            if(not v.dragged) then
                v:Hide()
            else
                self.MainWindow.LeftPane.buttons[i].delBtn:Hide()
                self.MainWindow.LeftPane.buttons[i].editBtn:Hide()
            end
        end
    end
end;

------------------------------------------------------
---create a new button
--type object of a button type;
--pool bool: true, if this is a new poolbutton
-- Optional: caption, x, y
------------------------------------------------------
function BossTactics:CreateNewMapButton(type, pool, caption, x, y, id)

    if(type == nil)then return end

    if(not self.MainWindow) then return end

    local xpos, ypos
    if(x ~= nil) then
        xpos = x
    else
        xpos = type.x
    end
    if(y ~= nil) then
        ypos = y
    else
        ypos = type.y
    end
    if(id == nil) then
        id = 0
    end

    local theFrame = self.MainWindow.LeftPane
    local i = #(theFrame.buttons)+1
    if(#theFrame.buttonPool > 0)then
        theFrame.buttons[i] = tremove(theFrame.buttonPool)
        if(self.debug)then
            self:Print("taken from buttonpool")
        end
    else
        if(self:IsDebug())then
            self:Print(i);
        end
        theFrame.buttons[i]=CreateFrame("Button","BT_button_"..i,theFrame)
    end
    theFrame.buttons[i]:SetWidth(type.width)
    theFrame.buttons[i]:SetHeight(type.height)
    theFrame.buttons[i]:ClearAllPoints()
    theFrame.buttons[i]:SetPoint("TOPLEFT",theFrame,"TOPLEFT",xpos,ypos)
    theFrame.buttons[i]:SetMovable(true)
    theFrame.buttons[i]:EnableMouse(true)
    theFrame.buttons[i]:SetClampedToScreen( true )
    theFrame.buttons[i].oldX = xpos
    theFrame.buttons[i].oldY = ypos
    theFrame.buttons[i].typename = type.name
    if(theFrame.buttons[i].text == nil)then
        theFrame.buttons[i].text = theFrame.buttons[i]:CreateFontString(nil,"OVERLAY","GameFontNormal")
        theFrame.buttons[i].text:SetPoint("Bottom",theFrame.buttons[i],"Bottom",0,-7)
        theFrame.buttons[i].text:SetTextColor(1.0,1.0,1.0,1.0)
    else
        theFrame.buttons[i].text:SetText("")
    end
    if(theFrame.buttons[i].editBtn == nil)then
        theFrame.buttons[i].editBtn = CreateFrame("Button","BT_button_"..i.."edit",theFrame.buttons[i],"UIPanelButtonTemplate")
        theFrame.buttons[i].editBtn:SetWidth(10)
        theFrame.buttons[i].editBtn:SetHeight(15)
        theFrame.buttons[i].editBtn:SetText("E")
        theFrame.buttons[i].editBtn:SetPoint("BOTTOMRIGHT",theFrame.buttons[i],"BOTTOMRIGHT",5,5)
        theFrame.buttons[i].editBtn:SetScript("OnClick",function()
                 if(this:GetParent().text:GetText() == nil or this:GetParent().text:GetText() == "") then
                     BossTactics:ShowButtonInputFrame(this:GetParent().text,this:GetParent(),BossTactics:GetTextFromButtonType(this:GetParent().typename))
                 else
                     BossTactics:ShowButtonInputFrame(this:GetParent().text,this:GetParent())
                 end
             end)
        theFrame.buttons[i].delBtn = CreateFrame("Button","BT_button_"..i.."delete",theFrame.buttons[i],"UIPanelButtonTemplate")
        theFrame.buttons[i].delBtn:SetWidth(10)
        theFrame.buttons[i].delBtn:SetHeight(10)
        theFrame.buttons[i].delBtn:SetText("x")
        theFrame.buttons[i].delBtn:SetPoint("BOTTOMRIGHT",theFrame.buttons[i],"BOTTOMRIGHT",5,20)
        theFrame.buttons[i].delBtn:SetScript("OnClick",function()  BossTactics:RemoveButton(this:GetParent().id,this:GetParent().instId,this:GetParent().bossId,this:GetParent().imgId)  end)
    end

    --unique id of a button to an instance
    theFrame.buttons[i].id = tonumber(id)
    theFrame.buttons[i].instId = self.currInstanceId
    theFrame.buttons[i].imgId = self.currImgId
    theFrame.buttons[i].bossId = self.currBossId
    theFrame.buttons[i].moduleId = self.currModuleId
    theFrame.buttons[i].mode = self.currInstanceMode

    theFrame.buttons[i]:SetScript("OnMouseDown", function()
                    if ((arg1 == "LeftButton"  and self.currModuleId ~= -1 and (self:IsRaidLeader() or self.tacticMode))) then
                      this:StartMoving();
                      this.isMoving = true;
                     end
                    end)
    theFrame.buttons[i]:SetScript("OnMouseUp", function()
                    if ( this.isMoving ) then
                      this:StopMovingOrSizing();
                      this.isMoving = false;
                      BossTactics:DragFrame(this,BossTactics.MainWindow.LeftPane)
                     end
                    end)

    theFrame.buttons[i]:SetNormalTexture(type.button)
    theFrame.buttons[i]:SetAlpha(1.0)

    --if pool -> not dragged, else dragged
    theFrame.buttons[i].dragged = not pool;

    if(caption ~= nil) then
        theFrame.buttons[i].text:SetText(caption)
    else
        theFrame.buttons[i].text:SetText("")
    end

    if(pool or not self:IsRaidLeader()) then
    	if(not self.tacticMode or pool)then
            theFrame.buttons[i].delBtn:Hide()
            theFrame.buttons[i].editBtn:Hide()
        end
    end
    theFrame.buttons[i]:Show()
    if(self.debug)then
        self:Print("Debug: Button with ID: "..theFrame.buttons[i].id.." created")
    end
end;

------------------------------------------------------------
--tests two buttons of equality
--if btn2 is nil test will be to current state
------------------------------------------------------------

function BossTactics:ButtonEqual(btn1, btn2)

	local mode = ""
	local inst = ""
	local boss =""
	local img = ""
	local module = ""
	if(btn2 == nil)then
		inst = self.currInstanceId
        img = self.currImgId
        boss = self.currBossId
        module = self.currModuleId
        mode = self.currInstanceMode
    else
		inst = btn2.instId
        img = btn2.imgId
        boss = btn2.bossId
        module = btn2.moduleId
        mode = btn2.mode
	end

	if(self.debug)then
	    self:Print("locals: "..inst..img..boss..module..mode)
        self:Print("btn1: "..btn1.instId..btn1.imgId..btn1.bossId..btn1.moduleId..btn1.mode)
    end
	return btn1.instId == inst and btn1.imgId == img and btn1.bossId == boss and btn1.moduleId == module and btn1.mode == mode

end;


--------------------------------------------------------------
--creates a fontstring on the map
--text:string,x:double,y:double,font: the font
--r,g,b color values
--------------------------------------------------------------

function BossTactics:CreateMapFontstring(text,x,y,font,r,g,b)

    local theFrame = self.MainWindow.LeftPane.ImgPane
    if(font == nil)then
        font = "MailTextFontNormal"
    end
    if(r == nil) then
        r = 1
    end
    if(g == nil) then
        g = 1
    end
    if(b == nil) then
        b = 1
    end

    local fontstr = theFrame:CreateFontString(nil,"OVERLAY",font)
    fontstr:SetTextColor(r,g,b)
    fontstr:SetText(text)
    fontstr:SetPoint("TOPLEFT",theFrame,"TOPLEFT",x,y)
    tinsert(theFrame.fontstrings,fontstr)

end;

------------------------------------------------------------
---called whenever there are changes in data
------------------------------------------------------------

function BossTactics:DataChanged()

    if(not self.dataChanged and self.currInstanceId ~= "EMPTY")then
        self.MainWindow.LeftPane.SaveBtn:Enable()

        self.dataChanged = true
        local imgdata = {}
        imgdata.instId = self.currInstanceId
        imgdata.imgId = self.currImgId
        imgdata.bossId = self.currBossId
        tinsert(self.dataChangedArray,imgdata)
    end

end;

------------------------------------------------------------
---called whenever there are changes in text data
------------------------------------------------------------

function BossTactics:InputDataChanged()

    if(self.currInstanceId ~= "EMPTY")then
    	local bool5man = self.currInstanceMode == "mode5"
    	local bossDB, rightpane
    	if(bool5man)then
            rightpane = self.MainGroupWindow.RightPane
        else
            rightpane = self.MainWindow.RightPane
        end
        if(rightpane.SwitchStdBtn.currId > 1)then
            rightpane.SaveBtn:Enable()
        else
            rightpane.SaveBtn:Disable()
        end
    end

end;

------------------------------------------------------------
--remove a button from the leftpanel
--id: id of the button
------------------------------------------------------------

function BossTactics:RemoveButton(id, instId, bossId, imgId)

    if(id == nil) then return end
    for i,val in ipairs(self.MainWindow.LeftPane.buttons)do
        if(val.id == id and val.instId == instId and val.bossId == bossId
            and val.imgId == imgId)then
            val:Hide()
            tinsert(self.MainWindow.LeftPane.buttonPool, table.remove(self.MainWindow.LeftPane.buttons,i))
            if(self:IsSession())then
                BossTactics:BT_SendDataMessage("{BTRM:"..id.."}")
            end
        end
    end
    self:DataChanged()
end;


------------------------------------------------------------
--show input dialog
--fontstring: fontstring object which should be updated
-- suggestion: string
------------------------------------------------------------

function BossTactics:ShowButtonInputFrame(fontstring, btn, suggestion)
    local theFrame = self.MainWindow
    if(theFrame.ButtonInputFrame == nil)then
        theFrame.ButtonInputFrame = CreateFrame("Frame","BT_Buttoninputframe",theFrame)
        theFrame.ButtonInputFrame:ClearAllPoints()
        theFrame.ButtonInputFrame:SetPoint("CENTER",theFrame)
        theFrame.ButtonInputFrame:SetHeight(100)
        theFrame.ButtonInputFrame:SetWidth(220)
        theFrame.ButtonInputFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        theFrame.ButtonInputFrame:SetBackdropColor(1/255, 1/255, 1/255)
        --theFrame.ButtonInputFrame:SetBackdropBorderColor(1.0,0,0.0)

        theFrame.ButtonInputFrame:SetFrameLevel(theFrame:GetFrameLevel()+20)

        theFrame.ButtonInputFrame.OkBtn = CreateFrame("Button","BT_buttoninputframe_ok",theFrame.ButtonInputFrame,"UIPanelButtonTemplate")
        theFrame.ButtonInputFrame.OkBtn:SetWidth(100)
        theFrame.ButtonInputFrame.OkBtn:SetHeight(20)
        theFrame.ButtonInputFrame.OkBtn:SetText(L["Ok"])
        theFrame.ButtonInputFrame.OkBtn:SetPoint("BOTTOMRIGHT",theFrame.ButtonInputFrame,"BOTTOMRIGHT",-10,15)
        theFrame.ButtonInputFrame.OkBtn:SetScript("OnClick",function()
                        local tmptxt = " "
                        if(this:GetParent().input:GetText() ~= nil and strlen(this:GetParent().input:GetText())>0)then
                            tmptxt = this:GetParent().input:GetText()
                        end
                        this:GetParent().currFontstring:SetText(tmptxt)
                        self:DataChanged()
                        if(self:IsSession())then
                            BossTactics:BT_SendDataMessage("{BTCT:"..this:GetParent().currBtn.id..":"..tmptxt.."}")
                        end
                        this:GetParent().input:SetText("")
                        this:GetParent():Hide()
                          end)

        theFrame.ButtonInputFrame.CBtn = CreateFrame("Button","BT_buttoninputframe_c",theFrame.ButtonInputFrame,"UIPanelButtonTemplate")
        theFrame.ButtonInputFrame.CBtn:SetWidth(100)
        theFrame.ButtonInputFrame.CBtn:SetHeight(20)
        theFrame.ButtonInputFrame.CBtn:SetText(L["Cancel"])
        theFrame.ButtonInputFrame.CBtn:SetPoint("BOTTOMRIGHT",theFrame.ButtonInputFrame,"BOTTOMRIGHT",-110,15)
        theFrame.ButtonInputFrame.CBtn:SetScript("OnClick",function()
                        this:GetParent().input:SetText("")
                        this:GetParent():Hide()
                                             end)
        theFrame.ButtonInputFrame.title = theFrame.ButtonInputFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        theFrame.ButtonInputFrame.title:SetTextColor(1,1,1)
        theFrame.ButtonInputFrame.title:SetText(L["Title Inputframe"])
        theFrame.ButtonInputFrame.title:SetPoint("TOP",theFrame.ButtonInputFrame,"TOP",0,-15)

        theFrame.ButtonInputFrame.input = CreateFrame("EditBox","BT_buttonInputFrameBox",theFrame.ButtonInputFrame, "InputBoxTemplate")
        theFrame.ButtonInputFrame.input:SetMaxLetters(20)
        theFrame.ButtonInputFrame.input:SetPoint("CENTER",theFrame.ButtonInputFrame, "CENTER", 0,5)
        theFrame.ButtonInputFrame.input:SetWidth(150);
        theFrame.ButtonInputFrame.input:SetHeight(20);
        theFrame.ButtonInputFrame.input:SetScript("OnEnterPressed", function()
                    local tmptxt = " "
                    if(this:GetText() ~= nil and strlen(this:GetText())>0) then
                        tmptxt = this:GetParent().input:GetText()
                    end
                    this:GetParent().currFontstring:SetText(tmptxt)
                    self:DataChanged()
                    if(self:IsSession())then
                        BossTactics:BT_SendDataMessage("{BTCT:"..this:GetParent().currBtn.id..":"..tmptxt.."}")
                    end
                    this:SetText("")
                    this:GetParent():Hide()
                    end)
        theFrame.ButtonInputFrame.input:SetScript("OnEscapePressed", function()
                    this:ClearFocus()
                    this:SetText("")
                    this:GetParent():Hide()
                    end)
    end
    theFrame.ButtonInputFrame.currFontstring = fontstring
    theFrame.ButtonInputFrame.currBtn = btn
    if(suggestion ~= nil)then
        theFrame.ButtonInputFrame.input:SetText(suggestion)
    else
        theFrame.ButtonInputFrame.input:SetText(fontstring:GetText())
    end
    theFrame.ButtonInputFrame.input:SetFocus()
    theFrame.ButtonInputFrame:Show()
end;

------------------------------------------------------------
--show input dialog for a new text
------------------------------------------------------------

function BossTactics:ShowNewTextInputFrame(okFun, title, msg,frame)
    local theFrame = self
    if(theFrame.NewTextInputFrame == nil)then
        theFrame.NewTextInputFrame = CreateFrame("Frame","BT_NewTextInputFrame",UIParent)
        theFrame.NewTextInputFrame:ClearAllPoints()
        theFrame.NewTextInputFrame:SetPoint("CENTER",UIParent)
        theFrame.NewTextInputFrame:SetHeight(150)
        theFrame.NewTextInputFrame:EnableMouse(true)
        theFrame.NewTextInputFrame:SetWidth(300)
        theFrame.NewTextInputFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        theFrame.NewTextInputFrame:SetBackdropColor(1/255, 1/255, 1/255)
        --theFrame.NewTextInputFrame:SetBackdropBorderColor(1.0,0,0.0)

        theFrame.NewTextInputFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)

        theFrame.NewTextInputFrame.OkBtn = CreateFrame("Button","BT_NewTextInputFrame_ok",theFrame.NewTextInputFrame,"UIPanelButtonTemplate")
        theFrame.NewTextInputFrame.OkBtn:SetWidth(100)
        theFrame.NewTextInputFrame.OkBtn:SetHeight(20)
        theFrame.NewTextInputFrame.OkBtn:SetText(L["Ok"])
        theFrame.NewTextInputFrame.OkBtn:SetPoint("BOTTOMRIGHT",theFrame.NewTextInputFrame,"BOTTOMRIGHT",-10,15)
        theFrame.NewTextInputFrame.OkBtn:SetScript("OnClick",function()
                        if(this:GetParent().input:GetText() ~= nil and strlen(this:GetParent().input:GetText())>0)then
                            this:GetParent():OkFun(this:GetParent().input:GetText())
                            this:GetParent().input:SetText("")
                            this:GetParent():Hide()
                        end

                          end)

        theFrame.NewTextInputFrame.CBtn = CreateFrame("Button","BT_NewTextInputFrame_c",theFrame.NewTextInputFrame,"UIPanelButtonTemplate")
        theFrame.NewTextInputFrame.CBtn:SetWidth(100)
        theFrame.NewTextInputFrame.CBtn:SetHeight(20)
        theFrame.NewTextInputFrame.CBtn:SetText(L["Cancel"])
        theFrame.NewTextInputFrame.CBtn:SetPoint("BOTTOMRIGHT",theFrame.NewTextInputFrame,"BOTTOMRIGHT",-110,15)
        theFrame.NewTextInputFrame.CBtn:SetScript("OnClick",function()
                        this:GetParent().input:SetText("")
                        this:GetParent():Hide()
                        if(frame)then
    	                   frame:SetFrameLevel(self.MainWindow:GetFrameLevel()+20)
                        end
                                             end)
        theFrame.NewTextInputFrame.title = theFrame.NewTextInputFrame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
        theFrame.NewTextInputFrame.title:SetTextColor(1,1,1)
        theFrame.NewTextInputFrame.title:SetPoint("TOP",theFrame.NewTextInputFrame,"TOP",0,-15)

        theFrame.NewTextInputFrame.infotext = theFrame.NewTextInputFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        theFrame.NewTextInputFrame.infotext:SetTextColor(1,1,1)
        theFrame.NewTextInputFrame.infotext:SetWidth(250)
        theFrame.NewTextInputFrame.infotext:SetPoint("TOP",theFrame.NewTextInputFrame,"TOP",5,-35)
        theFrame.NewTextInputFrame.infotext:SetJustifyH("LEFT")

        theFrame.NewTextInputFrame.input = CreateFrame("EditBox","BT_NewTextInputFrameBox",theFrame.NewTextInputFrame, "InputBoxTemplate")
        theFrame.NewTextInputFrame.input:SetMaxLetters(18)
        theFrame.NewTextInputFrame.input:SetPoint("CENTER",theFrame.NewTextInputFrame, "CENTER", 0,-10)
        theFrame.NewTextInputFrame.input:SetWidth(150);
        theFrame.NewTextInputFrame.input:SetHeight(20);
        theFrame.NewTextInputFrame.input:SetAutoFocus(false)
        theFrame.NewTextInputFrame.input:SetScript("OnEnterPressed", function()
                    if(this:GetParent().input:GetText() ~= nil and strlen(this:GetParent().input:GetText())>0)then
                            this:GetParent():OkFun(this:GetParent().input:GetText())
                            this:GetParent().input:SetText("")
                            this:GetParent():Hide()
                        end
                    end)
        theFrame.NewTextInputFrame.input:SetScript("OnEscapePressed", function()
                    this:ClearFocus()
                    end)
    end
    if(frame)then
    	theFrame.NewTextInputFrame:SetFrameLevel(frame:GetFrameLevel()+20)
    end
    theFrame.NewTextInputFrame.title:SetText(title)
    theFrame.NewTextInputFrame.infotext:SetText(msg)
    theFrame.NewTextInputFrame.OkFun = okFun
    theFrame.NewTextInputFrame.input:SetFocus()
    theFrame.NewTextInputFrame.frame = frame
    theFrame.NewTextInputFrame:Show()
end;

----------------------------------------------------------------------
---functions to create a dragable minimap button
----------------------------------------------------------------------

function BossTactics:CreateMinimapButton()

    if(self.MinimapBtnFrame == nil) then
    --self.MinimapBtnFrame = CreateFrame("Frame","BT_Minimapbtnframe",Minimap)
    local minimapBtn = CreateFrame("Button","BT_Minimapbtn",_G.Minimap)
    self.MinimapBtnFrame = minimapBtn
    self.MinimapBtnFrame:EnableMouse(true)
    self.MinimapBtnFrame:SetFrameStrata("MEDIUM")

    minimapBtn:SetWidth(32)
    minimapBtn:SetHeight(32)
    minimapBtn:SetPoint("TOPLEFT",_G.Minimap,"TOPLEFT",self.db.profile.minimapX,self.db.profile.minimapY)
    minimapBtn:SetMovable(true)
    minimapBtn:SetNormalTexture("Interface\\AddOns\\BossTactics\\Textures\\bt_minimap")
    minimapBtn:SetHighlightTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight")
    minimapBtn.frame = minimapBtn:CreateTexture("Interface\\Minimap\\Minimap-TrackingBorder","OVERLAY",minimapBtn)
    minimapBtn.frame:SetPoint("TOPLEFT")
    minimapBtn.frame:SetWidth(52)
    minimapBtn.frame:SetHeight(52)
    minimapBtn.frame:SetTexture("Interface\\Minimap\\Minimap-TrackingBorder")


    minimapBtn:SetScript("OnLoad", function()
                    this:SetFrameLevel(5);
                    this:RegisterForClicks("LeftButtonUp", "RightButtonDown", "RightButtonUp");
                    this.dragged = false;
                    end)
    minimapBtn:SetScript("OnDragStart", function()
                    this.dragged = true;
                    end)
    minimapBtn:SetScript("OnDragStop", function()
                    this.dragged = false;
                        if (MobileMinimapButtons_Coords) then
                            MobileMinimapButtons_Coords["BT_Minimapbtn"] = nil; -- fix for 'MobileMinimapButtons' doing damn *censored*!
                        end
                    end)
    minimapBtn:SetScript("OnUpdate", function()
                    if(this.dragged == true) then
                            BossTactics:MinimapBtnBeingDragged()
                    end
                        -- auto updater:
                        if (this.BT_auto_tooltip and GetTime() - this.BT_auto_tooltip > 1) then
                            this.BT_auto_tooltip = false;
                            BossTactics:MinimapBtnOnEnter(true);
                        elseif (not this.BT_auto_tooltip) then
                            this.BT_auto_tooltip = GetTime();
                        end
                    end)
    minimapBtn:SetScript("OnClick", function()
                    if(arg1 == "LeftButton")then
                        if(self.MainWindow)then
                            if(not self.MainWindow:IsVisible() and (self.MainGroupWindow and not self.MainGroupWindow:IsVisible()
                            	or not self.MainGroupWindow))then
                               self:openBossFrame()
                            else
                                self:HandleCloseMainWindow()
                            end
                        else
                            self:openBossFrame()
                        end
                    end
                        BossTactics:MinimapBtnOnEnter(true);
                    end)
    minimapBtn:SetScript("OnEnter", function()
                    this:RegisterForDrag("RightButton"); -- moved here to fix 'MobileMinimapButtons' and possible other AddOns doing damn *censored*!
                    BossTactics:MinimapBtnOnEnter();
                    end)
    minimapBtn:SetScript("OnLeave", function()
                    GameTooltip:Hide();
                    end)
    end
    self.MinimapBtnFrame:Show()
end;

function BossTactics:MinimapBtnBeingDragged()
    local xpos,ypos = GetCursorPosition();
    local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom();
    local minimapBtn = self.MinimapBtnFrame;

    xpos = -xpos/UIParent:GetScale()+70+xmin
    ypos = ypos/UIParent:GetScale()-70-ymin

    local miniradius = (xpos^2 + ypos^2)^0.5;
    if (miniradius < 100 and miniradius > 60 and not IsAltKeyDown()) then
        miniradius = 80;
    end
    --self:Print(xpos.." "..ypos.." "..miniradius);

    local bpoint = (math.deg(math.atan2(ypos,xpos)));

    if(bpoint < 0) then
        bpoint = bpoint + 360;
    end

    self.bMiniMapPos = bpoint;
    self.bMiniMapRadius = miniradius;
    minimapBtn:SetPoint("TOPLEFT", "Minimap", "TOPLEFT", 52 - (miniradius * cos(bpoint)), (miniradius * sin(bpoint)) - 52);
    minimapBtn:SetUserPlaced(false);
    local point, relativeTo, relativePoint, xOfs, yOfs = minimapBtn:GetPoint(1)
    self.db.profile.minimapX = xOfs
    self.db.profile.minimapY = yOfs
end;

function BossTactics:MinimapBtnOnEnter(update)

    if (update and (not GameTooltip:IsVisible() or not string.match(GameTooltipTextLeft1:GetText(), "BossTactics")) ) then
        return;
    end

    GameTooltip:SetOwner(this, "ANCHOR_LEFT");
    GameTooltip:SetText("|cffdf6003BossTactics|r");
    GameTooltip:AddLine("")
    GameTooltip:AddLine(L["tooltip1"]);
    GameTooltip:AddLine(L["tooltip2"]);
    GameTooltip:AddLine(string.format(L["version"],self.version));
    GameTooltip:Show();
end;

--------------------------------------------------------------
--shows the current dropdown for 2 levels
--format: ["level1Name"] = {[1] = {"label","arg1","arg2"}}
--table format: currDropdownTable = {["func"] = callback, ["values"] = {table}}
--------------------------------------------------------------

function BossTactics:DropDownTwoLevel_Initialize()
    if(not self.currDropdownTable) then return end

   local level = UIDROPDOWNMENU_MENU_LEVEL or 1;
   if (level == 1) then
     for key, subarray in pairs(self.currDropdownTable["values"]) do
       local info = UIDropDownMenu_CreateInfo();
       info.hasArrow = true; -- creates submenu
       info.notCheckable = true;
       info.owner = this:GetParent();
       info.colorCode = "|cffe0dd00"
       info.text = key;
       info.value = {
         ["BT_DropdownLevel1_Key"] = key;
       };
       UIDropDownMenu_AddButton(info, level);
     end -- for key, subarray
      local closeInfo = UIDropDownMenu_CreateInfo();
       closeInfo.notCheckable = true;
       closeInfo.owner = this:GetParent();
       closeInfo.text = L["Close Menu"];
       closeInfo.colorCode = "|cff00e1ff"
       closeInfo.func = function() CloseDropDownMenus() end;
       UIDropDownMenu_AddButton(closeInfo, 1);
   end -- if level 1



   if (level == 2) then
     -- getting values of first menu
     local Level1_Key = UIDROPDOWNMENU_MENU_VALUE["BT_DropdownLevel1_Key"];
     subarray = self.currDropdownTable["values"][Level1_Key];
     for key, subsubarray in pairs(subarray) do
       local info = UIDropDownMenu_CreateInfo();
       info.hasArrow = false; -- no submenues this time
       info.notCheckable = true;
       info.owner = this:GetParent();
       info.text = subsubarray[1];
       info.func = function(clickedBtn, arg1, arg2) self.currDropdownTable["func"](arg1, arg2) end;
       info.arg1 = subsubarray[2]
       info.arg2 = subsubarray[3]
       info.colorCode = "|cffe0dd00"
       info.value = {
         ["BT_DropdownLevel1_Key"] = Level1_Key;
         ["BT_DropdownSublevel_Key"] = key;
       };
       UIDropDownMenu_AddButton(info, level);
     end -- for key,subsubarray
     local closeInfo = UIDropDownMenu_CreateInfo();
     closeInfo.notCheckable = true;
     closeInfo.owner = this:GetParent();
     closeInfo.text = L["Close Menu"];
     closeInfo.colorCode = "|cff00e1ff"
     closeInfo.func = function() CloseDropDownMenus() end;
     UIDropDownMenu_AddButton(closeInfo, 2);
   end -- if level 2
 end

 --------------------------------------------------------------
--shows the current dropdown for 1 level
--format: [1] = {"lable","arg1","arg2"}
--table format: currDropdownTable = {["func"] = callback, ["values"] = {table}}
--------------------------------------------------------------

function BossTactics:DropDownOneLevel_Initialize()
    if(not self.currDropdownTable) then return end

   local level = UIDROPDOWNMENU_MENU_LEVEL or 1;
   if (level == 1) then
     for key, subarray in pairs(self.currDropdownTable["values"]) do
       if(type(subarray[1]) == "table")then return end
       local info = UIDropDownMenu_CreateInfo();
       info.hasArrow = false;
       info.notCheckable = true;
       info.owner = this:GetParent();
       info.func = function(clickedBtn, arg1, arg2) self.currDropdownTable["func"](arg1, arg2) end;
       info.arg1 = subarray[2]
       info.arg2 = subarray[3]
       info.text = subarray[1]
       info.colorCode = "|cffe0dd00"
       info.value = {
         ["BT_DropdownLevel1_Key"] = key;
       };
       UIDropDownMenu_AddButton(info, level);
     end -- for key, subarray
      local closeInfo = UIDropDownMenu_CreateInfo();
       closeInfo.notCheckable = true;
       closeInfo.hasArrow = false
       closeInfo.owner = this:GetParent();
       closeInfo.text = L["Close Menu"];
       closeInfo.colorCode = "|cff00e1ff"
       closeInfo.func = function() CloseDropDownMenus() end;
       UIDropDownMenu_AddButton(closeInfo, 1);
   end -- if level 1
 end

---------------------------------------------------------
---handels a click on the instance dropdown menu
--------------------------------------------------------

function BossTactics:InstanceDropdownClick(instId, instname)
    UIDropDownMenu_ClearAll(self.MainWindow.LeftPane.InstancesDropdown)
    CloseDropDownMenus()
    local ret = self:HandleInstanceSwitch(instId, instname)
	if(ret == "stop5Man")then return end
    if(self:IsRaidLeader() and self:IsSession())then
        self:BT_SendDataMessage("{RLI:"..instId.."}")
        self:SyncRaid(true)
    elseif(self:IsSession())then
    	self:Print(L["Out of synch with raidleader"])
        self.isOUS = 1
        self:BT_SendDataMessage("{UICH}")
    end
end;

---------------------------------------------------------
---handels a click on the instance dropdown menu
--------------------------------------------------------

function BossTactics:AddonDropdownClick(addonName, addonName2)
    self:HandleAddonSwitch(addonName)
    CloseDropDownMenus()

     if(self:IsRaidLeader() and self:IsSession())then
    	self:BT_SendDataMessage("{RLADDON:"..addonName.."}")
        self:SyncRaid(true)
     elseif(self:IsSession())then
     	self:Print(L["Out of synch with raidleader"])
        self.isOUS = 1
        self:BT_SendDataMessage("{UICH}")
    end

end;

---------------------------------------------------------
---handels a click on the instance dropdown menu
--------------------------------------------------------

function BossTactics:ModeDropdownClick(mode)

    BossTactics:SetInstanceMode(mode)
	if(self:IsRaidLeader() and self:IsSession())then
    	self:BT_SendDataMessage("{RLMODE:"..mode.."}")
        self:SyncRaid(true)
     elseif(self:IsSession())then
     	self:Print(L["Out of synch with raidleader"])
        self.isOUS = 1
        self:BT_SendDataMessage("{UICH}")
    end
    CloseDropDownMenus()

end;

---------------------------------------------------------
---handels a click on the boss dropdown menu
--------------------------------------------------------

function BossTactics:BossDropdownClick(bossId)

    --BossTactics:Print("bossgeklickt "..instId.." "..instLabel.." "..type)
    BossTactics:ShowBossTactic(bossId)
    if(BossTactics:IsRaidLeader() and BossTactics:IsSession())then
        BossTactics:BT_SendDataMessage("{RLB:"..BossTactics:GetCurrInstId()..":"..bossId.."}")
        BossTactics:SyncRaid(true)
    elseif(BossTactics:IsSession())then
        self:Print(L["Out of synch with raidleader"])
        self.isOUS = 1
        BossTactics:BT_SendDataMessage("{UICH}")
    end
    CloseDropDownMenus()

end;

---------------------------------------------------------
---handels a click on the switch dropdown menu
--------------------------------------------------------

function BossTactics:SwitchDropdownClick(id)

    self:HandleTacticSwitch(id)

    if(self:IsSession() and self.isSessionLeader and self.MainWindow.RightPane.TextSyncBtn.sync)then
        local mode
        if(self.MainWindow.RightPane.TrashBtn.stdTactic)then
            mode = "tactic"
        else
            mode = "trash"
        end

        if(self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId].trash == nil) then mode = "tactic" end

    	local boss = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId]
    	if(mode == "tactic")then
    		self:BT_SendDataMessage("{TRST:1}")
     		self:BT_SendDataMessage("{TASW:"..boss.tactictext[id].name..":"..tostring(boss.tactictext[id].version).."}")
     	else
     		self:BT_SendDataMessage("{TRST:0}")
     		self:BT_SendDataMessage("{TASW:"..boss.trash[id].name..":"..tostring(boss.trash[id].version).."}")
     	end
    end
    CloseDropDownMenus()

end;

---------------------------------------------------------
---handels a click on the boss dropdown menu
--------------------------------------------------------

function BossTactics:RLActionsDropdownClick(actionId)

    if(actionId == "RL")then
    	self:ShowRaidleadersFrame()
    elseif(actionId == "RA")then
    	self:SendRaMessages()
    elseif(actionId == "VER")then
		self:CompareRaid()
        self:BT_SendDataMessage("{RLVERCH}")
    elseif(actionId == "QU")then
    	self:ShowQueryManager()
    elseif(actionId == "ID")then
    	self:ShowIdInfoFrame()
    elseif(actionId == "5M")then
    	self:ShowGroupFrame()
    	self:SwitchFrameData()
    elseif(actionId == "VO")then
    	self:ShowVoteRlFrame()
    elseif(actionId == "TM")then
    	if(self.currInstanceId == "EMPTY")then
    		self:ShowInfoMessage(L["info no task"])
    		return
    	end
    	local theFrame = self.MainWindow
    	local taskInfo = {}
    	taskInfo.Task = {}
    	taskInfo.showInputChange = true
    	taskInfo.CloseAction = function ()
    		theFrame.TaskManagerFrame.OraCheckBoxBtn:Hide()
    		theFrame.TaskManagerFrame.TextSaveCB:Hide()
    	end
    	taskInfo.Post = function (arg1, arg2)
    		if(type(arg1) == "table") then arg1 = arg2 end
    		local boss = self.modules[self.currModuleId].bosses[self.currInstanceMode] [self.currBossId]
    		local tbl = {}
    		local intro = ""
    		local extro = ""
    		if(arg1 == L["tank"])then
    		   tbl = boss.taskTank
    		   intro = L["tank intro"]
    		   extro = format(L["task extro"], "tank")
    		elseif(arg1 == L["healer"])then
    		   tbl = boss.taskHealer
    		   intro = L["healer intro"]
    		   extro = format(L["task extro"], "heal")
            elseif(arg1 == L["melee"])then
               tbl = boss.taskMelee
               intro = L["melee intro"]
               extro = format(L["task extro"], "melee")
    		elseif(arg1 == L["ranged DPS"])then
    		   tbl = boss.taskRange
    		   intro = L["range intro"]
    		   extro = format(L["task extro"], "range")
            end
			ChatThrottleLib:SendChatMessage("NORMAL", "BOSSTACTICS", intro, "RAID")
			ChatThrottleLib:SendChatMessage("NORMAL", "BOSSTACTICS", "-----------------------------------------", "RAID")
            for i,v in ipairs(tbl)do
            	local newStr = v.value
            	local pos = strfind(newStr,"|c")
            	while(pos)do
            		newStr = strsub(newStr, 1, pos-1)..strsub(newStr, pos+10)
            		pos = strfind(newStr,"|c")
            	end
            	newStr = gsub(newStr,"|r", "")
            	ChatThrottleLib:SendChatMessage("NORMAL", "BOSSTACTICS", v.player.." "..newStr, "RAID")
            end
            ChatThrottleLib:SendChatMessage("NORMAL", "BOSSTACTICS", extro, "RAID")
            ChatThrottleLib:SendChatMessage("NORMAL", "BOSSTACTICS", " ", "RAID")
    	end
    	taskInfo.PostAll = function()
    		local boss = self.modules[self.currModuleId].bosses[self.currInstanceMode] [self.currBossId]
    		if(boss.taskTank and #boss.taskTank>0)then
    			taskInfo:Post(L["tank"])
    		end
    		if(boss.taskHealer and #boss.taskHealer>0)then
    			taskInfo:Post(L["healer"])
    		end
    		if(boss.taskMelee and #boss.taskMelee>0)then
    			taskInfo:Post(L["melee"])
    		end
    		if(boss.taskRange and #boss.taskRange>0)then
    			taskInfo:Post(L["ranged DPS"])
    		end
    	end
    	taskInfo.HandleWhisper = function(target, msg, arg3)
    		if(type(target) == "table") then target = msg; msg = arg3 end
    		msg = strlower(msg)
    		local boss = self.modules[self.currModuleId].bosses[self.currInstanceMode] [self.currBossId]
    		local tbl = {}
    		local found = false
    		if(msg == "tank")then
    			 tbl = boss.taskTank
    			 found = true
			elseif(msg == "heal")then
				 tbl = boss.taskHealer
				 found = true
			elseif(msg == "melee")then
				 tbl = boss.taskMelee
				 found = true
			elseif(msg == "range")then
				 tbl = boss.taskRange
				 found = true
    		end
    		if(not found)then return end
    		found = false
    		for i,v in ipairs(tbl)do
                if(v.player == target)then
                    found = true
                    local newStr = v.value
            	    local pos = strfind(newStr,"|c")
                    while(pos)do
                        newStr = strsub(newStr, 1, pos-1)..strsub(newStr, pos+10)
                        pos = strfind(newStr,"|c")
                    end
                    newStr = gsub(newStr,"|r", "")
                    ChatThrottleLib:SendChatMessage("NORMAL", "BOSSTACTICS",v.player.." "..newStr, "WHISPER", nil, target)
                    break
                end
            end

            if(not found)then
            	ChatThrottleLib:SendChatMessage("NORMAL", "BOSSTACTICS",L["no task"], "WHISPER", nil, target)
            end

    	end
    	taskInfo.CursorChange = function(arg1, arg2)
    		local boss = self.modules[self.currModuleId].bosses[self.currInstanceMode] [self.currBossId]
    		if(type(arg1) == "table") then arg1 = arg2 end
    		local tbl = {}
    		if(theFrame.TaskManagerFrame.TaskDropdown.selected == L["tank"])then
    		   tbl = boss.taskTank
    		elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["healer"])then
    		   tbl = boss.taskHealer
    		   theFrame.TaskManagerFrame.Player2Dropdown:Show()
               theFrame.TaskManagerFrame.Player2Label:Show()
            elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["melee"])then
    		   tbl = boss.taskMelee
    		elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["ranged DPS"])then
    		   tbl = boss.taskRange
            end
            if(not tbl) then return end
            theFrame.TaskManagerFrame.ChangeInput:SetText(self:FindColor(tbl[arg1].player).." "..tbl[arg1].value)
    		theFrame.TaskManagerFrame.ChangeInput.selected = tbl[arg1].player
    	end
    	taskInfo.Select = function(arg1, arg2)
    		local boss = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId]
    		if(type(arg1) == "table") then arg1 = arg2 end
    		local tbl = {}
    		if(theFrame.TaskManagerFrame.TaskDropdown.selected == L["tank"])then
    		   tbl = boss.taskTank
    		elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["healer"])then
    		   tbl = boss.taskHealer
            elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["melee"])then
    		   tbl = boss.taskMelee
    		elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["ranged DPS"])then
    		   tbl = boss.taskRange
            end
            for i,v in ipairs(tbl)do
                if(v.player == strsub(arg1,11,-3))then
                    theFrame.TaskManagerFrame.ChangeInput:SetText(arg1.." "..v.value)
                    break
                end
            end
    	end
    	taskInfo.Save = function(arg1, arg2, arg3)
    		if(type(arg1) == "table") then arg1 = arg2; arg2=arg3 end
    		local tbl = {}
    		local boss = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId]
    		if(theFrame.TaskManagerFrame.TaskDropdown.selected == L["tank"])then
    		   tbl = boss.taskTank
    		elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["healer"])then
    		   tbl = boss.taskHealer
            elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["melee"])then
    		   tbl = boss.taskMelee
    		elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["ranged DPS"])then
    		   tbl = boss.taskRange
            end
    		local str = ""
    		for i,v in ipairs(tbl)do
                if(v.player == arg1)then
                    v.value = arg2
                end
                str = str..self:FindColor(v.player).." "..v.value.."\n"
            end
            theFrame.TaskManagerFrame.TaskInput:SetText(strtrim(str))
            theFrame.TaskManagerFrame.TaskInput.tmpOld = strtrim(str)
    	end
    	taskInfo.Task.Label = L["Task:"]
    	taskInfo.Task.Init = function()
    		theFrame.TaskManagerFrame:Clean()
            local str = ""
    		theFrame.TaskManagerFrame.TaskDropdown.selected = L["tank"]
    		theFrame.TaskManagerFrame.Player2Dropdown:Hide()
        	theFrame.TaskManagerFrame.Player2Label:Hide()
            theFrame.TaskManagerFrame.Player3Dropdown:Hide()
            theFrame.TaskManagerFrame.Player3Label:Hide()
            UIDropDownMenu_SetText(theFrame.TaskManagerFrame.TaskDropdown, L["tank"])
            if (not self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId].taskTank)then
                   self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId].taskTank = {}
            end
            if (not self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId].taskHealer)then
                   self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId].taskHealer = {}
            end
            if (not self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId].taskMelee)then
                   self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId].taskMelee = {}
            end
            if (not self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId].taskRange)then
                   self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId].taskRange = {}
            end
            theFrame.TaskManagerFrame.ChangeInput:SetText("")
            for i,v in ipairs(self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId].taskTank)do
                local colChar = self:FindColor(v.player)
                str = str..colChar.." "..v.value.."\n"
                theFrame.TaskManagerFrame:AddPlayer(colChar)
            end
            theFrame.TaskManagerFrame.TaskInput:SetText(strtrim(str))
            theFrame.TaskManagerFrame.TaskInput.tmpOld = strtrim(str)
    	end
    	taskInfo.Task.Click = function(arg1)
    		local boss = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId]
    		theFrame.TaskManagerFrame.TaskDropdown.selected = arg1
            UIDropDownMenu_SetText(theFrame.TaskManagerFrame.TaskDropdown, arg1)
            if(theFrame.TaskManagerFrame.TaskDropdown.selected ~= L["healer"])then
                local tbl = {}
    		    if(theFrame.TaskManagerFrame.TaskDropdown.selected == L["tank"])then
                   tbl = boss.taskTank
                elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["melee"])then
                   tbl = boss.taskMelee
                elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["ranged DPS"])then
                   tbl = boss.taskRange
                end
                if(not tbl) then return end
                theFrame.TaskManagerFrame:Clean()
                local str = ""
                for i,v in ipairs(tbl)do
                	local colChar = self:FindColor(v.player)
                	str = str..colChar.." "..v.value.."\n"
                	theFrame.TaskManagerFrame:AddPlayer(colChar)
                end
                theFrame.TaskManagerFrame.TaskInput:SetText(strtrim(str))
                theFrame.TaskManagerFrame.TaskInput.tmpOld = strtrim(str)
                theFrame.TaskManagerFrame.Player2Dropdown:Hide()
                theFrame.TaskManagerFrame.Player2Label:Hide()
                theFrame.TaskManagerFrame.Player3Dropdown:Hide()
                theFrame.TaskManagerFrame.Player3Label:Hide()
                taskInfo.Player1:Init()
            else
                theFrame.TaskManagerFrame:Clean()
                local str = ""
                for i,v in ipairs(boss.taskHealer)do
                	local colChar = self:FindColor(v.player)
                	str = str..colChar.." "..v.value.."\n"
                	theFrame.TaskManagerFrame:AddPlayer(colChar)
                end
                theFrame.TaskManagerFrame.TaskInput:SetText(strtrim(str))
                theFrame.TaskManagerFrame.TaskInput.tmpOld = strtrim(str)
                theFrame.TaskManagerFrame.Player2Dropdown:Hide()
                theFrame.TaskManagerFrame.Player2Label:Hide()
                theFrame.TaskManagerFrame.Player3Dropdown:Hide()
                theFrame.TaskManagerFrame.Player3Label:Hide()
                taskInfo.Player1:Init()
                taskInfo.Player2:Init()
            end
    	end
    	taskInfo.Task.Values = function ()
    		return {{L["tank"],L["tank"]}, {L["healer"],L["healer"]}, {L["melee"],L["melee"]}, {L["ranged DPS"],L["ranged DPS"]}}
    	end

    	taskInfo.Player1 = {}
    	taskInfo.Player1.Label = L["Player:"]
    	taskInfo.Player1.Init = function()
    		if(theFrame.TaskManagerFrame.OraCheckBoxBtn and theFrame.TaskManagerFrame.OraCheckBoxBtn:GetChecked())then
    			if(oRA)then
    				wipe(self.tanklist)
    				for i,v in ipairs(oRA.maintanktable)do
                        self.tanklist[i] = v
                    end
    			end
    			if(#self.tanklist > 0)then
    			 	UIDropDownMenu_SetText(theFrame.TaskManagerFrame.PlayerDropdown, self.tanklist[1])
    			else
    				UIDropDownMenu_SetText(theFrame.TaskManagerFrame.PlayerDropdown, "")
    			end
    		else
    			local filter = {}
       		    if(theFrame.TaskManagerFrame.TaskDropdown.selected == L["tank"])then
                    filter = self.tankClasses
                elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["healer"])then
                    filter = self.healClasses
                elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["melee"])then
                    filter = self.meleeClasses
                elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["ranged DPS"])then
                    filter = self.rangeClasses
                end
                UIDropDownMenu_SetText(theFrame.TaskManagerFrame.PlayerDropdown, "")
                local anzMembers = GetNumRaidMembers()
                for i=1, anzMembers, 1 do
                    local name, _, subgr, _, _,fileName = GetRaidRosterInfo(i)
                    for ind,val in ipairs(filter)do
                        if(fileName == val and subgr <= 5)then
                           UIDropDownMenu_SetText(theFrame.TaskManagerFrame.PlayerDropdown, name)
                           break
                        end
                    end
                end
    		end
    	end
    	taskInfo.Player1.Delete = function (arg1, arg2)
    		local boss = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId]
    		local str = ""
    		if(type(arg1) == "table") then arg1 = arg2 end
    		local tbl = {}
    		if(theFrame.TaskManagerFrame.TaskDropdown.selected == L["tank"])then
    		   tbl = boss.taskTank
    		elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["healer"])then
    		   tbl = boss.taskHealer
            elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["melee"])then
    		   tbl = boss.taskMelee
    		elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["ranged DPS"])then
    		   tbl = boss.taskRange
            end
            for i,v in ipairs(tbl)do
                if(v.player == strsub(arg1,11,-3))then
                    tremove(tbl,i)
                    break
                end
            end
            for i,v in ipairs(tbl)do
                local colChar = self:FindColor(v.player)
                str = str..colChar.." "..v.value.."\n"
            end
            theFrame.TaskManagerFrame.TaskInput:SetText(strtrim(str))
            theFrame.TaskManagerFrame.TaskInput.tmpOld = strtrim(str)
    	end
    	taskInfo.Player1.Click = function(arg1)
    		local boss = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId]
            UIDropDownMenu_SetText(theFrame.TaskManagerFrame.PlayerDropdown, arg1)
            theFrame.TaskManagerFrame.PlayerDropdown.selected = arg1
            if(theFrame.TaskManagerFrame.TaskDropdown.selected == L["healer"])then
                theFrame.TaskManagerFrame.Player2Dropdown:Show()
                theFrame.TaskManagerFrame.Player2Label:Show()
            else
            	theFrame.TaskManagerFrame.AddPlayer(self:FindColor(arg1))
            	local tbl = {}
    		    if(theFrame.TaskManagerFrame.TaskDropdown.selected == L["tank"])then
                   tbl = boss.taskTank
                elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["melee"])then
                   tbl = boss.taskMelee
                elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["ranged DPS"])then
                   tbl = boss.taskRange
                end
            	local found = false
            	for i,v in ipairs(tbl)do
            		if(v.player == arg1)then
            			found = true
            		end
            	end
            	if(not found)then
            		if(theFrame.TaskManagerFrame.TaskDropdown.selected == L["tank"])then
                       tinsert(tbl, {player = arg1, value = L["tanks "]})
                    else
                       tinsert(tbl, {player = arg1, value = " "})
                    end
            	end
            	local str = ""
            	for i,v in ipairs(tbl)do
                	local colChar = self:FindColor(v.player)
                	str = str..colChar.." "..v.value.."\n"
                end
                theFrame.TaskManagerFrame.TaskInput:SetText(strtrim(str))
                theFrame.TaskManagerFrame.TaskInput.tmpOld = strtrim(str)
            end
    	end
    	taskInfo.Player1.Values = function ()
    		local tbl = {}

            if(theFrame.TaskManagerFrame.OraCheckBoxBtn:GetChecked())then
            	if(oRA)then
    				wipe(self.tanklist)
    				for i,v in ipairs(oRA.maintanktable)do
                        self.tanklist[i] = v
                    end
    			end
                for i,v in ipairs(self.tanklist)do
                    tinsert(tbl,{v,v})
                end
            else
            	local anzMembers = GetNumRaidMembers()
       		    local filter = {}
                if(theFrame.TaskManagerFrame.TaskDropdown.selected == L["tank"])then
                    filter = self.tankClasses
                elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["healer"])then
                    filter = self.healClasses
                elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["melee"])then
                    filter = self.meleeClasses
                elseif(theFrame.TaskManagerFrame.TaskDropdown.selected == L["ranged DPS"])then
                    filter = self.rangeClasses
                end

                for i=1, anzMembers, 1 do
                    local name, _, subgr, _, _,fileName = GetRaidRosterInfo(i)
                    for ind,val in ipairs(filter)do
                        if(fileName == val and subgr <= 5)then
                            tinsert(tbl,{name,name})
                        end
                    end
                end
            end
            return tbl
    	end

    	taskInfo.Player2 = {}
    	taskInfo.Player2.Label = L["Player:"]
    	taskInfo.Player2.Init = function()
    		local name = GetRaidRosterInfo(1)
            UIDropDownMenu_SetText(theFrame.TaskManagerFrame.Player2Dropdown, name)
    	end
    	taskInfo.Player2.Click = function(arg1)
            local boss = self.modules[self.currModuleId].bosses[self.currInstanceMode][self.currBossId]
            if(theFrame.TaskManagerFrame.TaskDropdown.selected == L["healer"])then
                local found = false
            	for i,v in ipairs(boss.taskHealer)do
            		if(v.player == theFrame.TaskManagerFrame.PlayerDropdown.selected)then
            			v.value = v.value..", "..self:FindColor(arg1)
            			found = true
            			break
            		end
            	end
            	if(not found)then
            		theFrame.TaskManagerFrame.AddPlayer(self:FindColor(theFrame.TaskManagerFrame.PlayerDropdown.selected))
            		tinsert(boss.taskHealer, {player = theFrame.TaskManagerFrame.PlayerDropdown.selected, value = L["heals "]..self:FindColor(arg1)})
            	end
            	local str = ""
            	for i,v in ipairs(boss.taskHealer)do
                	local colChar = self:FindColor(v.player)
                	str = str..colChar.." "..v.value.."\n"
                end
                theFrame.TaskManagerFrame.TaskInput:SetText(strtrim(str))
                theFrame.TaskManagerFrame.TaskInput.tmpOld = strtrim(str)
            end
            UIDropDownMenu_SetText(theFrame.TaskManagerFrame.Player2Dropdown, arg1)
    	end
    	taskInfo.Player2.Values = function ()
    		local tbl = {}
       		local anzMembers = GetNumRaidMembers()

       		for i=1, anzMembers, 1 do
            	local name, _, subgr, _, _,fileName = GetRaidRosterInfo(i)
				if(subgr <= 5)then
					tinsert(tbl,{name,name})
				end
            end
            return tbl
    	end

    	self:ShowTaskManager(taskInfo)
    	if(not theFrame.TaskManagerFrame.OraCheckBoxBtn)then
    		theFrame.TaskManagerFrame.OraCheckBoxBtn = CreateFrame("CheckButton","BT_TM_OraCheckBox",theFrame.TaskManagerFrame,"UICheckButtonTemplate")
    		theFrame.TaskManagerFrame.TextSaveCB = theFrame.TaskManagerFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
    		theFrame.TaskManagerFrame.OraCheckBoxBtn:SetWidth(20)
            theFrame.TaskManagerFrame.OraCheckBoxBtn:SetHeight(20)
            theFrame.TaskManagerFrame.OraCheckBoxBtn:SetPoint("TOPLEFT",theFrame.TaskManagerFrame,"TOPLEFT",30,-340)
            theFrame.TaskManagerFrame.OraCheckBoxBtn:SetChecked(self.db.profile.useOraMT)
            theFrame.TaskManagerFrame.OraCheckBoxBtn:SetScript("OnClick",function()
				taskInfo.Player1:Init()
				if(this:GetChecked())then
					self.db.profile.useOraMT = true
				else
					self.db.profile.useOraMT = false
				end
            end)

            theFrame.TaskManagerFrame.TextSaveCB:SetText(L["Ora MT checkbox"])
            theFrame.TaskManagerFrame.TextSaveCB:SetJustifyH("LEFT")
            theFrame.TaskManagerFrame.TextSaveCB:SetPoint("TOPLEFT",theFrame.TaskManagerFrame,"TOPLEFT",55,-344)
    	end
        theFrame.TaskManagerFrame.OraCheckBoxBtn:Show()
    	theFrame.TaskManagerFrame.TextSaveCB:Show()
        if(oRA or oRA3)then
        	theFrame.TaskManagerFrame.TextSaveCB:SetTextColor(1,1,1)
        else
        	theFrame.TaskManagerFrame.TextSaveCB:SetTextColor(128/255,128/255,128/255)
        	theFrame.TaskManagerFrame.OraCheckBoxBtn:SetChecked(false)
        	theFrame.TaskManagerFrame.OraCheckBoxBtn:Disable()
        end
        taskInfo.Player1:Init()
    end

    CloseDropDownMenus()

end;


-----------------------------------------------------
--insertion sort for fontstring arrays
-----------------------------------------------------

function BossTactics:InsertionSort(arr, value)
    local lastElement = true
    for index,v in ipairs(arr) do
        if(v:GetText() >= value:GetText()) then
            tinsert(arr,index,value)
            lastElement = false
            break
        end
    end
    if(lastElement)then
        tinsert(arr,value)
    end
end;


-------------------------------------------------------------------
---manages textcroll
--frame: the parent frame
--textarray: a array of fontstrings to scroll
--add: bool if we add a string true, false if we scroll
--point: String, BOTTOMLEFT or TOPLEFT
-------------------------------------------------------------------

function BossTactics:ScrollString(frame,textarray,add)
    local frameheight = frame:GetHeight()-10
    local linespace = textarray[1]:GetSpacing()
    local tmpheight = 15;

    if(add) then
        if(frame.scrollUp)then
            frame.scrollUp= false
        end
        frame.offset = #textarray;
    end

    for index,value in pairs(textarray) do
        value:Hide()
    end
    for index=#textarray,1,-1 do
        if(index <= frame.offset)then
            local currfontstring = textarray[index]
            local fontstrHeight = currfontstring:GetStringHeight()
            if(tmpheight+(linespace+fontstrHeight) < frameheight)then
                currfontstring:ClearAllPoints()
                currfontstring:SetPoint("BOTTOMLEFT",frame, "BOTTOMLEFT",10,tmpheight)
                currfontstring:Show()
                tmpheight = tmpheight+linespace+fontstrHeight
            else
                break
            end
        end
    end
end;

function BossTactics:ScrollStringTop(frame,textarray,add)
    if(#textarray == 0)then return end
    local frameheight = frame:GetHeight()-10
    local linespace = textarray[1]:GetSpacing()
    local tmpheight = 15;

    if(add) then
        if(frame.scrollUp)then
            frame.scrollUp= false
        end
        frame.offset = 1;
    end

    for index,value in pairs(textarray) do
        value:Hide()
    end
    for index=1,#textarray,1 do
        if(index >= frame.offset)then
            local currfontstring = textarray[index]
            local fontstrHeight = currfontstring:GetStringHeight()
            if(tmpheight+(linespace+fontstrHeight) < frameheight)then
                currfontstring:ClearAllPoints()
                currfontstring:SetPoint("TOPLEFT",frame, "TOPLEFT",10,-tmpheight)
                currfontstring:Show()
                tmpheight = tmpheight+linespace+fontstrHeight
            else
                break
            end
        end
    end
end;


---------------------------------------------------------------
--- helper methods
---------------------------------------------------------------

--helps to transform the coordinates of a button which has been dragged
--frame: the dragged frame, placeFrame: the frame in which it should be placed
function BossTactics:DragFrame(frame, placeFrame)

  if(frame == nil or placeFrame == nil)then
      if(self.debug)then
          self:Print("Debug: BossTactics:DragFrame is called by nil value")
      end
      return
  end
 -- local s_width = GetScreenWidth()/2
 -- local s_height = GetScreenHeight()/2
  local mainWinScale = self.MainWindow:GetScale()
  --be carefull mainwindow is relative to center!!
 -- local point2, relativeTo2, relativePoint2, xOfs2, yOfs2 = placeFrame:GetPoint(1)
--  local point3, relativeTo3, relativePoint3, xOfs3, yOfs3 = frame:GetPoint(1)
  local leftpaneX = self.MainWindow.LeftPane:GetLeft()
  local leftpaneY = math.abs(GetScreenHeight()-self.MainWindow.LeftPane:GetTop())
  local myy = frame.oldY
  local myx = frame.oldX

  --handle the x cooddinate first
  myx = frame:GetLeft()-leftpaneX
  --check if the button is within the x coodinate of the placeframe
  if(myx < 0 or myx > placeFrame:GetWidth()-frame:GetWidth())then
      --it is not in so reset the position
      myx = frame.oldX
  else
    --it is in the x coodrinate, so check the y one
    myy = frame:GetBottom()-placeFrame:GetBottom()-(placeFrame:GetTop()-placeFrame:GetBottom())+frame:GetTop()-frame:GetBottom()
    --check if the y coordinate is within the placeframe
    if(myy > 2 or myy < -placeFrame:GetHeight()+frame:GetHeight()) then
          myy = frame.oldY
          myx = frame.oldX
    else
       if(frame.oldY ~= myy and frame.oldX ~= myx)then
             self:DataChanged()
           --if it is a new button from the pool
          if(not frame.dragged)then
              --set ids
                frame.instId = self.currInstanceId
                frame.imgId = self.currImgId
                frame.bossId = self.currBossId
                frame.moduleId = self.currModuleId
                frame.mode = self.currInstanceMode
                --sessions must be handled
                if(self:IsSession()) then
                   frame.id = self.currSessionBtnId
                  self.currSessionBtnId = self.currSessionBtnId + 1
                  BossTactics:BT_SendDataMessage("{BTN:"..frame.id..":"..floor(myx)..":"..floor(myy)..":"..frame.typename.."}")
              else
                  frame.id = self.currBtnId
                  self.currBtnId = self.currBtnId +1
              end

              if(frame.text:GetText() == nil or frame.text:GetText() == "") then
                  BossTactics:ShowButtonInputFrame(frame.text,frame,BossTactics:GetTextFromButtonType(frame.typename))
              end
                frame.dragged = true
                --show the edit buttons if raidleader
                if(self:IsRaidLeader() or self.tacticMode)then
                    frame.editBtn:Show()
                    frame.delBtn:Show()
                end
                --create a new button in the pool
                BossTactics:CreateNewMapButton(BossTactics:GetTypeFromButtonType(frame.typename), true)
          else
              if(self:IsSession())then
                BossTactics:BT_SendDataMessage("{BTMV:"..frame.id..":"..floor(myx)..":"..floor(myy).."}")
              end
          end
       end
       frame.oldY = myy
       frame.oldX = myx
    end
  end

  --setup the new position, because of rounding the butten could jump a pixel
  frame:ClearAllPoints()
  frame:SetPoint("TOPLEFT",frame:GetParent(),"TOPLEFT",myx,myy)

end;


------------------------------------------------------------------
--if session leader closes window, pls ask to end session before
------------------------------------------------------------------

function BossTactics:AskForClose()

    if(self.CloseFrame == nil)then
        self.CloseFrame = CreateFrame("Frame","BT_CloseFrame",UIParent)
        self.CloseFrame:ClearAllPoints()
        self.CloseFrame:SetPoint("CENTER",UIParent)
        self.CloseFrame:SetHeight(100)
        self.CloseFrame:SetWidth(350)
        self.CloseFrame:SetBackdrop({
            bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = false,
            edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border", edgeSize = 32,
            insets = {left = 5, right = 5, top = 0, bottom = 5},
        })
        self.CloseFrame:SetBackdropColor(1/255, 1/255, 1/255)
        --self.CloseFrame:SetBackdropBorderColor(1.0,0,0.0)

        self.CloseFrame.YesBtn = CreateFrame("Button","BT_closeframe_yes",self.CloseFrame,"UIPanelButtonTemplate")
        self.CloseFrame.YesBtn:SetWidth(100)
        self.CloseFrame.YesBtn:SetHeight(20)
        self.CloseFrame.YesBtn:SetText(L["Yes"])
        self.CloseFrame.YesBtn:SetPoint("BOTTOMLEFT",self.CloseFrame,"BOTTOMLEFT",15,15)
        self.CloseFrame.YesBtn:SetScript("OnClick",function()
                self:EndSession()
                self.MainWindow:Hide()
                this:GetParent():Hide()
             end)
        self.CloseFrame.YesBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)

        self.CloseFrame.NoBtn = CreateFrame("Button","BT_closeframe_no",self.CloseFrame,"UIPanelButtonTemplate")
        self.CloseFrame.NoBtn:SetWidth(100)
        self.CloseFrame.NoBtn:SetHeight(20)
        self.CloseFrame.NoBtn:SetText(L["No"])
        self.CloseFrame.NoBtn:SetPoint("BOTTOMLEFT",self.CloseFrame,"BOTTOMLEFT",120,15)
        self.CloseFrame.NoBtn:SetScript("OnClick",function() this:GetParent():Hide() end)
        self.CloseFrame.NoBtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)

        self.CloseFrame.infotext = self.CloseFrame:CreateFontString(nil,"OVERLAY","GameFontNormal")
        self.CloseFrame.infotext:SetTextColor(1,1,1)
        self.CloseFrame.infotext:SetWidth(330)
        self.CloseFrame.infotext:SetText(L["Close info text"])
        self.CloseFrame.infotext:SetPoint("TOP",self.CloseFrame,"TOP",10,-25)
        self.CloseFrame.infotext:SetJustifyH("LEFT")

        self.CloseFrame.closebtn=CreateFrame("Button","BT_cinfoclose",self.CloseFrame)
        self.CloseFrame.closebtn:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up.blp")
        self.CloseFrame.closebtn:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down.blp")
        self.CloseFrame.closebtn:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight.blp")
        self.CloseFrame.closebtn:SetWidth(20)
        self.CloseFrame.closebtn:SetHeight(20)
        self.CloseFrame.closebtn:SetPoint("TOPRIGHT",self.CloseFrame,"TOPRIGHT",-5,-5)
        self.CloseFrame.closebtn:SetScript("OnClick",function() this:GetParent():Hide() end)
        self.CloseFrame.closebtn:SetFrameLevel(self.MainWindow:GetFrameLevel()+22)
    end
    self.CloseFrame:Show()
    self.CloseFrame:SetFrameLevel(self.MainWindow:GetFrameLevel()+21)

end;


--------------------------------------------------------------------
--event handlers
---------------------------------------------------------------------

function BossTactics:HandleCloseMainWindow()

    if(self:IsSession())then
        if(self.isSessionLeader)then
            self:AskForClose()
        else
            self:BT_SendDataMessage("{MAINCL}")
            local anzMembers = GetNumRaidMembers()
            for i=1, anzMembers, 1 do
                local name, rank, subgroup, level, class,
                        fileName,zone, online, isDead, role, isML = GetRaidRosterInfo(i)
                if(name and self.currInstanceMemberMax ~= -1 and name == self.player and subgroup > self.currInstanceMemberMax/5)then
                    self.isNotWatching = false
                    self.isNotWatchingAsked = false
                end
            end
            self.MainWindow:Hide()
        end
    else
        local anzMembers = GetNumRaidMembers()
        for i=1, anzMembers, 1 do
            local name, rank, subgroup, level, class,
                    fileName,zone, online, isDead, role, isML = GetRaidRosterInfo(i)
            if(name and self.currInstanceMemberMax ~= -1 and name == self.player and subgroup > self.currInstanceMemberMax/5)then
                self.isNotWatching = false
            	self.isNotWatchingAsked = false
            end
    	end
    	if(self.MainGroupWindow)then
    		self.MainGroupWindow:Hide()
    	end
        self.MainWindow:Hide()
    end
end;

----------------------------------------
--Hides some lines
----------------------------------------
function BossTactics:HideLines(textArr, anz)
    for i,v in ipairs(textArr)do
        v:Hide()
    end
end;

------------------------------------------
--Shows the lines
------------------------------------------
function BossTactics:ShowLines(textArr, anz)
    for i,v in ipairs(textArr)do
        v:Show()
        if(i>= anz)then break end
    end
end;

function BossTactics:ClearImage()

    if(not self.MainWindow)then return end
    self:HideLines(self.MainWindow.LeftPane.ImgPane.lines[self.currInstanceId][self.currInstanceMode][self.currBossId][self.currImgId].textures)
    self.MainWindow.LeftPane.ImgPane.lines[self.currInstanceId][self.currInstanceMode][self.currBossId][self.currImgId].count = 0

end;

------------------------------------------
--copied from whiteboard
------------------------------------------

function BossTactics:UpdatePaint()
    --if(self.syncInProgress) then return end
    local imgPane = self.MainWindow.LeftPane.ImgPane
    if (imgPane.drawing)then
        local X, Y = GetCursorPosition()
        X = (X / imgPane:GetEffectiveScale() - imgPane:GetLeft())
        Y = (Y / imgPane:GetEffectiveScale() - imgPane:GetBottom())
        if not self:OnImage(X, Y) then
            imgPane.LastX=nil
            imgPane.LastY=nil
            return
        end
        if (imgPane.LastX and imgPane.LastY)then
            local Dist=math.abs(X-imgPane.LastX)+math.abs(Y-imgPane.LastY)
            if Dist<=4 then
                return
            end
            self:DrawLine(imgPane,imgPane.LastX,imgPane.LastY,X,Y,imgPane.linewidth,imgPane.optColor)
            local args, i = {}, 1
            for id in string.gmatch(string.format("%.1f %.1f %.1f %.1f",imgPane.LastX,imgPane.LastY,X,Y), "%S+") do
                args[i] = id
                i = i + 1
            end
            self:BT_SendDataMessage("{DL:"..args[1]..":"..args[2]..":"..args[3]..":"..args[4].."}")
        end
        imgPane.LastX=X
        imgPane.LastY=Y
    else
        imgPane.LastX=nil
        imgPane.LastY=nil
    end
end

function BossTactics:OnImage(X, Y)
    X = X + 2
    Y = Y + 2
    if(X > (self.MainWindow.LeftPane.ImgPane:GetWidth() - 4)) or (X < 0) or (Y > (self.MainWindow.LeftPane.ImgPane:GetHeight() - 4)) or (Y < 0) then
        return false
    end
    return true
end


--Copied from Blizzard's TaxiFrame code and modifed for IMBA

-- The following function is used with permission from Daniel Stephens <iriel@vigilance-committee.org>

-- T        - Texture
-- C        - Canvas Frame (for anchoring)
-- sx,sy    - Coordinate of start of line
-- ex,ey    - Coordinate of end of line
-- w        - Width of line
-- relPoint - Relative point on canvas to interpret coords (Default BOTTOMLEFT)
--/script BossTactics:DrawLine(IMBA_Ouro,0,0,-200,-200,32)
function BossTactics:DrawLine(C, sx, sy, ex, ey, w, color)
   local T, relPoint;
   local imgPane = self.MainWindow.LeftPane.ImgPane
   if (not relPoint) then relPoint = "BOTTOMLEFT"; end

    T=nil;
    imgPane.lines[self.currInstanceId][self.currInstanceMode][self.currBossId][self.currImgId].count = imgPane.lines[self.currInstanceId][self.currInstanceMode][self.currBossId][self.currImgId].count + 1
   for k,v in pairs(imgPane.lines[self.currInstanceId][self.currInstanceMode][self.currBossId][self.currImgId].textures) do
    if not v:IsShown() and not T then
        T=v;
        T:Show();
        break
    end
   end

   if not T then
    T=C:CreateTexture(C:GetName().."_Line"..(getn(imgPane.lines[self.currInstanceId][self.currInstanceMode][self.currBossId][self.currImgId].textures)+1), "ARTWORK");
    T:SetTexture("Interface\\AddOns\\BossTactics\\Textures\\line");
    tinsert(imgPane.lines[self.currInstanceId][self.currInstanceMode][self.currBossId][self.currImgId].textures,T);
    T.data = {}
   end
    T.data.sx = sx
    T.data.sy = sy
    T.data.ex = ex
    T.data.ey = ey


    T:SetVertexColor(color[1],color[2],color[3],color[4]);
   -- Determine dimensions and center point of line
   local dx,dy = ex - sx, ey - sy;
   local cx,cy = (sx + ex) / 2, (sy + ey) / 2;

   -- Normalize direction if necessary
   if (dx < 0) then
      dx,dy = -dx,-dy;
   end

   -- Calculate actual length of line
   local l = sqrt((dx * dx) + (dy * dy));

   -- Quick escape if it's zero length
   if (l == 0) then
      T:SetTexCoord(0,0,0,0,0,0,0,0);
      T:SetPoint("BOTTOMLEFT", C, relPoint, cx,cy);
      T:SetPoint("TOPRIGHT",   C, relPoint, cx,cy);
      return;
   end

   -- Sin and Cosine of rotation, and combination (for later)
   local s,c = -dy / l, dx / l;
   local sc = s * c;

   -- Calculate bounding box size and texture coordinates
   local Bwid, Bhgt, BLx, BLy, TLx, TLy, TRx, TRy, BRx, BRy;
   if (dy >= 0) then
      Bwid = ((l * c) - (w * s)) * self.TAXIROUTE_LINEFACTOR;
      Bhgt = ((w * c) - (l * s)) * self.TAXIROUTE_LINEFACTOR;
      BLx, BLy, BRy = (w / l) * sc, s * s, (l / w) * sc;
      BRx, TLx, TLy, TRx = 1 - BLy, BLy, 1 - BRy, 1 - BLx;
      TRy = BRx;
   else
      Bwid = ((l * c) + (w * s)) * self.TAXIROUTE_LINEFACTOR;
      Bhgt = ((w * c) + (l * s)) * self.TAXIROUTE_LINEFACTOR;
      BLx, BLy, BRx = s * s, -(l / w) * sc, 1 + (w / l) * sc;
      BRy, TLx, TLy, TRy = BLx, 1 - BRx, 1 - BLx, 1 - BLy;
      TRx = TLy;
   end

   -- Set texture coordinates and anchors
   T:ClearAllPoints();
   T:SetTexCoord(TLx, TLy, BLx, BLy, TRx, TRy, BRx, BRy);
   T:SetPoint("BOTTOMLEFT", C, relPoint, cx - Bwid, cy - Bhgt);
   T:SetPoint("TOPRIGHT",   C, relPoint, cx + Bwid, cy + Bhgt);

   return T:GetName();
end